/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.summary;

import java.io.Serializable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.hipparchus.stat.descriptive.AggregatableStatistic;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class SumOfLogs
extends AbstractStorelessUnivariateStatistic
implements AggregatableStatistic<SumOfLogs>,
Serializable {
    private static final long serialVersionUID = 20150412L;
    private int n;
    private double value;

    public SumOfLogs() {
        this.value = 0.0;
        this.n = 0;
    }

    public SumOfLogs(SumOfLogs original) throws NullArgumentException {
        MathUtils.checkNotNull(original);
        this.n = original.n;
        this.value = original.value;
    }

    @Override
    public void increment(double d) {
        this.value += FastMath.log(d);
        ++this.n;
    }

    @Override
    public double getResult() {
        return this.value;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public void clear() {
        this.value = 0.0;
        this.n = 0;
    }

    @Override
    public void aggregate(SumOfLogs other) {
        MathUtils.checkNotNull(other);
        if (other.n > 0) {
            this.n += other.n;
            this.value += other.value;
        }
    }

    @Override
    public double evaluate(double[] values, int begin, int length) throws MathIllegalArgumentException {
        double sumLog = Double.NaN;
        if (MathArrays.verifyValues(values, begin, length, true)) {
            sumLog = 0.0;
            for (int i = begin; i < begin + length; ++i) {
                sumLog += FastMath.log(values[i]);
            }
        }
        return sumLog;
    }

    @Override
    public SumOfLogs copy() {
        return new SumOfLogs(this);
    }
}

