/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.inference;

import org.hipparchus.distribution.continuous.ChiSquaredDistribution;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.stat.LocalizedStatFormats;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class GTest {
    public double g(double[] expected, long[] observed) throws MathIllegalArgumentException {
        if (expected.length < 2) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, expected.length, 2);
        }
        MathUtils.checkDimension(expected.length, observed.length);
        MathArrays.checkPositive(expected);
        MathArrays.checkNonNegative(observed);
        double sumExpected = 0.0;
        double sumObserved = 0.0;
        for (int i = 0; i < observed.length; ++i) {
            sumExpected += expected[i];
            sumObserved += (double)observed[i];
        }
        double ratio = 1.0;
        boolean rescale = false;
        if (FastMath.abs(sumExpected - sumObserved) > 1.0E-5) {
            ratio = sumObserved / sumExpected;
            rescale = true;
        }
        double sum = 0.0;
        for (int i = 0; i < observed.length; ++i) {
            double dev = rescale ? FastMath.log((double)observed[i] / (ratio * expected[i])) : FastMath.log((double)observed[i] / expected[i]);
            sum += (double)observed[i] * dev;
        }
        return 2.0 * sum;
    }

    public double gTest(double[] expected, long[] observed) throws MathIllegalArgumentException, MathIllegalStateException {
        ChiSquaredDistribution distribution = new ChiSquaredDistribution((double)expected.length - 1.0);
        return 1.0 - distribution.cumulativeProbability(this.g(expected, observed));
    }

    public double gTestIntrinsic(double[] expected, long[] observed) throws MathIllegalArgumentException, MathIllegalStateException {
        ChiSquaredDistribution distribution = new ChiSquaredDistribution((double)expected.length - 2.0);
        return 1.0 - distribution.cumulativeProbability(this.g(expected, observed));
    }

    public boolean gTest(double[] expected, long[] observed, double alpha) throws MathIllegalArgumentException, MathIllegalStateException {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw new MathIllegalArgumentException(LocalizedStatFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, alpha, 0, 0.5);
        }
        return this.gTest(expected, observed) < alpha;
    }

    private double entropy(long[][] k) {
        int j;
        int i;
        double h = 0.0;
        double sum_k = 0.0;
        for (i = 0; i < k.length; ++i) {
            for (j = 0; j < k[i].length; ++j) {
                sum_k += (double)k[i][j];
            }
        }
        for (i = 0; i < k.length; ++i) {
            for (j = 0; j < k[i].length; ++j) {
                if (k[i][j] == 0L) continue;
                double p_ij = (double)k[i][j] / sum_k;
                h += p_ij * FastMath.log(p_ij);
            }
        }
        return -h;
    }

    private double entropy(long[] k) {
        int i;
        double h = 0.0;
        double sum_k = 0.0;
        for (i = 0; i < k.length; ++i) {
            sum_k += (double)k[i];
        }
        for (i = 0; i < k.length; ++i) {
            if (k[i] == 0L) continue;
            double p_i = (double)k[i] / sum_k;
            h += p_i * FastMath.log(p_i);
        }
        return -h;
    }

    public double gDataSetsComparison(long[] observed1, long[] observed2) throws MathIllegalArgumentException {
        if (observed1.length < 2) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, observed1.length, 2);
        }
        MathUtils.checkDimension(observed1.length, observed2.length);
        MathArrays.checkNonNegative(observed1);
        MathArrays.checkNonNegative(observed2);
        long countSum1 = 0L;
        long countSum2 = 0L;
        long[] collSums = new long[observed1.length];
        long[][] k = new long[2][observed1.length];
        for (int i = 0; i < observed1.length; ++i) {
            if (observed1[i] == 0L && observed2[i] == 0L) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.OBSERVED_COUNTS_BOTTH_ZERO_FOR_ENTRY, i);
            }
            countSum1 += observed1[i];
            countSum2 += observed2[i];
            collSums[i] = observed1[i] + observed2[i];
            k[0][i] = observed1[i];
            k[1][i] = observed2[i];
        }
        if (countSum1 == 0L || countSum2 == 0L) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.ZERO_NOT_ALLOWED, new Object[0]);
        }
        long[] rowSums = new long[]{countSum1, countSum2};
        double sum = (double)countSum1 + (double)countSum2;
        return 2.0 * sum * (this.entropy(rowSums) + this.entropy(collSums) - this.entropy(k));
    }

    public double rootLogLikelihoodRatio(long k11, long k12, long k21, long k22) {
        double llr = this.gDataSetsComparison(new long[]{k11, k12}, new long[]{k21, k22});
        double sqrt = FastMath.sqrt(llr);
        if ((double)k11 / (double)(k11 + k12) < (double)k21 / (double)(k21 + k22)) {
            sqrt = -sqrt;
        }
        return sqrt;
    }

    public double gTestDataSetsComparison(long[] observed1, long[] observed2) throws MathIllegalArgumentException, MathIllegalStateException {
        ChiSquaredDistribution distribution = new ChiSquaredDistribution((double)observed1.length - 1.0);
        return 1.0 - distribution.cumulativeProbability(this.gDataSetsComparison(observed1, observed2));
    }

    public boolean gTestDataSetsComparison(long[] observed1, long[] observed2, double alpha) throws MathIllegalArgumentException, MathIllegalStateException {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw new MathIllegalArgumentException(LocalizedStatFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, alpha, 0, 0.5);
        }
        return this.gTestDataSetsComparison(observed1, observed2) < alpha;
    }
}

