/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.inference;

import java.util.ArrayList;
import org.hipparchus.distribution.continuous.NormalDistribution;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.ranking.NaNStrategy;
import org.hipparchus.stat.ranking.NaturalRanking;
import org.hipparchus.stat.ranking.TiesStrategy;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;

public class WilcoxonSignedRankTest {
    private final NaturalRanking naturalRanking;

    public WilcoxonSignedRankTest() {
        this.naturalRanking = new NaturalRanking(NaNStrategy.FIXED, TiesStrategy.AVERAGE);
    }

    public WilcoxonSignedRankTest(NaNStrategy nanStrategy, TiesStrategy tiesStrategy) {
        this.naturalRanking = new NaturalRanking(nanStrategy, tiesStrategy);
    }

    private int ensureDataConformance(double[] x, double[] y) throws MathIllegalArgumentException, NullArgumentException {
        if (x == null || y == null) {
            throw new NullArgumentException();
        }
        if (x.length == 0 || y.length == 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NO_DATA, new Object[0]);
        }
        MathArrays.checkEqualLength(y, x);
        int nTies = 0;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] != y[i]) continue;
            ++nTies;
        }
        if (x.length - nTies == 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.INSUFFICIENT_DATA, new Object[0]);
        }
        return nTies;
    }

    private double[] calculateDifferences(double[] x, double[] y) {
        ArrayList<Double> differences = new ArrayList<Double>();
        for (int i = 0; i < x.length; ++i) {
            if (y[i] == x[i]) continue;
            differences.add(y[i] - x[i]);
        }
        int nDiff = differences.size();
        double[] z = new double[nDiff];
        for (int i = 0; i < nDiff; ++i) {
            z[i] = (Double)differences.get(i);
        }
        return z;
    }

    private double[] calculateAbsoluteDifferences(double[] z) throws MathIllegalArgumentException, NullArgumentException {
        if (z == null) {
            throw new NullArgumentException();
        }
        if (z.length == 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NO_DATA, new Object[0]);
        }
        double[] zAbs = new double[z.length];
        for (int i = 0; i < z.length; ++i) {
            zAbs[i] = FastMath.abs(z[i]);
        }
        return zAbs;
    }

    public double wilcoxonSignedRank(double[] x, double[] y) throws MathIllegalArgumentException, NullArgumentException {
        this.ensureDataConformance(x, y);
        double[] z = this.calculateDifferences(x, y);
        double[] zAbs = this.calculateAbsoluteDifferences(z);
        double[] ranks = this.naturalRanking.rank(zAbs);
        double Wplus = 0.0;
        for (int i = 0; i < z.length; ++i) {
            if (!(z[i] > 0.0)) continue;
            Wplus += ranks[i];
        }
        int n = z.length;
        double Wminus = (double)(n * (n + 1)) / 2.0 - Wplus;
        return FastMath.max(Wplus, Wminus);
    }

    private double calculateExactPValue(double stat, int n) {
        int m = 1 << n;
        int largerRankSums = 0;
        for (int i = 0; i < m; ++i) {
            int rankSum = 0;
            for (int j = 0; j < n; ++j) {
                if ((i >> j & 1) != 1) continue;
                rankSum += j + 1;
            }
            if (!((double)rankSum >= stat)) continue;
            ++largerRankSums;
        }
        return 2.0 * (double)largerRankSums / (double)m;
    }

    private double calculateAsymptoticPValue(double stat, int n) {
        double ES = (double)(n * (n + 1)) / 4.0;
        double VarS = ES * ((double)(2 * n + 1) / 6.0);
        double z = stat - ES;
        double t = FastMath.signum(z);
        if ((z = (z - t * 0.5) / FastMath.sqrt(VarS)) > 0.0) {
            z = -z;
        }
        NormalDistribution standardNormal = new NormalDistribution(0.0, 1.0);
        return 2.0 * standardNormal.cumulativeProbability(z);
    }

    public double wilcoxonSignedRankTest(double[] x, double[] y, boolean exactPValue) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        int nTies = this.ensureDataConformance(x, y);
        int n = x.length - nTies;
        double stat = this.wilcoxonSignedRank(x, y);
        if (exactPValue && n > 30) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE, n, 30);
        }
        if (exactPValue) {
            return this.calculateExactPValue(stat, n);
        }
        return this.calculateAsymptoticPValue(stat, n);
    }
}

