/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.util;

import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.MathArrays;

public enum PivotingStrategy {
    CENTRAL{

        @Override
        public int pivotIndex(double[] work, int begin, int end) throws MathIllegalArgumentException {
            MathArrays.verifyValues(work, begin, end - begin);
            return begin + (end - begin) / 2;
        }
    }
    ,
    MEDIAN_OF_3{

        @Override
        public int pivotIndex(double[] work, int begin, int end) throws MathIllegalArgumentException {
            MathArrays.verifyValues(work, begin, end - begin);
            int inclusiveEnd = end - 1;
            int middle = begin + (inclusiveEnd - begin) / 2;
            double wBegin = work[begin];
            double wMiddle = work[middle];
            double wEnd = work[inclusiveEnd];
            if (wBegin < wMiddle) {
                if (wMiddle < wEnd) {
                    return middle;
                }
                return wBegin < wEnd ? inclusiveEnd : begin;
            }
            if (wBegin < wEnd) {
                return begin;
            }
            return wMiddle < wEnd ? inclusiveEnd : middle;
        }
    };


    public abstract int pivotIndex(double[] var1, int var2, int var3) throws MathIllegalArgumentException;
}

