/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import java.io.Serializable;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeStamped;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;

class PosVelChebyshev
implements TimeStamped,
Serializable {
    private static final long serialVersionUID = 20151023L;
    private final TimeScale timeScale;
    private final AbsoluteDate start;
    private final double duration;
    private final double[] xCoeffs;
    private final double[] yCoeffs;
    private final double[] zCoeffs;

    PosVelChebyshev(AbsoluteDate start, TimeScale timeScale, double duration, double[] xCoeffs, double[] yCoeffs, double[] zCoeffs) {
        this.start = start;
        this.timeScale = timeScale;
        this.duration = duration;
        this.xCoeffs = xCoeffs;
        this.yCoeffs = yCoeffs;
        this.zCoeffs = zCoeffs;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.start;
    }

    public boolean inRange(AbsoluteDate date) {
        double dt = date.offsetFrom(this.start, this.timeScale);
        return dt >= -0.001 && dt <= this.duration + 0.001;
    }

    public PVCoordinates getPositionVelocityAcceleration(AbsoluteDate date) {
        double t = (2.0 * date.offsetFrom(this.start, this.timeScale) - this.duration) / this.duration;
        double twoT = 2.0 * t;
        double pKm1 = 1.0;
        double pK = t;
        double xP = this.xCoeffs[0];
        double yP = this.yCoeffs[0];
        double zP = this.zCoeffs[0];
        double qKm1 = 0.0;
        double qK = 1.0;
        double xV = 0.0;
        double yV = 0.0;
        double zV = 0.0;
        double rKm1 = 0.0;
        double rK = 0.0;
        double xA = 0.0;
        double yA = 0.0;
        double zA = 0.0;
        for (int k = 1; k < this.xCoeffs.length; ++k) {
            xP += this.xCoeffs[k] * pK;
            yP += this.yCoeffs[k] * pK;
            zP += this.zCoeffs[k] * pK;
            xV += this.xCoeffs[k] * qK;
            yV += this.yCoeffs[k] * qK;
            zV += this.zCoeffs[k] * qK;
            xA += this.xCoeffs[k] * rK;
            yA += this.yCoeffs[k] * rK;
            zA += this.zCoeffs[k] * rK;
            double pKm2 = pKm1;
            pKm1 = pK;
            pK = twoT * pKm1 - pKm2;
            double qKm2 = qKm1;
            qKm1 = qK;
            qK = twoT * qKm1 + 2.0 * pKm1 - qKm2;
            double rKm2 = rKm1;
            rKm1 = rK;
            rK = twoT * rKm1 + 4.0 * qKm1 - rKm2;
        }
        double vScale = 2.0 / this.duration;
        double aScale = vScale * vScale;
        return new PVCoordinates(new Vector3D(xP, yP, zP), new Vector3D(xV * vScale, yV * vScale, zV * vScale), new Vector3D(xA * aScale, yA * aScale, zA * aScale));
    }

    public <T extends RealFieldElement<T>> FieldPVCoordinates<T> getPositionVelocityAcceleration(FieldAbsoluteDate<T> date) {
        RealFieldElement zero = (RealFieldElement)date.getField().getZero();
        RealFieldElement one = (RealFieldElement)date.getField().getOne();
        RealFieldElement t = (RealFieldElement)((RealFieldElement)((RealFieldElement)date.offsetFrom(new FieldAbsoluteDate<T>(date.getField(), this.start), this.timeScale).multiply((int)2)).subtract(this.duration)).divide(this.duration);
        RealFieldElement twoT = t.add(t);
        RealFieldElement pKm1 = one;
        RealFieldElement pK = t;
        RealFieldElement xP = (RealFieldElement)zero.add(this.xCoeffs[0]);
        RealFieldElement yP = (RealFieldElement)zero.add(this.yCoeffs[0]);
        RealFieldElement zP = (RealFieldElement)zero.add(this.zCoeffs[0]);
        RealFieldElement qKm1 = zero;
        RealFieldElement qK = one;
        RealFieldElement xV = zero;
        RealFieldElement yV = zero;
        RealFieldElement zV = zero;
        RealFieldElement rKm1 = zero;
        RealFieldElement rK = zero;
        RealFieldElement xA = zero;
        RealFieldElement yA = zero;
        RealFieldElement zA = zero;
        for (int k = 1; k < this.xCoeffs.length; ++k) {
            xP = (RealFieldElement)xP.add(pK.multiply(this.xCoeffs[k]));
            yP = (RealFieldElement)yP.add(pK.multiply(this.yCoeffs[k]));
            zP = (RealFieldElement)zP.add(pK.multiply(this.zCoeffs[k]));
            xV = (RealFieldElement)xV.add(qK.multiply(this.xCoeffs[k]));
            yV = (RealFieldElement)yV.add(qK.multiply(this.yCoeffs[k]));
            zV = (RealFieldElement)zV.add(qK.multiply(this.zCoeffs[k]));
            xA = (RealFieldElement)xA.add(rK.multiply(this.xCoeffs[k]));
            yA = (RealFieldElement)yA.add(rK.multiply(this.yCoeffs[k]));
            zA = (RealFieldElement)zA.add(rK.multiply(this.zCoeffs[k]));
            RealFieldElement pKm2 = pKm1;
            pKm1 = pK;
            pK = twoT.multiply(pKm1).subtract(pKm2);
            RealFieldElement qKm2 = qKm1;
            qKm1 = qK;
            qK = ((RealFieldElement)twoT.multiply(qKm1).add(pKm1.multiply(2))).subtract(qKm2);
            RealFieldElement rKm2 = rKm1;
            rKm1 = rK;
            rK = ((RealFieldElement)twoT.multiply(rKm1).add(qKm1.multiply(4))).subtract(rKm2);
        }
        double vScale = 2.0 / this.duration;
        double aScale = vScale * vScale;
        return new FieldPVCoordinates<RealFieldElement>(new FieldVector3D<RealFieldElement>(xP, yP, zP), new FieldVector3D<RealFieldElement>((RealFieldElement)xV.multiply(vScale), (RealFieldElement)yV.multiply(vScale), (RealFieldElement)zV.multiply(vScale)), new FieldVector3D<RealFieldElement>((RealFieldElement)xA.multiply(aScale), (RealFieldElement)yA.multiply(aScale), (RealFieldElement)zA.multiply(aScale)));
    }
}

