/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.IAUPole;
import org.orekit.bodies.JPLEphemeridesLoader;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScalesFactory;

enum PredefinedIAUPoles implements IAUPole
{
    SUN{
        private static final double W0 = 84.176;
        private static final double W_DOT = 14.1844;
        private final Vector3D pole = new Vector3D(FastMath.toRadians(286.13), FastMath.toRadians(63.87));

        @Override
        public Vector3D getPole(AbsoluteDate date) {
            return this.pole;
        }

        @Override
        public <T extends RealFieldElement<T>> FieldVector3D<T> getPole(FieldAbsoluteDate<T> date) {
            return new FieldVector3D<T>(date.getField(), this.pole);
        }

        @Override
        public double getPrimeMeridianAngle(AbsoluteDate date) {
            return FastMath.toRadians(PredefinedIAUPoles.d(date) * 14.1844 + 84.176);
        }

        @Override
        public <T extends RealFieldElement<T>> T getPrimeMeridianAngle(FieldAbsoluteDate<T> date) {
            return (T)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)PredefinedIAUPoles.d(date).multiply(14.1844)).add(84.176));
        }
    }
    ,
    MERCURY{
        private static final double ALPHA_0 = 281.0097;
        private static final double ALPHA_DOT = -0.0328;
        private static final double DELTA_0 = 61.4143;
        private static final double DELTA_DOT = -0.0049;
        private static final double W_0 = 329.5469;
        private static final double W_DOT = 6.1385025;
        private static final double M1_COEFF = 0.00993822;
        private static final double M2_COEFF = -0.00104581;
        private static final double M3_COEFF = -1.028E-4;
        private static final double M4_COEFF = -2.364E-5;
        private static final double M5_COEFF = -5.32E-6;
        private static final double M1_0 = 174.791086;
        private static final double M1_DOT = 4.092335;
        private static final double M2_0 = 349.582171;
        private static final double M2_DOT = 8.18467;
        private static final double M3_0 = 164.373257;
        private static final double M3_DOT = 12.277005;
        private static final double M4_0 = 339.164343;
        private static final double M4_DOT = 16.36934;
        private static final double M5_0 = 153.955429;
        private static final double M5_DOT = 20.461675;

        @Override
        public Vector3D getPole(AbsoluteDate date) {
            double t = PredefinedIAUPoles.t(date);
            return new Vector3D(FastMath.toRadians(t * -0.0328 + 281.0097), FastMath.toRadians(t * -0.0049 + 61.4143));
        }

        @Override
        public <T extends RealFieldElement<T>> FieldVector3D<T> getPole(FieldAbsoluteDate<T> date) {
            RealFieldElement t = PredefinedIAUPoles.t(date);
            return new FieldVector3D<RealFieldElement>(PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)t.multiply(-0.0328)).add(281.0097)), PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)t.multiply(-0.0049)).add(61.4143)));
        }

        @Override
        public double getPrimeMeridianAngle(AbsoluteDate date) {
            double d = PredefinedIAUPoles.d(date);
            return FastMath.toRadians(PredefinedIAUPoles.d(date) * 6.1385025 + 329.5469 + FastMath.sin(FastMath.toRadians(d * 4.092335 + 174.791086)) * 0.00993822 + FastMath.sin(FastMath.toRadians(d * 8.18467 + 349.582171)) * -0.00104581 + FastMath.sin(FastMath.toRadians(d * 12.277005 + 164.373257)) * -1.028E-4 + FastMath.sin(FastMath.toRadians(d * 16.36934 + 339.164343)) * -2.364E-5 + FastMath.sin(FastMath.toRadians(d * 20.461675 + 153.955429)) * -5.32E-6);
        }

        @Override
        public <T extends RealFieldElement<T>> T getPrimeMeridianAngle(FieldAbsoluteDate<T> date) {
            RealFieldElement d = PredefinedIAUPoles.d(date);
            return (T)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)PredefinedIAUPoles.d(date).multiply(6.1385025)).add(329.5469)).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(4.092335)).add(174.791086)).sin()).multiply(0.00993822))).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(8.18467)).add(349.582171)).sin()).multiply(-0.00104581))).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(12.277005)).add(164.373257)).sin()).multiply(-1.028E-4))).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(16.36934)).add(339.164343)).sin()).multiply(-2.364E-5))).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(20.461675)).add(153.955429)).sin()).multiply(-5.32E-6)));
        }
    }
    ,
    VENUS{
        private static final double W_0 = 160.2;
        private static final double W_DOT = -1.4813688;
        private final Vector3D pole = new Vector3D(FastMath.toRadians(272.76), FastMath.toRadians(67.16));

        @Override
        public Vector3D getPole(AbsoluteDate date) {
            return this.pole;
        }

        @Override
        public <T extends RealFieldElement<T>> FieldVector3D<T> getPole(FieldAbsoluteDate<T> date) {
            return new FieldVector3D<T>(date.getField(), this.pole);
        }

        @Override
        public double getPrimeMeridianAngle(AbsoluteDate date) {
            return FastMath.toRadians(PredefinedIAUPoles.d(date) * -1.4813688 + 160.2);
        }

        @Override
        public <T extends RealFieldElement<T>> T getPrimeMeridianAngle(FieldAbsoluteDate<T> date) {
            return (T)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)PredefinedIAUPoles.d(date).multiply(-1.4813688)).add(160.2));
        }
    }
    ,
    EARTH{
        private static final double ALPHA_0 = 0.0;
        private static final double ALPHA_DOT = -0.641;
        private static final double DELTA_0 = 90.0;
        private static final double DELTA_DOT = -0.557;
        private static final double W_0 = 190.147;
        private static final double W_DOT = 360.9856235;

        @Override
        public Vector3D getPole(AbsoluteDate date) {
            double t = PredefinedIAUPoles.t(date);
            return new Vector3D(FastMath.toRadians(t * -0.641 + 0.0), FastMath.toRadians(t * -0.557 + 90.0));
        }

        @Override
        public <T extends RealFieldElement<T>> FieldVector3D<T> getPole(FieldAbsoluteDate<T> date) {
            RealFieldElement t = PredefinedIAUPoles.t(date);
            return new FieldVector3D<RealFieldElement>(PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)t.multiply(-0.641)).add(0.0)), PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)t.multiply(-0.557)).add(90.0)));
        }

        @Override
        public Vector3D getNode(AbsoluteDate date) {
            double t = PredefinedIAUPoles.t(date);
            return new Vector3D(FastMath.toRadians(t * -0.641 + 0.0 + 90.0), 0.0);
        }

        @Override
        public <T extends RealFieldElement<T>> FieldVector3D<T> getNode(FieldAbsoluteDate<T> date) {
            RealFieldElement t = PredefinedIAUPoles.t(date);
            return new FieldVector3D<RealFieldElement>(PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)t.multiply(-0.641)).add(90.0)), (RealFieldElement)date.getField().getZero());
        }

        @Override
        public double getPrimeMeridianAngle(AbsoluteDate date) {
            return FastMath.toRadians(PredefinedIAUPoles.d(date) * 360.9856235 + 190.147);
        }

        @Override
        public <T extends RealFieldElement<T>> T getPrimeMeridianAngle(FieldAbsoluteDate<T> date) {
            return (T)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)PredefinedIAUPoles.d(date).multiply(360.9856235)).add(190.147));
        }
    }
    ,
    MOON{
        private static final double ALPHA_0 = 269.9949;
        private static final double ALPHA_DOT = 0.0031;
        private static final double DELTA_0 = 66.5392;
        private static final double DELTA_DOT = 0.013;
        private static final double W_0 = 38.3213;
        private static final double W_DOT = 13.17635815;
        private static final double W_DOT_DOT = -1.4E-12;
        private static final double E01_0 = 125.045;
        private static final double E01_DOT = -0.0529921;
        private static final double E01_SIN = -3.8787;
        private static final double E01_COS = 1.5419;
        private static final double E01_W_SIN = 3.561;
        private static final double E02_0 = 250.089;
        private static final double E02_DOT = -0.1059842;
        private static final double E02_SIN = -0.1204;
        private static final double E02_COS = 0.0239;
        private static final double E02_W_SIN = 0.1208;
        private static final double E03_0 = 260.008;
        private static final double E03_DOT = 13.0120009;
        private static final double E03_SIN = 0.07;
        private static final double E03_COS = -0.0278;
        private static final double E03_W_SIN = -0.0642;
        private static final double E04_0 = 176.625;
        private static final double E04_DOT = 13.3407154;
        private static final double E04_SIN = -0.0172;
        private static final double E04_COS = 0.0068;
        private static final double E04_W_SIN = 0.0158;
        private static final double E05_0 = 357.529;
        private static final double E05_DOT = 0.9856003;
        private static final double E05_W_SIN = 0.0252;
        private static final double E06_0 = 311.589;
        private static final double E06_DOT = 26.4057084;
        private static final double E06_SIN = 0.0072;
        private static final double E06_COS = -0.0029;
        private static final double E06_W_SIN = -0.0066;
        private static final double E07_0 = 134.963;
        private static final double E07_DOT = 13.064993;
        private static final double E07_COS = 9.0E-4;
        private static final double E07_W_SIN = -0.0047;
        private static final double E08_0 = 276.617;
        private static final double E08_DOT = 0.3287146;
        private static final double E08_W_SIN = -0.0046;
        private static final double E09_0 = 34.226;
        private static final double E09_DOT = 1.7484877;
        private static final double E09_W_SIN = 0.0028;
        private static final double E10_0 = 15.134;
        private static final double E10_DOT = -0.1589763;
        private static final double E10_SIN = -0.0052;
        private static final double E10_COS = 8.0E-4;
        private static final double E10_W_SIN = 0.0052;
        private static final double E11_0 = 119.743;
        private static final double E11_DOT = 0.0036096;
        private static final double E11_W_SIN = 0.004;
        private static final double E12_0 = 239.961;
        private static final double E12_DOT = 0.1643573;
        private static final double E12_W_SIN = 0.0019;
        private static final double E13_0 = 25.053;
        private static final double E13_DOT = 12.9590088;
        private static final double E13_SIN = 0.0043;
        private static final double E13_COS = -9.0E-4;
        private static final double E13_W_SIN = -0.0044;

        @Override
        public Vector3D getPole(AbsoluteDate date) {
            double d = PredefinedIAUPoles.d(date);
            double t = PredefinedIAUPoles.t(date);
            return new Vector3D(FastMath.toRadians(t * 0.0031 + 269.9949 + FastMath.sin(FastMath.toRadians(d * -0.0529921 + 125.045)) * -3.8787 + FastMath.sin(FastMath.toRadians(d * -0.1059842 + 250.089)) * -0.1204 + FastMath.sin(FastMath.toRadians(d * 13.0120009 + 260.008)) * 0.07 + FastMath.sin(FastMath.toRadians(d * 13.3407154 + 176.625)) * -0.0172 + FastMath.sin(FastMath.toRadians(d * 26.4057084 + 311.589)) * 0.0072 + FastMath.sin(FastMath.toRadians(d * -0.1589763 + 15.134)) * -0.0052 + FastMath.sin(FastMath.toRadians(d * 12.9590088 + 25.053)) * 0.0043), FastMath.toRadians(t * 0.013 + 66.5392 + FastMath.cos(FastMath.toRadians(d * -0.0529921 + 125.045)) * 1.5419 + FastMath.cos(FastMath.toRadians(d * -0.1059842 + 250.089)) * 0.0239 + FastMath.cos(FastMath.toRadians(d * 13.0120009 + 260.008)) * -0.0278 + FastMath.cos(FastMath.toRadians(d * 13.3407154 + 176.625)) * 0.0068 + FastMath.cos(FastMath.toRadians(d * 26.4057084 + 311.589)) * -0.0029 + FastMath.cos(FastMath.toRadians(d * 13.064993 + 134.963)) * 9.0E-4 + FastMath.cos(FastMath.toRadians(d * -0.1589763 + 15.134)) * 8.0E-4 + FastMath.cos(FastMath.toRadians(d * 12.9590088 + 25.053)) * -9.0E-4));
        }

        @Override
        public <T extends RealFieldElement<T>> FieldVector3D<T> getPole(FieldAbsoluteDate<T> date) {
            RealFieldElement d = PredefinedIAUPoles.d(date);
            RealFieldElement t = PredefinedIAUPoles.t(date);
            return new FieldVector3D<RealFieldElement>(PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)t.multiply(0.0031)).add(269.9949)).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(-0.0529921)).add(125.045)).sin()).multiply(-3.8787))).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(-0.1059842)).add(250.089)).sin()).multiply(-0.1204))).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(13.0120009)).add(260.008)).sin()).multiply(0.07))).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(13.3407154)).add(176.625)).sin()).multiply(-0.0172))).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(26.4057084)).add(311.589)).sin()).multiply(0.0072))).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(-0.1589763)).add(15.134)).sin()).multiply(-0.0052))).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(12.9590088)).add(25.053)).sin()).multiply(0.0043))), PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)t.multiply(0.013)).add(66.5392)).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(-0.0529921)).add(125.045)).cos()).multiply(1.5419))).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(-0.1059842)).add(250.089)).cos()).multiply(0.0239))).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(13.0120009)).add(260.008)).cos()).multiply(-0.0278))).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(13.3407154)).add(176.625)).cos()).multiply(0.0068))).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(26.4057084)).add(311.589)).cos()).multiply(-0.0029))).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(13.064993)).add(134.963)).cos()).multiply(9.0E-4))).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(-0.1589763)).add(15.134)).cos()).multiply(8.0E-4))).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(12.9590088)).add(25.053)).cos()).multiply(-9.0E-4))));
        }

        @Override
        public double getPrimeMeridianAngle(AbsoluteDate date) {
            double d = PredefinedIAUPoles.d(date);
            return FastMath.toRadians(d * (d * -1.4E-12 + 13.17635815) + 38.3213 + FastMath.sin(FastMath.toRadians(d * -0.0529921 + 125.045)) * 3.561 + FastMath.sin(FastMath.toRadians(d * -0.1059842 + 250.089)) * 0.1208 + FastMath.sin(FastMath.toRadians(d * 13.0120009 + 260.008)) * -0.0642 + FastMath.sin(FastMath.toRadians(d * 13.3407154 + 176.625)) * 0.0158 + FastMath.sin(FastMath.toRadians(d * 0.9856003 + 357.529)) * 0.0252 + FastMath.sin(FastMath.toRadians(d * 26.4057084 + 311.589)) * -0.0066 + FastMath.sin(FastMath.toRadians(d * 13.064993 + 134.963)) * -0.0047 + FastMath.sin(FastMath.toRadians(d * 0.3287146 + 276.617)) * -0.0046 + FastMath.sin(FastMath.toRadians(d * 1.7484877 + 34.226)) * 0.0028 + FastMath.sin(FastMath.toRadians(d * -0.1589763 + 15.134)) * 0.0052 + FastMath.sin(FastMath.toRadians(d * 0.0036096 + 119.743)) * 0.004 + FastMath.sin(FastMath.toRadians(d * 0.1643573 + 239.961)) * 0.0019 + FastMath.sin(FastMath.toRadians(d * 12.9590088 + 25.053)) * -0.0044);
        }

        @Override
        public <T extends RealFieldElement<T>> T getPrimeMeridianAngle(FieldAbsoluteDate<T> date) {
            RealFieldElement d = PredefinedIAUPoles.d(date);
            return (T)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)d.multiply(((RealFieldElement)d.multiply(-1.4E-12)).add(13.17635815))).add(38.3213)).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(-0.0529921)).add(125.045)).sin()).multiply(3.561))).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(-0.1059842)).add(250.089)).sin()).multiply(0.1208))).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(13.0120009)).add(260.008)).sin()).multiply(-0.0642))).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(13.3407154)).add(176.625)).sin()).multiply(0.0158))).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(0.9856003)).add(357.529)).sin()).multiply(0.0252))).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(26.4057084)).add(311.589)).sin()).multiply(-0.0066))).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(13.064993)).add(134.963)).sin()).multiply(-0.0047))).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(0.3287146)).add(276.617)).sin()).multiply(-0.0046))).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(1.7484877)).add(34.226)).sin()).multiply(0.0028))).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(-0.1589763)).add(15.134)).sin()).multiply(0.0052))).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(0.0036096)).add(119.743)).sin()).multiply(0.004))).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(0.1643573)).add(239.961)).sin()).multiply(0.0019))).add(((RealFieldElement)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)d.multiply(12.9590088)).add(25.053)).sin()).multiply(-0.0044)));
        }
    }
    ,
    MARS{
        private static final double ALPHA_0 = 317.68143;
        private static final double ALPHA_DOT = -0.1061;
        private static final double DELTA_0 = 52.8865;
        private static final double DELTA_DOT = -0.0609;
        private static final double W_0 = 176.63;
        private static final double W_DOT = 350.89198226;

        @Override
        public Vector3D getPole(AbsoluteDate date) {
            double t = PredefinedIAUPoles.t(date);
            return new Vector3D(FastMath.toRadians(t * -0.1061 + 317.68143), FastMath.toRadians(t * -0.0609 + 52.8865));
        }

        @Override
        public <T extends RealFieldElement<T>> FieldVector3D<T> getPole(FieldAbsoluteDate<T> date) {
            RealFieldElement t = PredefinedIAUPoles.t(date);
            return new FieldVector3D<RealFieldElement>(PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)t.multiply(-0.1061)).add(317.68143)), PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)t.multiply(-0.0609)).add(52.8865)));
        }

        @Override
        public double getPrimeMeridianAngle(AbsoluteDate date) {
            return FastMath.toRadians(PredefinedIAUPoles.d(date) * 350.89198226 + 176.63);
        }

        @Override
        public <T extends RealFieldElement<T>> T getPrimeMeridianAngle(FieldAbsoluteDate<T> date) {
            return (T)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)PredefinedIAUPoles.d(date).multiply(350.89198226)).add(176.63));
        }
    }
    ,
    JUPITER{
        private static final double ALPHA_0 = 268.056595;
        private static final double ALPHA_DOT = -0.006499;
        private static final double DELTA_0 = 64.495303;
        private static final double DELTA_DOT = 0.002413;
        private static final double JA_0 = 99.360714;
        private static final double JA_DOT = 4850.4046;
        private static final double JA_SIN = 1.17E-4;
        private static final double JA_COS = 5.0E-5;
        private static final double JB_0 = 175.895369;
        private static final double JB_DOT = 1191.9605;
        private static final double JB_SIN = 9.38E-4;
        private static final double JB_COS = 4.04E-4;
        private static final double JC_0 = 300.323162;
        private static final double JC_DOT = 262.5475;
        private static final double JC_SIN = 0.001432;
        private static final double JC_COS = 6.17E-4;
        private static final double JD_0 = 114.012305;
        private static final double JD_DOT = 6070.2476;
        private static final double JD_SIN = 3.0E-5;
        private static final double JD_COS = -1.3E-5;
        private static final double JE_0 = 49.511251;
        private static final double JE_DOT = 64.3;
        private static final double JE_SIN = 0.00215;
        private static final double JE_COS = 9.26E-4;
        private static final double W_0 = 284.95;
        private static final double W_DOT = 870.536;

        @Override
        public Vector3D getPole(AbsoluteDate date) {
            double t = PredefinedIAUPoles.t(date);
            double ja = FastMath.toRadians(t * 4850.4046 + 99.360714);
            double jb = FastMath.toRadians(t * 1191.9605 + 175.895369);
            double jc = FastMath.toRadians(t * 262.5475 + 300.323162);
            double jd = FastMath.toRadians(t * 6070.2476 + 114.012305);
            double je = FastMath.toRadians(t * 64.3 + 49.511251);
            return new Vector3D(FastMath.toRadians(t * -0.006499 + 268.056595 + FastMath.sin(ja) * 1.17E-4 + FastMath.sin(jb) * 9.38E-4 + FastMath.sin(jc) * 0.001432 + FastMath.sin(jd) * 3.0E-5 + FastMath.sin(je) * 0.00215), FastMath.toRadians(t * 0.002413 + 64.495303 + FastMath.cos(ja) * 5.0E-5 + FastMath.cos(jb) * 4.04E-4 + FastMath.cos(jc) * 6.17E-4 + FastMath.cos(jd) * -1.3E-5 + FastMath.cos(je) * 9.26E-4));
        }

        @Override
        public <T extends RealFieldElement<T>> FieldVector3D<T> getPole(FieldAbsoluteDate<T> date) {
            RealFieldElement t = PredefinedIAUPoles.t(date);
            RealFieldElement ja = PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)t.multiply(4850.4046)).add(99.360714));
            RealFieldElement jb = PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)t.multiply(1191.9605)).add(175.895369));
            RealFieldElement jc = PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)t.multiply(262.5475)).add(300.323162));
            RealFieldElement jd = PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)t.multiply(6070.2476)).add(114.012305));
            RealFieldElement je = PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)t.multiply(64.3)).add(49.511251));
            return new FieldVector3D<RealFieldElement>(PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)t.multiply(-0.006499)).add(268.056595)).add(((RealFieldElement)ja.sin()).multiply(1.17E-4))).add(((RealFieldElement)jb.sin()).multiply(9.38E-4))).add(((RealFieldElement)jc.sin()).multiply(0.001432))).add(((RealFieldElement)jd.sin()).multiply(3.0E-5))).add(((RealFieldElement)je.sin()).multiply(0.00215))), PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)t.multiply(0.002413)).add(64.495303)).add(((RealFieldElement)ja.cos()).multiply(5.0E-5))).add(((RealFieldElement)jb.cos()).multiply(4.04E-4))).add(((RealFieldElement)jc.cos()).multiply(6.17E-4))).add(((RealFieldElement)jd.cos()).multiply(-1.3E-5))).add(((RealFieldElement)je.cos()).multiply(9.26E-4))));
        }

        @Override
        public double getPrimeMeridianAngle(AbsoluteDate date) {
            return FastMath.toRadians(PredefinedIAUPoles.d(date) * 870.536 + 284.95);
        }

        @Override
        public <T extends RealFieldElement<T>> T getPrimeMeridianAngle(FieldAbsoluteDate<T> date) {
            return (T)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)PredefinedIAUPoles.d(date).multiply(870.536)).add(284.95));
        }
    }
    ,
    SATURN{
        private static final double ALPHA_0 = 40.589;
        private static final double ALPHA_DOT = -0.036;
        private static final double DELTA_0 = 83.537;
        private static final double DELTA_DOT = -0.004;
        private static final double W_0 = 38.9;
        private static final double W_DOT = 810.7939024;

        @Override
        public Vector3D getPole(AbsoluteDate date) {
            double t = PredefinedIAUPoles.t(date);
            return new Vector3D(FastMath.toRadians(t * -0.036 + 40.589), FastMath.toRadians(t * -0.004 + 83.537));
        }

        @Override
        public <T extends RealFieldElement<T>> FieldVector3D<T> getPole(FieldAbsoluteDate<T> date) {
            RealFieldElement t = PredefinedIAUPoles.t(date);
            return new FieldVector3D<RealFieldElement>(PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)t.multiply(-0.036)).add(40.589)), PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)t.multiply(-0.004)).add(83.537)));
        }

        @Override
        public double getPrimeMeridianAngle(AbsoluteDate date) {
            return FastMath.toRadians(PredefinedIAUPoles.d(date) * 810.7939024 + 38.9);
        }

        @Override
        public <T extends RealFieldElement<T>> T getPrimeMeridianAngle(FieldAbsoluteDate<T> date) {
            return (T)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)PredefinedIAUPoles.d(date).multiply(810.7939024)).add(38.9));
        }
    }
    ,
    URANUS{
        private static final double W_0 = 203.81;
        private static final double W_DOT = -501.1600928;
        private final Vector3D pole = new Vector3D(FastMath.toRadians(257.311), FastMath.toRadians(-15.175));

        @Override
        public Vector3D getPole(AbsoluteDate date) {
            return this.pole;
        }

        @Override
        public <T extends RealFieldElement<T>> FieldVector3D<T> getPole(FieldAbsoluteDate<T> date) {
            return new FieldVector3D<T>(date.getField(), this.pole);
        }

        @Override
        public double getPrimeMeridianAngle(AbsoluteDate date) {
            return FastMath.toRadians(PredefinedIAUPoles.d(date) * -501.1600928 + 203.81);
        }

        @Override
        public <T extends RealFieldElement<T>> T getPrimeMeridianAngle(FieldAbsoluteDate<T> date) {
            return (T)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)PredefinedIAUPoles.d(date).multiply(-501.1600928)).add(203.81));
        }
    }
    ,
    NEPTUNE{
        private static final double ALPHA_0 = 299.36;
        private static final double ALPHA_SIN = 0.7;
        private static final double DELTA_0 = 43.46;
        private static final double DELTA_COS = -0.51;
        private static final double W_0 = 253.18;
        private static final double W_DOT = 536.3128492;
        private static final double W_SIN = -0.48;
        private static final double N_0 = 357.85;
        private static final double N_DOT = 52.316;

        @Override
        public Vector3D getPole(AbsoluteDate date) {
            double n = FastMath.toRadians(PredefinedIAUPoles.t(date) * 52.316 + 357.85);
            return new Vector3D(FastMath.toRadians(FastMath.sin(n) * 0.7 + 299.36), FastMath.toRadians(FastMath.cos(n) * -0.51 + 43.46));
        }

        @Override
        public <T extends RealFieldElement<T>> FieldVector3D<T> getPole(FieldAbsoluteDate<T> date) {
            RealFieldElement n = PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)PredefinedIAUPoles.t(date).multiply(52.316)).add(357.85));
            return new FieldVector3D<RealFieldElement>(PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)((RealFieldElement)n.sin()).multiply(0.7)).add(299.36)), PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)((RealFieldElement)n.cos()).multiply(-0.51)).add(43.46)));
        }

        @Override
        public double getPrimeMeridianAngle(AbsoluteDate date) {
            double n = FastMath.toRadians(PredefinedIAUPoles.t(date) * 52.316 + 357.85);
            return FastMath.toRadians(PredefinedIAUPoles.d(date) * 536.3128492 + FastMath.sin(n) * -0.48 + 253.18);
        }

        @Override
        public <T extends RealFieldElement<T>> T getPrimeMeridianAngle(FieldAbsoluteDate<T> date) {
            RealFieldElement n = PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)PredefinedIAUPoles.t(date).multiply(52.316)).add(357.85));
            return (T)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)((RealFieldElement)PredefinedIAUPoles.d(date).multiply(536.3128492)).add(((RealFieldElement)n.sin()).multiply(-0.48))).add(253.18));
        }
    }
    ,
    PLUTO{
        private static final double W_0 = 302.695;
        private static final double W_DOT = 56.3625225;
        private final Vector3D pole = new Vector3D(FastMath.toRadians(132.993), FastMath.toRadians(-6.163));

        @Override
        public Vector3D getPole(AbsoluteDate date) {
            return this.pole;
        }

        @Override
        public <T extends RealFieldElement<T>> FieldVector3D<T> getPole(FieldAbsoluteDate<T> date) {
            return new FieldVector3D<T>(date.getField(), this.pole);
        }

        @Override
        public double getPrimeMeridianAngle(AbsoluteDate date) {
            return FastMath.toRadians(PredefinedIAUPoles.d(date) * 56.3625225 + 302.695);
        }

        @Override
        public <T extends RealFieldElement<T>> T getPrimeMeridianAngle(FieldAbsoluteDate<T> date) {
            return (T)PredefinedIAUPoles.toRadians((RealFieldElement)((RealFieldElement)PredefinedIAUPoles.d(date).multiply(56.3625225)).add(302.695));
        }
    }
    ,
    GCRF_ALIGNED{

        @Override
        public Vector3D getPole(AbsoluteDate date) {
            return Vector3D.PLUS_K;
        }

        @Override
        public <T extends RealFieldElement<T>> FieldVector3D<T> getPole(FieldAbsoluteDate<T> date) {
            return FieldVector3D.getPlusK(date.getField());
        }

        @Override
        public Vector3D getNode(AbsoluteDate date) {
            return Vector3D.PLUS_I;
        }

        @Override
        public <T extends RealFieldElement<T>> FieldVector3D<T> getNode(FieldAbsoluteDate<T> date) {
            return FieldVector3D.getPlusI(date.getField());
        }

        @Override
        public double getPrimeMeridianAngle(AbsoluteDate date) {
            return 0.0;
        }

        @Override
        public <T extends RealFieldElement<T>> T getPrimeMeridianAngle(FieldAbsoluteDate<T> date) {
            return (T)((RealFieldElement)date.getField().getZero());
        }
    };


    public static PredefinedIAUPoles getIAUPole(JPLEphemeridesLoader.EphemerisType body) {
        switch (body) {
            case SUN: {
                return SUN;
            }
            case MERCURY: {
                return MERCURY;
            }
            case VENUS: {
                return VENUS;
            }
            case EARTH: {
                return EARTH;
            }
            case MOON: {
                return MOON;
            }
            case MARS: {
                return MARS;
            }
            case JUPITER: {
                return JUPITER;
            }
            case SATURN: {
                return SATURN;
            }
            case URANUS: {
                return URANUS;
            }
            case NEPTUNE: {
                return NEPTUNE;
            }
            case PLUTO: {
                return PLUTO;
            }
        }
        return GCRF_ALIGNED;
    }

    private static double t(AbsoluteDate date) {
        return date.offsetFrom(AbsoluteDate.J2000_EPOCH, TimeScalesFactory.getTDB()) / 3.15576E9;
    }

    private static <T extends RealFieldElement<T>> T t(FieldAbsoluteDate<T> date) {
        return (T)((RealFieldElement)date.offsetFrom(FieldAbsoluteDate.getJ2000Epoch(date.getField()), TimeScalesFactory.getTDB()).divide(3.15576E9));
    }

    private static double d(AbsoluteDate date) {
        return date.offsetFrom(AbsoluteDate.J2000_EPOCH, TimeScalesFactory.getTDB()) / 86400.0;
    }

    private static <T extends RealFieldElement<T>> T d(FieldAbsoluteDate<T> date) {
        return (T)((RealFieldElement)date.offsetFrom(FieldAbsoluteDate.getJ2000Epoch(date.getField()), TimeScalesFactory.getTDB()).divide(86400.0));
    }

    private static <T extends RealFieldElement<T>> T toRadians(T angleInDegrees) {
        return (T)((RealFieldElement)angleInDegrees.multiply(Math.PI / 180));
    }
}

