/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Pattern;
import org.hipparchus.exception.DummyLocalizable;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvider;
import org.orekit.data.DataProvidersManager;
import org.orekit.data.NamedData;
import org.orekit.data.ZipJarCrawler;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;

public class DirectoryCrawler
implements DataProvider {
    private final File root;

    public DirectoryCrawler(File root) {
        if (!root.isDirectory()) {
            throw new OrekitException((Localizable)OrekitMessages.NOT_A_DIRECTORY, root.getAbsolutePath());
        }
        this.root = root;
    }

    @Override
    public boolean feed(Pattern supported, DataLoader visitor) {
        try {
            return this.feed(supported, visitor, this.root);
        }
        catch (IOException ioe) {
            throw new OrekitException(ioe, new DummyLocalizable(ioe.getMessage()), new Object[0]);
        }
        catch (ParseException pe) {
            throw new OrekitException(pe, new DummyLocalizable(pe.getMessage()), new Object[0]);
        }
    }

    private boolean feed(Pattern supported, DataLoader visitor, File directory) throws IOException, ParseException {
        File[] list = directory.listFiles();
        Arrays.sort(list, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.compareTo(o2);
            }
        });
        OrekitException delayedException = null;
        boolean loaded = false;
        for (int i = 0; i < list.length; ++i) {
            try {
                if (!visitor.stillAcceptsData()) continue;
                File file = list[i];
                if (file.isDirectory()) {
                    loaded = this.feed(supported, visitor, file) || loaded;
                    continue;
                }
                if (ZIP_ARCHIVE_PATTERN.matcher(file.getName()).matches()) {
                    ZipJarCrawler zipProvider = new ZipJarCrawler(file);
                    loaded = zipProvider.feed(supported, visitor) || loaded;
                    continue;
                }
                NamedData data = new NamedData(file.getName(), () -> new FileInputStream(file));
                data = DataProvidersManager.getInstance().applyAllFilters(data);
                if (!supported.matcher(data.getName()).matches()) continue;
                try (InputStream input = data.getStreamOpener().openStream();){
                    visitor.loadData(input, file.getPath());
                    loaded = true;
                    continue;
                }
            }
            catch (OrekitException oe) {
                delayedException = oe;
            }
        }
        if (!loaded && delayedException != null) {
            throw delayedException;
        }
        return loaded;
    }
}

