/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import org.hipparchus.RealFieldElement;
import org.orekit.data.BodiesElements;
import org.orekit.data.FieldBodiesElements;
import org.orekit.data.SeriesTerm;

class LuniSolarTerm
extends SeriesTerm {
    private final int cL;
    private final int cLPrime;
    private final int cF;
    private final int cD;
    private final int cOmega;

    LuniSolarTerm(int cL, int cLPrime, int cF, int cD, int cOmega) {
        this.cL = cL;
        this.cLPrime = cLPrime;
        this.cF = cF;
        this.cD = cD;
        this.cOmega = cOmega;
    }

    @Override
    protected double argument(BodiesElements elements) {
        return (double)this.cL * elements.getL() + (double)this.cLPrime * elements.getLPrime() + (double)this.cF * elements.getF() + (double)this.cD * elements.getD() + (double)this.cOmega * elements.getOmega();
    }

    @Override
    protected double argumentDerivative(BodiesElements elements) {
        return (double)this.cL * elements.getLDot() + (double)this.cLPrime * elements.getLPrimeDot() + (double)this.cF * elements.getFDot() + (double)this.cD * elements.getDDot() + (double)this.cOmega * elements.getOmegaDot();
    }

    @Override
    protected <T extends RealFieldElement<T>> T argument(FieldBodiesElements<T> elements) {
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)elements.getL().multiply((int)this.cL)).add(elements.getLPrime().multiply((int)this.cLPrime))).add(elements.getF().multiply((int)this.cF))).add(elements.getD().multiply((int)this.cD))).add(elements.getOmega().multiply((int)this.cOmega)));
    }

    @Override
    protected <T extends RealFieldElement<T>> T argumentDerivative(FieldBodiesElements<T> elements) {
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)elements.getLDot().multiply((int)this.cL)).add(elements.getLPrimeDot().multiply((int)this.cLPrime))).add(elements.getFDot().multiply((int)this.cF))).add(elements.getDDot().multiply((int)this.cD))).add(elements.getOmegaDot().multiply((int)this.cOmega)));
    }
}

