/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import java.util.HashMap;
import java.util.Map;
import org.hipparchus.RealFieldElement;
import org.hipparchus.util.MathArrays;
import org.orekit.data.BodiesElements;
import org.orekit.data.FieldBodiesElements;
import org.orekit.data.NutationCodec;
import org.orekit.data.PolynomialNutation;
import org.orekit.data.SeriesTerm;

public class PoissonSeries {
    private final PolynomialNutation polynomial;
    private final Map<Long, SeriesTerm> series;

    public PoissonSeries(PolynomialNutation polynomial, Map<Long, SeriesTerm> series) {
        this.polynomial = polynomial;
        this.series = series;
    }

    public PolynomialNutation getPolynomial() {
        return this.polynomial;
    }

    public int getNonPolynomialSize() {
        return this.series.size();
    }

    public double value(BodiesElements elements) {
        double p = this.polynomial.value(elements.getTC());
        double npHigh = 0.0;
        double npLow = 0.0;
        for (Map.Entry<Long, SeriesTerm> entry : this.series.entrySet()) {
            double v = entry.getValue().value(elements)[0];
            double sum = npHigh + v;
            double sPrime = sum - v;
            double tPrime = sum - sPrime;
            double deltaS = npHigh - sPrime;
            double deltaT = v - tPrime;
            npLow += deltaS + deltaT;
            npHigh = sum;
        }
        return p + (npHigh + npLow);
    }

    public <T extends RealFieldElement<T>> T value(FieldBodiesElements<T> elements) {
        Object tc = elements.getTC();
        RealFieldElement p = this.polynomial.value(tc);
        RealFieldElement sum = (RealFieldElement)tc.getField().getZero();
        for (Map.Entry<Long, SeriesTerm> entry : this.series.entrySet()) {
            sum = sum.add(entry.getValue().value(elements)[0]);
        }
        return (T)p.add((RealFieldElement)sum);
    }

    @SafeVarargs
    public static CompiledSeries compile(PoissonSeries ... poissonSeries) {
        final PolynomialNutation[] polynomials = new PolynomialNutation[poissonSeries.length];
        for (int i = 0; i < polynomials.length; ++i) {
            polynomials[i] = poissonSeries[i].polynomial;
        }
        HashMap<Long, SeriesTerm> joinedMap = new HashMap<Long, SeriesTerm>();
        for (PoissonSeries ps : poissonSeries) {
            for (Map.Entry<Long, SeriesTerm> entry : ps.series.entrySet()) {
                long key = entry.getKey();
                if (joinedMap.containsKey(key)) continue;
                int[] m = NutationCodec.decode(key);
                SeriesTerm term = SeriesTerm.buildTerm(m[0], m[1], m[2], m[3], m[4], m[5], m[6], m[7], m[8], m[9], m[10], m[11], m[12], m[13], m[14]);
                term.add(poissonSeries.length - 1, -1, Double.NaN, Double.NaN);
                joinedMap.put(key, term);
            }
        }
        for (int i = 0; i < poissonSeries.length; ++i) {
            for (Map.Entry<Long, SeriesTerm> entry : poissonSeries[i].series.entrySet()) {
                SeriesTerm singleTerm = entry.getValue();
                SeriesTerm joinedTerm = (SeriesTerm)joinedMap.get(entry.getKey());
                for (int degree = 0; degree <= singleTerm.getDegree(0); ++degree) {
                    joinedTerm.add(i, degree, singleTerm.getSinCoeff(0, degree), singleTerm.getCosCoeff(0, degree));
                }
            }
        }
        final SeriesTerm[] joinedTerms = new SeriesTerm[joinedMap.size()];
        int index = 0;
        for (Map.Entry entry : joinedMap.entrySet()) {
            joinedTerms[index++] = (SeriesTerm)entry.getValue();
        }
        return new CompiledSeries(){

            @Override
            public double[] value(BodiesElements elements) {
                double[] npHigh = new double[polynomials.length];
                double[] npLow = new double[polynomials.length];
                for (SeriesTerm term : joinedTerms) {
                    double[] termValue = term.value(elements);
                    for (int i = 0; i < termValue.length; ++i) {
                        double v = termValue[i];
                        double sum = npHigh[i] + v;
                        double sPrime = sum - v;
                        double tPrime = sum - sPrime;
                        double deltaS = npHigh[i] - sPrime;
                        double deltaT = v - tPrime;
                        int n = i;
                        npLow[n] = npLow[n] + (deltaS + deltaT);
                        npHigh[i] = sum;
                    }
                }
                for (int i = 0; i < npHigh.length; ++i) {
                    int n = i;
                    npHigh[n] = npHigh[n] + (npLow[i] + polynomials[i].value(elements.getTC()));
                }
                return npHigh;
            }

            @Override
            public double[] derivative(BodiesElements elements) {
                double[] v = new double[polynomials.length];
                for (SeriesTerm term : joinedTerms) {
                    double[] termDerivative = term.derivative(elements);
                    for (int i = 0; i < termDerivative.length; ++i) {
                        int n = i;
                        v[n] = v[n] + termDerivative[i];
                    }
                }
                for (int i = 0; i < v.length; ++i) {
                    int n = i;
                    v[n] = v[n] + polynomials[i].derivative(elements.getTC());
                }
                return v;
            }

            @Override
            public <S extends RealFieldElement<S>> S[] value(FieldBodiesElements<S> elements) {
                RealFieldElement[] v = (RealFieldElement[])MathArrays.buildArray(elements.getTC().getField(), polynomials.length);
                for (SeriesTerm term : joinedTerms) {
                    RealFieldElement[] termValue = term.value(elements);
                    for (int i = 0; i < termValue.length; ++i) {
                        v[i] = v[i].add(termValue[i]);
                    }
                }
                Object tc = elements.getTC();
                for (int i = 0; i < v.length; ++i) {
                    v[i] = (RealFieldElement)v[i].add(polynomials[i].value(tc));
                }
                return v;
            }

            @Override
            public <S extends RealFieldElement<S>> S[] derivative(FieldBodiesElements<S> elements) {
                RealFieldElement[] v = (RealFieldElement[])MathArrays.buildArray(elements.getTC().getField(), polynomials.length);
                for (SeriesTerm term : joinedTerms) {
                    RealFieldElement[] termDerivative = term.derivative(elements);
                    for (int i = 0; i < termDerivative.length; ++i) {
                        v[i] = v[i].add(termDerivative[i]);
                    }
                }
                Object tc = elements.getTC();
                for (int i = 0; i < v.length; ++i) {
                    v[i] = (RealFieldElement)v[i].add(polynomials[i].derivative(tc));
                }
                return v;
            }
        };
    }

    public static interface CompiledSeries {
        public double[] value(BodiesElements var1);

        public double[] derivative(BodiesElements var1);

        public <S extends RealFieldElement<S>> S[] value(FieldBodiesElements<S> var1);

        public <S extends RealFieldElement<S>> S[] derivative(FieldBodiesElements<S> var1);
    }
}

