/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.iod;

import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.estimation.measurements.PV;
import org.orekit.frames.Frame;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;

public class IodGibbs {
    private static final double COPLANAR_THRESHOLD = FastMath.toRadians(5.0);
    private final double mu;

    public IodGibbs(double mu) {
        this.mu = mu;
    }

    public KeplerianOrbit estimate(Frame frame, PV pv1, PV pv2, PV pv3) {
        return this.estimate(frame, pv1.getPosition(), pv1.getDate(), pv2.getPosition(), pv2.getDate(), pv3.getPosition(), pv3.getDate());
    }

    public KeplerianOrbit estimate(Frame frame, Vector3D r1, AbsoluteDate date1, Vector3D r2, AbsoluteDate date2, Vector3D r3, AbsoluteDate date3) {
        double num;
        double alpha;
        if (date1.equals(date2) || date1.equals(date3) || date2.equals(date3)) {
            // empty if block
        }
        if (FastMath.abs(alpha = 1.5707963267948966 - FastMath.acos(num = r1.normalize().dotProduct(r2.normalize().crossProduct(r3.normalize())))) > COPLANAR_THRESHOLD) {
            // empty if block
        }
        Vector D = r1.crossProduct(r2).add(r2.crossProduct(r3).add((Vector)r3.crossProduct(r1)));
        Vector N = ((Vector3D)r2.crossProduct(r3).scalarMultiply(r1.getNorm()).add((Vector)r3.crossProduct(r1).scalarMultiply(r2.getNorm()))).add((Vector)r1.crossProduct(r2).scalarMultiply(r3.getNorm()));
        Vector3D B = ((Vector3D)D).crossProduct(r2);
        Vector S = r1.scalarMultiply(r2.getNorm() - r3.getNorm()).add(r2.scalarMultiply(r3.getNorm() - r1.getNorm()).add((Vector)r3.scalarMultiply(r1.getNorm() - r2.getNorm())));
        double vm = FastMath.sqrt(this.mu / (((Vector3D)N).getNorm() * ((Vector3D)D).getNorm()));
        Vector vlEci = B.scalarMultiply(vm / r2.getNorm()).add((Vector)((Vector3D)S).scalarMultiply(vm));
        PVCoordinates pv = new PVCoordinates(r2, (Vector3D)vlEci);
        AbsoluteDate date = date2;
        return new KeplerianOrbit(pv, frame, date, this.mu);
    }
}

