/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Arrays;
import java.util.HashMap;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.MathUtils;
import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.frames.FieldTransform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class AngularAzEl
extends AbstractMeasurement<AngularAzEl> {
    private final GroundStation station;

    public AngularAzEl(GroundStation station, AbsoluteDate date, double[] angular, double[] sigma, double[] baseWeight, ObservableSatellite satellite) {
        super(date, angular, sigma, baseWeight, Arrays.asList(satellite));
        this.addParameterDriver(station.getClockOffsetDriver());
        this.addParameterDriver(station.getEastOffsetDriver());
        this.addParameterDriver(station.getNorthOffsetDriver());
        this.addParameterDriver(station.getZenithOffsetDriver());
        this.addParameterDriver(station.getPrimeMeridianOffsetDriver());
        this.addParameterDriver(station.getPrimeMeridianDriftDriver());
        this.addParameterDriver(station.getPolarOffsetXDriver());
        this.addParameterDriver(station.getPolarDriftXDriver());
        this.addParameterDriver(station.getPolarOffsetYDriver());
        this.addParameterDriver(station.getPolarDriftYDriver());
        this.station = station;
    }

    public GroundStation getStation() {
        return this.station;
    }

    @Override
    protected EstimatedMeasurement<AngularAzEl> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        ObservableSatellite satellite = this.getSatellites().get(0);
        SpacecraftState state = states[satellite.getPropagatorIndex()];
        int nbParams = 6;
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            indices.put(driver.getName(), nbParams++);
        }
        DSFactory factory = new DSFactory(nbParams, 1);
        Field<DerivativeStructure> field = factory.getDerivativeField();
        FieldVector3D<DerivativeStructure> zero = FieldVector3D.getZero(field);
        TimeStampedFieldPVCoordinates<DerivativeStructure> pvaDS = AngularAzEl.getCoordinates(state, 0, factory);
        FieldTransform<DerivativeStructure> offsetToInertialDownlink = this.station.getOffsetToInertial(state.getFrame(), this.getDate(), factory, indices);
        FieldAbsoluteDate<DerivativeStructure> downlinkDateDS = offsetToInertialDownlink.getFieldDate();
        TimeStampedFieldPVCoordinates<DerivativeStructure> stationDownlink = offsetToInertialDownlink.transformPVCoordinates(new TimeStampedFieldPVCoordinates<DerivativeStructure>(downlinkDateDS, zero, zero, zero));
        FieldVector3D<DerivativeStructure> east = offsetToInertialDownlink.transformVector(FieldVector3D.getPlusI(field));
        FieldVector3D<DerivativeStructure> north = offsetToInertialDownlink.transformVector(FieldVector3D.getPlusJ(field));
        FieldVector3D<DerivativeStructure> zenith = offsetToInertialDownlink.transformVector(FieldVector3D.getPlusK(field));
        DerivativeStructure tauD = AngularAzEl.signalTimeOfFlight(pvaDS, stationDownlink.getPosition(), downlinkDateDS);
        DerivativeStructure delta = downlinkDateDS.durationFrom(state.getDate());
        DerivativeStructure deltaMTauD = tauD.negate().add(delta);
        SpacecraftState transitState = state.shiftedBy(deltaMTauD.getValue());
        FieldPVCoordinates transitStateDS = pvaDS.shiftedBy((RealFieldElement)deltaMTauD);
        FieldVector3D<DerivativeStructure> staSat = transitStateDS.getPosition().subtract(stationDownlink.getPosition());
        DerivativeStructure baseAzimuth = DerivativeStructure.atan2(staSat.dotProduct(east), staSat.dotProduct(north));
        double twoPiWrap = MathUtils.normalizeAngle(baseAzimuth.getReal(), this.getObservedValue()[0]) - baseAzimuth.getReal();
        DerivativeStructure azimuth = baseAzimuth.add(twoPiWrap);
        DerivativeStructure elevation = staSat.dotProduct(zenith).divide((DerivativeStructure)staSat.getNorm()).asin();
        EstimatedMeasurement<AngularAzEl> estimated = new EstimatedMeasurement<AngularAzEl>(this, iteration, evaluation, new SpacecraftState[]{transitState}, new TimeStampedPVCoordinates[]{((TimeStampedFieldPVCoordinates)transitStateDS).toTimeStampedPVCoordinates(), stationDownlink.toTimeStampedPVCoordinates()});
        estimated.setEstimatedValue(azimuth.getValue(), elevation.getValue());
        double[] azDerivatives = azimuth.getAllDerivatives();
        double[] elDerivatives = elevation.getAllDerivatives();
        estimated.setStateDerivatives(0, Arrays.copyOfRange(azDerivatives, 1, 7), Arrays.copyOfRange(elDerivatives, 1, 7));
        for (ParameterDriver driver : this.getParametersDrivers()) {
            Integer index = (Integer)indices.get(driver.getName());
            if (index == null) continue;
            estimated.setParameterDerivatives(driver, azDerivatives[index + 1], elDerivatives[index + 1]);
        }
        return estimated;
    }
}

