/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.estimation.measurements.ComparableMeasurement;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedPVCoordinates;

public class EstimatedMeasurement<T extends ObservedMeasurement<T>>
implements ComparableMeasurement {
    private final T observedMeasurement;
    private final int iteration;
    private final int count;
    private final SpacecraftState[] states;
    private final TimeStampedPVCoordinates[] participants;
    private double[] estimatedValue;
    private Status status;
    private double[][][] stateDerivatives;
    private final Map<ParameterDriver, double[]> parametersDerivatives;

    public EstimatedMeasurement(T observedMeasurement, int iteration, int count, SpacecraftState[] states, TimeStampedPVCoordinates[] participants) {
        this.observedMeasurement = observedMeasurement;
        this.iteration = iteration;
        this.count = count;
        this.states = (SpacecraftState[])states.clone();
        this.participants = (TimeStampedPVCoordinates[])participants.clone();
        this.status = Status.PROCESSED;
        this.stateDerivatives = new double[states.length][][];
        this.parametersDerivatives = new IdentityHashMap<ParameterDriver, double[]>();
    }

    public T getObservedMeasurement() {
        return this.observedMeasurement;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.observedMeasurement.getDate();
    }

    public int getIteration() {
        return this.iteration;
    }

    public int getCount() {
        return this.count;
    }

    public SpacecraftState[] getStates() {
        return (SpacecraftState[])this.states.clone();
    }

    public TimeStampedPVCoordinates[] getParticipants() {
        return (TimeStampedPVCoordinates[])this.participants.clone();
    }

    public double getTimeOffset() {
        return this.observedMeasurement.getDate().durationFrom(this.states[0].getDate());
    }

    @Override
    public double[] getObservedValue() {
        return this.observedMeasurement.getObservedValue();
    }

    public double[] getEstimatedValue() {
        return (double[])this.estimatedValue.clone();
    }

    public void setEstimatedValue(double ... estimatedValue) {
        this.estimatedValue = (double[])estimatedValue.clone();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public double[][] getStateDerivatives(int index) {
        double[][] sd = new double[this.observedMeasurement.getDimension()][];
        for (int i = 0; i < this.observedMeasurement.getDimension(); ++i) {
            sd[i] = (double[])this.stateDerivatives[index][i].clone();
        }
        return sd;
    }

    public void setStateDerivatives(int index, double[] ... derivatives) {
        this.stateDerivatives[index] = new double[this.observedMeasurement.getDimension()][];
        for (int i = 0; i < this.observedMeasurement.getDimension(); ++i) {
            this.stateDerivatives[index][i] = (double[])derivatives[i].clone();
        }
    }

    public Stream<ParameterDriver> getDerivativesDrivers() {
        return this.parametersDerivatives.entrySet().stream().map(entry -> (ParameterDriver)entry.getKey());
    }

    public double[] getParameterDerivatives(ParameterDriver driver) throws OrekitIllegalArgumentException {
        double[] p = this.parametersDerivatives.get(driver);
        if (p == null) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<ParameterDriver, double[]> entry : this.parametersDerivatives.entrySet()) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(entry.getKey().getName());
            }
            throw new OrekitIllegalArgumentException(OrekitMessages.UNSUPPORTED_PARAMETER_NAME, driver.getName(), builder.length() > 0 ? builder.toString() : "<none>");
        }
        return p;
    }

    public void setParameterDerivatives(ParameterDriver driver, double ... parameterDerivatives) {
        this.parametersDerivatives.put(driver, parameterDerivatives);
    }

    public static enum Status {
        PROCESSED,
        REJECTED;

    }
}

