/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.Iterator;
import java.util.TreeSet;
import org.hipparchus.util.FastMath;
import org.orekit.estimation.measurements.gnss.AbstractLambdaMethod;
import org.orekit.estimation.measurements.gnss.AlternatingSampler;

public class LambdaMethod
extends AbstractLambdaMethod {
    private static final double CHI2_MARGIN_FACTOR = 1.1;

    @Override
    protected void ltdlDecomposition() {
        double[] diag = this.getDiagReference();
        double[] low = this.getLowReference();
        for (int k = diag.length - 1; k >= 0; --k) {
            double inv = 1.0 / diag[k];
            int i = 0;
            while (i < k) {
                double lki = low[this.lIndex(k, i)];
                for (int j = 0; j < i; ++j) {
                    int n = this.lIndex(i, j);
                    low[n] = low[n] - lki * low[this.lIndex(k, j)] * inv;
                }
                int n = i++;
                diag[n] = diag[n] - lki * lki * inv;
            }
            for (int j = 0; j < k; ++j) {
                int n = this.lIndex(k, j);
                low[n] = low[n] * inv;
            }
        }
    }

    @Override
    protected void reduction() {
        int kSaved;
        double[] diag = this.getDiagReference();
        double[] low = this.getLowReference();
        int n = diag.length;
        int k0 = kSaved = n - 2;
        while (k0 >= 0) {
            double lk1k0;
            double delta;
            int k1 = k0 + 1;
            if (k0 <= kSaved) {
                for (int i = k0 + 1; i < n; ++i) {
                    this.integerGaussTransformation(i, k0);
                }
            }
            if ((delta = diag[k0] + (lk1k0 = low[this.lIndex(k1, k0)]) * lk1k0 * diag[k1]) < diag[k1]) {
                this.permutation(k0, delta);
                kSaved = k0;
                k0 = n - 2;
                continue;
            }
            --k0;
        }
    }

    @Override
    protected void discreteSearch() {
        double[] diag = this.getDiagReference();
        int n = diag.length;
        long[] fixed = new long[n];
        double[] offsets = new double[n];
        double[] left = new double[n];
        double[] right = new double[n];
        int maxSolutions = this.getMaxSolution();
        double[] decorrelated = this.getDecorrelatedReference();
        AlternatingSampler[] samplers = new AlternatingSampler[n];
        double chi2 = this.estimateChi2(fixed, offsets);
        right[n - 1] = chi2 / diag[n - 1];
        int index = n - 1;
        while (index < n) {
            if (index == -1) {
                double squaredNorm = chi2 - diag[0] * (right[0] - left[0]);
                this.addSolution(fixed, squaredNorm);
                int size = this.getSolutionsSize();
                if (size >= maxSolutions) {
                    chi2 = squaredNorm;
                    right[n - 1] = chi2 / diag[n - 1];
                    for (int i = n - 1; i > 0; --i) {
                        samplers[i].setRadius(FastMath.sqrt(right[i]));
                        right[i - 1] = diag[i] / diag[i - 1] * (right[i] - left[i]);
                    }
                    samplers[0].setRadius(FastMath.sqrt(right[0]));
                    if (size > maxSolutions) {
                        this.removeSolution();
                    }
                }
                ++index;
                continue;
            }
            if (samplers[index] == null) {
                samplers[index] = new AlternatingSampler(this.conditionalEstimate(index, offsets), FastMath.sqrt(right[index]));
            } else {
                samplers[index].generateNext();
            }
            if (samplers[index].inRange()) {
                fixed[index] = samplers[index].getCurrent();
                offsets[index] = (double)fixed[index] - decorrelated[index];
                double delta = (double)fixed[index] - samplers[index].getMidPoint();
                left[index] = delta * delta;
                if (index > 0) {
                    right[index - 1] = diag[index] / diag[index - 1] * (right[index] - left[index]);
                }
                --index;
                continue;
            }
            samplers[index] = null;
            ++index;
        }
    }

    @Override
    protected void inverseDecomposition() {
        double[] diag = this.getDiagReference();
        double[] low = this.getLowReference();
        int n = diag.length;
        double[] row = new double[n - 1];
        diag[0] = 1.0 / diag[0];
        for (int k = 1; k < n; ++k) {
            int iK = this.lIndex(k, 0);
            System.arraycopy(low, iK, row, 0, k);
            for (int j = 0; j < k; ++j) {
                double sum = row[j];
                for (int l = j + 1; l < k; ++l) {
                    sum += row[l] * low[this.lIndex(l, j)];
                }
                low[iK + j] = -sum;
            }
            diag[k] = 1.0 / diag[k];
        }
    }

    private double estimateChi2(long[] fixed, double[] offsets) {
        double[] diag = this.getDiagReference();
        int n = diag.length;
        int maxSolutions = this.getMaxSolution();
        double[] decorrelated = this.getDecorrelatedReference();
        AlternatingSampler[] samplers = new AlternatingSampler[n];
        for (int i = 0; i < n; ++i) {
            samplers[i] = new AlternatingSampler(decorrelated[i], 0.0);
        }
        TreeSet<Double> squaredNorms = new TreeSet<Double>();
        for (int i = 0; i < n; ++i) {
            fixed[i] = samplers[i].getCurrent();
        }
        squaredNorms.add(this.squaredNorm(fixed, offsets));
        while (squaredNorms.size() < maxSolutions) {
            int remaining = FastMath.min(n, maxSolutions - squaredNorms.size());
            for (int i = 0; i < remaining; ++i) {
                long saved = fixed[i];
                samplers[i].generateNext();
                fixed[i] = samplers[i].getCurrent();
                squaredNorms.add(this.squaredNorm(fixed, offsets));
                fixed[i] = saved;
            }
        }
        int count = 0;
        Iterator iterator = squaredNorms.iterator();
        while (iterator.hasNext()) {
            double s = (Double)iterator.next();
            if (++count != maxSolutions) continue;
            return s * 1.1;
        }
        return Double.NaN;
    }

    private double squaredNorm(long[] fixed, double[] offsets) {
        double[] diag = this.getDiagReference();
        double[] decorrelated = this.getDecorrelatedReference();
        double n2 = 0.0;
        for (int i = diag.length - 1; i >= 0; --i) {
            offsets[i] = (double)fixed[i] - decorrelated[i];
            double delta = (double)fixed[i] - this.conditionalEstimate(i, offsets);
            n2 += diag[i] * delta * delta;
        }
        return n2;
    }

    private double conditionalEstimate(int i, double[] offsets) {
        double[] diag = this.getDiagReference();
        double[] low = this.getLowReference();
        double[] decorrelated = this.getDecorrelatedReference();
        double conditional = decorrelated[i];
        for (int j = i + 1; j < diag.length; ++j) {
            conditional -= low[this.lIndex(j, i)] * offsets[j];
        }
        return conditional;
    }
}

