/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Collections;
import java.util.List;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.InterSatellitesRange;
import org.orekit.frames.Transform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedPVCoordinates;

public class OnBoardAntennaInterSatellitesRangeModifier
implements EstimationModifier<InterSatellitesRange> {
    private final Vector3D antennaPhaseCenter1;
    private final Vector3D antennaPhaseCenter2;

    public OnBoardAntennaInterSatellitesRangeModifier(Vector3D antennaPhaseCenter1, Vector3D antennaPhaseCenter2) {
        this.antennaPhaseCenter1 = antennaPhaseCenter1;
        this.antennaPhaseCenter2 = antennaPhaseCenter2;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    @Override
    public void modify(EstimatedMeasurement<InterSatellitesRange> estimated) {
        if (estimated.getParticipants().length < 3) {
            this.modifyOneWay(estimated);
        } else {
            this.modifyTwoWay(estimated);
        }
    }

    private void modifyOneWay(EstimatedMeasurement<InterSatellitesRange> estimated) {
        TimeStampedPVCoordinates[] participants = estimated.getParticipants();
        AbsoluteDate emissionDate = participants[0].getDate();
        AbsoluteDate receptionDate = participants[1].getDate();
        SpacecraftState refState1 = estimated.getStates()[0];
        SpacecraftState receptionState = refState1.shiftedBy(receptionDate.durationFrom(refState1.getDate()));
        Transform receptionSpacecraftToInert = receptionState.toTransform().getInverse();
        SpacecraftState refState2 = estimated.getStates()[1];
        SpacecraftState emissionState = refState2.shiftedBy(emissionDate.durationFrom(refState2.getDate()));
        Transform emissionSpacecraftToInert = emissionState.toTransform().getInverse();
        Vector3D pSpacecraftReception = receptionSpacecraftToInert.transformPosition(Vector3D.ZERO);
        Vector3D pSpacecraftEmission = emissionSpacecraftToInert.transformPosition(Vector3D.ZERO);
        double interSatellitesRangeUsingSpacecraftCenter = Vector3D.distance(pSpacecraftEmission, pSpacecraftReception);
        Vector3D pAPCReception = receptionSpacecraftToInert.transformPosition(this.antennaPhaseCenter1);
        Vector3D pAPCEmission = emissionSpacecraftToInert.transformPosition(this.antennaPhaseCenter2);
        double interSatellitesRangeUsingAntennaPhaseCenter = Vector3D.distance(pAPCEmission, pAPCReception);
        double[] value = estimated.getEstimatedValue();
        value[0] = value[0] + (interSatellitesRangeUsingAntennaPhaseCenter - interSatellitesRangeUsingSpacecraftCenter);
        estimated.setEstimatedValue(value);
    }

    private void modifyTwoWay(EstimatedMeasurement<InterSatellitesRange> estimated) {
        TimeStampedPVCoordinates[] participants = estimated.getParticipants();
        AbsoluteDate emissionDate = participants[0].getDate();
        AbsoluteDate transitDate = participants[1].getDate();
        AbsoluteDate receptionDate = participants[2].getDate();
        SpacecraftState refState1 = estimated.getStates()[0];
        SpacecraftState receptionState = refState1.shiftedBy(receptionDate.durationFrom(refState1.getDate()));
        Transform receptionSpacecraftToInert = receptionState.toTransform().getInverse();
        SpacecraftState refState2 = estimated.getStates()[1];
        SpacecraftState transitState = refState2.shiftedBy(transitDate.durationFrom(refState2.getDate()));
        Transform transitSpacecraftToInert = transitState.toTransform().getInverse();
        SpacecraftState emissionState = refState1.shiftedBy(emissionDate.durationFrom(refState1.getDate()));
        Transform emissionSpacecraftToInert = emissionState.toTransform().getInverse();
        Vector3D pSpacecraftReception = receptionSpacecraftToInert.transformPosition(Vector3D.ZERO);
        Vector3D pSpacecraftTransit = transitSpacecraftToInert.transformPosition(Vector3D.ZERO);
        Vector3D pSpacecraftEmission = emissionSpacecraftToInert.transformPosition(Vector3D.ZERO);
        double interSatellitesRangeUsingSpacecraftCenter = 0.5 * (Vector3D.distance(pSpacecraftEmission, pSpacecraftTransit) + Vector3D.distance(pSpacecraftTransit, pSpacecraftReception));
        Vector3D pAPCReception = receptionSpacecraftToInert.transformPosition(this.antennaPhaseCenter1);
        Vector3D pAPCTransit = transitSpacecraftToInert.transformPosition(this.antennaPhaseCenter2);
        Vector3D pAPCEmission = emissionSpacecraftToInert.transformPosition(this.antennaPhaseCenter1);
        double interSatellitesRangeUsingAntennaPhaseCenter = 0.5 * (Vector3D.distance(pAPCEmission, pAPCTransit) + Vector3D.distance(pAPCTransit, pAPCReception));
        double[] value = estimated.getEstimatedValue();
        value[0] = value[0] + (interSatellitesRangeUsingAntennaPhaseCenter - interSatellitesRangeUsingSpacecraftCenter);
        estimated.setEstimatedValue(value);
    }
}

