/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Collections;
import java.util.List;
import org.hipparchus.util.FastMath;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.gnss.Phase;
import org.orekit.utils.ParameterDriver;

public class PhaseAmbiguityModifier
implements EstimationModifier<Phase> {
    private static final double AMBIGUITY_SCALE = FastMath.scalb(1.0, 26);
    private final ParameterDriver ambiguity;

    public PhaseAmbiguityModifier(int key, double ambiguity) {
        this.ambiguity = new ParameterDriver("amgiguity-" + key, ambiguity, AMBIGUITY_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.singletonList(this.ambiguity);
    }

    @Override
    public void modify(EstimatedMeasurement<Phase> estimated) {
        double[] value = estimated.getEstimatedValue();
        value[0] = value[0] + this.ambiguity.getValue();
        if (this.ambiguity.isSelected()) {
            estimated.setParameterDerivatives(this.ambiguity, 1.0);
        }
        estimated.setEstimatedValue(value);
    }
}

