/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.sequential;

import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.orekit.errors.OrekitException;
import org.orekit.estimation.sequential.AbstractCovarianceMatrixProvider;
import org.orekit.frames.LOFType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.CartesianDerivativesFilter;

public class UnivariateProcessNoise
extends AbstractCovarianceMatrixProvider {
    private final LOFType lofType;
    private final PositionAngle positionAngle;
    private final UnivariateFunction[] lofCartesianOrbitalParametersEvolution;
    private final UnivariateFunction[] propagationParametersEvolution;

    public UnivariateProcessNoise(RealMatrix initialCovarianceMatrix, LOFType lofType, PositionAngle positionAngle, UnivariateFunction[] lofCartesianOrbitalParametersEvolution, UnivariateFunction[] propagationParametersEvolution) {
        super(initialCovarianceMatrix);
        this.lofType = lofType;
        this.positionAngle = positionAngle;
        this.lofCartesianOrbitalParametersEvolution = (UnivariateFunction[])lofCartesianOrbitalParametersEvolution.clone();
        this.propagationParametersEvolution = (UnivariateFunction[])propagationParametersEvolution.clone();
        if (lofCartesianOrbitalParametersEvolution.length != 6) {
            throw new OrekitException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, lofCartesianOrbitalParametersEvolution, 6);
        }
    }

    public LOFType getLofType() {
        return this.lofType;
    }

    public PositionAngle getPositionAngle() {
        return this.positionAngle;
    }

    public UnivariateFunction[] getLofCartesianOrbitalParametersEvolution() {
        return (UnivariateFunction[])this.lofCartesianOrbitalParametersEvolution.clone();
    }

    public UnivariateFunction[] getPropagationParametersEvolution() {
        return (UnivariateFunction[])this.propagationParametersEvolution.clone();
    }

    @Override
    public RealMatrix getProcessNoiseMatrix(SpacecraftState previous, SpacecraftState current) {
        RealMatrix inertialOrbitalProcessNoiseMatrix = this.getInertialOrbitalProcessNoiseMatrix(previous, current);
        if (this.propagationParametersEvolution.length == 0) {
            return inertialOrbitalProcessNoiseMatrix;
        }
        RealMatrix propagationProcessNoiseMatrix = this.getPropagationProcessNoiseMatrix(previous, current);
        int orbitalMatrixSize = this.lofCartesianOrbitalParametersEvolution.length;
        int propagationMatrixSize = this.propagationParametersEvolution.length;
        RealMatrix processNoiseMatrix = MatrixUtils.createRealMatrix(orbitalMatrixSize + propagationMatrixSize, orbitalMatrixSize + propagationMatrixSize);
        processNoiseMatrix.setSubMatrix(inertialOrbitalProcessNoiseMatrix.getData(), 0, 0);
        processNoiseMatrix.setSubMatrix(propagationProcessNoiseMatrix.getData(), orbitalMatrixSize, orbitalMatrixSize);
        return processNoiseMatrix;
    }

    private RealMatrix getInertialOrbitalProcessNoiseMatrix(SpacecraftState previous, SpacecraftState current) {
        double deltaT = current.getDate().durationFrom(previous.getDate());
        int lofOrbitalprocessNoiseLength = this.lofCartesianOrbitalParametersEvolution.length;
        double[] lofOrbitalProcessNoiseValues = new double[lofOrbitalprocessNoiseLength];
        for (int i = 0; i < lofOrbitalprocessNoiseLength; ++i) {
            double functionValue = this.lofCartesianOrbitalParametersEvolution[i].value(deltaT);
            lofOrbitalProcessNoiseValues[i] = functionValue * functionValue;
        }
        RealMatrix lofCartesianProcessNoiseMatrix = MatrixUtils.createRealDiagonalMatrix(lofOrbitalProcessNoiseValues);
        double[][] dLofdInertial = new double[6][6];
        this.lofType.transformFromInertial(current.getDate(), current.getPVCoordinates()).getInverse().getJacobian(CartesianDerivativesFilter.USE_PV, dLofdInertial);
        RealMatrix jacLofToInertial = MatrixUtils.createRealMatrix(dLofdInertial);
        double[][] dYdC = new double[6][6];
        current.getOrbit().getJacobianWrtCartesian(this.positionAngle, dYdC);
        RealMatrix jacOrbitWrtCartesian = MatrixUtils.createRealMatrix(dYdC);
        RealMatrix jacobian = jacOrbitWrtCartesian.multiply(jacLofToInertial);
        RealMatrix inertialOrbitalProcessNoiseMatrix = jacobian.multiply(lofCartesianProcessNoiseMatrix).multiplyTransposed(jacobian);
        return inertialOrbitalProcessNoiseMatrix;
    }

    private RealMatrix getPropagationProcessNoiseMatrix(SpacecraftState previous, SpacecraftState current) {
        double deltaT = current.getDate().durationFrom(previous.getDate());
        int propagationProcessNoiseLength = this.propagationParametersEvolution.length;
        double[] propagationProcessNoiseValues = new double[propagationProcessNoiseLength];
        for (int i = 0; i < propagationProcessNoiseLength; ++i) {
            double functionValue = this.propagationParametersEvolution[i].value(deltaT);
            propagationProcessNoiseValues[i] = functionValue * functionValue;
        }
        return MatrixUtils.createRealDiagonalMatrix(propagationProcessNoiseValues);
    }
}

