/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.hipparchus.exception.DummyLocalizable;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.KeyValue;
import org.orekit.files.ccsds.ODMParser;
import org.orekit.files.ccsds.OMMFile;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;

public class OMMParser
extends ODMParser {
    public OMMParser() {
        this(AbsoluteDate.FUTURE_INFINITY, Double.NaN, null, true, 0, 0, "");
    }

    private OMMParser(AbsoluteDate missionReferenceDate, double mu, IERSConventions conventions, boolean simpleEOP, int launchYear, int launchNumber, String launchPiece) {
        super(missionReferenceDate, mu, conventions, simpleEOP, launchYear, launchNumber, launchPiece);
    }

    @Override
    public OMMParser withMissionReferenceDate(AbsoluteDate newMissionReferenceDate) {
        return new OMMParser(newMissionReferenceDate, this.getMu(), this.getConventions(), this.isSimpleEOP(), this.getLaunchYear(), this.getLaunchNumber(), this.getLaunchPiece());
    }

    @Override
    public OMMParser withMu(double newMu) {
        return new OMMParser(this.getMissionReferenceDate(), newMu, this.getConventions(), this.isSimpleEOP(), this.getLaunchYear(), this.getLaunchNumber(), this.getLaunchPiece());
    }

    @Override
    public OMMParser withConventions(IERSConventions newConventions) {
        return new OMMParser(this.getMissionReferenceDate(), this.getMu(), newConventions, this.isSimpleEOP(), this.getLaunchYear(), this.getLaunchNumber(), this.getLaunchPiece());
    }

    @Override
    public OMMParser withSimpleEOP(boolean newSimpleEOP) {
        return new OMMParser(this.getMissionReferenceDate(), this.getMu(), this.getConventions(), newSimpleEOP, this.getLaunchYear(), this.getLaunchNumber(), this.getLaunchPiece());
    }

    @Override
    public OMMParser withInternationalDesignator(int newLaunchYear, int newLaunchNumber, String newLaunchPiece) {
        return new OMMParser(this.getMissionReferenceDate(), this.getMu(), this.getConventions(), this.isSimpleEOP(), newLaunchYear, newLaunchNumber, newLaunchPiece);
    }

    @Override
    public OMMFile parse(String fileName) {
        return (OMMFile)super.parse(fileName);
    }

    @Override
    public OMMFile parse(InputStream stream) {
        return (OMMFile)super.parse(stream);
    }

    @Override
    public OMMFile parse(InputStream stream, String fileName) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            ParseInfo pi = new ParseInfo();
            pi.fileName = fileName;
            OMMFile file = pi.file;
            pi.file.setMissionReferenceDate(this.getMissionReferenceDate());
            pi.file.setMuSet(this.getMu());
            pi.file.setConventions(this.getConventions());
            pi.file.getMetaData().setLaunchYear(this.getLaunchYear());
            pi.file.getMetaData().setLaunchNumber(this.getLaunchNumber());
            pi.file.getMetaData().setLaunchPiece(this.getLaunchPiece());
            String line = reader.readLine();
            while (line != null) {
                ++pi.lineNumber;
                if (line.trim().length() != 0) {
                    pi.keyValue = new KeyValue(line, pi.lineNumber, pi.fileName);
                    if (pi.keyValue.getKeyword() == null) {
                        throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNEXPECTED_KEYWORD, pi.lineNumber, pi.fileName, line);
                    }
                    switch (pi.keyValue.getKeyword()) {
                        case CCSDS_OMM_VERS: {
                            file.setFormatVersion(pi.keyValue.getDoubleValue());
                            break;
                        }
                        case MEAN_ELEMENT_THEORY: {
                            file.getMetaData().setMeanElementTheory(pi.keyValue.getValue());
                            break;
                        }
                        case MEAN_MOTION: {
                            file.setMeanMotion(pi.keyValue.getDoubleValue() * Math.PI / 43200.0);
                            break;
                        }
                        case EPHEMERIS_TYPE: {
                            file.setTLERelatedParametersComment(pi.commentTmp);
                            pi.commentTmp.clear();
                            file.setEphemerisType(Integer.parseInt(pi.keyValue.getValue()));
                            break;
                        }
                        case CLASSIFICATION_TYPE: {
                            file.setClassificationType(pi.keyValue.getValue().charAt(0));
                            break;
                        }
                        case NORAD_CAT_ID: {
                            file.setNoradID(Integer.parseInt(pi.keyValue.getValue()));
                            break;
                        }
                        case ELEMENT_SET_NO: {
                            file.setElementSetNo(pi.keyValue.getValue());
                            break;
                        }
                        case REV_AT_EPOCH: {
                            file.setRevAtEpoch(Integer.parseInt(pi.keyValue.getValue()));
                            break;
                        }
                        case BSTAR: {
                            file.setbStar(pi.keyValue.getDoubleValue());
                            break;
                        }
                        case MEAN_MOTION_DOT: {
                            file.setMeanMotionDot(pi.keyValue.getDoubleValue() * Math.PI / 1.86624E9);
                            break;
                        }
                        case MEAN_MOTION_DDOT: {
                            file.setMeanMotionDotDot(pi.keyValue.getDoubleValue() * Math.PI / 5.3747712E13);
                            break;
                        }
                        default: {
                            boolean parsed = false;
                            parsed = parsed || this.parseComment(pi.keyValue, pi.commentTmp);
                            parsed = parsed || this.parseHeaderEntry(pi.keyValue, file, pi.commentTmp);
                            parsed = parsed || this.parseMetaDataEntry(pi.keyValue, file.getMetaData(), pi.commentTmp);
                            boolean bl = parsed = parsed || this.parseGeneralStateDataEntry(pi.keyValue, file, pi.commentTmp);
                            if (parsed) break;
                            throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNEXPECTED_KEYWORD, pi.lineNumber, pi.fileName, line);
                        }
                    }
                }
                line = reader.readLine();
            }
            reader.close();
            return file;
        }
        catch (IOException ioe) {
            throw new OrekitException(ioe, new DummyLocalizable(ioe.getMessage()), new Object[0]);
        }
    }

    private static class ParseInfo {
        private OMMFile file = new OMMFile();
        private String fileName;
        private int lineNumber = 0;
        private KeyValue keyValue;
        private List<String> commentTmp = new ArrayList<String>();

        protected ParseInfo() {
        }
    }
}

