/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Euclidean3D;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.forces.drag.DragSensitive;
import org.orekit.forces.radiation.RadiationSensitive;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.ParameterDriver;

public class BoxAndSolarArraySpacecraft
implements RadiationSensitive,
DragSensitive {
    private final double SCALE = FastMath.scalb(1.0, -3);
    private final ParameterDriver dragParameterDriver;
    private final ParameterDriver liftParameterDriver;
    private final ParameterDriver absorptionParameterDriver;
    private final ParameterDriver reflectionParameterDriver;
    private final List<Facet> facets;
    private final double solarArrayArea;
    private final AbsoluteDate referenceDate;
    private final double rotationRate;
    private final Vector3D saX;
    private final Vector3D saY;
    private final Vector3D saZ;
    private final PVCoordinatesProvider sun;

    public BoxAndSolarArraySpacecraft(double xLength, double yLength, double zLength, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, double dragCoeff, double absorptionCoeff, double reflectionCoeff) {
        this(BoxAndSolarArraySpacecraft.simpleBoxFacets(xLength, yLength, zLength), sun, solarArrayArea, solarArrayAxis, dragCoeff, 0.0, false, absorptionCoeff, reflectionCoeff);
    }

    public BoxAndSolarArraySpacecraft(double xLength, double yLength, double zLength, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, double dragCoeff, double liftRatio, double absorptionCoeff, double reflectionCoeff) {
        this(BoxAndSolarArraySpacecraft.simpleBoxFacets(xLength, yLength, zLength), sun, solarArrayArea, solarArrayAxis, dragCoeff, liftRatio, absorptionCoeff, reflectionCoeff);
    }

    public BoxAndSolarArraySpacecraft(Facet[] facets, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, double dragCoeff, double absorptionCoeff, double reflectionCoeff) {
        this(facets, sun, solarArrayArea, solarArrayAxis, dragCoeff, 0.0, false, absorptionCoeff, reflectionCoeff);
    }

    public BoxAndSolarArraySpacecraft(Facet[] facets, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, double dragCoeff, double liftRatio, double absorptionCoeff, double reflectionCoeff) {
        this(facets, sun, solarArrayArea, solarArrayAxis, dragCoeff, liftRatio, true, absorptionCoeff, reflectionCoeff);
    }

    private BoxAndSolarArraySpacecraft(Facet[] facets, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, double dragCoeff, double liftRatio, boolean useLift, double absorptionCoeff, double reflectionCoeff) {
        this.dragParameterDriver = this.buildDragParameterDriver(dragCoeff);
        this.liftParameterDriver = useLift ? this.buildLiftParameterDriver(liftRatio) : null;
        this.absorptionParameterDriver = this.buildAbsorptionParameterDriver(absorptionCoeff);
        this.reflectionParameterDriver = this.buildReflectionParameterDriver(reflectionCoeff);
        this.facets = BoxAndSolarArraySpacecraft.filter(facets);
        this.sun = sun;
        this.solarArrayArea = solarArrayArea;
        this.referenceDate = null;
        this.rotationRate = 0.0;
        this.saZ = solarArrayAxis.normalize();
        this.saY = null;
        this.saX = null;
    }

    public BoxAndSolarArraySpacecraft(double xLength, double yLength, double zLength, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, AbsoluteDate referenceDate, Vector3D referenceNormal, double rotationRate, double dragCoeff, double absorptionCoeff, double reflectionCoeff) {
        this(BoxAndSolarArraySpacecraft.simpleBoxFacets(xLength, yLength, zLength), sun, solarArrayArea, solarArrayAxis, referenceDate, referenceNormal, rotationRate, dragCoeff, 0.0, false, absorptionCoeff, reflectionCoeff);
    }

    public BoxAndSolarArraySpacecraft(double xLength, double yLength, double zLength, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, AbsoluteDate referenceDate, Vector3D referenceNormal, double rotationRate, double dragCoeff, double liftRatio, double absorptionCoeff, double reflectionCoeff) {
        this(BoxAndSolarArraySpacecraft.simpleBoxFacets(xLength, yLength, zLength), sun, solarArrayArea, solarArrayAxis, referenceDate, referenceNormal, rotationRate, dragCoeff, liftRatio, true, absorptionCoeff, reflectionCoeff);
    }

    public BoxAndSolarArraySpacecraft(Facet[] facets, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, AbsoluteDate referenceDate, Vector3D referenceNormal, double rotationRate, double dragCoeff, double absorptionCoeff, double reflectionCoeff) {
        this(facets, sun, solarArrayArea, solarArrayAxis, referenceDate, referenceNormal, rotationRate, dragCoeff, 0.0, false, absorptionCoeff, reflectionCoeff);
    }

    public BoxAndSolarArraySpacecraft(Facet[] facets, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, AbsoluteDate referenceDate, Vector3D referenceNormal, double rotationRate, double dragCoeff, double liftRatio, double absorptionCoeff, double reflectionCoeff) {
        this(facets, sun, solarArrayArea, solarArrayAxis, referenceDate, referenceNormal, rotationRate, dragCoeff, liftRatio, true, absorptionCoeff, reflectionCoeff);
    }

    private BoxAndSolarArraySpacecraft(Facet[] facets, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, AbsoluteDate referenceDate, Vector3D referenceNormal, double rotationRate, double dragCoeff, double liftRatio, boolean useLift, double absorptionCoeff, double reflectionCoeff) {
        this.dragParameterDriver = this.buildDragParameterDriver(dragCoeff);
        this.liftParameterDriver = useLift ? this.buildLiftParameterDriver(liftRatio) : null;
        this.absorptionParameterDriver = this.buildAbsorptionParameterDriver(absorptionCoeff);
        this.reflectionParameterDriver = this.buildReflectionParameterDriver(reflectionCoeff);
        this.facets = BoxAndSolarArraySpacecraft.filter((Facet[])facets.clone());
        this.sun = sun;
        this.solarArrayArea = solarArrayArea;
        this.referenceDate = referenceDate;
        this.rotationRate = rotationRate;
        this.saZ = solarArrayAxis.normalize();
        this.saY = Vector3D.crossProduct(this.saZ, referenceNormal).normalize();
        this.saX = Vector3D.crossProduct(this.saY, this.saZ);
    }

    private ParameterDriver buildDragParameterDriver(double coeff) {
        try {
            return new ParameterDriver("drag coefficient", coeff, this.SCALE, 0.0, Double.POSITIVE_INFINITY);
        }
        catch (OrekitException oe) {
            throw new OrekitInternalError(oe);
        }
    }

    private ParameterDriver buildLiftParameterDriver(double coeff) {
        try {
            return new ParameterDriver("lift ratio", coeff, this.SCALE, 0.0, 1.0);
        }
        catch (OrekitException oe) {
            throw new OrekitInternalError(oe);
        }
    }

    private ParameterDriver buildAbsorptionParameterDriver(double coeff) {
        try {
            return new ParameterDriver("absorption coefficient", coeff, this.SCALE, 0.0, 1.0);
        }
        catch (OrekitException oe) {
            throw new OrekitInternalError(oe);
        }
    }

    private ParameterDriver buildReflectionParameterDriver(double coeff) {
        try {
            return new ParameterDriver("reflection coefficient", coeff, this.SCALE, 0.0, 1.0);
        }
        catch (OrekitException oe) {
            throw new OrekitInternalError(oe);
        }
    }

    @Override
    public ParameterDriver[] getDragParametersDrivers() {
        ParameterDriver[] parameterDriverArray;
        if (this.liftParameterDriver == null) {
            ParameterDriver[] parameterDriverArray2 = new ParameterDriver[1];
            parameterDriverArray = parameterDriverArray2;
            parameterDriverArray2[0] = this.dragParameterDriver;
        } else {
            ParameterDriver[] parameterDriverArray3 = new ParameterDriver[2];
            parameterDriverArray3[0] = this.dragParameterDriver;
            parameterDriverArray = parameterDriverArray3;
            parameterDriverArray3[1] = this.liftParameterDriver;
        }
        return parameterDriverArray;
    }

    @Override
    public ParameterDriver[] getRadiationParametersDrivers() {
        return new ParameterDriver[]{this.absorptionParameterDriver, this.reflectionParameterDriver};
    }

    public synchronized Vector3D getNormal(AbsoluteDate date, Frame frame, Vector3D position, Rotation rotation) {
        if (this.referenceDate != null) {
            double alpha = this.rotationRate * date.durationFrom(this.referenceDate);
            return new Vector3D(FastMath.cos(alpha), this.saX, FastMath.sin(alpha), this.saY);
        }
        Vector3D sunInert = ((Vector3D)this.sun.getPVCoordinates(date, frame).getPosition().subtract((Vector)position)).normalize();
        Vector3D sunSpacecraft = rotation.applyTo(sunInert);
        double d = Vector3D.dotProduct(sunSpacecraft, this.saZ);
        double f = 1.0 - d * d;
        if (f < Precision.EPSILON) {
            return this.saZ.orthogonal();
        }
        double s = 1.0 / FastMath.sqrt(f);
        return new Vector3D(s, sunSpacecraft, -s * d, this.saZ);
    }

    public synchronized <T extends RealFieldElement<T>> FieldVector3D<T> getNormal(FieldAbsoluteDate<T> date, Frame frame, FieldVector3D<T> position, FieldRotation<T> rotation) {
        if (this.referenceDate != null) {
            RealFieldElement alpha = (RealFieldElement)date.durationFrom(this.referenceDate).multiply(this.rotationRate);
            return new FieldVector3D<RealFieldElement>((RealFieldElement)alpha.cos(), this.saX, (RealFieldElement)alpha.sin(), this.saY);
        }
        FieldVector3D<T> sunInert = position.subtract(this.sun.getPVCoordinates(date.toAbsoluteDate(), frame).getPosition()).negate().normalize();
        FieldVector3D<T> sunSpacecraft = rotation.applyTo(sunInert);
        T d = FieldVector3D.dotProduct(sunSpacecraft, this.saZ);
        RealFieldElement f = (RealFieldElement)((RealFieldElement)((RealFieldElement)d.multiply(d)).subtract(1.0)).negate();
        if (f.getReal() < Precision.EPSILON) {
            return new FieldVector3D(f.getField(), this.saZ.orthogonal());
        }
        RealFieldElement s = (RealFieldElement)((RealFieldElement)f.sqrt()).reciprocal();
        return new FieldVector3D<RealFieldElement>(s, sunSpacecraft, (RealFieldElement)((RealFieldElement)s.multiply(d)).negate(), new FieldVector3D<T>(date.getField(), this.saZ));
    }

    @Deprecated
    public synchronized FieldVector3D<DerivativeStructure> getNormal(AbsoluteDate date, Frame frame, FieldVector3D<DerivativeStructure> position, FieldRotation<DerivativeStructure> rotation) {
        DerivativeStructure zero = position.getX().getField().getZero();
        if (this.referenceDate != null) {
            DerivativeStructure alpha = zero.add(this.rotationRate * date.durationFrom(this.referenceDate));
            return new FieldVector3D<DerivativeStructure>(alpha.cos(), this.saX, alpha.sin(), this.saY);
        }
        FieldVector3D<DerivativeStructure> sunInert = position.subtract(this.sun.getPVCoordinates(date, frame).getPosition()).negate().normalize();
        FieldVector3D<DerivativeStructure> sunSpacecraft = rotation.applyTo(sunInert);
        DerivativeStructure d = FieldVector3D.dotProduct(sunSpacecraft, this.saZ);
        DerivativeStructure f = d.multiply(d).subtract(1.0).negate();
        if (f.getValue() < Precision.EPSILON) {
            return new FieldVector3D<DerivativeStructure>(position.getX().getField(), this.saZ.orthogonal());
        }
        DerivativeStructure s = f.sqrt().reciprocal();
        return new FieldVector3D<DerivativeStructure>(s, sunSpacecraft, s.multiply(d).negate(), new FieldVector3D<DerivativeStructure>(zero.getField(), this.saZ));
    }

    @Override
    public Vector3D dragAcceleration(AbsoluteDate date, Frame frame, Vector3D position, Rotation rotation, double mass, double density, Vector3D relativeVelocity, double[] parameters) {
        double dragCoeff = parameters[0];
        double liftRatio = this.liftParameterDriver == null ? 0.0 : parameters[1];
        double vNorm2 = relativeVelocity.getNormSq();
        double vNorm = FastMath.sqrt(vNorm2);
        Vector3D vDir = rotation.applyTo(relativeVelocity.scalarMultiply(1.0 / vNorm));
        double coeff = density * dragCoeff * vNorm2 / (2.0 * mass);
        double oMr = 1.0 - liftRatio;
        Vector3D frontNormal = this.getNormal(date, frame, position, rotation);
        double s = coeff * this.solarArrayArea * Vector3D.dotProduct(frontNormal, vDir);
        Vector3D acceleration = new Vector3D(oMr * FastMath.abs(s), vDir, liftRatio * s * 2.0, frontNormal);
        for (Facet facet : this.facets) {
            double dot = Vector3D.dotProduct(facet.getNormal(), vDir);
            if (!(dot < 0.0)) continue;
            double f = coeff * facet.getArea() * dot;
            acceleration = new Vector3D(1.0, acceleration, oMr * FastMath.abs(f), vDir, liftRatio * f * 2.0, facet.getNormal());
        }
        return rotation.applyInverseTo(acceleration);
    }

    @Override
    public Vector3D radiationPressureAcceleration(AbsoluteDate date, Frame frame, Vector3D position, Rotation rotation, double mass, Vector3D flux, double[] parameters) {
        if (flux.getNormSq() < Precision.SAFE_MIN) {
            return Vector3D.ZERO;
        }
        Vector3D fluxSat = rotation.applyTo(flux);
        Vector3D normal = this.getNormal(date, frame, position, rotation);
        double dot = Vector3D.dotProduct(normal, fluxSat);
        if (dot > 0.0) {
            dot = -dot;
            normal = normal.negate();
        }
        Vector<Euclidean3D> force = this.facetRadiationAcceleration(normal, this.solarArrayArea, fluxSat, dot, parameters);
        for (Facet bodyFacet : this.facets) {
            normal = bodyFacet.getNormal();
            dot = Vector3D.dotProduct(normal, fluxSat);
            if (!(dot < 0.0)) continue;
            force = force.add((Vector)this.facetRadiationAcceleration(normal, bodyFacet.getArea(), fluxSat, dot, parameters));
        }
        return rotation.applyInverseTo(new Vector3D(1.0 / mass, (Vector3D)force));
    }

    @Override
    public <T extends RealFieldElement<T>> FieldVector3D<T> dragAcceleration(FieldAbsoluteDate<T> date, Frame frame, FieldVector3D<T> position, FieldRotation<T> rotation, T mass, T density, FieldVector3D<T> relativeVelocity, T[] parameters) {
        T dragCoeff = parameters[0];
        RealFieldElement liftRatio = this.liftParameterDriver == null ? (RealFieldElement)dragCoeff.getField().getZero() : parameters[1];
        T vNorm2 = relativeVelocity.getNormSq();
        RealFieldElement vNorm = (RealFieldElement)vNorm2.sqrt();
        FieldVector3D<RealFieldElement> vDir = rotation.applyTo(relativeVelocity.scalarMultiply((RealFieldElement)vNorm.reciprocal()));
        T coeff = ((RealFieldElement)((RealFieldElement)((RealFieldElement)density.multiply(0.5)).multiply(dragCoeff)).multiply(vNorm2)).divide(mass);
        RealFieldElement oMr = (RealFieldElement)((RealFieldElement)liftRatio.negate()).add(1.0);
        FieldVector3D<T> frontNormal = this.getNormal(date, frame, position, rotation);
        RealFieldElement s = ((RealFieldElement)coeff.multiply(this.solarArrayArea)).multiply(FieldVector3D.dotProduct(frontNormal, vDir));
        FieldVector3D<RealFieldElement> acceleration = new FieldVector3D<RealFieldElement>(((RealFieldElement)s.abs()).multiply(oMr), vDir, (RealFieldElement)((RealFieldElement)s.multiply(liftRatio)).multiply(2), frontNormal);
        Field field = coeff.getField();
        for (Facet facet : this.facets) {
            RealFieldElement dot = FieldVector3D.dotProduct(facet.getNormal(), vDir);
            if (!(dot.getReal() < 0.0)) continue;
            RealFieldElement f = ((RealFieldElement)coeff.multiply(facet.getArea())).multiply(dot);
            acceleration = new FieldVector3D<RealFieldElement>((RealFieldElement)field.getOne(), acceleration, ((RealFieldElement)f.abs()).multiply(oMr), vDir, (RealFieldElement)((RealFieldElement)f.multiply(liftRatio)).multiply(2), new FieldVector3D(field, facet.getNormal()));
        }
        return rotation.applyInverseTo(acceleration);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldVector3D<T> radiationPressureAcceleration(FieldAbsoluteDate<T> date, Frame frame, FieldVector3D<T> position, FieldRotation<T> rotation, T mass, FieldVector3D<T> flux, T[] parameters) {
        if (flux.getNormSq().getReal() < Precision.SAFE_MIN) {
            return FieldVector3D.getZero(date.getField());
        }
        FieldVector3D<T> fluxSat = rotation.applyTo(flux);
        FieldVector3D<T> normal = this.getNormal(date, frame, position, rotation);
        Object dot = FieldVector3D.dotProduct(normal, fluxSat);
        if (dot.getReal() > 0.0) {
            dot = (RealFieldElement)dot.negate();
            normal = normal.negate();
        }
        FieldVector3D force = this.facetRadiationAcceleration(normal, this.solarArrayArea, fluxSat, (RealFieldElement)dot, (RealFieldElement[])parameters);
        for (Facet bodyFacet : this.facets) {
            normal = new FieldVector3D<T>(date.getField(), bodyFacet.getNormal());
            dot = FieldVector3D.dotProduct(fluxSat, normal);
            if (!(dot.getReal() < 0.0)) continue;
            force = force.add(this.facetRadiationAcceleration(normal, bodyFacet.getArea(), fluxSat, (RealFieldElement)dot, (RealFieldElement[])parameters));
        }
        return rotation.applyInverseTo(new FieldVector3D<RealFieldElement>((RealFieldElement)mass.reciprocal(), force));
    }

    private Vector3D facetRadiationAcceleration(Vector3D normal, double area, Vector3D fluxSat, double dot, double[] parameters) {
        double absorptionCoeff = parameters[0];
        double specularReflectionCoeff = parameters[1];
        double diffuseReflectionCoeff = 1.0 - (absorptionCoeff + specularReflectionCoeff);
        double psr = fluxSat.getNorm();
        double cN = 2.0 * area * dot * (diffuseReflectionCoeff / 3.0 - specularReflectionCoeff * dot / psr);
        double cS = area * dot / psr * (specularReflectionCoeff - 1.0);
        return new Vector3D(cN, normal, cS, fluxSat);
    }

    private <T extends RealFieldElement<T>> FieldVector3D<T> facetRadiationAcceleration(FieldVector3D<T> normal, double area, FieldVector3D<T> fluxSat, T dot, T[] parameters) {
        T absorptionCoeff = parameters[0];
        T specularReflectionCoeff = parameters[1];
        RealFieldElement diffuseReflectionCoeff = (RealFieldElement)((RealFieldElement)((RealFieldElement)absorptionCoeff.add(specularReflectionCoeff)).negate()).add(1.0);
        T psr = fluxSat.getNorm();
        RealFieldElement cN = (RealFieldElement)((RealFieldElement)dot.multiply(-2.0 * area)).multiply(((RealFieldElement)((RealFieldElement)dot.multiply(specularReflectionCoeff)).divide(psr)).subtract(diffuseReflectionCoeff.divide(3.0)));
        RealFieldElement cS = (RealFieldElement)((RealFieldElement)((RealFieldElement)dot.multiply(area)).multiply(specularReflectionCoeff.subtract(1.0))).divide(psr);
        return new FieldVector3D<RealFieldElement>(cN, normal, cS, fluxSat);
    }

    private static Facet[] simpleBoxFacets(double xLength, double yLength, double zLength) {
        return new Facet[]{new Facet(Vector3D.MINUS_I, yLength * zLength), new Facet(Vector3D.PLUS_I, yLength * zLength), new Facet(Vector3D.MINUS_J, xLength * zLength), new Facet(Vector3D.PLUS_J, xLength * zLength), new Facet(Vector3D.MINUS_K, xLength * yLength), new Facet(Vector3D.PLUS_K, xLength * yLength)};
    }

    private static List<Facet> filter(Facet[] facets) {
        ArrayList<Facet> filtered = new ArrayList<Facet>(facets.length);
        for (Facet facet : facets) {
            if (!(facet.getArea() > 0.0)) continue;
            filtered.add(facet);
        }
        return filtered;
    }

    public static class Facet {
        private final Vector3D normal;
        private final double area;

        public Facet(Vector3D normal, double area) {
            this.normal = normal.normalize();
            this.area = area;
        }

        public Vector3D getNormal() {
            return this.normal;
        }

        public double getArea() {
            return this.area;
        }
    }
}

