/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.data.DataLoader;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;

public class AstronomicalAmplitudeReader
implements DataLoader {
    private static final String OPTIONAL_FIELD_PATTERN = "\\S*";
    private static final String DOODSON_TYPE_PATTERN = "\\p{Digit}{2,3}[.,]\\p{Digit}{3}";
    private static final String REAL_TYPE_PATTERN = "[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?";
    private final String supportedNames;
    private final Pattern regularLinePattern;
    private final int columnDoodson;
    private final int columnHf;
    private final double scale;
    private final Map<Integer, Double> amplitudesMap;

    public AstronomicalAmplitudeReader(String supportedNames, int columns, int columnDoodson, int columnHf, double scale) {
        StringBuilder builder = new StringBuilder("^\\p{Space}*");
        for (int i = 1; i <= columns; ++i) {
            builder.append("(");
            if (i == columnDoodson) {
                builder.append(DOODSON_TYPE_PATTERN);
            } else if (i == columnHf) {
                builder.append(REAL_TYPE_PATTERN);
            } else {
                builder.append(OPTIONAL_FIELD_PATTERN);
            }
            builder.append(")");
            builder.append(i < FastMath.max(columnDoodson, columnHf) ? "\\p{Space}+" : "\\p{Space}*");
        }
        builder.append('$');
        this.regularLinePattern = Pattern.compile(builder.toString());
        this.supportedNames = supportedNames;
        this.columnDoodson = columnDoodson;
        this.columnHf = columnHf;
        this.scale = scale;
        this.amplitudesMap = new HashMap<Integer, Double>();
    }

    public String getSupportedNames() {
        return this.supportedNames;
    }

    @Override
    public boolean stillAcceptsData() {
        return this.amplitudesMap.isEmpty();
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(input, "UTF-8"));
        int lineNumber = 0;
        String line = r.readLine();
        while (line != null) {
            ++lineNumber;
            try {
                line = line.replace('\u2212', '-');
                Matcher regularMatcher = this.regularLinePattern.matcher(line);
                if (regularMatcher.matches()) {
                    int doodson = Integer.parseInt(regularMatcher.group(this.columnDoodson).replaceAll("[.,]", ""));
                    double hf = this.scale * Double.parseDouble(regularMatcher.group(this.columnHf));
                    this.amplitudesMap.put(doodson, hf);
                }
            }
            catch (NumberFormatException nfe) {
                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
            }
            line = r.readLine();
        }
        if (this.amplitudesMap.isEmpty()) {
            throw new OrekitException((Localizable)OrekitMessages.NOT_A_SUPPORTED_IERS_DATA_FILE, name);
        }
    }

    public Map<Integer, Double> getAstronomicalAmplitudesMap() {
        return Collections.unmodifiableMap(this.amplitudesMap);
    }
}

