/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.gravity.potential.AstronomicalAmplitudeReader;
import org.orekit.forces.gravity.potential.ConstantSphericalHarmonics;
import org.orekit.forces.gravity.potential.EGMFormatReader;
import org.orekit.forces.gravity.potential.FESCHatEpsilonReader;
import org.orekit.forces.gravity.potential.FESCnmSnmReader;
import org.orekit.forces.gravity.potential.GRGSFormatReader;
import org.orekit.forces.gravity.potential.ICGEMFormatReader;
import org.orekit.forces.gravity.potential.NormalizedSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.Normalizer;
import org.orekit.forces.gravity.potential.OceanLoadDeformationCoefficients;
import org.orekit.forces.gravity.potential.OceanTidesReader;
import org.orekit.forces.gravity.potential.OceanTidesWave;
import org.orekit.forces.gravity.potential.PotentialCoefficientsReader;
import org.orekit.forces.gravity.potential.RawSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.SHMFormatReader;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.Unnormalizer;
import org.orekit.forces.gravity.potential.WrappingNormalizedProvider;
import org.orekit.forces.gravity.potential.WrappingUnnormalizedProvider;

public class GravityFieldFactory {
    public static final String ICGEM_FILENAME = "^(.*\\.gfc)|(g(\\d)+_eigen[-_](\\w)+_coef)$";
    public static final String SHM_FILENAME = "^eigen[-_](\\w)+_coef$";
    public static final String EGM_FILENAME = "^egm\\d\\d_to\\d.*$";
    public static final String GRGS_FILENAME = "^grim\\d_.*$";
    public static final String FES_CNM_SNM_FILENAME = "^fes(\\d)+_Cnm-Snm.dat$";
    public static final String FES_CHAT_EPSILON_FILENAME = "^fes(\\d)+.dat$";
    public static final String FES_HF_FILENAME = "^hf-fes(\\d)+.dat$";
    private static final List<PotentialCoefficientsReader> READERS = new ArrayList<PotentialCoefficientsReader>();
    private static final List<OceanTidesReader> OCEAN_TIDES_READERS = new ArrayList<OceanTidesReader>();
    private static OceanLoadDeformationCoefficients OCEAN_LOAD_DEFORMATION_COEFFICIENTS = OceanLoadDeformationCoefficients.IERS_2010;

    private GravityFieldFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPotentialCoefficientsReader(PotentialCoefficientsReader reader) {
        List<PotentialCoefficientsReader> list = READERS;
        synchronized (list) {
            READERS.add(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDefaultPotentialCoefficientsReaders() {
        List<PotentialCoefficientsReader> list = READERS;
        synchronized (list) {
            READERS.add(new ICGEMFormatReader(ICGEM_FILENAME, false));
            READERS.add(new SHMFormatReader(SHM_FILENAME, false));
            READERS.add(new EGMFormatReader(EGM_FILENAME, false));
            READERS.add(new GRGSFormatReader(GRGS_FILENAME, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPotentialCoefficientsReaders() {
        List<PotentialCoefficientsReader> list = READERS;
        synchronized (list) {
            READERS.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOceanTidesReader(OceanTidesReader reader) {
        List<OceanTidesReader> list = OCEAN_TIDES_READERS;
        synchronized (list) {
            OCEAN_TIDES_READERS.add(reader);
        }
    }

    public static void configureOceanLoadDeformationCoefficients(OceanLoadDeformationCoefficients oldc) {
        OCEAN_LOAD_DEFORMATION_COEFFICIENTS = oldc;
    }

    public static OceanLoadDeformationCoefficients getOceanLoadDeformationCoefficients() {
        return OCEAN_LOAD_DEFORMATION_COEFFICIENTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDefaultOceanTidesReaders() {
        List<OceanTidesReader> list = OCEAN_TIDES_READERS;
        synchronized (list) {
            OCEAN_TIDES_READERS.add(new FESCnmSnmReader(FES_CNM_SNM_FILENAME, 1.0E-11));
            AstronomicalAmplitudeReader aaReader = new AstronomicalAmplitudeReader(FES_HF_FILENAME, 5, 2, 3, 1.0);
            DataProvidersManager.getInstance().feed(aaReader.getSupportedNames(), aaReader);
            Map<Integer, Double> map = aaReader.getAstronomicalAmplitudesMap();
            OCEAN_TIDES_READERS.add(new FESCHatEpsilonReader(FES_CHAT_EPSILON_FILENAME, 0.01, FastMath.toRadians(1.0), GravityFieldFactory.getOceanLoadDeformationCoefficients(), map));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearOceanTidesReaders() {
        List<OceanTidesReader> list = OCEAN_TIDES_READERS;
        synchronized (list) {
            OCEAN_TIDES_READERS.clear();
        }
    }

    public static NormalizedSphericalHarmonicsProvider getConstantNormalizedProvider(int degree, int order) {
        PotentialCoefficientsReader reader = GravityFieldFactory.readGravityField(degree, order);
        ConstantSphericalHarmonics provider = reader.getConstantProvider(true, degree, order);
        return new WrappingNormalizedProvider(provider);
    }

    public static NormalizedSphericalHarmonicsProvider getNormalizedProvider(int degree, int order) {
        PotentialCoefficientsReader reader = GravityFieldFactory.readGravityField(degree, order);
        RawSphericalHarmonicsProvider provider = reader.getProvider(true, degree, order);
        return new WrappingNormalizedProvider(provider);
    }

    public static NormalizedSphericalHarmonicsProvider getNormalizedProvider(double ae, double mu, TideSystem tideSystem, double[][] normalizedC, double[][] normalizedS) {
        return new WrappingNormalizedProvider(new ConstantSphericalHarmonics(ae, mu, tideSystem, normalizedC, normalizedS));
    }

    public static NormalizedSphericalHarmonicsProvider getNormalizedProvider(UnnormalizedSphericalHarmonicsProvider unnormalized) {
        return new Normalizer(unnormalized);
    }

    public static UnnormalizedSphericalHarmonicsProvider getConstantUnnormalizedProvider(int degree, int order) {
        PotentialCoefficientsReader reader = GravityFieldFactory.readGravityField(degree, order);
        ConstantSphericalHarmonics provider = reader.getConstantProvider(false, degree, order);
        return new WrappingUnnormalizedProvider(provider);
    }

    public static UnnormalizedSphericalHarmonicsProvider getUnnormalizedProvider(int degree, int order) {
        PotentialCoefficientsReader reader = GravityFieldFactory.readGravityField(degree, order);
        RawSphericalHarmonicsProvider provider = reader.getProvider(false, degree, order);
        return new WrappingUnnormalizedProvider(provider);
    }

    public static UnnormalizedSphericalHarmonicsProvider getUnnormalizedProvider(double ae, double mu, TideSystem tideSystem, double[][] unnormalizedC, double[][] unnormalizedS) {
        return new WrappingUnnormalizedProvider(new ConstantSphericalHarmonics(ae, mu, tideSystem, unnormalizedC, unnormalizedS));
    }

    public static UnnormalizedSphericalHarmonicsProvider getUnnormalizedProvider(NormalizedSphericalHarmonicsProvider normalized) {
        return new Unnormalizer(normalized);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PotentialCoefficientsReader readGravityField(int maxParseDegree, int maxParseOrder) {
        List<PotentialCoefficientsReader> list = READERS;
        synchronized (list) {
            if (READERS.isEmpty()) {
                GravityFieldFactory.addDefaultPotentialCoefficientsReaders();
            }
            for (PotentialCoefficientsReader reader : READERS) {
                reader.setMaxParseDegree(maxParseDegree);
                reader.setMaxParseOrder(maxParseOrder);
                DataProvidersManager.getInstance().feed(reader.getSupportedNames(), reader);
                if (reader.stillAcceptsData()) continue;
                return reader;
            }
        }
        throw new OrekitException((Localizable)OrekitMessages.NO_GRAVITY_FIELD_DATA_LOADED, new Object[0]);
    }

    public static double[][] getUnnormalizationFactors(int degree, int order) {
        int rows = degree + 1;
        double[][] factor = new double[rows][];
        factor[0] = new double[]{1.0};
        for (int n = 1; n <= degree; ++n) {
            double[] row = new double[FastMath.min(n, order) + 1];
            row[0] = FastMath.sqrt(2 * n + 1);
            double coeff = 2.0 * (double)(2 * n + 1);
            for (int m = 1; m < row.length; ++m) {
                row[m] = FastMath.sqrt(coeff /= (double)((n - m + 1) * (n + m)));
                if (!(row[m] < Precision.SAFE_MIN)) continue;
                throw new OrekitException((Localizable)OrekitMessages.GRAVITY_FIELD_NORMALIZATION_UNDERFLOW, n, m);
            }
            factor[n] = row;
        }
        return factor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<OceanTidesWave> getOceanTidesWaves(int degree, int order) {
        List<OceanTidesReader> list = OCEAN_TIDES_READERS;
        synchronized (list) {
            if (OCEAN_TIDES_READERS.isEmpty()) {
                GravityFieldFactory.addDefaultOceanTidesReaders();
            }
            for (OceanTidesReader reader : OCEAN_TIDES_READERS) {
                reader.setMaxParseDegree(degree);
                reader.setMaxParseOrder(order);
                DataProvidersManager.getInstance().feed(reader.getSupportedNames(), reader);
                if (reader.stillAcceptsData()) continue;
                return reader.getWaves();
            }
        }
        throw new OrekitException((Localizable)OrekitMessages.NO_OCEAN_TIDE_DATA_LOADED, new Object[0]);
    }
}

