/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.data.DataLoader;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.gravity.potential.ConstantSphericalHarmonics;
import org.orekit.forces.gravity.potential.GravityFieldFactory;
import org.orekit.forces.gravity.potential.RawSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.TideSystem;

public abstract class PotentialCoefficientsReader
implements DataLoader {
    private int maxParseDegree;
    private int maxParseOrder;
    private final String supportedNames;
    private final boolean missingCoefficientsAllowed;
    private boolean readComplete;
    private double ae;
    private double mu;
    private double[][] rawC;
    private double[][] rawS;
    private boolean normalized;
    private TideSystem tideSystem;

    protected PotentialCoefficientsReader(String supportedNames, boolean missingCoefficientsAllowed) {
        this.supportedNames = supportedNames;
        this.missingCoefficientsAllowed = missingCoefficientsAllowed;
        this.maxParseDegree = Integer.MAX_VALUE;
        this.maxParseOrder = Integer.MAX_VALUE;
        this.readComplete = false;
        this.ae = Double.NaN;
        this.mu = Double.NaN;
        this.rawC = null;
        this.rawS = null;
        this.normalized = false;
        this.tideSystem = TideSystem.UNKNOWN;
    }

    public String getSupportedNames() {
        return this.supportedNames;
    }

    public boolean missingCoefficientsAllowed() {
        return this.missingCoefficientsAllowed;
    }

    public void setMaxParseDegree(int maxParseDegree) {
        this.maxParseDegree = maxParseDegree;
    }

    public int getMaxParseDegree() {
        return this.maxParseDegree;
    }

    public void setMaxParseOrder(int maxParseOrder) {
        this.maxParseOrder = maxParseOrder;
    }

    public int getMaxParseOrder() {
        return this.maxParseOrder;
    }

    @Override
    public boolean stillAcceptsData() {
        return !this.readComplete || this.getMaxAvailableDegree() < this.getMaxParseDegree() || this.getMaxAvailableOrder() < this.getMaxParseOrder();
    }

    protected void setReadComplete(boolean readComplete) {
        this.readComplete = readComplete;
    }

    protected void setAe(double ae) {
        this.ae = ae;
    }

    protected double getAe() {
        return this.ae;
    }

    protected void setMu(double mu) {
        this.mu = mu;
    }

    protected double getMu() {
        return this.mu;
    }

    protected void setTideSystem(TideSystem tideSystem) {
        this.tideSystem = tideSystem;
    }

    protected TideSystem getTideSystem() {
        return this.tideSystem;
    }

    protected void setRawCoefficients(boolean rawNormalized, double[][] c, double[][] s, String name) {
        int j;
        int i;
        this.normalized = rawNormalized;
        this.setIfUnset(c, 0, 0, 1.0);
        this.setIfUnset(s, 0, 0, 0.0);
        this.setIfUnset(c, 1, 0, 0.0);
        this.setIfUnset(s, 1, 0, 0.0);
        this.setIfUnset(c, 1, 1, 0.0);
        this.setIfUnset(s, 1, 1, 0.0);
        for (i = 0; i < c.length; ++i) {
            for (j = 0; j < c[i].length; ++j) {
                if (!Double.isNaN(c[i][j])) continue;
                throw new OrekitException((Localizable)OrekitMessages.MISSING_GRAVITY_FIELD_COEFFICIENT_IN_FILE, Character.valueOf('C'), i, j, name);
            }
        }
        this.rawC = c;
        for (i = 0; i < s.length; ++i) {
            for (j = 0; j < s[i].length; ++j) {
                if (!Double.isNaN(s[i][j])) continue;
                throw new OrekitException((Localizable)OrekitMessages.MISSING_GRAVITY_FIELD_COEFFICIENT_IN_FILE, Character.valueOf('S'), i, j, name);
            }
        }
        this.rawS = s;
    }

    private boolean setIfUnset(double[][] array, int i, int j, double value) {
        if (array.length > i && array[i].length > j && (Double.isNaN(array[i][j]) || Precision.equals(array[i][j], 0.0, 0))) {
            array[i][j] = value;
            return true;
        }
        return false;
    }

    public int getMaxAvailableDegree() {
        return this.rawC.length - 1;
    }

    public int getMaxAvailableOrder() {
        return this.rawC[this.rawC.length - 1].length - 1;
    }

    @Override
    public abstract void loadData(InputStream var1, String var2) throws IOException, ParseException, OrekitException;

    public abstract RawSphericalHarmonicsProvider getProvider(boolean var1, int var2, int var3);

    protected ConstantSphericalHarmonics getConstantProvider(boolean wantNormalized, int degree, int order) {
        if (!this.readComplete) {
            throw new OrekitException((Localizable)OrekitMessages.NO_GRAVITY_FIELD_DATA_LOADED, new Object[0]);
        }
        if (degree >= this.rawC.length) {
            throw new OrekitException((Localizable)OrekitMessages.TOO_LARGE_DEGREE_FOR_GRAVITY_FIELD, degree, this.rawC.length - 1);
        }
        if (order >= this.rawC[this.rawC.length - 1].length) {
            throw new OrekitException((Localizable)OrekitMessages.TOO_LARGE_ORDER_FOR_GRAVITY_FIELD, order, this.rawC[this.rawC.length - 1].length);
        }
        double[][] truncatedC = PotentialCoefficientsReader.buildTriangularArray(degree, order, 0.0);
        double[][] truncatedS = PotentialCoefficientsReader.buildTriangularArray(degree, order, 0.0);
        PotentialCoefficientsReader.rescale(1.0, this.normalized, this.rawC, this.rawS, wantNormalized, truncatedC, truncatedS);
        return new ConstantSphericalHarmonics(this.ae, this.mu, this.tideSystem, truncatedC, truncatedS);
    }

    protected static double[][] buildTriangularArray(int degree, int order, double value) {
        int rows = degree + 1;
        double[][] array = new double[rows][];
        for (int k = 0; k < array.length; ++k) {
            array[k] = PotentialCoefficientsReader.buildRow(k, order, value);
        }
        return array;
    }

    protected static double parseDouble(String string) {
        return Double.parseDouble(string.toUpperCase(Locale.ENGLISH).replace('D', 'E'));
    }

    protected static double[] buildRow(int degree, int order, double value) {
        double[] row = new double[FastMath.min(order, degree) + 1];
        Arrays.fill(row, value);
        return row;
    }

    protected void extendListOfLists(List<List<Double>> list, int degree, int order, double value) {
        for (int i = list.size(); i <= degree; ++i) {
            list.add(new ArrayList());
        }
        List<Double> listN = list.get(degree);
        Double v = value;
        for (int j = listN.size(); j <= order; ++j) {
            listN.add(v);
        }
    }

    protected double[][] toArray(List<List<Double>> list) {
        double[][] array = new double[list.size()][];
        for (int i = 0; i < array.length; ++i) {
            array[i] = new double[list.get(i).size()];
            for (int j = 0; j < array[i].length; ++j) {
                array[i][j] = list.get(i).get(j);
            }
        }
        return array;
    }

    protected void parseCoefficient(String field, List<List<Double>> list, int i, int j, String cName, String name) {
        double value = PotentialCoefficientsReader.parseDouble(field);
        double oldValue = list.get(i).get(j);
        if (!Double.isNaN(oldValue) && !Precision.equals(oldValue, 0.0, 0)) {
            throw new OrekitException((Localizable)OrekitMessages.DUPLICATED_GRAVITY_FIELD_COEFFICIENT_IN_FILE, name, i, j, name);
        }
        list.get(i).set(j, value);
    }

    protected void parseCoefficient(String field, double[][] array, int i, int j, String cName, String name) {
        double value = PotentialCoefficientsReader.parseDouble(field);
        double oldValue = array[i][j];
        if (!Double.isNaN(oldValue) && !Precision.equals(oldValue, 0.0, 0)) {
            throw new OrekitException((Localizable)OrekitMessages.DUPLICATED_GRAVITY_FIELD_COEFFICIENT_IN_FILE, name, i, j, name);
        }
        array[i][j] = value;
    }

    protected static void rescale(double scale, boolean normalizedOrigin, double[][] originC, double[][] originS, boolean wantNormalized, double[][] rescaledC, double[][] rescaledS) {
        if (wantNormalized == normalizedOrigin) {
            for (int i = 0; i < rescaledC.length; ++i) {
                double[] rCi = rescaledC[i];
                double[] rSi = rescaledS[i];
                double[] oCi = originC[i];
                double[] oSi = originS[i];
                for (int j = 0; j < rCi.length; ++j) {
                    rCi[j] = oCi[j] * scale;
                    rSi[j] = oSi[j] * scale;
                }
            }
        } else {
            double[][] factors = GravityFieldFactory.getUnnormalizationFactors(rescaledC.length - 1, rescaledC.length - 1);
            if (wantNormalized) {
                for (int i = 0; i < rescaledC.length; ++i) {
                    double[] rCi = rescaledC[i];
                    double[] rSi = rescaledS[i];
                    double[] oCi = originC[i];
                    double[] oSi = originS[i];
                    double[] fi = factors[i];
                    for (int j = 0; j < rCi.length; ++j) {
                        double factor = scale / fi[j];
                        rCi[j] = oCi[j] * factor;
                        rSi[j] = oSi[j] * factor;
                    }
                }
            } else {
                for (int i = 0; i < rescaledC.length; ++i) {
                    double[] rCi = rescaledC[i];
                    double[] rSi = rescaledS[i];
                    double[] oCi = originC[i];
                    double[] oSi = originS[i];
                    double[] fi = factors[i];
                    for (int j = 0; j < rCi.length; ++j) {
                        double factor = scale * fi[j];
                        rCi[j] = oCi[j] * factor;
                        rSi[j] = oSi[j] * factor;
                    }
                }
            }
        }
    }
}

