/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import org.orekit.forces.gravity.potential.GravityFieldFactory;
import org.orekit.forces.gravity.potential.NormalizedSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.time.AbsoluteDate;

class Unnormalizer
implements UnnormalizedSphericalHarmonicsProvider {
    private final NormalizedSphericalHarmonicsProvider normalized;
    private final double[][] factors;

    Unnormalizer(NormalizedSphericalHarmonicsProvider normalized) {
        this.normalized = normalized;
        this.factors = GravityFieldFactory.getUnnormalizationFactors(normalized.getMaxDegree(), normalized.getMaxOrder());
    }

    @Override
    public int getMaxDegree() {
        return this.normalized.getMaxDegree();
    }

    @Override
    public int getMaxOrder() {
        return this.normalized.getMaxOrder();
    }

    @Override
    public double getMu() {
        return this.normalized.getMu();
    }

    @Override
    public double getAe() {
        return this.normalized.getAe();
    }

    @Override
    public AbsoluteDate getReferenceDate() {
        return this.normalized.getReferenceDate();
    }

    @Override
    public double getOffset(AbsoluteDate date) {
        return this.normalized.getOffset(date);
    }

    @Override
    public TideSystem getTideSystem() {
        return this.normalized.getTideSystem();
    }

    @Override
    public UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics onDate(final AbsoluteDate date) {
        final NormalizedSphericalHarmonicsProvider.NormalizedSphericalHarmonics harmonics = this.normalized.onDate(date);
        return new UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics(){

            @Override
            public AbsoluteDate getDate() {
                return date;
            }

            @Override
            public double getUnnormalizedCnm(int n, int m) {
                return harmonics.getNormalizedCnm(n, m) * Unnormalizer.this.factors[n][m];
            }

            @Override
            public double getUnnormalizedSnm(int n, int m) {
                return harmonics.getNormalizedSnm(n, m) * Unnormalizer.this.factors[n][m];
            }
        };
    }
}

