/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.EOPEntry;
import org.orekit.frames.EOPHistoryLoader;
import org.orekit.frames.ITRFVersionLoader;
import org.orekit.time.DateComponents;
import org.orekit.utils.IERSConventions;

class BulletinAFilesLoader
implements EOPHistoryLoader {
    private static final double MILLI_ARC_SECONDS_TO_RADIANS = 4.84813681109536E-9;
    private static final String LINE_START_REGEXP = "^\\p{Blank}+";
    private static final String LINE_END_REGEXP = "\\p{Blank}*$";
    private static final String INTEGER_REGEXP = "[-+]?\\p{Digit}+";
    private static final String REAL_REGEXP = "[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?";
    private static final String STORED_INTEGER_FIELD = "\\p{Blank}*([-+]?\\p{Digit}+)";
    private static final String STORED_MJD_FIELD = "\\p{Blank}+(\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit})";
    private static final String STORED_REAL_FIELD = "\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)";
    private static final String IGNORED_REAL_FIELD = "\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?";
    private final String supportedNames;

    BulletinAFilesLoader(String supportedNames) {
        this.supportedNames = supportedNames;
    }

    @Override
    public void fillHistory(IERSConventions.NutationCorrectionConverter converter, SortedSet<EOPEntry> history) {
        Parser parser = new Parser();
        DataProvidersManager.getInstance().feed(this.supportedNames, parser);
        parser.fill(history);
    }

    private static class Parser
    implements DataLoader {
        private final Map<Integer, double[]> eopFieldsMap = new HashMap<Integer, double[]>();
        private final Map<Integer, double[]> poleOffsetsFieldsMap = new HashMap<Integer, double[]>();
        private final ITRFVersionLoader itrfVersionLoader = new ITRFVersionLoader("itrf-versions.conf");
        private ITRFVersionLoader.ITRFVersionConfiguration configuration;
        private String fileName;
        private int lineNumber = 0;
        private String line;
        private int mjdMin = Integer.MAX_VALUE;
        private int mjdMax = Integer.MIN_VALUE;
        private int firstMJD = -1;

        Parser() {
        }

        @Override
        public boolean stillAcceptsData() {
            return true;
        }

        @Override
        public void loadData(InputStream input, String name) throws IOException {
            this.configuration = null;
            this.fileName = name;
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
            this.lineNumber = 0;
            this.firstMJD = -1;
            ArrayList<Section> remaining = new ArrayList<Section>();
            remaining.addAll(Arrays.asList(Section.values()));
            Section section = this.nextSection(remaining, reader, name);
            while (section != null) {
                switch (section) {
                    case EOP_RAPID_SERVICE: 
                    case EOP_FINAL_VALUES: 
                    case EOP_PREDICTION: {
                        this.loadXYDT(section, reader, name);
                        break;
                    }
                    case POLE_OFFSETS_IAU_1980_RAPID_SERVICE: 
                    case POLE_OFFSETS_IAU_1980_FINAL_VALUES: {
                        this.loadPoleOffsets(section, false, reader, name);
                        break;
                    }
                    case POLE_OFFSETS_IAU_2000_RAPID_SERVICE: 
                    case POLE_OFFSETS_IAU_2000_FINAL_VALUES: {
                        this.loadPoleOffsets(section, true, reader, name);
                        break;
                    }
                    default: {
                        throw new OrekitInternalError(null);
                    }
                }
                remaining.remove((Object)section);
                section = this.nextSection(remaining, reader, name);
            }
            if (remaining.contains((Object)Section.EOP_RAPID_SERVICE) || remaining.contains((Object)Section.EOP_PREDICTION) || remaining.contains((Object)Section.POLE_OFFSETS_IAU_1980_RAPID_SERVICE) ^ remaining.contains((Object)Section.POLE_OFFSETS_IAU_2000_RAPID_SERVICE) || remaining.contains((Object)Section.POLE_OFFSETS_IAU_1980_FINAL_VALUES) ^ remaining.contains((Object)Section.POLE_OFFSETS_IAU_2000_FINAL_VALUES)) {
                throw new OrekitException((Localizable)OrekitMessages.NOT_A_SUPPORTED_IERS_DATA_FILE, name);
            }
        }

        public void fill(SortedSet<EOPEntry> history) {
            double[] currentEOP = null;
            double[] nextEOP = this.eopFieldsMap.get(this.mjdMin);
            for (int mjd = this.mjdMin; mjd <= this.mjdMax; ++mjd) {
                double[] currentPole = this.poleOffsetsFieldsMap.get(mjd);
                double[] previousEOP = currentEOP;
                currentEOP = nextEOP;
                nextEOP = this.eopFieldsMap.get(mjd + 1);
                if (currentEOP == null) {
                    if (currentPole == null) continue;
                    if (this.configuration == null || !this.configuration.isValid(mjd)) {
                        this.configuration = this.itrfVersionLoader.getConfiguration(this.fileName, mjd);
                    }
                    history.add(new EOPEntry(mjd, 0.0, 0.0, 0.0, 0.0, currentPole[1] * 4.84813681109536E-9, currentPole[2] * 4.84813681109536E-9, currentPole[3] * 4.84813681109536E-9, currentPole[4] * 4.84813681109536E-9, this.configuration.getVersion()));
                    continue;
                }
                double lod = previousEOP == null ? (nextEOP == null ? 0.0 : currentEOP[3] - nextEOP[3]) : (nextEOP == null ? previousEOP[3] - currentEOP[3] : 0.5 * (previousEOP[3] - nextEOP[3]));
                if (this.configuration == null || !this.configuration.isValid(mjd)) {
                    this.configuration = this.itrfVersionLoader.getConfiguration(this.fileName, mjd);
                }
                if (currentPole == null) {
                    history.add(new EOPEntry(mjd, currentEOP[3], lod, currentEOP[1] * 4.84813681109536E-6, currentEOP[2] * 4.84813681109536E-6, 0.0, 0.0, 0.0, 0.0, this.configuration.getVersion()));
                    continue;
                }
                history.add(new EOPEntry(mjd, currentEOP[3], lod, currentEOP[1] * 4.84813681109536E-6, currentEOP[2] * 4.84813681109536E-6, currentPole[1] * 4.84813681109536E-9, currentPole[2] * 4.84813681109536E-9, currentPole[3] * 4.84813681109536E-9, currentPole[4] * 4.84813681109536E-9, this.configuration.getVersion()));
            }
        }

        private Section nextSection(List<Section> sections, BufferedReader reader, String name) throws IOException {
            this.line = reader.readLine();
            while (this.line != null) {
                ++this.lineNumber;
                for (Section section : sections) {
                    if (!section.matchesHeader(this.line)) continue;
                    return section;
                }
                this.line = reader.readLine();
            }
            return null;
        }

        private void loadXYDT(Section section, BufferedReader reader, String name) throws IOException {
            boolean inValuesPart = false;
            this.line = reader.readLine();
            while (this.line != null) {
                ++this.lineNumber;
                String[] fields = section.getFields(this.line);
                if (fields != null) {
                    double[] eop;
                    inValuesPart = true;
                    int year = Integer.parseInt(fields[0]);
                    int month = Integer.parseInt(fields[1]);
                    int day = Integer.parseInt(fields[2]);
                    int mjd = Integer.parseInt(fields[3]);
                    DateComponents dc = new DateComponents(DateComponents.MODIFIED_JULIAN_EPOCH, mjd);
                    if (dc.getYear() % 100 != year % 100 || dc.getMonth() != month || dc.getDay() != day) {
                        throw new OrekitException((Localizable)OrekitMessages.INCONSISTENT_DATES_IN_IERS_FILE, name, year, month, day, mjd);
                    }
                    this.mjdMin = FastMath.min(this.mjdMin, mjd);
                    this.mjdMax = FastMath.max(this.mjdMax, mjd);
                    if (this.firstMJD < 0) {
                        this.firstMJD = mjd;
                    }
                    if (this.eopFieldsMap.containsKey(mjd)) {
                        eop = this.eopFieldsMap.get(mjd);
                    } else {
                        eop = new double[4];
                        this.eopFieldsMap.put(mjd, eop);
                    }
                    if (eop[0] <= (double)this.firstMJD) {
                        eop[0] = this.firstMJD;
                        eop[1] = Double.parseDouble(fields[4]);
                        eop[2] = Double.parseDouble(fields[5]);
                        eop[3] = Double.parseDouble(fields[6]);
                    }
                } else if (inValuesPart) {
                    return;
                }
                this.line = reader.readLine();
            }
            throw new OrekitException((Localizable)OrekitMessages.UNEXPECTED_END_OF_FILE_AFTER_LINE, name, this.lineNumber);
        }

        private void loadPoleOffsets(Section section, boolean isNonRotatingOrigin, BufferedReader reader, String name) throws IOException {
            boolean inValuesPart = false;
            this.line = reader.readLine();
            while (this.line != null) {
                ++this.lineNumber;
                String[] fields = section.getFields(this.line);
                if (fields != null) {
                    double[] pole;
                    inValuesPart = true;
                    int mjd = Integer.parseInt(fields[0]);
                    this.mjdMin = FastMath.min(this.mjdMin, mjd);
                    this.mjdMax = FastMath.max(this.mjdMax, mjd);
                    if (this.poleOffsetsFieldsMap.containsKey(mjd)) {
                        pole = this.poleOffsetsFieldsMap.get(mjd);
                    } else {
                        pole = new double[5];
                        this.poleOffsetsFieldsMap.put(mjd, pole);
                    }
                    if (pole[0] <= (double)this.firstMJD) {
                        pole[0] = this.firstMJD;
                        if (isNonRotatingOrigin) {
                            pole[1] = Double.parseDouble(fields[1]);
                            pole[2] = Double.parseDouble(fields[2]);
                        } else {
                            pole[3] = Double.parseDouble(fields[1]);
                            pole[4] = Double.parseDouble(fields[2]);
                        }
                    }
                } else if (inValuesPart) {
                    return;
                }
                this.line = reader.readLine();
            }
            throw new OrekitException((Localizable)OrekitMessages.UNEXPECTED_END_OF_FILE_AFTER_LINE, name, this.lineNumber);
        }
    }

    private static enum Section {
        EOP_RAPID_SERVICE("^ *COMBINED EARTH ORIENTATION PARAMETERS: *$", "^\\p{Blank}+\\p{Blank}*([-+]?\\p{Digit}+)\\p{Blank}*([-+]?\\p{Digit}+)\\p{Blank}*([-+]?\\p{Digit}+)\\p{Blank}+(\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit})\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?\\p{Blank}*$"),
        EOP_FINAL_VALUES("^ *IERS Final Values *$", "^\\p{Blank}+\\p{Blank}*([-+]?\\p{Digit}+)\\p{Blank}*([-+]?\\p{Digit}+)\\p{Blank}*([-+]?\\p{Digit}+)\\p{Blank}+(\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit})\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)\\p{Blank}*$"),
        EOP_PREDICTION("^ *PREDICTIONS: *$", "^\\p{Blank}+\\p{Blank}*([-+]?\\p{Digit}+)\\p{Blank}*([-+]?\\p{Digit}+)\\p{Blank}*([-+]?\\p{Digit}+)\\p{Blank}+(\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit})\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)\\p{Blank}*$"),
        POLE_OFFSETS_IAU_1980_RAPID_SERVICE("^ *NEOS Celestial Pole Offset Series *$", "^\\p{Blank}+\\p{Blank}+(\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit})\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?\\p{Blank}*$"),
        POLE_OFFSETS_IAU_1980_FINAL_VALUES("^ *IERS Celestial Pole Offset Final Series *$", "^\\p{Blank}+\\p{Blank}+(\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit})\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)\\p{Blank}*$"),
        POLE_OFFSETS_IAU_2000_RAPID_SERVICE("^ *IAU2000A Celestial Pole Offset Series *$", "^\\p{Blank}+\\p{Blank}+(\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit})\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?\\p{Blank}*$"),
        POLE_OFFSETS_IAU_2000_FINAL_VALUES("^ *IAU2000A Celestial Pole Offset Final Series *$", "^\\p{Blank}+\\p{Blank}+(\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit})\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)\\p{Blank}*$");

        private final Pattern header;
        private final Pattern data;

        private Section(String headerRegExp, String dataRegExp) {
            this.header = Pattern.compile(headerRegExp);
            this.data = Pattern.compile(dataRegExp);
        }

        public boolean matchesHeader(String line) {
            return this.header.matcher(line).matches();
        }

        public String[] getFields(String line) {
            Matcher matcher = this.data.matcher(line);
            if (matcher.matches()) {
                String[] fields = new String[matcher.groupCount()];
                for (int i = 0; i < fields.length; ++i) {
                    fields[i] = matcher.group(i + 1);
                }
                return fields;
            }
            return null;
        }
    }
}

