/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.hipparchus.FieldElement;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.interpolation.FieldHermiteInterpolator;
import org.hipparchus.analysis.interpolation.HermiteInterpolator;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.MathArrays;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.errors.TimeStampedCacheException;
import org.orekit.frames.EOPEntry;
import org.orekit.frames.FieldPoleCorrection;
import org.orekit.frames.ITRFVersion;
import org.orekit.frames.PoleCorrection;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeStamped;
import org.orekit.time.TimeVectorFunction;
import org.orekit.utils.GenericTimeStampedCache;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.ImmutableTimeStampedCache;
import org.orekit.utils.OrekitConfiguration;
import org.orekit.utils.TimeStampedCache;
import org.orekit.utils.TimeStampedGenerator;

public class EOPHistory
implements Serializable {
    private static final long serialVersionUID = 20131010L;
    private static final int INTERPOLATION_POINTS = 4;
    private final boolean hasData;
    private final transient ImmutableTimeStampedCache<EOPEntry> cache;
    private final IERSConventions conventions;
    private final transient TimeVectorFunction tidalCorrection;

    protected EOPHistory(IERSConventions conventions, Collection<EOPEntry> data, boolean simpleEOP) {
        this(conventions, data, simpleEOP ? null : new CachedCorrection(conventions.getEOPTidalCorrection()));
    }

    private EOPHistory(IERSConventions conventions, Collection<EOPEntry> data, TimeVectorFunction tidalCorrection) {
        this.conventions = conventions;
        this.tidalCorrection = tidalCorrection;
        if (data.size() >= 4) {
            this.cache = new ImmutableTimeStampedCache<EOPEntry>(4, data);
            this.hasData = true;
        } else {
            this.cache = ImmutableTimeStampedCache.emptyCache();
            this.hasData = false;
        }
    }

    public EOPHistory getNonInterpolatingEOPHistory() {
        return new EOPHistory(this.conventions, this.getEntries(), this.conventions.getEOPTidalCorrection());
    }

    public boolean usesInterpolation() {
        return this.tidalCorrection != null && this.tidalCorrection instanceof CachedCorrection;
    }

    public IERSConventions getConventions() {
        return this.conventions;
    }

    public AbsoluteDate getStartDate() {
        return this.cache.getEarliest().getDate();
    }

    public AbsoluteDate getEndDate() {
        return this.cache.getLatest().getDate();
    }

    public double getUT1MinusUTC(AbsoluteDate date) {
        if (!this.hasDataFor(date)) {
            return this.tidalCorrection == null ? 0.0 : this.tidalCorrection.value(date)[2];
        }
        try {
            DUT1Interpolator interpolator = new DUT1Interpolator(date);
            this.getNeighbors(date).forEach(interpolator);
            double interpolated = interpolator.getInterpolated();
            if (this.tidalCorrection != null) {
                interpolated += this.tidalCorrection.value(date)[2];
            }
            return interpolated;
        }
        catch (TimeStampedCacheException tce) {
            throw new OrekitInternalError(tce);
        }
    }

    public <T extends RealFieldElement<T>> T getUT1MinusUTC(FieldAbsoluteDate<T> date) {
        AbsoluteDate absDate = date.toAbsoluteDate();
        if (!this.hasDataFor(absDate)) {
            return (T)(this.tidalCorrection == null ? (RealFieldElement)date.getField().getZero() : this.tidalCorrection.value(date)[2]);
        }
        try {
            FieldDUT1Interpolator<T> interpolator = new FieldDUT1Interpolator<T>(date, absDate);
            this.getNeighbors(absDate).forEach(interpolator);
            RealFieldElement interpolated = interpolator.getInterpolated();
            if (this.tidalCorrection != null) {
                interpolated = interpolated.add((RealFieldElement)this.tidalCorrection.value(date)[2]);
            }
            return (T)interpolated;
        }
        catch (TimeStampedCacheException tce) {
            throw new OrekitInternalError(tce);
        }
    }

    protected Stream<EOPEntry> getNeighbors(AbsoluteDate central) {
        return this.cache.getNeighbors(central);
    }

    public double getLOD(AbsoluteDate date) {
        if (!this.hasDataFor(date)) {
            return this.tidalCorrection == null ? 0.0 : this.tidalCorrection.value(date)[3];
        }
        double interpolated = this.interpolate(date, entry -> entry.getLOD());
        if (this.tidalCorrection != null) {
            interpolated += this.tidalCorrection.value(date)[3];
        }
        return interpolated;
    }

    public <T extends RealFieldElement<T>> T getLOD(FieldAbsoluteDate<T> date) {
        AbsoluteDate aDate = date.toAbsoluteDate();
        if (!this.hasDataFor(aDate)) {
            return (T)(this.tidalCorrection == null ? (RealFieldElement)date.getField().getZero() : this.tidalCorrection.value(date)[3]);
        }
        RealFieldElement interpolated = this.interpolate(date, aDate, (EOPEntry entry) -> entry.getLOD());
        if (this.tidalCorrection != null) {
            interpolated = interpolated.add((RealFieldElement)this.tidalCorrection.value(date)[3]);
        }
        return (T)interpolated;
    }

    public PoleCorrection getPoleCorrection(AbsoluteDate date) {
        if (!this.hasDataFor(date)) {
            if (this.tidalCorrection == null) {
                return PoleCorrection.NULL_CORRECTION;
            }
            double[] correction = this.tidalCorrection.value(date);
            return new PoleCorrection(correction[0], correction[1]);
        }
        double[] interpolated = this.interpolate(date, (EOPEntry entry) -> entry.getX(), (EOPEntry entry) -> entry.getY());
        if (this.tidalCorrection != null) {
            double[] correction = this.tidalCorrection.value(date);
            interpolated[0] = interpolated[0] + correction[0];
            interpolated[1] = interpolated[1] + correction[1];
        }
        return new PoleCorrection(interpolated[0], interpolated[1]);
    }

    public <T extends RealFieldElement<T>> FieldPoleCorrection<T> getPoleCorrection(FieldAbsoluteDate<T> date) {
        AbsoluteDate aDate = date.toAbsoluteDate();
        if (!this.hasDataFor(aDate)) {
            if (this.tidalCorrection == null) {
                return new FieldPoleCorrection<RealFieldElement>((RealFieldElement)date.getField().getZero(), (RealFieldElement)date.getField().getZero());
            }
            RealFieldElement[] correction = this.tidalCorrection.value(date);
            return new FieldPoleCorrection<RealFieldElement>(correction[0], correction[1]);
        }
        RealFieldElement[] interpolated = this.interpolate(date, aDate, entry -> entry.getX(), entry -> entry.getY());
        if (this.tidalCorrection != null) {
            RealFieldElement[] correction = this.tidalCorrection.value(date);
            interpolated[0] = interpolated[0].add(correction[0]);
            interpolated[1] = interpolated[1].add(correction[1]);
        }
        return new FieldPoleCorrection<RealFieldElement>(interpolated[0], interpolated[1]);
    }

    public double[] getEquinoxNutationCorrection(AbsoluteDate date) {
        if (!this.hasDataFor(date)) {
            return new double[2];
        }
        return this.interpolate(date, (EOPEntry entry) -> entry.getDdPsi(), (EOPEntry entry) -> entry.getDdEps());
    }

    public <T extends RealFieldElement<T>> T[] getEquinoxNutationCorrection(FieldAbsoluteDate<T> date) {
        AbsoluteDate aDate = date.toAbsoluteDate();
        if (!this.hasDataFor(aDate)) {
            return (RealFieldElement[])MathArrays.buildArray(date.getField(), 2);
        }
        return this.interpolate(date, aDate, entry -> entry.getDdPsi(), entry -> entry.getDdEps());
    }

    public double[] getNonRotatinOriginNutationCorrection(AbsoluteDate date) {
        if (!this.hasDataFor(date)) {
            return new double[2];
        }
        return this.interpolate(date, (EOPEntry entry) -> entry.getDx(), (EOPEntry entry) -> entry.getDy());
    }

    public <T extends RealFieldElement<T>> T[] getNonRotatinOriginNutationCorrection(FieldAbsoluteDate<T> date) {
        AbsoluteDate aDate = date.toAbsoluteDate();
        if (!this.hasDataFor(aDate)) {
            return (RealFieldElement[])MathArrays.buildArray(date.getField(), 2);
        }
        return this.interpolate(date, aDate, entry -> entry.getDx(), entry -> entry.getDy());
    }

    public ITRFVersion getITRFVersion(AbsoluteDate date) {
        if (!this.hasDataFor(date)) {
            return ITRFVersion.ITRF_2014;
        }
        try {
            Optional<EOPEntry> first = this.getNeighbors(date).findFirst();
            return first.isPresent() ? first.get().getITRFType() : ITRFVersion.ITRF_2014;
        }
        catch (TimeStampedCacheException tce) {
            throw new OrekitInternalError(tce);
        }
    }

    public void checkEOPContinuity(double maxGap) {
        TimeStamped preceding = null;
        for (TimeStamped timeStamped : this.cache.getAll()) {
            if (preceding != null && timeStamped.getDate().durationFrom(preceding.getDate()) > maxGap) {
                throw new OrekitException((Localizable)OrekitMessages.MISSING_EARTH_ORIENTATION_PARAMETERS_BETWEEN_DATES, preceding.getDate(), timeStamped.getDate());
            }
            preceding = timeStamped;
        }
    }

    protected boolean hasDataFor(AbsoluteDate date) {
        return this.hasData && this.getStartDate().compareTo(date) <= 0 && date.compareTo(this.getEndDate()) <= 0;
    }

    public List<EOPEntry> getEntries() {
        return this.cache.getAll();
    }

    private double interpolate(AbsoluteDate date, Function<EOPEntry, Double> selector) {
        try {
            HermiteInterpolator interpolator = new HermiteInterpolator();
            this.getNeighbors(date).forEach(entry -> interpolator.addSamplePoint(entry.getDate().durationFrom(date), new double[][]{{(Double)selector.apply((EOPEntry)entry)}}));
            return interpolator.value(0.0)[0];
        }
        catch (TimeStampedCacheException tce) {
            throw new OrekitInternalError(tce);
        }
    }

    private <T extends RealFieldElement<T>> T interpolate(FieldAbsoluteDate<T> date, AbsoluteDate aDate, Function<EOPEntry, Double> selector) {
        try {
            FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
            RealFieldElement[] y = (RealFieldElement[])MathArrays.buildArray(date.getField(), 1);
            RealFieldElement zero = (RealFieldElement)date.getField().getZero();
            FieldAbsoluteDate<RealFieldElement> central = new FieldAbsoluteDate<RealFieldElement>(aDate, zero);
            this.getNeighbors(aDate).forEach(entry -> {
                y[0] = (RealFieldElement)zero.add((Double)selector.apply((EOPEntry)entry));
                interpolator.addSamplePoint((FieldElement)central.durationFrom(entry.getDate()).negate(), new RealFieldElement[][]{y});
            });
            return (T)((RealFieldElement[])interpolator.value(date.durationFrom(central)))[0];
        }
        catch (TimeStampedCacheException tce) {
            throw new OrekitInternalError(tce);
        }
    }

    private double[] interpolate(AbsoluteDate date, Function<EOPEntry, Double> selector1, Function<EOPEntry, Double> selector2) {
        try {
            HermiteInterpolator interpolator = new HermiteInterpolator();
            this.getNeighbors(date).forEach(entry -> interpolator.addSamplePoint(entry.getDate().durationFrom(date), new double[][]{{(Double)selector1.apply((EOPEntry)entry), (Double)selector2.apply((EOPEntry)entry)}}));
            return interpolator.value(0.0);
        }
        catch (TimeStampedCacheException tce) {
            throw new OrekitInternalError(tce);
        }
    }

    private <T extends RealFieldElement<T>> T[] interpolate(FieldAbsoluteDate<T> date, AbsoluteDate aDate, Function<EOPEntry, Double> selector1, Function<EOPEntry, Double> selector2) {
        try {
            FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
            RealFieldElement[] y = (RealFieldElement[])MathArrays.buildArray(date.getField(), 2);
            RealFieldElement zero = (RealFieldElement)date.getField().getZero();
            FieldAbsoluteDate<RealFieldElement> central = new FieldAbsoluteDate<RealFieldElement>(aDate, zero);
            this.getNeighbors(aDate).forEach(entry -> {
                y[0] = (RealFieldElement)zero.add((Double)selector1.apply((EOPEntry)entry));
                y[1] = (RealFieldElement)zero.add((Double)selector2.apply((EOPEntry)entry));
                interpolator.addSamplePoint((FieldElement)central.durationFrom(entry.getDate()).negate(), new RealFieldElement[][]{y});
            });
            return (RealFieldElement[])interpolator.value(date.durationFrom(central));
        }
        catch (TimeStampedCacheException tce) {
            throw new OrekitInternalError(tce);
        }
    }

    private Object writeReplace() {
        return new DataTransferObject(this.conventions, this.getEntries(), this.tidalCorrection == null);
    }

    private static class CachedCorrection
    implements TimeVectorFunction,
    TimeStampedGenerator<TidalCorrectionEntry> {
        private final TimeVectorFunction tidalCorrection;
        private final double step;
        private final TimeStampedCache<TidalCorrectionEntry> cache;

        CachedCorrection(TimeVectorFunction tidalCorrection) {
            this.step = 3600.0;
            this.tidalCorrection = tidalCorrection;
            this.cache = new GenericTimeStampedCache<TidalCorrectionEntry>(8, OrekitConfiguration.getCacheSlotsNumber(), 2592000.0, 86400.0, this);
        }

        @Override
        public double[] value(AbsoluteDate date) {
            try {
                HermiteInterpolator interpolator = new HermiteInterpolator();
                this.cache.getNeighbors(date).forEach(entry -> interpolator.addSamplePoint(((TidalCorrectionEntry)entry).date.durationFrom(date), new double[][]{((TidalCorrectionEntry)entry).correction}));
                return interpolator.value(0.0);
            }
            catch (TimeStampedCacheException tsce) {
                throw new OrekitInternalError(tsce);
            }
        }

        @Override
        public <T extends RealFieldElement<T>> T[] value(FieldAbsoluteDate<T> date) {
            try {
                AbsoluteDate aDate = date.toAbsoluteDate();
                FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
                RealFieldElement[] y = (RealFieldElement[])MathArrays.buildArray(date.getField(), 4);
                RealFieldElement zero = (RealFieldElement)date.getField().getZero();
                FieldAbsoluteDate<RealFieldElement> central = new FieldAbsoluteDate<RealFieldElement>(aDate, zero);
                this.cache.getNeighbors(aDate).forEach(entry -> {
                    for (int i = 0; i < y.length; ++i) {
                        y[i] = (RealFieldElement)zero.add(((TidalCorrectionEntry)entry).correction[i]);
                    }
                    interpolator.addSamplePoint((FieldElement)central.durationFrom(entry.getDate()).negate(), new RealFieldElement[][]{y});
                });
                return (RealFieldElement[])interpolator.value(date.durationFrom(central));
            }
            catch (TimeStampedCacheException tsce) {
                throw new OrekitInternalError(tsce);
            }
        }

        @Override
        public List<TidalCorrectionEntry> generate(AbsoluteDate existingDate, AbsoluteDate date) {
            ArrayList<TidalCorrectionEntry> generated = new ArrayList<TidalCorrectionEntry>();
            if (existingDate == null) {
                int i = -this.cache.getNeighborsSize() / 2;
                while (generated.size() < this.cache.getNeighborsSize()) {
                    AbsoluteDate t = date.shiftedBy((double)i * this.step);
                    generated.add(new TidalCorrectionEntry(t, this.tidalCorrection.value(t)));
                    ++i;
                }
            } else {
                AbsoluteDate t = existingDate;
                if (date.compareTo(t) > 0) {
                    do {
                        t = t.shiftedBy(this.step);
                        generated.add(new TidalCorrectionEntry(t, this.tidalCorrection.value(t)));
                    } while (t.compareTo(date) <= 0);
                } else {
                    do {
                        t = t.shiftedBy(-this.step);
                        generated.add(0, new TidalCorrectionEntry(t, this.tidalCorrection.value(t)));
                    } while (t.compareTo(date) >= 0);
                }
            }
            return generated;
        }
    }

    private static class TidalCorrectionEntry
    implements TimeStamped {
        private final AbsoluteDate date;
        private final double[] correction;

        TidalCorrectionEntry(AbsoluteDate date, double[] correction) {
            this.date = date;
            this.correction = correction;
        }

        @Override
        public AbsoluteDate getDate() {
            return this.date;
        }
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20131010L;
        private final IERSConventions conventions;
        private final List<EOPEntry> entries;
        private final boolean simpleEOP;

        DataTransferObject(IERSConventions conventions, List<EOPEntry> entries, boolean simpleEOP) {
            this.conventions = conventions;
            this.entries = entries;
            this.simpleEOP = simpleEOP;
        }

        private Object readResolve() {
            try {
                return new EOPHistory(this.conventions, this.entries, this.simpleEOP);
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(oe);
            }
        }
    }

    private static class FieldDUT1Interpolator<T extends RealFieldElement<T>>
    implements Consumer<EOPEntry> {
        private double firstDUT = Double.NaN;
        private boolean beforeLeap = true;
        private final FieldHermiteInterpolator<T> interpolator = new FieldHermiteInterpolator();
        private FieldAbsoluteDate<T> date;
        private AbsoluteDate absDate;

        FieldDUT1Interpolator(FieldAbsoluteDate<T> date, AbsoluteDate absDate) {
            this.date = date;
            this.absDate = absDate;
        }

        @Override
        public void accept(EOPEntry neighbor) {
            double dut;
            if (Double.isNaN(this.firstDUT)) {
                this.firstDUT = neighbor.getUT1MinusUTC();
            }
            if (neighbor.getUT1MinusUTC() - this.firstDUT > 0.9) {
                dut = neighbor.getUT1MinusUTC() - 1.0;
                if (neighbor.getDate().compareTo(this.absDate) <= 0) {
                    this.beforeLeap = false;
                }
            } else {
                dut = neighbor.getUT1MinusUTC();
            }
            RealFieldElement[] array = (RealFieldElement[])MathArrays.buildArray(this.date.getField(), 1);
            array[0] = (RealFieldElement)((RealFieldElement)this.date.getField().getZero()).add(dut);
            this.interpolator.addSamplePoint((FieldElement)this.date.durationFrom(neighbor.getDate()).negate(), new RealFieldElement[][]{array});
        }

        public T getInterpolated() {
            RealFieldElement interpolated = ((RealFieldElement[])this.interpolator.value((FieldElement)this.date.getField().getZero()))[0];
            return (T)(this.beforeLeap ? interpolated : (RealFieldElement)interpolated.add(1.0));
        }
    }

    private static class DUT1Interpolator
    implements Consumer<EOPEntry> {
        private double firstDUT = Double.NaN;
        private boolean beforeLeap = true;
        private final HermiteInterpolator interpolator = new HermiteInterpolator();
        private AbsoluteDate date;

        DUT1Interpolator(AbsoluteDate date) {
            this.date = date;
        }

        @Override
        public void accept(EOPEntry neighbor) {
            double dut;
            if (Double.isNaN(this.firstDUT)) {
                this.firstDUT = neighbor.getUT1MinusUTC();
            }
            if (neighbor.getUT1MinusUTC() - this.firstDUT > 0.9) {
                dut = neighbor.getUT1MinusUTC() - 1.0;
                if (neighbor.getDate().compareTo(this.date) <= 0) {
                    this.beforeLeap = false;
                }
            } else {
                dut = neighbor.getUT1MinusUTC();
            }
            this.interpolator.addSamplePoint(neighbor.getDate().durationFrom(this.date), new double[][]{{dut}});
        }

        public double getInterpolated() {
            double interpolated = this.interpolator.value(0.0)[0];
            return this.beforeLeap ? interpolated : interpolated + 1.0;
        }
    }
}

