/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.HelmertTransformation;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.frames.TransformProviderUtils;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;

public enum ITRFVersion {
    ITRF_2014(2014),
    ITRF_2008(2008),
    ITRF_2005(2005),
    ITRF_2000(2000),
    ITRF_97(1997),
    ITRF_96(1996),
    ITRF_94(1994),
    ITRF_93(1993),
    ITRF_92(1992),
    ITRF_91(1991),
    ITRF_90(1990),
    ITRF_89(1989),
    ITRF_88(1988);

    private final int year;
    private final String name;

    private ITRFVersion(int year) {
        this.year = year;
        this.name = "ITRF-" + (year >= 2000 ? year : year - 1900);
    }

    public int getYear() {
        return this.year;
    }

    public String getName() {
        return this.name;
    }

    public static ITRFVersion getITRFVersion(int year) {
        for (ITRFVersion version : ITRFVersion.values()) {
            if (version.getYear() != year) continue;
            return version;
        }
        throw new OrekitException((Localizable)OrekitMessages.NO_SUCH_ITRF_FRAME, year);
    }

    public static ITRFVersion getITRFVersion(String name) {
        for (ITRFVersion version : ITRFVersion.values()) {
            if (!version.getName().equalsIgnoreCase(name)) continue;
            return version;
        }
        throw new OrekitException((Localizable)OrekitMessages.NO_SUCH_ITRF_FRAME, name);
    }

    public static Converter getConverter(ITRFVersion origin, ITRFVersion destination) {
        TransformProvider provider = null;
        if (origin == destination) {
            provider = TransformProviderUtils.IDENTITY_PROVIDER;
        }
        if (provider == null) {
            provider = ITRFVersion.getDirectTransformProvider(origin, destination);
        }
        if (provider == null) {
            provider = TransformProviderUtils.getCombinedProvider(ITRFVersion.getDirectTransformProvider(origin, ITRF_2014), ITRFVersion.getDirectTransformProvider(ITRF_2014, destination));
        }
        return new Converter(origin, destination, provider);
    }

    private static TransformProvider getDirectTransformProvider(ITRFVersion origin, ITRFVersion destination) {
        for (HelmertTransformation.Predefined predefined : HelmertTransformation.Predefined.values()) {
            if (predefined.getOrigin() == origin && predefined.getDestination() == destination) {
                return predefined.getTransformation();
            }
            if (predefined.getOrigin() != destination || predefined.getDestination() != origin) continue;
            return TransformProviderUtils.getReversedProvider(predefined.getTransformation());
        }
        return null;
    }

    public static class Converter
    implements TransformProvider {
        private static final long serialVersionUID = 20180330L;
        private final ITRFVersion origin;
        private final ITRFVersion destination;
        private final TransformProvider provider;

        Converter(ITRFVersion origin, ITRFVersion destination, TransformProvider provider) {
            this.origin = origin;
            this.destination = destination;
            this.provider = provider;
        }

        public ITRFVersion getOrigin() {
            return this.origin;
        }

        public ITRFVersion getDestination() {
            return this.destination;
        }

        @Override
        public Transform getTransform(AbsoluteDate date) {
            return this.provider.getTransform(date);
        }

        @Override
        public <T extends RealFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) {
            return this.provider.getTransform(date);
        }
    }
}

