/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import org.hipparchus.RealFieldElement;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;

public class TransformProviderUtils {
    public static final TransformProvider IDENTITY_PROVIDER = new TransformProvider(){
        private static final long serialVersionUID = 20180330L;

        @Override
        public Transform getTransform(AbsoluteDate date) {
            return Transform.IDENTITY;
        }

        @Override
        public <T extends RealFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) {
            return FieldTransform.getIdentity(date.getField());
        }
    };

    private TransformProviderUtils() {
    }

    public static TransformProvider getReversedProvider(final TransformProvider provider) {
        return new TransformProvider(){
            private static final long serialVersionUID = 20180330L;

            @Override
            public Transform getTransform(AbsoluteDate date) {
                return provider.getTransform(date).getInverse();
            }

            @Override
            public <T extends RealFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) {
                return provider.getTransform(date).getInverse();
            }
        };
    }

    public static TransformProvider getCombinedProvider(final TransformProvider first, final TransformProvider second) {
        return new TransformProvider(){
            private static final long serialVersionUID = 20180330L;

            @Override
            public Transform getTransform(AbsoluteDate date) {
                return new Transform(date, first.getTransform(date), second.getTransform(date));
            }

            @Override
            public <T extends RealFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) {
                return new FieldTransform<T>(date, first.getTransform(date), second.getTransform(date));
            }
        };
    }
}

