/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;

class VEISProvider
implements TransformProvider {
    private static final long serialVersionUID = 20130530L;
    private static AbsoluteDate VST_REFERENCE = new AbsoluteDate(DateComponents.FIFTIES_EPOCH, (TimeScale)TimeScalesFactory.getTAI());
    private static final double VST0 = 1.746647708617871;
    private static final double VST1 = 0.017202179573714598;
    private static final double VSTD = 7.292115146705209E-5;

    VEISProvider() {
    }

    @Override
    public Transform getTransform(AbsoluteDate date) {
        double dtai = date.durationFrom(VST_REFERENCE);
        double dutc = TimeScalesFactory.getUTC().offsetFromTAI(date);
        double dut1 = 0.0;
        double tut1 = dtai + dutc + 0.0;
        double ttd = tut1 / 86400.0;
        double rdtt = ttd - (double)((int)ttd);
        double vst = (1.746647708617871 + 0.017202179573714598 * ttd + Math.PI * 2 * rdtt) % (Math.PI * 2);
        Vector3D rotationRate = new Vector3D(-7.292115146705209E-5, Vector3D.PLUS_K);
        return new Transform(date, new Rotation(Vector3D.PLUS_K, vst, RotationConvention.VECTOR_OPERATOR), rotationRate);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) {
        T dtai = date.durationFrom(VST_REFERENCE);
        double dutc = TimeScalesFactory.getUTC().offsetFromTAI(date.toAbsoluteDate());
        double dut1 = 0.0;
        RealFieldElement tut1 = (RealFieldElement)dtai.add(dutc + 0.0);
        RealFieldElement ttd = (RealFieldElement)tut1.divide(86400.0);
        RealFieldElement rdtt = (RealFieldElement)ttd.subtract((int)ttd.getReal());
        RealFieldElement vst = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)ttd.multiply(0.017202179573714598)).add(rdtt.multiply(Math.PI * 2))).add(1.746647708617871)).remainder(Math.PI * 2);
        FieldVector3D<RealFieldElement> rotationRate = new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)date.getField().getZero()).add(-7.292115146705209E-5), Vector3D.PLUS_K);
        return new FieldTransform<RealFieldElement>(date, new FieldRotation<RealFieldElement>(FieldVector3D.getPlusK(date.getField()), vst, RotationConvention.VECTOR_OPERATOR), rotationRate);
    }
}

