/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.hipparchus.RealFieldElement;
import org.orekit.frames.EOPBasedTransformProvider;
import org.orekit.frames.EOPHistory;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.ITRFProvider;
import org.orekit.frames.ITRFVersion;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;

class VersionedITRFProvider
implements EOPBasedTransformProvider {
    private static final long serialVersionUID = 20180403L;
    private final ITRFVersion version;
    private final ITRFProvider rawProvider;
    private final AtomicReference<ITRFVersion.Converter> converter;

    VersionedITRFProvider(ITRFVersion version, ITRFProvider rawProvider) {
        this.version = version;
        this.rawProvider = rawProvider;
        this.converter = new AtomicReference();
    }

    public ITRFVersion getITRFVersion() {
        return this.version;
    }

    @Override
    public EOPHistory getEOPHistory() {
        return this.rawProvider.getEOPHistory();
    }

    @Override
    public VersionedITRFProvider getNonInterpolatingProvider() {
        return new VersionedITRFProvider(this.version, this.rawProvider.getNonInterpolatingProvider());
    }

    @Override
    public Transform getTransform(AbsoluteDate date) {
        Transform rawTransform = this.rawProvider.getTransform(date);
        ITRFVersion.Converter converterForDate = this.getConverter(date);
        if (converterForDate == null) {
            return rawTransform;
        }
        return new Transform(date, rawTransform, converterForDate.getTransform(date));
    }

    @Override
    public <T extends RealFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) {
        FieldTransform<T> rawTransform = this.rawProvider.getTransform(date);
        ITRFVersion.Converter converterForDate = this.getConverter(date.toAbsoluteDate());
        if (converterForDate == null) {
            return rawTransform;
        }
        return new FieldTransform<T>(date, rawTransform, converterForDate.getTransform(date));
    }

    private ITRFVersion.Converter getConverter(AbsoluteDate date) {
        ITRFVersion rawVersion = this.getEOPHistory().getITRFVersion(date);
        if (rawVersion == this.version) {
            return null;
        }
        ITRFVersion.Converter existing = this.converter.get();
        if (existing != null && existing.getOrigin() == rawVersion) {
            return existing;
        }
        ITRFVersion.Converter newConverter = ITRFVersion.getConverter(rawVersion, this.version);
        this.converter.compareAndSet(null, newConverter);
        return newConverter;
    }

    private Object writeReplace() {
        return new DataTransferObject(this.version, this.rawProvider);
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20180403L;
        private final ITRFVersion version;
        private final ITRFProvider rawProvider;

        DataTransferObject(ITRFVersion version, ITRFProvider rawProvider) {
            this.version = version;
            this.rawProvider = rawProvider;
        }

        private Object readResolve() {
            return new VersionedITRFProvider(this.version, this.rawProvider);
        }
    }
}

