/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.hipparchus.exception.DummyLocalizable;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.util.FastMath;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.gnss.ObservationData;
import org.orekit.gnss.ObservationDataSet;
import org.orekit.gnss.ObservationType;
import org.orekit.gnss.RinexHeader;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;

public class RinexLoader {
    public static final String DEFAULT_RINEX_2_SUPPORTED_NAMES = "^\\w{4}\\d{3}[0a-x](?:\\d{2})?\\.\\d{2}[oO]$";
    public static final String DEFAULT_RINEX_3_SUPPORTED_NAMES = "^\\w{9}_\\w{1}_\\d{11}_\\d{2}\\w_\\d{2}\\w{1}_\\w{2}\\.rnx$";
    private static final String RINEX_VERSION_TYPE = "RINEX VERSION / TYPE";
    private static final String COMMENT = "COMMENT";
    private static final String PGM_RUN_BY_DATE = "PGM / RUN BY / DATE";
    private static final String MARKER_NAME = "MARKER NAME";
    private static final String MARKER_NUMBER = "MARKER NUMBER";
    private static final String MARKER_TYPE = "MARKER TYPE";
    private static final String OBSERVER_AGENCY = "OBSERVER / AGENCY";
    private static final String REC_NB_TYPE_VERS = "REC # / TYPE / VERS";
    private static final String ANT_NB_TYPE = "ANT # / TYPE";
    private static final String APPROX_POSITION_XYZ = "APPROX POSITION XYZ";
    private static final String ANTENNA_DELTA_H_E_N = "ANTENNA: DELTA H/E/N";
    private static final String ANTENNA_DELTA_X_Y_Z = "ANTENNA: DELTA X/Y/Z";
    private static final String ANTENNA_PHASECENTER = "ANTENNA: PHASECENTER";
    private static final String ANTENNA_B_SIGHT_XYZ = "ANTENNA: B.SIGHT XYZ";
    private static final String ANTENNA_ZERODIR_AZI = "ANTENNA: ZERODIR AZI";
    private static final String ANTENNA_ZERODIR_XYZ = "ANTENNA: ZERODIR XYZ";
    private static final String NB_OF_SATELLITES = "# OF SATELLITES";
    private static final String WAVELENGTH_FACT_L1_2 = "WAVELENGTH FACT L1/2";
    private static final String RCV_CLOCK_OFFS_APPL = "RCV CLOCK OFFS APPL";
    private static final String INTERVAL = "INTERVAL";
    private static final String TIME_OF_FIRST_OBS = "TIME OF FIRST OBS";
    private static final String TIME_OF_LAST_OBS = "TIME OF LAST OBS";
    private static final String LEAP_SECONDS = "LEAP SECONDS";
    private static final String PRN_NB_OF_OBS = "PRN / # OF OBS";
    private static final String NB_TYPES_OF_OBSERV = "# / TYPES OF OBSERV";
    private static final String END_OF_HEADER = "END OF HEADER";
    private static final String CENTER_OF_MASS_XYZ = "CENTER OF MASS: XYZ";
    private static final String SIGNAL_STRENGTH_UNIT = "SIGNAL STRENGTH UNIT";
    private static final String SYS_NB_OBS_TYPES = "SYS / # / OBS TYPES";
    private static final String SYS_DCBS_APPLIED = "SYS / DCBS APPLIED";
    private static final String SYS_PCVS_APPLIED = "SYS / PCVS APPLIED";
    private static final String SYS_SCALE_FACTOR = "SYS / SCALE FACTOR";
    private static final String SYS_PHASE_SHIFT = "SYS / PHASE SHIFT";
    private static final String GLONASS_SLOT_FRQ_NB = "GLONASS SLOT / FRQ #";
    private static final String GLONASS_COD_PHS_BIS = "GLONASS COD/PHS/BIS";
    private static final String OBS_SCALE_FACTOR = "OBS SCALE FACTOR";
    private static final String GPS = "GPS";
    private static final String GAL = "GAL";
    private static final String GLO = "GLO";
    private static final String QZS = "QZS";
    private static final String BDT = "BDT";
    private static final String IRN = "IRN";
    private final List<ObservationDataSet> observationDataSets;

    public RinexLoader(String supportedNames) {
        this.observationDataSets = new ArrayList<ObservationDataSet>();
        DataProvidersManager.getInstance().feed(supportedNames, new Parser());
    }

    public RinexLoader(InputStream input, String name) {
        try {
            this.observationDataSets = new ArrayList<ObservationDataSet>();
            new Parser().loadData(input, name);
        }
        catch (IOException ioe) {
            throw new OrekitException(ioe, new DummyLocalizable(ioe.getMessage()), new Object[0]);
        }
    }

    public List<ObservationDataSet> getObservationDataSets() {
        return Collections.unmodifiableList(this.observationDataSets);
    }

    public class Parser
    implements DataLoader {
        private static final int LABEL_START = 60;
        private static final String FILE_TYPE = "O";

        @Override
        public boolean stillAcceptsData() {
            return true;
        }

        @Override
        public void loadData(InputStream input, String name) throws IOException, OrekitException {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));){
                SatelliteSystem satelliteSystem = null;
                double formatVersion = Double.NaN;
                boolean inRinexVersion = false;
                int lineNumber = 0;
                SatelliteSystem obsTypesSystem = null;
                String markerName = null;
                String markerNumber = null;
                String markerType = null;
                String observerName = null;
                String agencyName = null;
                String receiverNumber = null;
                String receiverType = null;
                String receiverVersion = null;
                String antennaNumber = null;
                String antennaType = null;
                Vector3D approxPos = null;
                Vector3D antRefPoint = null;
                String obsCode = null;
                Vector3D antPhaseCenter = null;
                Vector3D antBSight = null;
                double antAzi = Double.NaN;
                Vector3D antZeroDir = null;
                Vector3D centerMass = null;
                double antHeight = Double.NaN;
                Vector2D eccentricities = Vector2D.ZERO;
                int clkOffset = -1;
                int nbTypes = -1;
                int nbSat = -1;
                double interval = Double.NaN;
                AbsoluteDate tFirstObs = AbsoluteDate.PAST_INFINITY;
                AbsoluteDate tLastObs = AbsoluteDate.FUTURE_INFINITY;
                TimeScale timeScale = null;
                String timeScaleStr = null;
                int leapSeconds = 0;
                AbsoluteDate tObs = AbsoluteDate.PAST_INFINITY;
                String[] satsObsList = null;
                String strYear = null;
                int eventFlag = -1;
                int nbSatObs = -1;
                int nbLinesSat = -1;
                double rcvrClkOffset = 0.0;
                boolean inRunBy = false;
                boolean inMarkerName = false;
                boolean inMarkerType = false;
                boolean inObserver = false;
                boolean inRecType = false;
                boolean inAntType = false;
                boolean inAproxPos = false;
                boolean inAntDelta = false;
                boolean inTypesObs = false;
                boolean inFirstObs = false;
                boolean inPhaseShift = false;
                boolean inGlonassSlot = false;
                boolean inGlonassCOD = false;
                RinexHeader rinexHeader = null;
                int scaleFactor = 1;
                int nbObsScaleFactor = 0;
                ArrayList<ScaleFactorCorrection> scaleFactorCorrections = new ArrayList<ScaleFactorCorrection>();
                HashMap listTypeObs = new HashMap();
                String line = reader.readLine();
                ++lineNumber;
                formatVersion = this.parseDouble(line, 0, 9);
                int format100 = (int)FastMath.rint(100.0 * formatVersion);
                if (format100 != 200 && format100 != 210 && format100 != 211 && format100 != 212 && format100 != 220 && format100 != 300 && format100 != 301 && format100 != 302 && format100 != 303) {
                    throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_FILE_FORMAT, name);
                }
                if (!this.parseString(line, 20, 1).equals(FILE_TYPE)) {
                    throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_FILE_FORMAT, name);
                }
                satelliteSystem = SatelliteSystem.parseSatelliteSystem(this.parseString(line, 40, 1));
                inRinexVersion = true;
                switch (format100 / 100) {
                    case 2: {
                        int MAX_OBS_TYPES_PER_LINE_RNX2 = 9;
                        int MAX_N_SAT_OBSERVATION = 12;
                        int MAX_N_TYPES_OBSERVATION = 5;
                        int MAX_OBS_TYPES_SCALE_FACTOR = 8;
                        ArrayList<ObservationType> typesObs = new ArrayList<ObservationType>();
                        line = reader.readLine();
                        while (line != null) {
                            ++lineNumber;
                            if (rinexHeader == null) {
                                switch (line.substring(60).trim()) {
                                    case "RINEX VERSION / TYPE": {
                                        formatVersion = this.parseDouble(line, 0, 9);
                                        if (!this.parseString(line, 20, 1).equals(FILE_TYPE)) {
                                            throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_FILE_FORMAT, name);
                                        }
                                        satelliteSystem = SatelliteSystem.parseSatelliteSystem(this.parseString(line, 40, 1));
                                        inRinexVersion = true;
                                        break;
                                    }
                                    case "COMMENT": {
                                        break;
                                    }
                                    case "PGM / RUN BY / DATE": {
                                        inRunBy = true;
                                        break;
                                    }
                                    case "MARKER NAME": {
                                        markerName = this.parseString(line, 0, 60);
                                        inMarkerName = true;
                                        break;
                                    }
                                    case "MARKER NUMBER": {
                                        markerNumber = this.parseString(line, 0, 20);
                                        break;
                                    }
                                    case "MARKER TYPE": {
                                        markerType = this.parseString(line, 0, 20);
                                        break;
                                    }
                                    case "OBSERVER / AGENCY": {
                                        observerName = this.parseString(line, 0, 20);
                                        agencyName = this.parseString(line, 20, 40);
                                        inObserver = true;
                                        break;
                                    }
                                    case "REC # / TYPE / VERS": {
                                        receiverNumber = this.parseString(line, 0, 20);
                                        receiverType = this.parseString(line, 20, 20);
                                        receiverVersion = this.parseString(line, 40, 20);
                                        inRecType = true;
                                        break;
                                    }
                                    case "ANT # / TYPE": {
                                        antennaNumber = this.parseString(line, 0, 20);
                                        antennaType = this.parseString(line, 20, 20);
                                        inAntType = true;
                                        break;
                                    }
                                    case "APPROX POSITION XYZ": {
                                        approxPos = new Vector3D(this.parseDouble(line, 0, 14), this.parseDouble(line, 14, 14), this.parseDouble(line, 28, 14));
                                        inAproxPos = true;
                                        break;
                                    }
                                    case "ANTENNA: DELTA H/E/N": {
                                        antHeight = this.parseDouble(line, 0, 14);
                                        eccentricities = new Vector2D(this.parseDouble(line, 14, 14), this.parseDouble(line, 28, 14));
                                        inAntDelta = true;
                                        break;
                                    }
                                    case "ANTENNA: DELTA X/Y/Z": {
                                        antRefPoint = new Vector3D(this.parseDouble(line, 0, 14), this.parseDouble(line, 14, 14), this.parseDouble(line, 28, 14));
                                        break;
                                    }
                                    case "ANTENNA: B.SIGHT XYZ": {
                                        antBSight = new Vector3D(this.parseDouble(line, 0, 14), this.parseDouble(line, 14, 14), this.parseDouble(line, 28, 14));
                                        break;
                                    }
                                    case "CENTER OF MASS: XYZ": {
                                        centerMass = new Vector3D(this.parseDouble(line, 0, 14), this.parseDouble(line, 14, 14), this.parseDouble(line, 28, 14));
                                        break;
                                    }
                                    case "# OF SATELLITES": {
                                        nbSat = this.parseInt(line, 0, 6);
                                        break;
                                    }
                                    case "WAVELENGTH FACT L1/2": {
                                        break;
                                    }
                                    case "RCV CLOCK OFFS APPL": {
                                        clkOffset = this.parseInt(line, 0, 6);
                                        break;
                                    }
                                    case "INTERVAL": {
                                        interval = this.parseDouble(line, 0, 10);
                                        break;
                                    }
                                    case "TIME OF FIRST OBS": {
                                        switch (satelliteSystem) {
                                            case GPS: {
                                                timeScale = TimeScalesFactory.getGPS();
                                                break;
                                            }
                                            case GALILEO: {
                                                timeScale = TimeScalesFactory.getGST();
                                                break;
                                            }
                                            case GLONASS: {
                                                timeScale = TimeScalesFactory.getGLONASS();
                                                break;
                                            }
                                            case MIXED: {
                                                timeScaleStr = this.parseString(line, 48, 3);
                                                if (timeScaleStr.equals(RinexLoader.GPS)) {
                                                    timeScale = TimeScalesFactory.getGPS();
                                                    break;
                                                }
                                                if (timeScaleStr.equals(RinexLoader.GAL)) {
                                                    timeScale = TimeScalesFactory.getGST();
                                                    break;
                                                }
                                                if (timeScaleStr.equals(RinexLoader.GLO)) {
                                                    timeScale = TimeScalesFactory.getGLONASS();
                                                    break;
                                                }
                                                throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_FILE_FORMAT, name);
                                            }
                                            default: {
                                                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                                            }
                                        }
                                        tFirstObs = new AbsoluteDate(this.parseInt(line, 0, 6), this.parseInt(line, 6, 6), this.parseInt(line, 12, 6), this.parseInt(line, 18, 6), this.parseInt(line, 24, 6), this.parseDouble(line, 30, 13), timeScale);
                                        inFirstObs = true;
                                        break;
                                    }
                                    case "TIME OF LAST OBS": {
                                        tLastObs = new AbsoluteDate(this.parseInt(line, 0, 6), this.parseInt(line, 6, 6), this.parseInt(line, 12, 6), this.parseInt(line, 18, 6), this.parseInt(line, 24, 6), this.parseDouble(line, 30, 13), timeScale);
                                        break;
                                    }
                                    case "LEAP SECONDS": {
                                        leapSeconds = this.parseInt(line, 0, 6);
                                        break;
                                    }
                                    case "PRN / # OF OBS": {
                                        break;
                                    }
                                    case "# / TYPES OF OBSERV": {
                                        nbTypes = this.parseInt(line, 0, 6);
                                        int nbLinesTypesObs = (nbTypes + 9 - 1) / 9;
                                        for (int j = 0; j < nbLinesTypesObs; ++j) {
                                            if (j > 0) {
                                                line = reader.readLine();
                                                ++lineNumber;
                                            }
                                            int iMax = FastMath.min(9, nbTypes - typesObs.size());
                                            for (int i = 0; i < iMax; ++i) {
                                                try {
                                                    typesObs.add(ObservationType.valueOf(this.parseString(line, 10 + 6 * i, 2)));
                                                    continue;
                                                }
                                                catch (IllegalArgumentException iae) {
                                                    throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_RINEX_FREQUENCY, this.parseString(line, 10 + 6 * i, 2), name, lineNumber);
                                                }
                                            }
                                        }
                                        inTypesObs = true;
                                        break;
                                    }
                                    case "OBS SCALE FACTOR": {
                                        scaleFactor = FastMath.max(1, this.parseInt(line, 0, 6));
                                        nbObsScaleFactor = this.parseInt(line, 6, 6);
                                        if (nbObsScaleFactor > 8) {
                                            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                                        }
                                        ArrayList<ObservationType> typesObsScaleFactor = new ArrayList<ObservationType>(nbObsScaleFactor);
                                        for (int i = 0; i < nbObsScaleFactor; ++i) {
                                            typesObsScaleFactor.add(ObservationType.valueOf(this.parseString(line, 16 + 6 * i, 2)));
                                        }
                                        scaleFactorCorrections.add(new ScaleFactorCorrection(satelliteSystem, scaleFactor, typesObsScaleFactor));
                                        break;
                                    }
                                    case "END OF HEADER": {
                                        if (!inRinexVersion || !inRunBy || !inMarkerName || !inObserver || !inRecType || !inAntType || formatVersion < 2.2 && !inAproxPos || formatVersion < 2.2 && !inAntDelta || !inTypesObs || !inFirstObs) {
                                            throw new OrekitException((Localizable)OrekitMessages.INCOMPLETE_HEADER, name);
                                        }
                                        rinexHeader = new RinexHeader(formatVersion, satelliteSystem, markerName, markerNumber, markerType, observerName, agencyName, receiverNumber, receiverType, receiverVersion, antennaNumber, antennaType, approxPos, antHeight, eccentricities, antRefPoint, antBSight, centerMass, interval, tFirstObs, tLastObs, clkOffset, leapSeconds);
                                        break;
                                    }
                                    default: {
                                        if (rinexHeader == null) {
                                            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                                        } else {
                                            break;
                                        }
                                    }
                                }
                            } else {
                                rcvrClkOffset = 0.0;
                                nbLinesSat = -1;
                                eventFlag = -1;
                                nbSatObs = -1;
                                satsObsList = null;
                                tObs = null;
                                strYear = null;
                                eventFlag = this.parseInt(line, 28, 1);
                                if (eventFlag != 0) {
                                    if (eventFlag == 6) {
                                        nbSatObs = this.parseInt(line, 29, 3);
                                        nbLinesSat = (nbSatObs + 12 - 1) / 12;
                                        int nbLinesObs = (nbTypes + 5 - 1) / 5;
                                        int nbLinesSkip = nbLinesSat - 1 + nbSatObs * nbLinesObs;
                                        for (int i = 0; i < nbLinesSkip; ++i) {
                                            line = reader.readLine();
                                            ++lineNumber;
                                        }
                                    } else {
                                        int nbLinesSkip = this.parseInt(line, 29, 3);
                                        for (int i = 0; i < nbLinesSkip; ++i) {
                                            line = reader.readLine();
                                            ++lineNumber;
                                        }
                                    }
                                } else {
                                    int y = Integer.parseInt(this.parseString(line, 0, 3));
                                    if (79 < y && y <= 99) {
                                        strYear = "19" + y;
                                    } else if (0 <= y && y <= 79) {
                                        strYear = "20" + this.parseString(line, 0, 3);
                                    }
                                    tObs = new AbsoluteDate(Integer.parseInt(strYear), this.parseInt(line, 3, 3), this.parseInt(line, 6, 3), this.parseInt(line, 9, 3), this.parseInt(line, 12, 3), this.parseDouble(line, 15, 11), timeScale);
                                    nbSatObs = this.parseInt(line, 29, 3);
                                    satsObsList = new String[nbSatObs];
                                    if (nbSat != -1 && nbSatObs > nbSat) {
                                        throw new OrekitException((Localizable)OrekitMessages.INCONSISTENT_NUMBER_OF_SATS, lineNumber, name, nbSatObs, nbSat);
                                    }
                                    nbLinesSat = (nbSatObs + 12 - 1) / 12;
                                    for (int j = 0; j < nbLinesSat; ++j) {
                                        if (j > 0) {
                                            line = reader.readLine();
                                            ++lineNumber;
                                        }
                                        int iMax = FastMath.min(12, nbSatObs - j * 12);
                                        for (int i = 0; i < iMax; ++i) {
                                            satsObsList[i + 12 * j] = this.parseString(line, 32 + 3 * i, 3);
                                        }
                                        rcvrClkOffset = this.parseDouble(line, 68, 12);
                                        if (!Double.isNaN(rcvrClkOffset)) continue;
                                        rcvrClkOffset = 0.0;
                                    }
                                    int nbLinesObs = (nbTypes + 5 - 1) / 5;
                                    for (int k = 0; k < nbSatObs; ++k) {
                                        int prnNumber;
                                        int id;
                                        SatelliteSystem satelliteSystemSat;
                                        ArrayList<ObservationData> observationData = new ArrayList<ObservationData>(nbSatObs);
                                        for (int j = 0; j < nbLinesObs; ++j) {
                                            line = reader.readLine();
                                            ++lineNumber;
                                            int iMax = FastMath.min(5, nbTypes - observationData.size());
                                            for (int i = 0; i < iMax; ++i) {
                                                ObservationType type = (ObservationType)((Object)typesObs.get(observationData.size()));
                                                double value = this.parseDouble(line, 16 * i, 14);
                                                boolean scaleFactorFound = false;
                                                for (int l = 0; l < scaleFactorCorrections.size() && !scaleFactorFound; ++l) {
                                                    if (!((ScaleFactorCorrection)scaleFactorCorrections.get(l)).getTypesObsScaled().contains((Object)type)) continue;
                                                    value /= ((ScaleFactorCorrection)scaleFactorCorrections.get(l)).getCorrection();
                                                    scaleFactorFound = true;
                                                }
                                                observationData.add(new ObservationData(type, value, this.parseInt(line, 14 + 16 * i, 1), this.parseInt(line, 15 + 16 * i, 1)));
                                            }
                                        }
                                        if (satsObsList[k].length() < 3) {
                                            satelliteSystemSat = satelliteSystem;
                                            id = Integer.parseInt(satsObsList[k]);
                                        } else {
                                            satelliteSystemSat = SatelliteSystem.parseSatelliteSystem(satsObsList[k]);
                                            id = Integer.parseInt(satsObsList[k].substring(1, 3).trim());
                                        }
                                        if (!satelliteSystem.equals((Object)SatelliteSystem.MIXED) && !satelliteSystemSat.equals((Object)satelliteSystem)) {
                                            throw new OrekitException((Localizable)OrekitMessages.INCONSISTENT_SATELLITE_SYSTEM, new Object[]{lineNumber, name, satelliteSystem, satelliteSystemSat});
                                        }
                                        switch (satelliteSystemSat) {
                                            case GPS: 
                                            case GALILEO: 
                                            case GLONASS: {
                                                prnNumber = id;
                                                break;
                                            }
                                            case SBAS: {
                                                prnNumber = id + 100;
                                                break;
                                            }
                                            default: {
                                                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                                            }
                                        }
                                        RinexLoader.this.observationDataSets.add(new ObservationDataSet(rinexHeader, satelliteSystemSat, prnNumber, tObs, rcvrClkOffset, observationData));
                                    }
                                }
                            }
                            line = reader.readLine();
                        }
                        break;
                    }
                    case 3: {
                        int MAX_OBS_TYPES_PER_LINE_RNX3 = 13;
                        int MAX_OBS_TYPES_SCALE_FACTOR_PER_LINE = 12;
                        int MAX_N_SAT_PHSHIFT_PER_LINE = 10;
                        ArrayList<ObservationType> typeObs = new ArrayList<ObservationType>();
                        String sigStrengthUnit = null;
                        int leapSecondsFuture = 0;
                        int leapSecondsWeekNum = 0;
                        int leapSecondsDayNum = 0;
                        ArrayList<AppliedDCBS> listAppliedDCBs = new ArrayList<AppliedDCBS>();
                        ArrayList<AppliedPCVS> listAppliedPCVS = new ArrayList<AppliedPCVS>();
                        SatelliteSystem satSystemScaleFactor = null;
                        String[] satsPhaseShift = null;
                        int nbSatPhaseShift = 0;
                        SatelliteSystem satSystemPhaseShift = null;
                        double corrPhaseShift = 0.0;
                        ArrayList<PhaseShiftCorrection> phaseShiftCorrections = new ArrayList<PhaseShiftCorrection>();
                        ObservationType phaseShiftTypeObs = null;
                        line = reader.readLine();
                        while (line != null) {
                            int j;
                            ++lineNumber;
                            if (rinexHeader == null) {
                                switch (line.substring(60).trim()) {
                                    case "RINEX VERSION / TYPE": {
                                        formatVersion = this.parseDouble(line, 0, 9);
                                        format100 = (int)FastMath.rint(100.0 * formatVersion);
                                        if (format100 != 300 && format100 != 301 && format100 != 302 && format100 != 303) {
                                            throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_FILE_FORMAT, name);
                                        }
                                        if (!this.parseString(line, 20, 1).equals(FILE_TYPE)) {
                                            throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_FILE_FORMAT, name);
                                        }
                                        satelliteSystem = SatelliteSystem.parseSatelliteSystem(this.parseString(line, 40, 1));
                                        inRinexVersion = true;
                                        break;
                                    }
                                    case "COMMENT": {
                                        break;
                                    }
                                    case "PGM / RUN BY / DATE": {
                                        inRunBy = true;
                                        break;
                                    }
                                    case "MARKER NAME": {
                                        markerName = this.parseString(line, 0, 60);
                                        inMarkerName = true;
                                        break;
                                    }
                                    case "MARKER NUMBER": {
                                        markerNumber = this.parseString(line, 0, 20);
                                        break;
                                    }
                                    case "MARKER TYPE": {
                                        markerType = this.parseString(line, 0, 20);
                                        inMarkerType = true;
                                        break;
                                    }
                                    case "OBSERVER / AGENCY": {
                                        observerName = this.parseString(line, 0, 20);
                                        agencyName = this.parseString(line, 20, 40);
                                        inObserver = true;
                                        break;
                                    }
                                    case "REC # / TYPE / VERS": {
                                        receiverNumber = this.parseString(line, 0, 20);
                                        receiverType = this.parseString(line, 20, 20);
                                        receiverVersion = this.parseString(line, 40, 20);
                                        inRecType = true;
                                        break;
                                    }
                                    case "ANT # / TYPE": {
                                        antennaNumber = this.parseString(line, 0, 20);
                                        antennaType = this.parseString(line, 20, 20);
                                        inAntType = true;
                                        break;
                                    }
                                    case "APPROX POSITION XYZ": {
                                        approxPos = new Vector3D(this.parseDouble(line, 0, 14), this.parseDouble(line, 14, 14), this.parseDouble(line, 28, 14));
                                        inAproxPos = true;
                                        break;
                                    }
                                    case "ANTENNA: DELTA H/E/N": {
                                        antHeight = this.parseDouble(line, 0, 14);
                                        eccentricities = new Vector2D(this.parseDouble(line, 14, 14), this.parseDouble(line, 28, 14));
                                        inAntDelta = true;
                                        break;
                                    }
                                    case "ANTENNA: DELTA X/Y/Z": {
                                        antRefPoint = new Vector3D(this.parseDouble(line, 0, 14), this.parseDouble(line, 14, 14), this.parseDouble(line, 28, 14));
                                        break;
                                    }
                                    case "ANTENNA: PHASECENTER": {
                                        obsCode = this.parseString(line, 2, 3);
                                        antPhaseCenter = new Vector3D(this.parseDouble(line, 5, 9), this.parseDouble(line, 14, 14), this.parseDouble(line, 28, 14));
                                        break;
                                    }
                                    case "ANTENNA: B.SIGHT XYZ": {
                                        antBSight = new Vector3D(this.parseDouble(line, 0, 14), this.parseDouble(line, 14, 14), this.parseDouble(line, 28, 14));
                                        break;
                                    }
                                    case "ANTENNA: ZERODIR AZI": {
                                        antAzi = this.parseDouble(line, 0, 14);
                                        break;
                                    }
                                    case "ANTENNA: ZERODIR XYZ": {
                                        antZeroDir = new Vector3D(this.parseDouble(line, 0, 14), this.parseDouble(line, 14, 14), this.parseDouble(line, 28, 14));
                                        break;
                                    }
                                    case "CENTER OF MASS: XYZ": {
                                        centerMass = new Vector3D(this.parseDouble(line, 0, 14), this.parseDouble(line, 14, 14), this.parseDouble(line, 28, 14));
                                        break;
                                    }
                                    case "# OF SATELLITES": {
                                        nbSat = this.parseInt(line, 0, 6);
                                        break;
                                    }
                                    case "RCV CLOCK OFFS APPL": {
                                        clkOffset = this.parseInt(line, 0, 6);
                                        break;
                                    }
                                    case "INTERVAL": {
                                        interval = this.parseDouble(line, 0, 10);
                                        break;
                                    }
                                    case "TIME OF FIRST OBS": {
                                        switch (satelliteSystem) {
                                            case GPS: {
                                                timeScale = TimeScalesFactory.getGPS();
                                                break;
                                            }
                                            case GALILEO: {
                                                timeScale = TimeScalesFactory.getGST();
                                                break;
                                            }
                                            case GLONASS: {
                                                timeScale = TimeScalesFactory.getGLONASS();
                                                break;
                                            }
                                            case QZSS: {
                                                timeScale = TimeScalesFactory.getQZSS();
                                                break;
                                            }
                                            case BEIDOU: {
                                                timeScale = TimeScalesFactory.getBDT();
                                                break;
                                            }
                                            case IRNSS: {
                                                timeScale = TimeScalesFactory.getIRNSS();
                                                break;
                                            }
                                            case MIXED: {
                                                timeScaleStr = this.parseString(line, 48, 3);
                                                if (timeScaleStr.equals(RinexLoader.GPS)) {
                                                    timeScale = TimeScalesFactory.getGPS();
                                                    break;
                                                }
                                                if (timeScaleStr.equals(RinexLoader.GAL)) {
                                                    timeScale = TimeScalesFactory.getGST();
                                                    break;
                                                }
                                                if (timeScaleStr.equals(RinexLoader.GLO)) {
                                                    timeScale = TimeScalesFactory.getGLONASS();
                                                    break;
                                                }
                                                if (timeScaleStr.equals(RinexLoader.QZS)) {
                                                    timeScale = TimeScalesFactory.getQZSS();
                                                    break;
                                                }
                                                if (timeScaleStr.equals(RinexLoader.BDT)) {
                                                    timeScale = TimeScalesFactory.getBDT();
                                                    break;
                                                }
                                                if (timeScaleStr.equals(RinexLoader.IRN)) {
                                                    timeScale = TimeScalesFactory.getIRNSS();
                                                    break;
                                                }
                                                throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_FILE_FORMAT, name);
                                            }
                                            default: {
                                                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                                            }
                                        }
                                        tFirstObs = new AbsoluteDate(this.parseInt(line, 0, 6), this.parseInt(line, 6, 6), this.parseInt(line, 12, 6), this.parseInt(line, 18, 6), this.parseInt(line, 24, 6), this.parseDouble(line, 30, 13), timeScale);
                                        inFirstObs = true;
                                        break;
                                    }
                                    case "TIME OF LAST OBS": {
                                        tLastObs = new AbsoluteDate(this.parseInt(line, 0, 6), this.parseInt(line, 6, 6), this.parseInt(line, 12, 6), this.parseInt(line, 18, 6), this.parseInt(line, 24, 6), this.parseDouble(line, 30, 13), timeScale);
                                        break;
                                    }
                                    case "LEAP SECONDS": {
                                        leapSeconds = this.parseInt(line, 0, 6);
                                        leapSecondsFuture = this.parseInt(line, 6, 6);
                                        leapSecondsWeekNum = this.parseInt(line, 12, 6);
                                        leapSecondsDayNum = this.parseInt(line, 18, 6);
                                        break;
                                    }
                                    case "PRN / # OF OBS": {
                                        break;
                                    }
                                    case "SYS / # / OBS TYPES": {
                                        obsTypesSystem = null;
                                        typeObs.clear();
                                        obsTypesSystem = SatelliteSystem.parseSatelliteSystem(this.parseString(line, 0, 1));
                                        nbTypes = this.parseInt(line, 3, 3);
                                        int nbLinesTypesObs = (nbTypes + 13 - 1) / 13;
                                        for (int j2 = 0; j2 < nbLinesTypesObs; ++j2) {
                                            if (j2 > 0) {
                                                line = reader.readLine();
                                                ++lineNumber;
                                            }
                                            int iMax = FastMath.min(13, nbTypes - typeObs.size());
                                            for (int i = 0; i < iMax; ++i) {
                                                try {
                                                    typeObs.add(ObservationType.valueOf(this.parseString(line, 7 + 4 * i, 3)));
                                                    continue;
                                                }
                                                catch (IllegalArgumentException iae) {
                                                    throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_RINEX_FREQUENCY, this.parseString(line, 7 + 4 * i, 3), name, lineNumber);
                                                }
                                            }
                                        }
                                        listTypeObs.put(obsTypesSystem, new ArrayList(typeObs));
                                        inTypesObs = true;
                                        break;
                                    }
                                    case "SIGNAL STRENGTH UNIT": {
                                        sigStrengthUnit = this.parseString(line, 0, 20);
                                        break;
                                    }
                                    case "SYS / DCBS APPLIED": {
                                        listAppliedDCBs.add(new AppliedDCBS(SatelliteSystem.parseSatelliteSystem(this.parseString(line, 0, 1)), this.parseString(line, 2, 17), this.parseString(line, 20, 40)));
                                        break;
                                    }
                                    case "SYS / PCVS APPLIED": {
                                        listAppliedPCVS.add(new AppliedPCVS(SatelliteSystem.parseSatelliteSystem(this.parseString(line, 0, 1)), this.parseString(line, 2, 17), this.parseString(line, 20, 40)));
                                        break;
                                    }
                                    case "SYS / SCALE FACTOR": {
                                        int i;
                                        int iMax;
                                        satSystemScaleFactor = null;
                                        scaleFactor = 1;
                                        nbObsScaleFactor = 0;
                                        satSystemScaleFactor = SatelliteSystem.parseSatelliteSystem(this.parseString(line, 0, 1));
                                        scaleFactor = this.parseInt(line, 2, 4);
                                        nbObsScaleFactor = this.parseInt(line, 8, 2);
                                        ArrayList<ObservationType> typesObsScaleFactor = new ArrayList<ObservationType>(nbObsScaleFactor);
                                        if (nbObsScaleFactor == 0) {
                                            typesObsScaleFactor.addAll((Collection)listTypeObs.get((Object)satSystemScaleFactor));
                                        } else {
                                            int nbLinesTypesObsScaleFactor = (nbObsScaleFactor + 12 - 1) / 12;
                                            for (j = 0; j < nbLinesTypesObsScaleFactor; ++j) {
                                                if (j > 0) {
                                                    line = reader.readLine();
                                                    ++lineNumber;
                                                }
                                                iMax = FastMath.min(12, nbObsScaleFactor - typesObsScaleFactor.size());
                                                for (i = 0; i < iMax; ++i) {
                                                    typesObsScaleFactor.add(ObservationType.valueOf(this.parseString(line, 11 + 4 * i, 3)));
                                                }
                                            }
                                        }
                                        scaleFactorCorrections.add(new ScaleFactorCorrection(satSystemScaleFactor, scaleFactor, typesObsScaleFactor));
                                        break;
                                    }
                                    case "SYS / PHASE SHIFT": {
                                        int i;
                                        int iMax;
                                        nbSatPhaseShift = 0;
                                        satsPhaseShift = null;
                                        corrPhaseShift = 0.0;
                                        phaseShiftTypeObs = null;
                                        satSystemPhaseShift = null;
                                        satSystemPhaseShift = SatelliteSystem.parseSatelliteSystem(this.parseString(line, 0, 1));
                                        phaseShiftTypeObs = ObservationType.valueOf(this.parseString(line, 2, 3));
                                        nbSatPhaseShift = this.parseInt(line, 16, 2);
                                        corrPhaseShift = this.parseDouble(line, 6, 8);
                                        if (nbSatPhaseShift != 0) {
                                            satsPhaseShift = new String[nbSatPhaseShift];
                                            int nbLinesSatPhaseShift = (nbSatPhaseShift + 10 - 1) / 10;
                                            for (j = 0; j < nbLinesSatPhaseShift; ++j) {
                                                if (j > 0) {
                                                    line = reader.readLine();
                                                    ++lineNumber;
                                                }
                                                iMax = FastMath.min(10, nbSatPhaseShift - j * 10);
                                                for (i = 0; i < iMax; ++i) {
                                                    satsPhaseShift[i + 10 * j] = this.parseString(line, 19 + 4 * i, 3);
                                                }
                                            }
                                        }
                                        phaseShiftCorrections.add(new PhaseShiftCorrection(satSystemPhaseShift, phaseShiftTypeObs, corrPhaseShift, satsPhaseShift));
                                        inPhaseShift = true;
                                        break;
                                    }
                                    case "GLONASS SLOT / FRQ #": {
                                        inGlonassSlot = true;
                                        break;
                                    }
                                    case "GLONASS COD/PHS/BIS": {
                                        inGlonassCOD = true;
                                        break;
                                    }
                                    case "END OF HEADER": {
                                        if (!inRinexVersion || !inRunBy || !inMarkerName || !inMarkerType || !inObserver || !inRecType || !inAntType || !inAproxPos || !inAntDelta || !inTypesObs || !inFirstObs || formatVersion >= 3.01 && !inPhaseShift || formatVersion >= 3.03 && (!inGlonassSlot || !inGlonassCOD)) {
                                            throw new OrekitException((Localizable)OrekitMessages.INCOMPLETE_HEADER, name);
                                        }
                                        rinexHeader = new RinexHeader(formatVersion, satelliteSystem, markerName, markerNumber, markerType, observerName, agencyName, receiverNumber, receiverType, receiverVersion, antennaNumber, antennaType, approxPos, antHeight, eccentricities, antRefPoint, obsCode, antPhaseCenter, antBSight, antAzi, antZeroDir, centerMass, sigStrengthUnit, interval, tFirstObs, tLastObs, clkOffset, listAppliedDCBs, listAppliedPCVS, phaseShiftCorrections, leapSeconds, leapSecondsFuture, leapSecondsWeekNum, leapSecondsDayNum);
                                        break;
                                    }
                                    default: {
                                        if (rinexHeader == null) {
                                            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                                        } else {
                                            break;
                                        }
                                    }
                                }
                            } else {
                                rcvrClkOffset = 0.0;
                                eventFlag = -1;
                                nbSatObs = -1;
                                tObs = null;
                                if (this.parseString(line, 0, 1).equals(">")) {
                                    eventFlag = this.parseInt(line, 31, 1);
                                    if (eventFlag != 0) {
                                        int nbLinesSkip = this.parseInt(line, 32, 3);
                                        for (int i = 0; i < nbLinesSkip; ++i) {
                                            line = reader.readLine();
                                            ++lineNumber;
                                        }
                                    } else {
                                        tObs = new AbsoluteDate(this.parseInt(line, 2, 4), this.parseInt(line, 6, 3), this.parseInt(line, 9, 3), this.parseInt(line, 12, 3), this.parseInt(line, 15, 3), this.parseDouble(line, 18, 11), timeScale);
                                        nbSatObs = this.parseInt(line, 32, 3);
                                        if (nbSat != -1 && nbSatObs > nbSat) {
                                            throw new OrekitException((Localizable)OrekitMessages.INCONSISTENT_NUMBER_OF_SATS, lineNumber, name, nbSatObs, nbSat);
                                        }
                                        rcvrClkOffset = this.parseDouble(line, 41, 15);
                                        if (Double.isNaN(rcvrClkOffset)) {
                                            rcvrClkOffset = 0.0;
                                        }
                                        for (int i = 0; i < nbSatObs; ++i) {
                                            int prnNumber;
                                            line = reader.readLine();
                                            ++lineNumber;
                                            SatelliteSystem satelliteSystemSat = SatelliteSystem.parseSatelliteSystem(this.parseString(line, 0, 1));
                                            if (!satelliteSystem.equals((Object)SatelliteSystem.MIXED) && !satelliteSystemSat.equals((Object)satelliteSystem)) {
                                                throw new OrekitException((Localizable)OrekitMessages.INCONSISTENT_SATELLITE_SYSTEM, new Object[]{lineNumber, name, satelliteSystem, satelliteSystemSat});
                                            }
                                            int prn = this.parseInt(line, 1, 2);
                                            switch (satelliteSystemSat) {
                                                case GPS: 
                                                case GALILEO: 
                                                case GLONASS: 
                                                case BEIDOU: 
                                                case IRNSS: {
                                                    prnNumber = prn;
                                                    break;
                                                }
                                                case QZSS: {
                                                    prnNumber = prn + 192;
                                                    break;
                                                }
                                                case SBAS: {
                                                    prnNumber = prn + 100;
                                                    break;
                                                }
                                                default: {
                                                    throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                                                }
                                            }
                                            ArrayList<ObservationData> observationData = new ArrayList<ObservationData>(nbSatObs);
                                            for (j = 0; j < ((List)listTypeObs.get((Object)satelliteSystemSat)).size(); ++j) {
                                                ObservationType rf = (ObservationType)((Object)((List)listTypeObs.get((Object)satelliteSystemSat)).get(j));
                                                boolean scaleFactorFound = false;
                                                double value = this.parseDouble(line, 3 + j * 16, 14);
                                                for (int k = 0; k < scaleFactorCorrections.size() && !scaleFactorFound; ++k) {
                                                    if (!((ScaleFactorCorrection)scaleFactorCorrections.get(k)).getSatelliteSystem().equals((Object)satelliteSystemSat) || !((ScaleFactorCorrection)scaleFactorCorrections.get(k)).getTypesObsScaled().contains((Object)rf)) continue;
                                                    value /= ((ScaleFactorCorrection)scaleFactorCorrections.get(k)).getCorrection();
                                                    scaleFactorFound = true;
                                                }
                                                observationData.add(new ObservationData(rf, value, this.parseInt(line, 17 + j * 16, 1), this.parseInt(line, 18 + j * 16, 1)));
                                            }
                                            RinexLoader.this.observationDataSets.add(new ObservationDataSet(rinexHeader, satelliteSystemSat, prnNumber, tObs, rcvrClkOffset, observationData));
                                        }
                                    }
                                }
                            }
                            line = reader.readLine();
                        }
                        break;
                    }
                    default: {
                        throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_FILE_FORMAT, name);
                    }
                }
            }
        }

        private String parseString(String line, int start, int length) {
            if (line.length() > start) {
                return line.substring(start, FastMath.min(line.length(), start + length)).trim();
            }
            return null;
        }

        private int parseInt(String line, int start, int length) {
            if (line.length() > start && !this.parseString(line, start, length).isEmpty()) {
                return Integer.parseInt(this.parseString(line, start, length));
            }
            return 0;
        }

        private double parseDouble(String line, int start, int length) {
            if (line.length() > start && !this.parseString(line, start, length).isEmpty()) {
                return Double.parseDouble(this.parseString(line, start, length));
            }
            return Double.NaN;
        }

        public class AppliedPCVS {
            private final SatelliteSystem satelliteSystem;
            private final String progPCVS;
            private final String sourcePCVS;

            private AppliedPCVS(SatelliteSystem satelliteSystem, String progPCVS, String sourcePCVS) {
                this.satelliteSystem = satelliteSystem;
                this.progPCVS = progPCVS;
                this.sourcePCVS = sourcePCVS;
            }

            public SatelliteSystem getSatelliteSystem() {
                return this.satelliteSystem;
            }

            public String getProgPCVS() {
                return this.progPCVS;
            }

            public String getSourcePCVS() {
                return this.sourcePCVS;
            }
        }

        public class AppliedDCBS {
            private final SatelliteSystem satelliteSystem;
            private final String progDCBS;
            private final String sourceDCBS;

            private AppliedDCBS(SatelliteSystem satelliteSystem, String progDCBS, String sourceDCBS) {
                this.satelliteSystem = satelliteSystem;
                this.progDCBS = progDCBS;
                this.sourceDCBS = sourceDCBS;
            }

            public SatelliteSystem getSatelliteSystem() {
                return this.satelliteSystem;
            }

            public String getProgDCBS() {
                return this.progDCBS;
            }

            public String getSourceDCBS() {
                return this.sourceDCBS;
            }
        }

        public class ScaleFactorCorrection {
            private final SatelliteSystem satSystemScaleFactor;
            private final List<ObservationType> typesObsScaleFactor;
            private final double scaleFactor;

            private ScaleFactorCorrection(SatelliteSystem satSystemScaleFactor, double scaleFactor, List<ObservationType> typesObsScaleFactor) {
                this.satSystemScaleFactor = satSystemScaleFactor;
                this.scaleFactor = scaleFactor;
                this.typesObsScaleFactor = typesObsScaleFactor;
            }

            public SatelliteSystem getSatelliteSystem() {
                return this.satSystemScaleFactor;
            }

            public double getCorrection() {
                return this.scaleFactor;
            }

            public List<ObservationType> getTypesObsScaled() {
                return this.typesObsScaleFactor;
            }
        }

        public class PhaseShiftCorrection {
            private final SatelliteSystem satSystemPhaseShift;
            private final ObservationType typeObsPhaseShift;
            private final double phaseShiftCorrection;
            private final String[] satsPhaseShift;

            private PhaseShiftCorrection(SatelliteSystem satSystemPhaseShift, ObservationType typeObsPhaseShift, double phaseShiftCorrection, String[] satsPhaseShift) {
                this.satSystemPhaseShift = satSystemPhaseShift;
                this.typeObsPhaseShift = typeObsPhaseShift;
                this.phaseShiftCorrection = phaseShiftCorrection;
                this.satsPhaseShift = satsPhaseShift;
            }

            public SatelliteSystem getSatelliteSystem() {
                return this.satSystemPhaseShift;
            }

            public ObservationType getTypeObs() {
                return this.typeObsPhaseShift;
            }

            public double getCorrection() {
                return this.phaseShiftCorrection;
            }

            public String[] getSatsCorrected() {
                return this.satsPhaseShift == null ? null : (String[])this.satsPhaseShift.clone();
            }
        }
    }
}

