/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.attitude;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.RealFieldUnivariateFunction;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.solvers.AllowedSolution;
import org.hipparchus.analysis.solvers.BracketingNthOrderBrentSolver;
import org.hipparchus.analysis.solvers.FieldBracketingNthOrderBrentSolver;
import org.hipparchus.analysis.solvers.UnivariateSolverUtils;
import org.hipparchus.util.FastMath;
import org.orekit.frames.Frame;
import org.orekit.gnss.attitude.AbstractGNSSAttitudeProvider;
import org.orekit.gnss.attitude.GNSSAttitudeContext;
import org.orekit.gnss.attitude.GNSSFieldAttitudeContext;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;

public class Glonass
extends AbstractGNSSAttitudeProvider {
    public static final double DEFAULT_YAW_RATE = FastMath.toRadians(0.25);
    private static final double NIGHT_TURN_LIMIT = FastMath.toRadians(165.8);
    private static final double YAW_END_ZERO = FastMath.toRadians(75.0);
    private static final double END_MARGIN = 0.0;
    private final double yawRate;

    public Glonass(double yawRate, AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame) {
        super(validityStart, validityEnd, sun, inertialFrame);
        this.yawRate = yawRate;
    }

    @Override
    protected TimeStampedAngularCoordinates correctedYaw(GNSSAttitudeContext context) {
        double realBeta = context.beta(context.getDate());
        double muRate = context.getMuRate();
        double aNight = NIGHT_TURN_LIMIT;
        double aNoon = FastMath.atan(muRate / this.yawRate);
        if (FastMath.abs(realBeta) < aNoon) {
            UnivariateFunction f = yawEnd -> {
                double delta = muRate * yawEnd / this.yawRate;
                return yawEnd - 0.5 * FastMath.abs(context.computePhi(realBeta, delta) - context.computePhi(realBeta, -delta));
            };
            double[] bracket = UnivariateSolverUtils.bracket(f, YAW_END_ZERO, 0.0, Math.PI);
            double yawEnd2 = new BracketingNthOrderBrentSolver(1.0E-14, 1.0E-8, 1.0E-15, 5).solve(50, f, bracket[0], bracket[1], AllowedSolution.ANY_SIDE);
            aNoon = muRate * yawEnd2 / this.yawRate;
        }
        double cNoon = FastMath.cos(aNoon);
        double cNight = FastMath.cos(aNight);
        if (context.setUpTurnRegion(cNight, cNoon)) {
            context.setHalfSpan(context.inSunSide() ? aNoon : context.inOrbitPlaneAbsoluteAngle(aNight - Math.PI), 0.0);
            if (context.inTurnTimeRange()) {
                double linearPhi;
                double phiDot;
                double beta = context.getSecuredBeta();
                double phiStart = context.getYawStart(beta);
                double dtStart = context.timeSinceTurnStart();
                double phiEnd = context.getYawEnd(beta);
                if (context.inSunSide()) {
                    phiDot = -FastMath.copySign(this.yawRate, beta);
                    linearPhi = phiStart + phiDot * dtStart;
                } else {
                    phiDot = FastMath.copySign(this.yawRate, beta);
                    linearPhi = phiStart + phiDot * dtStart;
                    if (phiEnd / linearPhi < 0.0 || phiEnd / linearPhi > 1.0) {
                        return context.turnCorrectedAttitude(phiEnd, 0.0);
                    }
                }
                return context.turnCorrectedAttitude(linearPhi, phiDot);
            }
        }
        return context.nominalYaw(context.getDate());
    }

    @Override
    protected <T extends RealFieldElement<T>> TimeStampedFieldAngularCoordinates<T> correctedYaw(GNSSFieldAttitudeContext<T> context) {
        Field<T> field = context.getDate().getField();
        Object realBeta = context.beta(context.getDate());
        RealFieldElement muRate = context.getMuRate();
        RealFieldElement aNight = (RealFieldElement)((RealFieldElement)field.getZero()).add(NIGHT_TURN_LIMIT);
        RealFieldElement aNoon = FastMath.atan((RealFieldElement)muRate.divide(this.yawRate));
        if (FastMath.abs(realBeta).getReal() < aNoon.getReal()) {
            RealFieldUnivariateFunction<RealFieldElement> f = yawEnd -> {
                RealFieldElement delta = (RealFieldElement)muRate.multiply(yawEnd).divide(this.yawRate);
                return (RealFieldElement)yawEnd.subtract(FastMath.abs(context.computePhi((RealFieldElement)realBeta, delta).subtract(context.computePhi((RealFieldElement)realBeta, (RealFieldElement)delta.negate()))).multiply(0.5));
            };
            RealFieldElement[] bracket = UnivariateSolverUtils.bracket(f, (RealFieldElement)((RealFieldElement)((RealFieldElement)field.getZero()).add(YAW_END_ZERO)), (RealFieldElement)((RealFieldElement)field.getZero()), (RealFieldElement)((RealFieldElement)((RealFieldElement)field.getZero()).add(Math.PI)));
            RealFieldElement yawEnd2 = new FieldBracketingNthOrderBrentSolver<RealFieldElement>((RealFieldElement)((RealFieldElement)field.getZero()).add(1.0E-14), (RealFieldElement)((RealFieldElement)field.getZero()).add(1.0E-8), (RealFieldElement)((RealFieldElement)field.getZero()).add(1.0E-15), 5).solve(50, f, bracket[0], bracket[1], AllowedSolution.ANY_SIDE);
            aNoon = (RealFieldElement)muRate.multiply((RealFieldElement)yawEnd2).divide(this.yawRate);
        }
        double cNoon = FastMath.cos(aNoon.getReal());
        double cNight = FastMath.cos(aNight.getReal());
        if (context.setUpTurnRegion(cNight, cNoon)) {
            context.setHalfSpan(context.inSunSide() ? aNoon : context.inOrbitPlaneAbsoluteAngle((RealFieldElement)aNight.subtract(Math.PI)), 0.0);
            if (context.inTurnTimeRange()) {
                RealFieldElement linearPhi;
                RealFieldElement phiDot;
                T beta = context.getSecuredBeta();
                T phiStart = context.getYawStart((RealFieldElement)beta);
                T dtStart = context.timeSinceTurnStart();
                T phiEnd = context.getYawEnd((RealFieldElement)beta);
                if (context.inSunSide()) {
                    phiDot = (RealFieldElement)((RealFieldElement)field.getZero()).add(-FastMath.copySign(this.yawRate, beta.getReal()));
                    linearPhi = (RealFieldElement)phiStart.add(phiDot.multiply(dtStart));
                } else {
                    phiDot = (RealFieldElement)((RealFieldElement)field.getZero()).add(FastMath.copySign(this.yawRate, beta.getReal()));
                    linearPhi = (RealFieldElement)phiStart.add(phiDot.multiply(dtStart));
                    if (phiEnd.getReal() / linearPhi.getReal() < 0.0 || phiEnd.getReal() / linearPhi.getReal() > 1.0) {
                        return context.turnCorrectedAttitude((RealFieldElement)phiEnd, (RealFieldElement)field.getZero());
                    }
                }
                return context.turnCorrectedAttitude(linearPhi, phiDot);
            }
        }
        return context.nominalYaw(context.getDate());
    }
}

