/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth;

import java.io.Serializable;
import java.text.NumberFormat;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;

public class GeoMagneticElements
implements Serializable {
    private static final long serialVersionUID = 1881493738280586855L;
    private Vector3D b;
    private double inclination;
    private double declination;
    private double totalIntensity;
    private double horizontalIntensity;

    public GeoMagneticElements(Vector3D b) {
        this.b = b;
        this.horizontalIntensity = FastMath.hypot(b.getX(), b.getY());
        this.totalIntensity = b.getNorm();
        this.declination = FastMath.atan2(b.getY(), b.getX());
        this.inclination = FastMath.atan2(b.getZ(), this.horizontalIntensity);
    }

    public Vector3D getFieldVector() {
        return this.b;
    }

    public double getInclination() {
        return this.inclination;
    }

    public double getDeclination() {
        return this.declination;
    }

    public double getTotalIntensity() {
        return this.totalIntensity;
    }

    public double getHorizontalIntensity() {
        return this.horizontalIntensity;
    }

    public String toString() {
        NumberFormat f = NumberFormat.getInstance();
        StringBuilder sb = new StringBuilder();
        sb.append("MagneticField[");
        sb.append("B=");
        sb.append(this.b.toString(f));
        sb.append(",H=");
        sb.append(f.format(this.getHorizontalIntensity()));
        sb.append(",F=");
        sb.append(f.format(this.getTotalIntensity()));
        sb.append(",I=");
        sb.append(f.format(this.getInclination()));
        sb.append(",D=");
        sb.append(f.format(this.getDeclination()));
        sb.append("]");
        return sb.toString();
    }
}

