/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.atmosphere;

import java.io.Serializable;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;

public interface Atmosphere
extends Serializable {
    public Frame getFrame();

    public double getDensity(AbsoluteDate var1, Vector3D var2, Frame var3);

    public <T extends RealFieldElement<T>> T getDensity(FieldAbsoluteDate<T> var1, FieldVector3D<T> var2, Frame var3);

    default public Vector3D getVelocity(AbsoluteDate date, Vector3D position, Frame frame) {
        Transform bodyToFrame = this.getFrame().getTransformTo(frame, date);
        Vector3D posInBody = bodyToFrame.getInverse().transformPosition(position);
        PVCoordinates pvBody = new PVCoordinates(posInBody, Vector3D.ZERO);
        PVCoordinates pvFrame = bodyToFrame.transformPVCoordinates(pvBody);
        return pvFrame.getVelocity();
    }

    default public <T extends RealFieldElement<T>> FieldVector3D<T> getVelocity(FieldAbsoluteDate<T> date, FieldVector3D<T> position, Frame frame) {
        Transform bodyToFrame = this.getFrame().getTransformTo(frame, date.toAbsoluteDate());
        FieldVector3D<T> posInBody = bodyToFrame.getInverse().transformPosition(position);
        FieldPVCoordinates<T> pvBody = new FieldPVCoordinates<T>(posInBody, FieldVector3D.getZero(position.getX().getField()));
        FieldPVCoordinates<T> pvFrame = bodyToFrame.transformPVCoordinates(pvBody);
        return pvFrame.getVelocity();
    }
}

