/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.tessellation;

import java.util.Arrays;
import java.util.List;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.interpolation.HermiteInterpolator;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Pair;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.models.earth.tessellation.HalfTrackSampler;
import org.orekit.models.earth.tessellation.HalfTrackSpanHandler;
import org.orekit.models.earth.tessellation.TileAiming;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.analytical.KeplerianPropagator;
import org.orekit.propagation.events.LatitudeExtremumDetector;
import org.orekit.utils.TimeStampedPVCoordinates;

public class AlongTrackAiming
implements TileAiming {
    private static final int SAMPLING_STEPS = 1000;
    private final List<Pair<GeodeticPoint, TimeStampedPVCoordinates>> halfTrack;
    private final boolean retrogradeOrbit;
    private final DSFactory factory;

    public AlongTrackAiming(OneAxisEllipsoid ellipsoid, Orbit orbit, boolean isAscending) {
        this.halfTrack = AlongTrackAiming.findHalfTrack(orbit, ellipsoid, isAscending);
        this.retrogradeOrbit = orbit.getPVCoordinates().getMomentum().getZ() < 0.0;
        this.factory = new DSFactory(1, 1);
    }

    @Override
    public List<GeodeticPoint> getSingularPoints() {
        return Arrays.asList(GeodeticPoint.NORTH_POLE, GeodeticPoint.SOUTH_POLE);
    }

    @Override
    public Vector3D alongTileDirection(Vector3D point, GeodeticPoint gp) {
        Vector3D velocity;
        Vector3D position;
        double lStart = this.halfTrack.get(0).getFirst().getLatitude();
        double lEnd = this.halfTrack.get(this.halfTrack.size() - 1).getFirst().getLatitude();
        if (gp.getLatitude() < FastMath.min(lStart, lEnd) || gp.getLatitude() > FastMath.max(lStart, lEnd)) {
            return this.retrogradeOrbit ? gp.getWest() : gp.getEast();
        }
        int iInf = 0;
        int iSup = this.halfTrack.size() - 1;
        while (iSup - iInf > 1) {
            int iMiddle;
            if (lStart < lEnd ^ this.halfTrack.get(iMiddle = (iSup + iInf) / 2).getFirst().getLatitude() > gp.getLatitude()) {
                iInf = iMiddle;
                continue;
            }
            iSup = iMiddle;
        }
        int iStart = FastMath.max(0, FastMath.min(iInf - 1, this.halfTrack.size() - 4));
        HermiteInterpolator interpolator = new HermiteInterpolator();
        for (int i = iStart; i < iStart + 4; ++i) {
            position = this.halfTrack.get(i).getSecond().getPosition();
            velocity = this.halfTrack.get(i).getSecond().getVelocity();
            interpolator.addSamplePoint(this.halfTrack.get(i).getFirst().getLatitude(), new double[][]{{position.getX(), position.getY(), position.getZ(), velocity.getX(), velocity.getY(), velocity.getZ()}});
        }
        DerivativeStructure[] p = interpolator.value(this.factory.variable(0, gp.getLatitude()));
        position = new Vector3D(p[0].getValue(), p[1].getValue(), p[2].getValue());
        velocity = new Vector3D(p[3].getValue(), p[4].getValue(), p[5].getValue());
        Rotation rotation = new Rotation(Vector3D.PLUS_K, position, Vector3D.PLUS_K, point);
        Vector3D fixedVelocity = rotation.applyTo(velocity);
        return fixedVelocity.normalize();
    }

    private static List<Pair<GeodeticPoint, TimeStampedPVCoordinates>> findHalfTrack(Orbit orbit, OneAxisEllipsoid ellipsoid, boolean isAscending) {
        KeplerianPropagator propagator = new KeplerianPropagator(orbit);
        HalfTrackSpanHandler handler = new HalfTrackSpanHandler(isAscending);
        LatitudeExtremumDetector detector = (LatitudeExtremumDetector)new LatitudeExtremumDetector(0.25 * orbit.getKeplerianPeriod(), 0.001, ellipsoid).withHandler(handler).withMaxIter(100);
        propagator.addEventDetector(detector);
        propagator.propagate(orbit.getDate().shiftedBy(3.0 * orbit.getKeplerianPeriod()));
        propagator.clearEventsDetectors();
        HalfTrackSampler sampler = new HalfTrackSampler(ellipsoid);
        propagator.setMasterMode(handler.getEnd().durationFrom(handler.getStart()) / 1000.0, sampler);
        propagator.propagate(handler.getStart(), handler.getEnd());
        return sampler.getHalfTrack();
    }
}

