/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import java.util.Collections;
import java.util.List;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class MariniMurrayModel
implements DiscreteTroposphericModel {
    private double T0;
    private double P0;
    private double e0;
    private double latitude;
    private double lambda;

    public MariniMurrayModel(double t0, double p0, double rh, double latitude, double lambda) {
        this.T0 = t0;
        this.P0 = p0;
        this.e0 = this.getWaterVapor(rh);
        this.latitude = latitude;
        this.lambda = lambda * 0.001;
    }

    public static MariniMurrayModel getStandardModel(double latitude, double lambda) {
        return new MariniMurrayModel(293.15, 1013.25, 0.5, latitude, lambda);
    }

    @Override
    public double pathDelay(double elevation, double height, double[] parameters, AbsoluteDate date) {
        double A = 0.002357 * this.P0 + 1.41E-4 * this.e0;
        double K = 1.163 - 0.00968 * FastMath.cos(2.0 * this.latitude) - 0.00104 * this.T0 + 1.435E-5 * this.P0;
        double B = 1.0840000000000001E-8 * this.P0 * this.T0 * K + 4.734E-8 * this.P0 * (this.P0 / this.T0) * (2.0 * K) / (3.0 * K - 1.0);
        double flambda = this.getLaserFrequencyParameter();
        double fsite = this.getSiteFunctionValue(height / 1000.0);
        double sinE = FastMath.sin(elevation);
        double dR = flambda / fsite * (A + B) / (sinE + B / ((A + B) * (sinE + 0.01)));
        return dR;
    }

    @Override
    public <T extends RealFieldElement<T>> T pathDelay(T elevation, T height, T[] parameters, FieldAbsoluteDate<T> date) {
        double A = 0.002357 * this.P0 + 1.41E-4 * this.e0;
        double K = 1.163 - 0.00968 * FastMath.cos(2.0 * this.latitude) - 0.00104 * this.T0 + 1.435E-5 * this.P0;
        double B = 1.0840000000000001E-8 * this.P0 * this.T0 * K + 4.734E-8 * this.P0 * (this.P0 / this.T0) * (2.0 * K) / (3.0 * K - 1.0);
        double flambda = this.getLaserFrequencyParameter();
        RealFieldElement fsite = this.getSiteFunctionValue((RealFieldElement)height.divide(1000.0));
        Object sinE = FastMath.sin(elevation);
        RealFieldElement dR = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)fsite.divide(flambda)).reciprocal()).multiply(A + B)).divide(sinE.add(((RealFieldElement)((RealFieldElement)((RealFieldElement)sinE.add(0.01)).multiply(A + B)).divide(B)).reciprocal()));
        return (T)dR;
    }

    @Override
    public double[] computeZenithDelay(double height, double[] parameters, AbsoluteDate date) {
        return new double[]{this.pathDelay(1.5707963267948966, height, parameters, date), 0.0};
    }

    @Override
    public <T extends RealFieldElement<T>> T[] computeZenithDelay(T height, T[] parameters, FieldAbsoluteDate<T> date) {
        Field field = height.getField();
        RealFieldElement zero = (RealFieldElement)field.getZero();
        RealFieldElement[] delay = (RealFieldElement[])MathArrays.buildArray(field, 2);
        delay[0] = this.pathDelay((RealFieldElement)zero.add(1.5707963267948966), height, (RealFieldElement[])parameters, date);
        delay[1] = zero;
        return delay;
    }

    @Override
    public double[] mappingFactors(double elevation, double height, double[] parameters, AbsoluteDate date) {
        return new double[]{1.0, 1.0};
    }

    @Override
    public <T extends RealFieldElement<T>> T[] mappingFactors(T elevation, T height, T[] parameters, FieldAbsoluteDate<T> date) {
        Field<T> field = date.getField();
        RealFieldElement one = (RealFieldElement)field.getOne();
        RealFieldElement[] factors = (RealFieldElement[])MathArrays.buildArray(field, 2);
        factors[0] = one;
        factors[1] = one;
        return factors;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    private double getLaserFrequencyParameter() {
        return 0.965 + 0.0164 * FastMath.pow(this.lambda, -2) + 2.28E-4 * FastMath.pow(this.lambda, -4);
    }

    private double getSiteFunctionValue(double height) {
        return 1.0 - 0.0026 * FastMath.cos(2.0 * this.latitude) - 3.1E-4 * height;
    }

    private <T extends RealFieldElement<T>> T getSiteFunctionValue(T height) {
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)height.multiply(3.1E-4)).negate()).subtract(0.0026 * FastMath.cos(2.0 * this.latitude))).add(1.0));
    }

    private double getWaterVapor(double rh) {
        double es = 0.01 * FastMath.exp(1.2378847000000001E-5 * this.T0 * this.T0 - 0.019121316 * this.T0 + 33.93711047 - 6343.164500000001 / this.T0);
        double fw = 1.00062 + 3.14E-6 * this.P0 + 5.599999999999999E-7 * FastMath.pow(this.T0 - 273.15, 2);
        double e = rh * fw * es;
        return e;
    }
}

