/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import org.hipparchus.analysis.interpolation.BilinearInterpolatingFunction;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.models.earth.troposphere.ViennaModelType;
import org.orekit.time.DateTimeComponents;

public class ViennaModelCoefficientsLoader
implements DataLoader {
    public static final String DEFAULT_SUPPORTED_NAMES = "VMF*_\\\\*\\*\\.*H$";
    private String supportedNames;
    private double[] coefficientsA = null;
    private double[] zenithDelay = null;
    private double latitude;
    private double longitude;
    private ViennaModelType type;

    public ViennaModelCoefficientsLoader(String supportedNames, double latitude, double longitude, ViennaModelType type) {
        this.supportedNames = supportedNames;
        this.type = type;
        this.latitude = latitude;
        this.longitude = MathUtils.normalizeAngle(longitude, Math.PI);
    }

    public ViennaModelCoefficientsLoader(double latitude, double longitude, ViennaModelType type) {
        this(DEFAULT_SUPPORTED_NAMES, latitude, longitude, type);
    }

    public double[] getA() {
        return (double[])this.coefficientsA.clone();
    }

    public double[] getZenithDelay() {
        return (double[])this.zenithDelay.clone();
    }

    public String getSupportedNames() {
        return this.supportedNames;
    }

    public void loadViennaCoefficients() {
        DataProvidersManager.getInstance().feed(this.supportedNames, this);
        if (this.coefficientsA == null || this.zenithDelay == null) {
            throw new OrekitException((Localizable)OrekitMessages.VIENNA_ACOEF_OR_ZENITH_DELAY_NOT_LOADED, this.supportedNames);
        }
    }

    public void loadViennaCoefficients(DateTimeComponents dateTimeComponents) {
        int year = dateTimeComponents.getDate().getYear();
        int month = dateTimeComponents.getDate().getMonth();
        int day = dateTimeComponents.getDate().getDay();
        int hour = dateTimeComponents.getTime().getHour();
        String monthString = month < 10 ? "0" + String.valueOf(month) : String.valueOf(month);
        String dayString = day < 10 ? "0" + String.valueOf(day) : String.valueOf(day);
        String hourString = hour < 10 ? "0" + String.valueOf(hour) : String.valueOf(hour);
        switch (this.type) {
            case VIENNA_ONE: {
                this.supportedNames = String.format("VMFG_%04d%2s%2s.H%2s", year, monthString, dayString, hourString);
                break;
            }
            case VIENNA_THREE: {
                this.supportedNames = String.format("VMF3_%04d%2s%2s.H%2s", year, monthString, dayString, hourString);
                break;
            }
        }
        try {
            this.loadViennaCoefficients();
        }
        catch (OrekitException oe) {
            throw new OrekitException(oe, OrekitMessages.VIENNA_ACOEF_OR_ZENITH_DELAY_NOT_AVAILABLE_FOR_DATE, dateTimeComponents.toString());
        }
    }

    @Override
    public boolean stillAcceptsData() {
        return true;
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException, ParseException {
        BufferedReader br = new BufferedReader(new InputStreamReader(input, "UTF-8"));
        int lineNumber = 0;
        String splitter = "\\s+";
        ArrayList<Double> latitudes = new ArrayList<Double>();
        ArrayList<Double> longitudes = new ArrayList<Double>();
        ArrayList<Double> ah = new ArrayList<Double>();
        ArrayList<Double> aw = new ArrayList<Double>();
        ArrayList<Double> zhd = new ArrayList<Double>();
        ArrayList<Double> zwd = new ArrayList<Double>();
        String line = br.readLine();
        while (line != null) {
            ++lineNumber;
            line = line.trim();
            try {
                if (line.length() > 0 && line.startsWith("! Range/resolution:")) {
                    String[] range_line = line.split("\\s+");
                    for (double lat = Double.valueOf(range_line[2]).doubleValue(); lat <= Double.valueOf(range_line[3]); lat += Double.valueOf(range_line[6]).doubleValue()) {
                        latitudes.add(FastMath.toRadians(lat));
                    }
                    for (double lon = Double.valueOf(range_line[4]).doubleValue(); lon <= Double.valueOf(range_line[5]); lon += Double.valueOf(range_line[7]).doubleValue()) {
                        longitudes.add(FastMath.toRadians(lon));
                        if (this.type == ViennaModelType.VIENNA_ONE && lon >= 357.5) break;
                    }
                }
                if (line.length() > 0 && !line.startsWith("!")) {
                    String[] values_line = line.split("\\s+");
                    ah.add(Double.valueOf(values_line[2]));
                    aw.add(Double.valueOf(values_line[3]));
                    zhd.add(Double.valueOf(values_line[4]));
                    zwd.add(Double.valueOf(values_line[5]));
                }
            }
            catch (NumberFormatException nfe) {
                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
            }
            line = br.readLine();
        }
        input.close();
        int dimLat = latitudes.size();
        int dimLon = longitudes.size();
        double[] xVal = new double[dimLat];
        for (int i = 0; i < dimLat; ++i) {
            xVal[i] = (Double)latitudes.get(i);
        }
        double[] yVal = new double[dimLon];
        for (int j = 0; j < dimLon; ++j) {
            yVal[j] = (Double)longitudes.get(j);
        }
        double[][] fvalAH = new double[dimLat][dimLon];
        double[][] fvalAW = new double[dimLat][dimLon];
        double[][] fvalZH = new double[dimLat][dimLon];
        double[][] fvalZW = new double[dimLat][dimLon];
        int index = dimLon * dimLat;
        for (int x = 0; x < dimLat; ++x) {
            for (int y = dimLon - 1; y >= 0; --y) {
                fvalAH[x][y] = (Double)ah.get(--index);
                fvalAW[x][y] = (Double)aw.get(index);
                fvalZH[x][y] = (Double)zhd.get(index);
                fvalZW[x][y] = (Double)zwd.get(index);
            }
        }
        BilinearInterpolatingFunction functionAH = new BilinearInterpolatingFunction(xVal, yVal, fvalAH);
        BilinearInterpolatingFunction functionAW = new BilinearInterpolatingFunction(xVal, yVal, fvalAW);
        BilinearInterpolatingFunction functionZH = new BilinearInterpolatingFunction(xVal, yVal, fvalZH);
        BilinearInterpolatingFunction functionZW = new BilinearInterpolatingFunction(xVal, yVal, fvalZW);
        this.coefficientsA = new double[2];
        this.zenithDelay = new double[2];
        this.coefficientsA[0] = functionAH.value(this.latitude, this.longitude);
        this.coefficientsA[1] = functionAW.value(this.latitude, this.longitude);
        this.zenithDelay[0] = functionZH.value(this.latitude, this.longitude);
        this.zenithDelay[1] = functionZW.value(this.latitude, this.longitude);
        if (this.coefficientsA == null || this.zenithDelay == null) {
            throw new OrekitException((Localizable)OrekitMessages.NO_VIENNA_ACOEF_OR_ZENITH_DELAY_IN_FILE, name);
        }
    }
}

