/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import java.util.Collections;
import java.util.List;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.util.CombinatoricsUtils;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScalesFactory;
import org.orekit.utils.ParameterDriver;

public class ViennaThreeModel
implements DiscreteTroposphericModel {
    private final double[] coefficientsA;
    private final double[] zenithDelay;
    private final double latitude;
    private final double longitude;

    public ViennaThreeModel(double[] coefficientA, double[] zenithDelay, double latitude, double longitude) {
        this.coefficientsA = (double[])coefficientA.clone();
        this.zenithDelay = (double[])zenithDelay.clone();
        this.latitude = latitude;
        this.longitude = longitude;
    }

    @Override
    public double[] mappingFactors(double elevation, double height, double[] parameters, AbsoluteDate date) {
        DateTimeComponents dtc = date.getComponents(TimeScalesFactory.getUTC());
        int dofyear = dtc.getDate().getDayOfYear();
        int degree = 12;
        int order = 12;
        LegendrePolynomials p = new LegendrePolynomials(12, 12);
        double a0Bh = 0.0;
        double a0Bw = 0.0;
        double a0Ch = 0.0;
        double a0Cw = 0.0;
        double a1Bh = 0.0;
        double a1Bw = 0.0;
        double a1Ch = 0.0;
        double a1Cw = 0.0;
        double b1Bh = 0.0;
        double b1Bw = 0.0;
        double b1Ch = 0.0;
        double b1Cw = 0.0;
        double a2Bh = 0.0;
        double a2Bw = 0.0;
        double a2Ch = 0.0;
        double a2Cw = 0.0;
        double b2Bh = 0.0;
        double b2Bw = 0.0;
        double b2Ch = 0.0;
        double b2Cw = 0.0;
        LegendreFunctions AnmBnm = new LegendreFunctions();
        int j = 0;
        for (int n = 0; n <= 12; ++n) {
            for (int m = 0; m <= n; ++m) {
                double pCosmLambda = p.getPnm(n, m) * FastMath.cos((double)m * this.longitude);
                double pSinmLambda = p.getPnm(n, m) * FastMath.sin((double)m * this.longitude);
                a0Bh += AnmBnm.getAnmBh(j, 0) * pCosmLambda + AnmBnm.getBnmBh(j, 0) * pSinmLambda;
                a0Bw += AnmBnm.getAnmBw(j, 0) * pCosmLambda + AnmBnm.getBnmBw(j, 0) * pSinmLambda;
                a0Ch += AnmBnm.getAnmCh(j, 0) * pCosmLambda + AnmBnm.getBnmCh(j, 0) * pSinmLambda;
                a0Cw += AnmBnm.getAnmCw(j, 0) * pCosmLambda + AnmBnm.getBnmCw(j, 0) * pSinmLambda;
                a1Bh += AnmBnm.getAnmBh(j, 1) * pCosmLambda + AnmBnm.getBnmBh(j, 1) * pSinmLambda;
                a1Bw += AnmBnm.getAnmBw(j, 1) * pCosmLambda + AnmBnm.getBnmBw(j, 1) * pSinmLambda;
                a1Ch += AnmBnm.getAnmCh(j, 1) * pCosmLambda + AnmBnm.getBnmCh(j, 1) * pSinmLambda;
                a1Cw += AnmBnm.getAnmCw(j, 1) * pCosmLambda + AnmBnm.getBnmCw(j, 1) * pSinmLambda;
                b1Bh += AnmBnm.getAnmBh(j, 2) * pCosmLambda + AnmBnm.getBnmBh(j, 2) * pSinmLambda;
                b1Bw += AnmBnm.getAnmBw(j, 2) * pCosmLambda + AnmBnm.getBnmBw(j, 2) * pSinmLambda;
                b1Ch += AnmBnm.getAnmCh(j, 2) * pCosmLambda + AnmBnm.getBnmCh(j, 2) * pSinmLambda;
                b1Cw += AnmBnm.getAnmCw(j, 2) * pCosmLambda + AnmBnm.getBnmCw(j, 2) * pSinmLambda;
                a2Bh += AnmBnm.getAnmBh(j, 3) * pCosmLambda + AnmBnm.getBnmBh(j, 3) * pSinmLambda;
                a2Bw += AnmBnm.getAnmBw(j, 3) * pCosmLambda + AnmBnm.getBnmBw(j, 3) * pSinmLambda;
                a2Ch += AnmBnm.getAnmCh(j, 3) * pCosmLambda + AnmBnm.getBnmCh(j, 3) * pSinmLambda;
                a2Cw += AnmBnm.getAnmCw(j, 3) * pCosmLambda + AnmBnm.getBnmCw(j, 3) * pSinmLambda;
                b2Bh += AnmBnm.getAnmBh(j, 4) * pCosmLambda + AnmBnm.getBnmBh(j, 4) * pSinmLambda;
                b2Bw += AnmBnm.getAnmBw(j, 4) * pCosmLambda + AnmBnm.getBnmBw(j, 4) * pSinmLambda;
                b2Ch += AnmBnm.getAnmCh(j, 4) * pCosmLambda + AnmBnm.getBnmCh(j, 4) * pSinmLambda;
                b2Cw += AnmBnm.getAnmCw(j, 4) * pCosmLambda + AnmBnm.getBnmCw(j, 4) * pSinmLambda;
                ++j;
            }
        }
        double bh = this.computeSeasonalFit(dofyear, a0Bh, a1Bh, a2Bh, b1Bh, b2Bh);
        double bw = this.computeSeasonalFit(dofyear, a0Bw, a1Bw, a2Bw, b1Bw, b2Bw);
        double ch = this.computeSeasonalFit(dofyear, a0Ch, a1Ch, a2Ch, b1Ch, b2Ch);
        double cw = this.computeSeasonalFit(dofyear, a0Cw, a1Cw, a2Cw, b1Cw, b2Cw);
        double[] function = new double[]{this.computeFunction(this.coefficientsA[0], bh, ch, elevation), this.computeFunction(this.coefficientsA[1], bw, cw, elevation)};
        return function;
    }

    @Override
    public <T extends RealFieldElement<T>> T[] mappingFactors(T elevation, T height, T[] parameters, FieldAbsoluteDate<T> date) {
        Field field = height.getField();
        RealFieldElement zero = (RealFieldElement)field.getZero();
        DateTimeComponents dtc = date.getComponents(TimeScalesFactory.getUTC());
        int dofyear = dtc.getDate().getDayOfYear();
        int degree = 12;
        int order = 12;
        LegendrePolynomials p = new LegendrePolynomials(12, 12);
        RealFieldElement a0Bh = zero;
        RealFieldElement a0Bw = zero;
        RealFieldElement a0Ch = zero;
        RealFieldElement a0Cw = zero;
        RealFieldElement a1Bh = zero;
        RealFieldElement a1Bw = zero;
        RealFieldElement a1Ch = zero;
        RealFieldElement a1Cw = zero;
        RealFieldElement b1Bh = zero;
        RealFieldElement b1Bw = zero;
        RealFieldElement b1Ch = zero;
        RealFieldElement b1Cw = zero;
        RealFieldElement a2Bh = zero;
        RealFieldElement a2Bw = zero;
        RealFieldElement a2Ch = zero;
        RealFieldElement a2Cw = zero;
        RealFieldElement b2Bh = zero;
        RealFieldElement b2Bw = zero;
        RealFieldElement b2Ch = zero;
        RealFieldElement b2Cw = zero;
        LegendreFunctions AnmBnm = new LegendreFunctions();
        int j = 0;
        for (int n = 0; n <= 12; ++n) {
            for (int m = 0; m <= n; ++m) {
                RealFieldElement pCosmLambda = (RealFieldElement)zero.add(p.getPnm(n, m) * FastMath.cos((double)m * this.longitude));
                RealFieldElement pSinmLambda = (RealFieldElement)zero.add(p.getPnm(n, m) * FastMath.sin((double)m * this.longitude));
                a0Bh = (RealFieldElement)a0Bh.add(((RealFieldElement)pCosmLambda.multiply(AnmBnm.getAnmBh(j, 0))).add(pSinmLambda.multiply(AnmBnm.getBnmBh(j, 0))));
                a0Bw = (RealFieldElement)a0Bw.add(((RealFieldElement)pCosmLambda.multiply(AnmBnm.getAnmBw(j, 0))).add(pSinmLambda.multiply(AnmBnm.getBnmBw(j, 0))));
                a0Ch = (RealFieldElement)a0Ch.add(((RealFieldElement)pCosmLambda.multiply(AnmBnm.getAnmCh(j, 0))).add(pSinmLambda.multiply(AnmBnm.getBnmCh(j, 0))));
                a0Cw = (RealFieldElement)a0Cw.add(((RealFieldElement)pCosmLambda.multiply(AnmBnm.getAnmCw(j, 0))).add(pSinmLambda.multiply(AnmBnm.getBnmCw(j, 0))));
                a1Bh = (RealFieldElement)a1Bh.add(((RealFieldElement)pCosmLambda.multiply(AnmBnm.getAnmBh(j, 1))).add(pSinmLambda.multiply(AnmBnm.getBnmBh(j, 1))));
                a1Bw = (RealFieldElement)a1Bw.add(((RealFieldElement)pCosmLambda.multiply(AnmBnm.getAnmBw(j, 1))).add(pSinmLambda.multiply(AnmBnm.getBnmBw(j, 1))));
                a1Ch = (RealFieldElement)a1Ch.add(((RealFieldElement)pCosmLambda.multiply(AnmBnm.getAnmCh(j, 1))).add(pSinmLambda.multiply(AnmBnm.getBnmCh(j, 1))));
                a1Cw = (RealFieldElement)a1Cw.add(((RealFieldElement)pCosmLambda.multiply(AnmBnm.getAnmCw(j, 1))).add(pSinmLambda.multiply(AnmBnm.getBnmCw(j, 1))));
                b1Bh = (RealFieldElement)b1Bh.add(((RealFieldElement)pCosmLambda.multiply(AnmBnm.getAnmBh(j, 2))).add(pSinmLambda.multiply(AnmBnm.getBnmBh(j, 2))));
                b1Bw = (RealFieldElement)b1Bw.add(((RealFieldElement)pCosmLambda.multiply(AnmBnm.getAnmBw(j, 2))).add(pSinmLambda.multiply(AnmBnm.getBnmBw(j, 2))));
                b1Ch = (RealFieldElement)b1Ch.add(((RealFieldElement)pCosmLambda.multiply(AnmBnm.getAnmCh(j, 2))).add(pSinmLambda.multiply(AnmBnm.getBnmCh(j, 2))));
                b1Cw = (RealFieldElement)b1Cw.add(((RealFieldElement)pCosmLambda.multiply(AnmBnm.getAnmCw(j, 2))).add(pSinmLambda.multiply(AnmBnm.getBnmCw(j, 2))));
                a2Bh = (RealFieldElement)a2Bh.add(((RealFieldElement)pCosmLambda.multiply(AnmBnm.getAnmBh(j, 3))).add(pSinmLambda.multiply(AnmBnm.getBnmBh(j, 3))));
                a2Bw = (RealFieldElement)a2Bw.add(((RealFieldElement)pCosmLambda.multiply(AnmBnm.getAnmBw(j, 3))).add(pSinmLambda.multiply(AnmBnm.getBnmBw(j, 3))));
                a2Ch = (RealFieldElement)a2Ch.add(((RealFieldElement)pCosmLambda.multiply(AnmBnm.getAnmCh(j, 3))).add(pSinmLambda.multiply(AnmBnm.getBnmCh(j, 3))));
                a2Cw = (RealFieldElement)a2Cw.add(((RealFieldElement)pCosmLambda.multiply(AnmBnm.getAnmCw(j, 3))).add(pSinmLambda.multiply(AnmBnm.getBnmCw(j, 3))));
                b2Bh = (RealFieldElement)b2Bh.add(((RealFieldElement)pCosmLambda.multiply(AnmBnm.getAnmBh(j, 4))).add(pSinmLambda.multiply(AnmBnm.getBnmBh(j, 4))));
                b2Bw = (RealFieldElement)b2Bw.add(((RealFieldElement)pCosmLambda.multiply(AnmBnm.getAnmBw(j, 4))).add(pSinmLambda.multiply(AnmBnm.getBnmBw(j, 4))));
                b2Ch = (RealFieldElement)b2Ch.add(((RealFieldElement)pCosmLambda.multiply(AnmBnm.getAnmCh(j, 4))).add(pSinmLambda.multiply(AnmBnm.getBnmCh(j, 4))));
                b2Cw = (RealFieldElement)b2Cw.add(((RealFieldElement)pCosmLambda.multiply(AnmBnm.getAnmCw(j, 4))).add(pSinmLambda.multiply(AnmBnm.getBnmCw(j, 4))));
                ++j;
            }
        }
        RealFieldElement bh = this.computeSeasonalFit(dofyear, a0Bh, a1Bh, a2Bh, b1Bh, b2Bh);
        RealFieldElement bw = this.computeSeasonalFit(dofyear, a0Bw, a1Bw, a2Bw, b1Bw, b2Bw);
        RealFieldElement ch = this.computeSeasonalFit(dofyear, a0Ch, a1Ch, a2Ch, b1Ch, b2Ch);
        RealFieldElement cw = this.computeSeasonalFit(dofyear, a0Cw, a1Cw, a2Cw, b1Cw, b2Cw);
        RealFieldElement[] function = (RealFieldElement[])MathArrays.buildArray(field, 2);
        function[0] = this.computeFunction((RealFieldElement)zero.add(this.coefficientsA[0]), bh, ch, elevation);
        function[1] = this.computeFunction((RealFieldElement)zero.add(this.coefficientsA[1]), bw, cw, elevation);
        return function;
    }

    @Override
    public double pathDelay(double elevation, double height, double[] parameters, AbsoluteDate date) {
        double[] delays = this.computeZenithDelay(height, parameters, date);
        double[] mappingFunction = this.mappingFactors(elevation, height, parameters, date);
        return delays[0] * mappingFunction[0] + delays[1] * mappingFunction[1];
    }

    @Override
    public <T extends RealFieldElement<T>> T pathDelay(T elevation, T height, T[] parameters, FieldAbsoluteDate<T> date) {
        RealFieldElement[] delays = this.computeZenithDelay(height, (RealFieldElement[])parameters, date);
        RealFieldElement[] mappingFunction = this.mappingFactors(elevation, height, (RealFieldElement[])parameters, date);
        return (T)delays[0].multiply(mappingFunction[0]).add(delays[1].multiply(mappingFunction[1]));
    }

    @Override
    public double[] computeZenithDelay(double height, double[] parameters, AbsoluteDate date) {
        return (double[])this.zenithDelay.clone();
    }

    @Override
    public <T extends RealFieldElement<T>> T[] computeZenithDelay(T height, T[] parameters, FieldAbsoluteDate<T> date) {
        Field field = height.getField();
        RealFieldElement zero = (RealFieldElement)field.getZero();
        RealFieldElement[] delays = (RealFieldElement[])MathArrays.buildArray(field, 2);
        delays[0] = (RealFieldElement)zero.add(this.zenithDelay[0]);
        delays[1] = (RealFieldElement)zero.add(this.zenithDelay[1]);
        return delays;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    private double computeFunction(double a, double b, double c, double elevation) {
        double sinE = FastMath.sin(elevation);
        double numMP = 1.0 + a / (1.0 + b / (1.0 + c));
        double denMP = sinE + a / (sinE + b / (sinE + c));
        double felevation = numMP / denMP;
        return felevation;
    }

    private <T extends RealFieldElement<T>> T computeFunction(T a, T b, T c, T elevation) {
        T sinE = FastMath.sin(elevation);
        RealFieldElement numMP = (RealFieldElement)((RealFieldElement)a.divide(((RealFieldElement)b.divide(c.add(1.0))).add(1.0))).add(1.0);
        T denMP = a.divide(b.divide(c.add(sinE)).add(sinE)).add(sinE);
        T felevation = numMP.divide(denMP);
        return felevation;
    }

    private double computeSeasonalFit(int doy, double A0, double A1, double A2, double B1, double B2) {
        double coef = (double)doy / 365.25 * 2.0 * Math.PI;
        double cosCoef = FastMath.cos(coef);
        double sinCoef = FastMath.sin(coef);
        double cos2Coef = FastMath.cos(coef * 2.0);
        double sin2Coef = FastMath.sin(coef * 2.0);
        return A0 + A1 * cosCoef + B1 * sinCoef + A2 * cos2Coef + B2 * sin2Coef;
    }

    private <T extends RealFieldElement<T>> T computeSeasonalFit(int doy, T A0, T A1, T A2, T B1, T B2) {
        double coef = (double)doy / 365.25 * 2.0 * Math.PI;
        double cosCoef = FastMath.cos(coef);
        double sinCoef = FastMath.sin(coef);
        double cos2Coef = FastMath.cos(coef * 2.0);
        double sin2Coef = FastMath.sin(coef * 2.0);
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)A0.add(A1.multiply(cosCoef))).add(B1.multiply(sinCoef))).add(A2.multiply(cos2Coef))).add(B2.multiply(sin2Coef)));
    }

    private static class LegendreFunctions {
        private static final double[][] BH_A = new double[][]{{0.00271285863109945, -1.39197786008938E-6, 1.34955672002719E-6, 2.71686279717968E-7, 1.56659301773925E-6}, {9.80476624811974E-6, -5.83922611260673E-5, -2.07307023860417E-5, 1.14628726961148E-6, 4.93610283608719E-6}, {-1.03443106534268E-5, -2.05536138785961E-6, 2.09692641914244E-6, -1.55491034130965E-8, -1.89706404675801E-7}, {-3.00353961749658E-5, 2.37284447073503E-5, 2.02236885378918E-5, 1.69276006349609E-6, 8.72156681243892E-7}, {-7.99121077044035E-7, -5.39048313389504E-6, -4.21234502039861E-6, -2.70944149806894E-6, -6.80894455531746E-7}, {7.51439609883296E-7, 3.8550970886552E-7, 4.41508016098164E-8, -2.07507808307757E-8, 4.95354985050743E-8}, {2.21790962160087E-5, -5.56986238775212E-5, -1.81287885563308E-5, -4.41076013532589E-6, 4.93573223917278E-6}, {-4.47639989737328E-6, -2.6045289307212E-6, 2.56376320011189E-6, 4.41600992220479E-7, 2.93437730332869E-7}, {8.14992682244945E-7, 2.03945571424434E-7, 1.11832498659806E-8, 3.25756664234497E-8, 3.01029040414968E-8}, {-7.96927680907488E-8, -3.66953150925865E-8, -6.74742632186619E-9, -1.30315731273651E-8, -2.00748924306947E-9}, {-2.16138375166934E-5, 1.67350317962556E-5, 1.93768260076821E-5, 1.9959512016185E-6, -2.42463528222014E-6}, {5.34360283708044E-7, -3.641890220406E-6, -2.99935375194279E-6, -2.06880962903922E-6, -9.40815692626002E-7}, {6.80235884441822E-7, 1.33023436079845E-7, -1.80349593705226E-8, 2.51276252565192E-8, -1.43240592002794E-9}, {-7.13790897253802E-8, 7.81998506267559E-9, 1.13826909570178E-9, -5.89629600214654E-9, -4.20760865522804E-9}, {-5.80109372399116E-9, 1.13702284491976E-9, 7.29046067602764E-10, -9.10468988754012E-10, -2.58814364808642E-10}, {1.75558618192965E-5, -2.85579168876063E-5, -1.47442190284602E-5, -6.29300414335248E-6, -5.1220453891346E-7}, {-1.9078855829131E-6, -1.62144845155361E-6, 7.57239241641566E-7, 6.93365788711348E-7, 6.88855644570695E-7}, {2.27050351488552E-7, 1.0392579127766E-7, -3.31105076632079E-9, 2.88065761026675E-8, -8.00256848229136E-9}, {-2.77028851807614E-8, -5.9625113220693E-9, 2.95987495527251E-10, -5.87644249625625E-9, -3.28803981542337E-9}, {-1.89918479865558E-8, 3.54083436578857E-9, 8.10617835854935E-10, 4.99207055948336E-10, -1.52691648387663E-10}, {1.04022499586096E-9, -2.36437143845013E-10, -2.25110813484842E-10, -7.39850069252329E-11, 7.95929405440911E-11}, {-3.1157942126763E-5, -3.43576336877494E-6, 5.81663608263384E-6, 8.31534700351802E-7, 4.02619520312154E-6}, {6.00037066879001E-7, -1.12538760056168E-7, -3.8674533211559E-7, -3.88218746020826E-7, -6.83764967176388E-7}, {-9.79583981249316E-8, 9.14964449851003E-8, 4.77779838549237E-9, 2.44283811750703E-9, -6.26361079345158E-9}, {-2.37742207548109E-8, -5.53336301671633E-9, -3.73625445257115E-9, -1.92304189572886E-9, -7.18681390197449E-9}, {-6.58203463929583E-9, 9.28456148541896E-10, 2.47218904311077E-10, 1.10664919110218E-10, -4.20390976974043E-11}, {9.45857603373426E-10, -3.29683402990254E-11, -8.15440375865127E-11, -1.21615589356628E-12, -9.70713008848085E-12}, {1.61377382316176E-10, 6.84326027598147E-12, -4.66898885683671E-12, 2.31211355085535E-12, 2.39195112937346E-12}, {2.99634365075821E-7, 8.14391615472128E-6, 6.70458490942443E-6, -9.92542646762E-7, -3.0407806499275E-6}, {-6.52697933801393E-7, 2.87255329776428E-7, -1.78227609772085E-8, 2.65525429849935E-7, 8.60650570551813E-8}, {-1.6272716401171E-7, 1.09102479325892E-7, 4.97827431850001E-9, 7.86649963082937E-11, -6.67193813407656E-9}, {-2.9637000098776E-9, 1.20008401576557E-9, 1.75885448022883E-9, -1.74756709684384E-9, 3.21963061454248E-9}, {-9.9110169777856E-10, 7.54541713140752E-10, -2.95880967800875E-10, 1.81009160501278E-10, 8.31547411640954E-11}, {1.21268051949609E-10, -5.93572774509587E-11, -5.03295034994351E-11, 3.05383430975252E-11, 3.56280438509939E-11}, {6.92012970333794E-11, -9.02885345797597E-12, -3.4415183274488E-12, 2.03164894681921E-12, -5.44852265137606E-12}, {5.567312636728E-12, 3.57272150106101E-12, 2.25885622368678E-12, -2.44508240047675E-13, -6.83314378535235E-13}, {3.96883487797254E-6, -4.57100506169608E-6, -3.30208117813256E-6, 3.32599719134845E-6, 4.26539325549339E-6}, {1.10123151770973E-6, 4.58046760144882E-7, 1.86831972581926E-7, -1.60092770735081E-7, -5.58956114867062E-7}, {-3.40344900506653E-8, 2.87649741373047E-8, -1.83929753066251E-8, -9.74179203885847E-9, -2.42064137485043E-9}, {-6.49731596932566E-9, -3.07048108404447E-9, -2.84380614669848E-9, 1.55123146524283E-9, 4.53694984588346E-10}, {5.45175793803325E-10, -3.73287624700125E-10, -1.16293122618336E-10, 7.2584561860269E-11, -4.34112440021627E-11}, {1.89481447552805E-10, 3.67431482211078E-12, -1.72180065021194E-11, 1.47046319023226E-11, 1.31920481414062E-11}, {2.10125915737167E-12, -3.08420783495975E-12, -4.8774871236302E-12, 1.1636359990249E-14, 1.26698255558605E-13}, {-8.07894928696254E-12, 9.19344620512607E-13, 3.26929173307443E-13, 2.00438149416495E-13, -9.57035765212079E-15}, {1.38737151773284E-12, 1.0934017837142E-13, 5.15714202449053E-14, -5.92156438588931E-14, -3.29586752336143E-14}, {6.38137197198254E-6, 4.62426300749908E-6, 4.42334454191034E-6, 1.15374736092349E-6, -2.61859702227253E-6}, {-2.25320619636149E-7, 3.21907705479353E-7, -3.34834530764823E-7, -4.8213275360181E-7, -3.22410936343355E-7}, {3.48894515496995E-9, 3.49951261408458E-8, -6.01128959281142E-9, 4.78213900943443E-9, 1.46012816168576E-8}, {-9.66682871952083E-11, 3.75806627535317E-9, 2.38984004956705E-9, 2.07545049877203E-9, 1.58573595632766E-9}, {1.06834370693917E-9, -4.07975055112153E-10, -2.37598937943957E-10, 5.89327007480137E-11, 1.18891820437634E-10}, {5.22433722695807E-11, 6.02011995016293E-12, -7.80605402956048E-12, 1.50873145627341E-11, -1.40550093106311E-12}, {2.13396242187279E-13, -1.71939313965536E-12, -3.57625378660975E-14, -5.01675184988446E-14, -1.07805487368797E-12}, {-1.24352330043311E-12, 8.26105883301606E-13, 4.63606970128517E-13, 6.39517888984486E-14, -7.35135439920086E-14}, {-5.39023859065631E-13, 2.54188315588243E-14, 1.30933833278664E-14, 6.06153473304781E-15, -4.24722717533726E-14}, {3.12767756884813E-14, -2.29517847871632E-15, 2.53117304424948E-16, 7.07504914138118E-16, -1.20089065310688E-15}, {2.08311178819214E-6, -1.22179185044174E-6, -2.98842190131044E-6, 3.07310218974299E-6, 2.27100346036619E-6}, {-3.94601643855452E-7, -5.44014825116083E-7, -6.16955333162507E-8, -2.3195482158067E-7, 1.1401081300531E-7}, {6.11067575043044E-8, -3.93240193194272E-8, -1.62979132528933E-8, 1.01339204652581E-8, 1.97319601566071E-8}, {2.57770508710055E-9, 1.87799543582899E-9, 1.95407654714372E-9, 1.1527641928127E-9, 2.2539700540212E-9}, {7.16926338026236E-10, -3.65857693313858E-10, -1.54864067050915E-11, 6.50770211276549E-11, -7.85160007413546E-12}, {4.90007693914221E-12, 3.3164939653634E-12, 4.8166487116564E-13, 7.26080745617085E-12, 2.30960953372164E-12}, {9.75489202240545E-13, -1.68967954531421E-13, 7.3838339133411E-13, -3.58435515913239E-13, -3.0156471002745E-13}, {-3.79533601922805E-13, 2.76681830946617E-13, 1.21480375553803E-13, -1.5772907764485E-14, -8.876649778187E-14}, {-3.96462845480288E-14, 2.9415569093461E-14, 6.78413205760717E-15, -4.12135802787361E-15, -1.46373307795619E-14}, {-8.64941937408121E-15, -1.91822620970386E-15, -8.01725413560744E-16, 5.02941051180784E-16, -1.07572628474344E-15}, {-4.13816294742758E-15, -7.4360201978588E-17, -5.54248556346072E-17, -4.83999456005158E-17, -1.19622559730466E-16}, {-8.34852132750364E-7, -7.45794677612056E-6, -6.58132648865533E-6, -1.38608110346732E-6, 5.32326534882584E-7}, {-2.7551380241415E-7, 3.64713745106279E-8, -7.12385417940442E-8, -7.86206067228882E-8, 2.28048393207161E-8}, {-4.26696415431918E-8, -4.65599668635087E-9, 7.35037936327566E-9, 1.17098354115804E-8, 1.44594777658035E-8}, {1.12407689274199E-9, 7.62142529563709E-10, -6.72563708415472E-10, -1.18094592485992E-10, -1.17043815733292E-9}, {1.76612225246125E-10, -1.01188552503192E-10, 7.32546072616968E-11, 1.7954282180161E-11, -2.23264859965402E-11}, {-9.35960722512375E-12, 1.90894283812231E-12, -6.3479282452576E-13, 3.98597963877826E-12, -4.47591409078971E-12}, {-3.34623858556099E-12, 4.56384903915853E-14, 2.72561108521416E-13, -3.57942733300468E-15, 1.99794810657713E-13}, {-6.16775522568954E-14, 8.25316968328823E-14, 7.19845814260518E-14, -2.92415710855106E-14, -5.49570017444031E-15}, {-8.50728802453217E-15, 8.38161600916267E-15, 3.43651657459983E-15, -8.1942943411591E-16, -4.089057464611E-15}, {4.39042894275548E-15, -3.69440485320477E-16, 1.22249256876779E-16, -2.09359444520984E-16, -3.34211740264257E-16}, {-5.36054548134225E-16, 3.29794204041989E-17, 2.13564354374585E-17, -1.37838993720865E-18, -1.29188342867753E-17}, {-3.26421841529845E-17, 7.38235405234126E-18, 2.4929165967621E-18, 8.18252735459593E-19, 1.7382495227923E-20}, {4.67237509268208E-6, 1.93611283787239E-6, 9.39035455627622E-7, -5.84565118072823E-7, -1.76198705802101E-7}, {-3.33739157421993E-7, 4.12139555299163E-7, 1.58754695700856E-7, 1.37448753329669E-7, 1.04722936936873E-7}, {6.64200603076386E-9, 1.45412222625734E-8, 1.8249879611803E-8, 2.86633517581614E-9, 1.060669845481E-9}, {5.25549696746655E-9, -1.33677183394083E-9, 7.60804375937931E-11, -1.07918624219037E-10, 8.09178898247941E-10}, {1.89318454110039E-10, 9.23092164791765E-11, 5.5143457313118E-11, 3.8669639228924E-11, -1.15208165047149E-11}, {-1.02252706006226E-12, -7.25921015411136E-13, -1.9811012688762E-12, -2.18964868282672E-13, -7.18834476685625E-13}, {-2.69770025318548E-12, -2.17850340796321E-14, 4.73040820865871E-13, 1.57947421572149E-13, 1.86925164972766E-13}, {1.07831718354771E-13, 2.26681841611017E-14, 2.56046087047783E-14, -1.14995851659554E-14, -2.27056907624485E-14}, {6.29825154734712E-15, 8.04458225889001E-16, 9.53173540411138E-16, 1.16892301877735E-15, -1.04324684545047E-15}, {-5.57345639727027E-16, -2.93949227634932E-16, 7.47621406284534E-18, -5.36416885470756E-17, -2.87213280230513E-16}, {1.73219775047208E-16, 2.05017387523061E-17, 9.08873886345587E-18, -2.86881547225742E-18, -1.25303645304992E-17}, {-7.30829109684568E-18, 2.03711261415353E-18, 7.62162636124024E-19, -7.54847922012517E-19, -8.8510509819503E-19}, {5.62039968280587E-18, -1.38144206573507E-19, 1.68028711767211E-20, 1.81223858251981E-19, -8.50245194985878E-20}};
        private static final double[][] BW_A = new double[][]{{0.00136127467401223, -6.83476317823061E-7, -1.37211986707674E-6, 7.02561866200582E-7, -2.16342338010651E-7}, {-9.53197486400299E-6, 6.58703762338336E-6, 2.42000663952044E-6, -6.04283463108935E-7, 2.0214442467699E-7}, {-6.76728911259359E-6, 6.03830755085583E-7, -8.72568628835897E-8, 2.21750344140938E-6, 1.0514603293102E-6}, {-3.21102832397338E-5, -7.88685357568093E-6, -2.55495673641049E-6, -1.99601934456719E-6, -4.62005252198027E-7}, {-7.8463926352325E-7, 3.11624739733849E-6, 9.02170019697389E-7, 6.37066632506008E-7, -9.44485038780872E-9}, {2.19476873575507E-6, -2.20580510638233E-7, 6.94761415598378E-7, 4.80770865279717E-7, -1.34357837196401E-7}, {2.18469215148328E-5, -1.80674174262038E-6, -1.5275428560506E-6, -3.51212288219241E-7, 2.73741237656351E-6}, {2.85579058479116E-6, 1.57201369332361E-7, -2.80599072875081E-7, -4.91267304946072E-7, -2.11648188821805E-7}, {2.8172925559477E-6, 3.02487362536122E-7, -1.64836481475431E-7, -2.11607615408593E-7, -6.47817762225366E-8}, {1.31809947620223E-7, -1.58289524114549E-7, -7.05580919885505E-8, 5.56781440550867E-8, 1.23403290710365E-8}, {-1.29252282695869E-5, -1.0724707203759E-5, -3.31109519638196E-6, 2.13776673779736E-6, -1.49519398373391E-7}, {1.81685152305722E-6, -1.17362204417861E-6, -3.1920527713637E-8, 4.09166457255416E-7, 1.53286667406152E-7}, {1.63477723125362E-6, -2.68584775517243E-8, 4.94662064805191E-9, -7.09027987928288E-8, 4.44353430574937E-8}, {-2.13090618917978E-7, 4.05836983493219E-8, 2.94495876336549E-8, -1.75005469063176E-8, -3.03015988647002E-9}, {-2.16074435298006E-9, 9.37631708987675E-9, -2.05996036369828E-8, 6.97068002894092E-9, -8.90988987979604E-9}, {1.38047798906967E-5, 2.05528261553901E-5, 1.59072148872708E-5, 7.34088731264443E-7, 1.2822671038358E-6}, {7.08175753966264E-7, -9.27988276636505E-7, 1.60535820026081E-7, -3.27296675122065E-7, -2.20518321170684E-7}, {1.90932483086199E-7, -7.44215272759193E-8, 1.81330673333187E-8, 4.37149649043616E-8, 4.18884335594172E-8}, {-5.37009063880924E-8, 2.22870057779431E-8, 1.73740123037651E-8, -4.45137302235032E-9, 9.44721910524571E-9}, {-6.83406949047909E-8, -1.95046676795923E-10, 2.57535903049686E-9, 4.8264316408302E-9, 3.37657333705158E-9}, {3.96128688448981E-9, -6.63809403270686E-10, 2.44781464212534E-10, 5.92280853590699E-11, -4.78502591970721E-10}, {1.75859399041414E-5, -2.81238050668481E-6, -2.43670534594848E-6, 3.58244562699714E-6, -1.76547446732691E-6}, {-1.06451311473304E-7, 1.54336689617184E-6, -2.00690000442673E-7, 1.3879004791188E-9, -1.62490619890017E-7}, {-2.72757421686155E-7, 1.71139266205398E-7, -2.55080309401917E-8, -8.40793079489831E-9, -1.01129447760167E-8}, {2.92966025844079E-8, -2.07556718857313E-8, 5.45985315647905E-9, 8.7685769027415E-9, 1.06785510440474E-8}, {-1.22059608941331E-8, 6.52491630264276E-9, -1.79332492326928E-10, 3.75921793745396E-10, -7.06416506254786E-10}, {1.63224355776652E-9, 4.95586028736232E-10, -3.0787901175904E-10, -7.78354087544277E-11, 1.4395904706725E-10}, {3.86319414653663E-10, -2.06467134617933E-10, 4.37330971382694E-11, -5.00421056263711E-11, -9.40237773015723E-12}, {-1.23856142706451E-5, 7.61047394008415E-6, -1.99104114578138E-7, 6.86177748886858E-7, -1.09466747592827E-7}, {2.99866062403128E-7, 1.8752556139739E-7, 4.99374806994715E-8, 4.86229763781404E-7, 4.46570575517658E-7}, {-5.0574833236843E-7, 1.95523624722285E-8, -9.17535435911345E-8, -2.56671607433547E-8, -7.11896201616653E-8}, {-2.66062200406494E-8, -5.40470019739274E-9, -2.29718660244954E-9, -3.73328592264404E-9, 3.38748313712376E-9}, {5.30855327954894E-10, 5.28851845648032E-10, -2.22278913745418E-10, -5.52628653064771E-11, -9.24825145219684E-10}, {6.03737227573716E-10, -3.52190673510919E-12, -1.30371720641414E-10, -9.12787239944822E-12, 6.42187285537238E-12}, {1.78081862458539E-10, 2.93772078656037E-12, -1.04698379945322E-11, -2.82260024833024E-11, -5.61810459067525E-12}, {9.3500309229958E-12, -8.23133834521577E-13, 5.54878414224198E-13, -3.62943215777181E-13, 2.38858933771653E-12}, {-1.31216096107331E-5, -5.70451670731759E-6, -5.11598683573971E-6, -4.99990779887599E-6, 1.27389320221511E-7}, {-1.23108260369048E-6, 5.53093245213587E-7, 8.60093183929302E-7, 2.65569700925696E-7, 1.95485134805575E-7}, {-2.29647072638049E-7, -5.45266515081825E-8, 2.85298129762263E-8, 1.98167939680185E-8, 5.52227340898335E-9}, {-2.73844745019857E-8, -4.48345173291362E-10, -1.93967347049382E-9, -1.41508853776629E-9, -1.75456962391145E-9}, {-2.68863184376108E-11, -2.20546981683293E-9, 6.56116990576877E-10, 1.27129855674922E-10, -2.32334506413213E-10}, {1.98303136881156E-10, 6.04782006047075E-11, 2.9129111543157E-11, 6.18098615782757E-11, -3.82682292530379E-11}, {9.48294455071158E-12, -3.05873596453015E-13, 5.31539408055057E-13, -7.310164386656E-12, -1.19921002209198E-11}, {-2.25188050845725E-11, -3.91627574966393E-13, -6.80217235976769E-13, 5.91033607278405E-13, 5.02991534452191E-13}, {1.29532063896247E-12, 1.66337285851564E-13, 3.25543028344555E-13, 1.89143357962363E-13, 3.32288378169726E-13}, {-2.45864358781728E-6, 4.4946052489826E-6, 1.03890496648813E-6, -2.73783420376785E-6, 7.12695730642593E-7}, {-9.27805078535168E-7, -4.97733876686731E-7, 9.1868029890651E-8, -2.4720061742398E-7, 6.16163630140379E-8}, {-1.39623661883136E-8, -1.12580495666505E-7, 2.61821435950379E-8, -2.31875562002885E-8, 5.72679835033659E-8}, {-9.52538983318497E-9, -5.40909215302433E-9, 1.88698793952475E-9, -4.08127746406372E-9, 1.09534895853812E-10}, {3.79767457525741E-9, 1.11549801373366E-10, -6.45504957274111E-10, 3.05477141010356E-10, 1.26261210565856E-10}, {5.088135779453E-11, 1.43250547678637E-11, 8.81616572082448E-12, 2.58968878880804E-11, 3.83421818249954E-11}, {8.95094368142044E-12, -3.26220304555971E-12, -1.28047847191896E-12, 2.67562170258942E-12, 2.7219503157667E-12}, {-6.47181697409757E-12, 1.13776457455685E-12, 2.84856274334969E-13, -7.63667272085395E-14, -1.34451657758826E-13}, {-1.25291265888343E-12, 8.63500441050317E-14, -1.21307856635548E-13, 5.12570529540511E-14, 3.32389276976573E-14}, {3.73573418085813E-14, -5.37808783042784E-16, -4.2343040827085E-16, -4.75110565740493E-15, 6.02553212780166E-15}, {8.95483987262751E-6, -3.90778212666235E-6, -1.12115019808259E-6, 1.78678942093383E-6, 1.46806344157962E-6}, {-4.59185232678613E-7, 1.09497995905419E-7, 1.31663977640045E-7, 4.20525791073626E-8, -9.71470741607431E-8}, {1.63399802579572E-7, 1.50909360648645E-8, -1.11480472593347E-8, -1.84000857674573E-8, 7.82124614794256E-9}, {1.22887452385094E-8, -4.06647399822746E-10, -6.49120327585597E-10, 8.63651225791194E-10, -2.73440085913102E-9}, {2.51748630889583E-9, 4.79895880425564E-10, -2.44908073860844E-10, 2.56735882664876E-10, -1.64815306286912E-10}, {4.85671381736718E-11, -2.51742732115131E-11, -2.60819437993179E-11, 6.12728324086123E-12, 2.16833310896138E-11}, {4.11389702320298E-12, -8.09433180989935E-13, -1.19812498226024E-12, 1.4688573788852E-12, 3.15807685137836E-12}, {-1.47614580597013E-12, 4.6672641390932E-13, 1.72089709006255E-13, 1.13854935381418E-13, 2.77741161317003E-13}, {-1.02257724967727E-13, 1.10394382923502E-13, -3.14153505370805E-15, 2.41103099110106E-14, 2.13853053149771E-14}, {-3.19080885842786E-14, -9.53904307973447E-15, 2.74542788156379E-15, 2.33797859107844E-15, -2.53192474907304E-15}, {-5.87702222126367E-15, -1.80133850930249E-15, -3.09793125614454E-16, -1.04197538975295E-16, 3.72781664701327E-16}, {1.86187054729085E-6, 8.33098045333428E-6, 3.18277735484232E-6, -7.68273797022231E-7, -1.52337222261696E-6}, {-5.07076646593648E-7, -8.61959553442156E-7, -3.51690005432816E-7, -4.20797082902431E-7, -3.07652993252673E-7}, {-7.38992472164147E-8, -8.3947308308028E-8, -2.51587083298935E-8, 7.30691259725451E-9, -3.19457155958983E-8}, {-1.99777182012924E-9, -3.21265085916022E-9, -4.84477421865675E-10, -1.82924814205799E-9, -3.46664344655997E-10}, {-7.05788559634927E-11, 1.21840735569025E-10, 7.97347726425926E-11, 1.08275679614409E-10, -1.17891254809785E-10}, {1.10299718947774E-11, -3.22958261390263E-11, -1.43535798209229E-11, 6.87096504209595E-12, -6.64963212272352E-12}, {-6.47393639740084E-12, 1.0315697832512E-12, -9.20099775082358E-14, -2.40150316641949E-13, 1.14008812047857E-12}, {-1.2395784639725E-13, 2.85996703969692E-13, 1.91579874982553E-13, 5.20597174693064E-14, -4.0674143488337E-14}, {-2.35479068911236E-14, 1.97847338186993E-14, 1.58935977518516E-15, -2.32217195254742E-15, -8.48611789490575E-15}, {1.03992320391626E-14, 1.54017082092642E-15, 1.05950035082788E-16, -1.17870898461353E-15, -1.10937420707372E-15}, {-1.0901194837452E-15, -6.04168007633584E-16, -9.10901998157436E-17, 1.98379116989461E-16, -1.03715496658498E-16}, {-1.38171942108278E-16, -6.33037999097522E-17, -1.3877769501147E-17, 1.94191397045401E-17, 5.70055906754485E-18}, {1.92989406002085E-6, -3.82662130483128E-6, -4.60189561036048E-7, 2.24290587856309E-6, 1.4054437945155E-6}, {6.49033717633394E-8, 2.41396114435326E-7, 2.73948898223321E-7, 1.10633664439332E-7, -3.19555270171075E-8}, {-2.91988966963297E-8, -6.03828192816571E-9, 1.1846238644484E-8, 1.32095545004128E-8, -5.06572721528914E-9}, {7.31079058474148E-9, -8.42775299751834E-10, 1.10190810090667E-9, 1.96592273424306E-9, -2.13135932785688E-9}, {7.06656405314388E-11, 1.43441125783756E-10, 1.46962246686924E-10, 7.44592776425197E-11, -3.64331892799173E-11}, {-2.52393942119372E-11, 1.07520964869263E-11, 5.84669886072094E-12, 6.52029744217103E-12, 1.82947123132059E-12}, {-4.15669940115121E-12, -1.95963254053648E-13, 2.16977822834301E-13, -2.84701408462031E-13, 4.27194601040231E-13}, {3.07891105454129E-13, 1.91523190672955E-13, 1.05367297580989E-13, -5.28136363920236E-14, -3.53364110005917E-14}, {7.02156663274738E-15, 9.52230536780849E-15, -3.41019408682733E-15, -3.59825303352899E-15, -2.6257641163615E-15}, {-1.75110277413804E-15, 5.29265220719483E-16, 4.45015980897919E-16, -3.80179856341347E-16, -4.32917763829695E-16}, {1.16038609651443E-16, -6.69643574373352E-17, 2.65667154817303E-17, -9.76010333683956E-17, 4.07312981076655E-17}, {5.72659246346386E-18, 1.30357528108671E-18, 2.49193258417535E-18, 1.76247014075584E-18, 7.59614374197688E-19}, {1.03352170833303E-17, -2.30633516638829E-18, 2.84777940620193E-18, -7.72161347944693E-19, 6.0702803450638E-19}};
        private static final double[][] CH_A = new double[][]{{0.0571481238161787, 3.35402081801137E-5, 3.15988141788728E-5, -1.34477341887086E-5, -2.61831023577773E-7}, {5.77367395845715E-5, -6.69057185209558E-4, -6.51057691648904E-5, -1.61830149147091E-6, 8.96771209464758E-5}, {-8.50773002452907E-5, -4.87106614880272E-5, 4.03431160775277E-5, 2.54090162741464E-6, -5.59109319864264E-6}, {0.00150536423187709, 6.11682258892697E-4, 3.69730024614855E-4, -1.95658439780282E-5, -3.462467265537E-5}, {-2.32168718433966E-5, -1.27478686553809E-4, -9.00292451740728E-5, -6.0783431590183E-5, -1.04628419422714E-5}, {-1.38607250922551E-6, -3.97271603842309E-6, -8.16155320152118E-7, 5.73266706046665E-7, 2.00366060212696E-7}, {6.52491559188663E-5, -0.00112224323460183, -3.44967958304075E-4, -7.672826409473E-5, 1.07907110551939E-4}, {-1.38870461448036E-4, -7.29995695401936E-5, 5.35986591445824E-5, 9.0380486970389E-6, 8.61370129482732E-6}, {-9.98524443968768E-7, -6.84966792665998E-8, 1.47478021860771E-7, 1.94857794008064E-6, 7.1717685273291E-7}, {1.2706636791172E-6, 1.12113289164288E-6, 2.71525688515375E-7, -2.76125723009239E-7, -1.05429690305013E-7}, {-3.77264999981652E-4, 2.62691217024294E-4, 1.8363978583759E-4, 3.93177048515576E-6, -6.66187081899168E-6}, {-4.93720951871921E-5, -1.02820030405771E-4, -5.69904376301748E-5, -3.79603438055116E-5, -3.9672601783493E-6}, {-2.21881958961135E-6, -1.40207117987894E-6, 1.60956630798516E-7, 2.06121145135022E-6, 6.50944708093149E-7}, {2.21876332411271E-7, 1.92272880430386E-7, -6.44016558013941E-9, -1.4095492133241E-7, -4.26742169137667E-7}, {-3.51738525149881E-8, 2.89616194332516E-8, -3.40343352397886E-8, -2.89763392721812E-8, -6.40980581663785E-10}, {3.51240856823468E-5, -7.25895015345786E-4, -3.22514037108045E-4, -1.06143759981636E-4, 4.08153152459337E-5}, {-2.36269716929413E-5, -4.20691836557932E-5, 1.43926743222922E-5, 2.61811210631784E-5, 2.09610762194903E-5}, {-7.9176575667389E-7, 1.64556789159745E-6, -9.43930166276555E-7, 6.46641738736139E-7, -5.91509547299176E-7}, {3.92768838766879E-7, -1.9802773170369E-7, -5.41303590057253E-8, -4.21705797874207E-7, -6.06042329660681E-8}, {-1.56650141024305E-8, 7.61808165752027E-8, -1.81900460250934E-8, 1.30196216971675E-8, 1.08616031342379E-8}, {-2.80964779829242E-8, -7.25951488826103E-9, -2.59789823306225E-9, -2.79271942407154E-9, 4.10558774868586E-9}, {-6.38227857648286E-4, -1.54814045363391E-4, 7.78518327501759E-5, -2.95961469342381E-5, 1.15965225055757E-6}, {4.47833146915112E-6, 1.33712284237555E-5, 3.61048816552123E-6, -2.50717844073547E-6, -1.28100822021734E-5}, {-2.26958070007455E-6, 2.57779960912242E-6, 1.08395653197976E-6, 1.29403393862805E-7, -1.04854652812567E-6}, {-3.98954043463392E-7, -2.26931182815454E-7, -1.09169545045028E-7, -1.49509536031939E-7, -3.98376793949903E-7}, {2.3041891107111E-8, 1.23098508481555E-8, -1.71161401463708E-8, 2.35829696577657E-9, 1.3113616416204E-8}, {3.69423793101582E-9, 3.49231027561927E-10, -1.18581468768647E-9, 5.4318073582882E-10, 5.43192337651588E-10}, {-1.38608847117992E-9, -1.86719145546559E-10, -8.13477384765498E-10, 2.01919878240491E-10, 1.00067892622287E-10}, {-4.35499078415956E-5, 4.50727967957804E-4, 3.2897849426885E-4, -3.05249478582848E-5, -3.2191483454431E-5}, {1.24887940973241E-5, 1.34275239548403E-5, 1.11275518344713E-6, 7.46733554562851E-6, -2.12458664760353E-6}, {9.50250784948476E-7, 2.34367372695203E-6, -5.4309924479898E-7, -4.35196904508734E-7, -8.31852234345897E-7}, {5.91775478636535E-9, -1.48970922508592E-7, 2.9984006117384E-8, -1.30595933407792E-7, 1.27136765045597E-7}, {-1.78491083554475E-8, 1.76864919393085E-8, -1.96740493482011E-8, 1.21096708004261E-8, 2.95518703155064E-10}, {1.75053510088658E-9, -1.31414287871615E-9, -1.44689439791928E-9, 1.1468248366846E-9, 1.74488616540169E-9}, {1.08152964586251E-9, -3.85678162063266E-10, -2.77851016629979E-10, 3.8989057862559E-11, -2.54627365853495E-10}, {-1.88340955578221E-10, 5.19645384002867E-11, 2.14131326027631E-11, 1.24027770392728E-11, -9.42818962431967E-12}, {3.59777729843898E-4, -1.11692619996219E-4, -6.87103418744904E-5, 1.15128973879551E-4, 7.59796247722486E-5}, {5.23717968000879E-5, 1.32279078116467E-5, -5.72277317139479E-7, -7.56326558610214E-6, -1.95749622214651E-5}, {1.00109213210139E-6, -2.75515216592735E-7, -1.13393194050846E-6, -4.75049734870663E-7, -3.21499480530932E-7}, {-2.0701371659889E-7, -7.31392258077707E-8, -3.9644571408416E-8, 3.21390452929387E-8, -1.43738764991525E-8}, {2.03081434931767E-9, -1.35423687136122E-8, -4.47637454261816E-9, 2.18409121726643E-9, -3.74845286805217E-9}, {3.17469255318367E-9, 2.44221027314129E-10, -2.46820614760019E-10, 7.55851003884434E-10, 6.98980592550891E-10}, {9.89541493531067E-11, -2.78762878057315E-11, -2.10947962916771E-10, 3.77882267360636E-11, -1.20009542671532E-12}, {5.0172057573094E-11, 1.66470417102135E-11, -7.50624817938091E-12, 9.97880221482238E-12, 4.87141864438892E-12}, {2.53137945301589E-11, 1.93030083090772E-12, -1.4470880423129E-12, -1.77837100743423E-12, -8.10068935490951E-13}, {1.15735341520738E-4, 1.1691059104835E-4, 8.36315620479475E-5, 1.61095702669207E-5, -7.53084853489862E-5}, {-9.76879433427199E-6, 9.16968438003335E-6, -8.7275512728883E-6, -1.30077933880053E-5, -9.7884193799332E-6}, {1.04902782517565E-7, 2.14036988364936E-7, -7.19358686652888E-7, 1.12529592946332E-7, 7.07316352860448E-7}, {7.6317726528508E-8, 1.2278197443429E-7, 8.99971272969286E-8, 5.6348223935299E-8, 4.31054352285547E-8}, {3.29855763107355E-9, -6.95004336734441E-9, -6.52491370576354E-9, 1.97749180391742E-9, 3.51941791940498E-9}, {3.85373745846559E-10, 1.65754130924183E-10, -3.31326088103057E-10, 5.93256024580436E-10, 1.27725220636915E-10}, {-1.08840956376565E-10, -4.56042860268189E-11, -4.77254322645633E-12, -2.94405398621875E-12, -3.07199979999475E-11}, {2.0738987909501E-11, 1.51186798732451E-11, 9.28139802941848E-12, 5.92738269687687E-12, 9.70337402306505E-13}, {-2.85879708060306E-12, 1.92164314717053E-13, 4.0266467896789E-14, 5.18246319204277E-13, -7.91438726419423E-13}, {6.91890667590734E-13, -8.49442290988352E-14, -5.54404947212402E-15, 9.7109337753879E-15, -5.33714333415971E-14}, {-5.06132972789792E-5, -4.28348772058883E-5, -6.90746551020305E-5, 8.48380415176836E-5, 7.04135614675053E-5}, {-1.27945598849788E-5, -1.92362865537803E-5, -2.30971771867138E-6, -8.98515975724166E-6, 5.25675205004752E-6}, {-8.71907027470177E-7, -1.02091512861164E-6, -1.69548051683864E-7, 4.87239045855761E-7, 9.13163249899837E-7}, {-6.23651943425918E-8, 6.98993315829649E-8, 5.9159776673339E-8, 4.36227124230661E-8, 6.45321798431575E-8}, {-1.46315079552637E-10, -7.85142670184337E-9, 1.48788168857903E-9, 2.1687049991216E-9, -1.16723047065545E-9}, {3.31888494450352E-10, 1.90931898336457E-10, -3.13671901557599E-11, 2.60711798190524E-10, 8.45240112207997E-11}, {1.36645682588537E-11, -5.68830303783976E-12, 1.5751892384814E-11, -1.61935794656758E-11, -4.16568077748351E-12}, {9.44684950971905E-13, 7.30313977131995E-12, 3.14451447892684E-12, 6.49029875639842E-13, -9.66911019905919E-13}, {-8.13097374090024E-13, 5.23351897822186E-13, 8.94349188113951E-14, -1.3332775967327E-13, -4.04549450989029E-13}, {-3.76176467005839E-14, -6.19953702289713E-14, -3.74537190139726E-14, 1.71275486301958E-14, -3.81946773167132E-14}, {-4.8139338554416E-14, 3.66084990006325E-15, 3.10432030972253E-15, -4.10964475657416E-15, -6.586442442429E-15}, {-7.81077363746945E-5, -2.54773632197303E-4, -2.14538508009518E-4, -3.80780934346726E-5, 1.8349535919399E-5}, {5.89140224113144E-6, -3.17312632433258E-6, -3.81872516710791E-6, -2.27592226861647E-6, 1.57044619888023E-6}, {-1.4427250508869E-6, -1.10236588903758E-7, 2.64336813084693E-7, 4.7607416333246E-7, 4.2862358769457E-7}, {3.98889120733904E-8, -1.29638005554027E-8, -4.13668481273828E-8, 1.27686793719542E-9, -3.54202962042383E-8}, {1.6072683755175E-9, -2.70750776726156E-9, 2.7938709268107E-9, -3.01419734793998E-10, -1.29101669438296E-10}, {-2.55708290234943E-10, 2.27878015173471E-11, -6.43063443462716E-12, 1.26531554846856E-10, -1.6582214743722E-10}, {-3.35886470557484E-11, -3.51895009091595E-12, 5.80698399963198E-12, -2.84881487149207E-12, 8.91708061745902E-12}, {-3.12788523950588E-12, 3.35366912964637E-12, 2.52236848033838E-12, -8.12801050709184E-13, -2.63510394773892E-13}, {6.83791881183142E-14, 2.41583263270381E-13, 8.58807794189356E-14, -5.12528492761045E-14, -1.40961725631276E-13}, {-1.28585349115321E-14, -2.11049721804969E-14, 5.26409596614749E-15, -4.31736582588616E-15, -1.60991602619068E-14}, {-9.35623261461309E-15, -3.94384886372442E-16, 5.04633016896942E-16, -5.40268998456055E-16, -1.07857944298104E-15}, {8.79756791888023E-16, 4.5252993567533E-16, 1.36886341163227E-16, -1.12984402980452E-16, 6.30354561057224E-18}, {1.17829256884757E-4, 2.67013591698442E-5, 2.5791344677525E-5, -4.40766244878807E-5, -1.60651761172523E-6}, {-1.87058092029105E-5, 1.34371169060024E-5, 5.59131416451555E-6, 4.50960364635647E-6, 2.87612873904633E-6}, {2.79835536517287E-7, 8.93092708148293E-7, 8.37294601021795E-7, -1.99029785860896E-8, -8.87240405168977E-8}, {4.95854313394905E-8, -1.44694570735912E-8, 2.51662229339375E-8, -3.87086600452258E-9, 2.2974191907127E-8}, {4.71497840986162E-9, 2.47509999454076E-9, 1.67323845102824E-9, 8.1419676828353E-10, -3.71467396944165E-10}, {-1.07340743907054E-10, -8.07691657949326E-11, -5.99381660248133E-11, 2.33173929639378E-12, -2.26994195544563E-11}, {-3.83130441984224E-11, -5.82499946138714E-12, 1.43286311435124E-11, 3.15150503353387E-12, 5.97891025146774E-12}, {-5.6438919107223E-13, 9.57258316335954E-13, 1.12055192185939E-12, -4.4241770677542E-13, -9.93190361616481E-13}, {1.78188860269677E-13, 7.8258202490495E-14, 5.18061650118009E-14, 2.13456507353387E-14, -5.2620211377951E-14}, {-8.18481324740893E-15, -3.71256746886786E-15, 4.23508855164371E-16, -2.91292502923102E-15, -1.1545420538935E-14}, {6.1657869169681E-15, 6.74087154080877E-16, 5.71628946437034E-16, -2.05251213979975E-16, -7.25999138903781E-16}, {9.35481959699383E-17, 6.23535830498083E-17, 3.1807672880206E-18, -2.92353209354587E-17, 7.65216088665263E-19}, {2.34173078531701E-17, -8.30342420281772E-18, -4.33602329912952E-18, 1.90226281379981E-18, -7.85507922718903E-19}};
        private static final double[][] CW_A = new double[][]{{0.0395329695826997, -1.31114380761895E-4, -1.16331009006233E-4, 6.23548420410646E-5, 5.72641113425116E-5}, {-4.4183764088065E-4, 7.01288648654908E-4, 3.3848980285827E-4, 3.76700309908602E-5, -8.70889013574699E-6}, {1.30418530496887E-5, -1.85046547597376E-4, 4.31032103066723E-5, 1.05583334124319E-4, 3.23045436993589E-5}, {3.68918433448519E-5, -2.19433014681503E-4, 3.46768613485E-6, -9.17185187163528E-5, -3.69243242456081E-5}, {-6.50227201116778E-6, 2.07614874282187E-5, -5.09131314798362E-5, -3.08053225174359E-5, -4.18483655873918E-5}, {2.67879176459056E-5, -6.89303730743691E-5, 2.11046783217168E-6, 1.93163912538178E-5, -1.97877143887704E-6}, {3.93937595007422E-4, -4.52948381236406E-4, -1.36517846073846E-4, 1.38239247989489E-4, 1.33175232977863E-4}, {5.00214539435002E-5, 3.57229726719727E-5, -9.38010547535432E-7, -3.52586798317563E-5, -7.01218677681254E-6}, {3.91965314099929E-5, 1.02236686806489E-5, -1.95710695226022E-5, -5.93904795230695E-6, 3.24339769876093E-6}, {6.68158778290653E-6, -8.10468752307024E-6, -9.91192994096109E-6, -1.89755520007723E-7, -3.26799467595579E-6}, {3.14196817753895E-4, -2.96548447162009E-4, -2.18410153263575E-4, -1.57318389871E-5, 4.69789570185785E-5}, {1.04597721123977E-4, -3.31000119089319E-5, 5.60326793626348E-5, 4.71895007710715E-5, 3.57432326236664E-5}, {8.95483021572039E-6, 1.44019305383365E-5, 4.87912790492931E-6, -3.45826387853503E-6, 3.23960320438157E-6}, {-1.3524965100993E-5, -2.49349762695977E-6, -2.51509483521132E-6, -9.14254874104858E-7, -8.5789740610089E-7}, {-1.68143325235195E-6, 1.72073417594235E-6, 1.38765993969565E-6, 4.0977098213753E-7, -6.60908742097123E-7}, {-6.39889366487161E-4, 0.00120194042474696, 7.53258598887703E-4, 3.87356377414663E-5, 1.31231811175345E-5}, {2.77062763606783E-5, -9.51425270178477E-6, -6.61068056107547E-6, -1.38713669012109E-5, 9.84662092961671E-6}, {-2.69398078539471E-6, 6.50860676783123E-6, 3.8085592698809E-6, -1.98076068364785E-6, 1.17187335666772E-6}, {-2.63719028151905E-6, 5.03149473656743E-7, 7.38964893399716E-7, -8.38892485369078E-7, 1.30943917775613E-6}, {-1.56634992245479E-6, -2.97026487417045E-8, 5.06602801102463E-8, -4.60436007958792E-8, -1.62536449440997E-7}, {-2.37493912770935E-7, 1.69781593069938E-8, 8.35178275224265E-8, -4.83564044549811E-8, -4.96448864199318E-8}, {0.00134012259587597, -2.50989369253194E-4, -2.97647945512547E-5, -6.47889968094926E-5, 8.41302130716859E-5}, {-1.13287184900929E-4, 4.78918993866293E-5, -3.14572113583139E-5, -2.10518256626847E-5, -2.03933633847417E-5}, {-4.97413321312139E-7, 3.72599822034753E-6, -3.53221588399266E-6, -1.05232048036416E-6, -2.74821498198519E-6}, {4.81988542428155E-6, 4.21400219782474E-7, 1.02814808667637E-6, 4.40299068486188E-9, 3.37103399036634E-9}, {1.10140301678818E-8, 1.90257670180182E-7, -1.00831353341885E-8, 1.44860642389714E-8, -5.29882089987747E-8}, {6.12420414245775E-8, -4.48953461152996E-9, -1.38837603709003E-8, -2.05533675904779E-8, 1.49517908802329E-9}, {9.17090243673643E-10, -9.24878857867367E-9, -2.30856560363943E-9, -4.36348789716735E-9, -4.45808881183025E-10}, {-4.24912699609112E-4, -1.14365438471564E-4, -4.03200981827193E-4, 4.19949560550194E-5, -3.02068483713739E-5}, {3.85435472851225E-5, -5.70726887668306E-5, 4.96313706308613E-7, 1.02395703617082E-5, 5.85550000567006E-6}, {-7.38204470183331E-6, -4.56638770109511E-6, -3.94007992121367E-6, -2.16666812189101E-6, -4.55694264113194E-6}, {5.89841165408527E-7, 1.40862905173449E-8, 1.08149086563211E-7, -2.18592601537944E-7, -3.78927431428119E-7}, {4.85164687450468E-8, 8.34273921293655E-8, 1.47489605513673E-8, 6.01494125001291E-8, 6.43812884159484E-9}, {1.13055580655363E-8, 3.50568765400469E-9, -5.0939616250175E-9, -1.83362063152411E-9, -4.11227251553035E-9}, {3.16454132867156E-9, -1.39634794131087E-9, -7.34085003895929E-10, -7.55541371271796E-10, -1.57568747643705E-10}, {1.27572900992112E-9, -3.51625955080441E-10, -4.84132020565098E-10, 1.52427274930711E-10, 1.27466120431317E-10}, {-4.81655666236529E-4, -2.45423313903835E-4, -2.39499902816719E-4, -1.57132947351028E-4, 5.54583099258017E-5}, {-1.52987254785589E-5, 2.78383892116245E-5, 4.3229912399186E-5, 1.70981319744327E-5, -1.35090841769225E-6}, {-8.65400907717798E-6, -6.51882656990376E-6, -2.43810171017369E-7, 8.54348785752623E-7, 2.98371863248143E-7}, {-1.68155571776752E-6, -3.53602587563318E-7, -1.00404435881759E-7, -2.14162249012859E-8, -2.42131535531526E-7}, {-1.08048603277187E-8, -9.7885078576303E-8, -2.32906554437417E-8, 2.22003630858805E-8, -2.27230368089683E-9}, {-5.98864391551041E-9, 7.38970926486848E-9, 3.61322835311957E-9, 3.70037329172919E-9, -3.41121137081362E-9}, {-7.33113754909726E-10, -9.0837424933522E-11, -1.78204392133739E-10, 8.28618491929026E-11, -1.32966817912373E-10}, {-5.23340481314676E-10, 1.36403528233346E-10, -7.04478837151279E-11, -6.83175201536443E-12, -2.86040864071134E-12}, {3.75347503578356E-11, -1.08518134138781E-11, -2.53583751744508E-12, 1.00168232812303E-11, 1.74929602713312E-11}, {-6.8680533637057E-4, 5.91849814585706E-4, 4.75117378328026E-4, -2.59339398048415E-5, 3.74825110514968E-5}, {3.35231363034093E-5, 2.38331521146909E-5, 7.43545963794093E-6, -3.41430817541849E-6, 7.20180957675353E-6}, {3.60564374432978E-7, -3.13300039589662E-6, -6.3897474610802E-7, -8.63985524672024E-7, 2.43367665208655E-6}, {-4.09605238516094E-7, -2.51158699554904E-7, -1.29359217235188E-7, -2.27744642483133E-7, 7.04065989970205E-8}, {6.74886341820129E-8, -1.02009407061935E-8, -3.30790296448812E-8, 1.64959795655031E-8, 1.40641779998855E-8}, {1.31706886235108E-9, -1.06243701278671E-9, -2.85573799673944E-9, 3.72566568681289E-9, 2.48402582003925E-9}, {-3.68427463251097E-11, -1.90028122983781E-10, -3.98586561768697E-11, 1.14458831693287E-11, -2.27722300377854E-12}, {-7.90029729611056E-11, 3.81213646526419E-11, 4.63303426711788E-11, 1.52294835905903E-11, -2.99094751490726E-12}, {-2.36146602045017E-11, 1.03852674709985E-11, -4.472421263071E-12, 5.30884113537806E-12, 1.68499023262969E-12}, {-3.30107358134527E-13, -4.73989085379655E-13, 5.17199549822684E-13, 2.34951744478255E-13, 2.05931351608192E-13}, {4.3021568751178E-4, -1.32831373000014E-4, -3.41830835017045E-5, 4.70312161436033E-6, -3.84807179340006E-5}, {1.66861163032403E-5, -8.1009290852355E-6, 8.20658107437905E-6, 6.12399025026683E-6, -1.85536495631911E-6}, {1.53552093641337E-6, 2.19486495660361E-6, -1.07253805120137E-6, -4.72141767909137E-7, 4.00744581573216E-7}, {2.56647305130757E-7, -8.07492046592274E-8, -2.05858469296168E-7, 1.09784168930599E-7, -7.76823030181225E-8}, {1.77744008115031E-8, 1.6413467781742E-8, 4.8616304487902E-9, 1.13334251800856E-8, -7.17260621115426E-9}, {1.61133063219326E-9, -1.85414677057024E-9, -2.13798537812651E-9, 1.15255123229679E-9, 2.24504700129464E-9}, {1.23344223096739E-10, -1.20385012169848E-10, -2.18038256346433E-12, 3.23033120628279E-11, 8.011795682134E-11}, {-6.55745274387847E-12, 1.22127104697198E-11, 5.83805016355883E-12, -8.31201582509817E-12, 1.90985373872656E-12}, {-2.89199983667265E-12, 5.05962500506667E-12, 1.28092925110279E-12, 5.60353813743813E-13, 1.7675373196877E-12}, {-1.61678729774956E-13, -3.92206170988615E-13, -9.04941327579237E-14, 1.89847694200763E-13, 4.10008676756463E-14}, {-1.16808369005656E-13, -9.9746459143051E-14, 7.46366550245722E-15, 2.53398578153179E-14, 1.06510689748906E-14}, {-1.1371692138479E-4, -1.31902722651488E-4, -1.62844886485788E-4, 7.90171538739454E-6, -1.78768066961413E-4}, {-2.131465353665E-6, -3.57818705543597E-5, -1.50825855069298E-5, -2.17909259570022E-5, -8.19332236308581E-6}, {-2.88001138617357E-6, -2.09957465440793E-6, 6.81466526687552E-8, 3.58308906974448E-7, -4.18502067223724E-7}, {-1.10761444317605E-7, 6.91773860777929E-8, 8.17125372450372E-8, -2.16476237959181E-8, 7.59221970502074E-8}, {-9.56994224818941E-9, 6.64104921728432E-9, 6.33077902928348E-9, 2.85721181743727E-9, -6.39666681678123E-9}, {4.62558627839842E-10, -1.69014863754621E-9, -2.80260429599733E-10, 4.27558937623863E-11, -1.66926133269027E-10}, {-7.23385132663753E-11, 5.5196119354528E-11, 3.04070791942335E-11, 3.23227055919062E-12, 8.47312431934829E-11}, {-1.61189613765486E-11, 1.66868155925172E-11, 1.05370341694715E-11, -4.41495859079592E-12, -2.2493905140175E-12}, {-8.72229568056267E-13, 1.88613726203286E-12, 1.2171113753439E-14, -1.13342372297867E-12, -6.87151975256052E-13}, {7.9931198854409E-15, 4.46150979586709E-14, 7.50406779454998E-14, -3.20385428942275E-14, -1.26543636054393E-14}, {4.80503817699514E-14, -3.35545623603729E-14, -1.18546423610485E-14, 4.1941920998598E-15, -1.7352561443688E-14}, {-1.20464898830163E-15, -8.80752065000456E-16, -1.22214298993313E-15, 1.69928513019657E-15, 1.93593051311405E-16}, {1.68528879784841E-5, 3.57144412031081E-5, -1.65999910125077E-5, 5.40370336805755E-5, 1.18138122851376E-4}, {-3.28151779115881E-5, 1.04231790790798E-5, -2.8076186289064E-6, 2.98996152515593E-6, -2.67641158709985E-6}, {-2.08664816151978E-6, -1.64463884697475E-6, 6.79099429284834E-8, 7.23955842946495E-7, -6.86378427465657E-7}, {-2.88205823027255E-9, 2.38319699493291E-9, 1.14169347509045E-7, 8.12981074994402E-8, -1.56957943666988E-7}, {-7.09711403570189E-9, 6.29470515502988E-9, 3.50833306577579E-9, 8.31289199649054E-9, -2.14221463168338E-9}, {-8.11910123910038E-10, 3.34047829618955E-10, 3.7061937744649E-10, 3.30426088213373E-10, 4.86297305597865E-11}, {1.98628160424161E-11, -4.98557831380098E-12, -5.90523187802174E-12, -1.27027116925122E-12, 1.49982368570355E-11}, {2.62289263262748E-12, 3.91242360693861E-12, 6.56035499387192E-12, -1.17412941089401E-12, -9.40878197853394E-13}, {-3.37805010124487E-13, 5.39454874299593E-13, -2.41569839991525E-13, -2.41572016820792E-13, -3.01983673057198E-13}, {-1.85034053857964E-13, 4.31132161871815E-14, 4.13497222026824E-15, -4.6007551459598E-14, -1.92454846400146E-14}, {2.96113888929854E-15, -1.11688534391626E-14, 3.76275373238932E-15, -3.72593295948136E-15, 1.98205490249604E-16}, {1.40074667864629E-15, -5.15564234798333E-16, 3.56287382196512E-16, 5.07242777691587E-16, -2.30405782826134E-17}, {2.96822530176851E-16, -4.77029898301223E-17, 1.12782285532775E-16, 1.58443229778573E-18, 8.22141904662969E-17}};
        private static final double[][] BH_B = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}, {-2.29210587053658E-6, -2.33805004374529E-6, -7.49312880102168E-7, -5.12022747852006E-7, 5.88926055066172E-7}, {0.0, 0.0, 0.0, 0.0, 0.0}, {-4.6338275484369E-6, -2.23853015662938E-6, 8.14830531656518E-7, 1.15453269407116E-6, -4.53555450927571E-7}, {-6.92432096320778E-7, -2.98734455136141E-7, 1.48085153955641E-8, 1.37881746148773E-7, -6.92492118460215E-9}, {0.0, 0.0, 0.0, 0.0, 0.0}, {-1.9150797985031E-6, -1.83614825459598E-6, -7.46807436870647E-7, -1.28329122348007E-6, 5.04937180063059E-7}, {-8.07527103916713E-7, 2.8399784057457E-8, -6.01890498063025E-8, -2.48339507554546E-8, 2.46284627824308E-8}, {-2.82995069303093E-7, 1.38818274596408E-9, 3.22731214161408E-9, 2.87731153972404E-10, 1.53895537278496E-8}, {0.0, 0.0, 0.0, 0.0, 0.0}, {-6.682102709568E-7, -2.19104833297845E-6, 1.30116691657253E-7, 4.7844573043345E-7, -4.40344300914051E-7}, {-2.36946755740436E-7, -1.32730991878204E-7, 1.8366959369386E-8, 7.90218931983569E-8, -4.70161979232584E-8}, {1.07746083292179E-7, -4.1708863776033E-9, -1.83296035841109E-9, -5.80243971371211E-9, -2.11682361167439E-9}, {-5.44712355496109E-8, 1.89717032256923E-9, 2.27327316287804E-10, 7.78400728280038E-10, 8.82380487618991E-12}, {0.0, 0.0, 0.0, 0.0, 0.0}, {-5.61707049615673E-8, -1.09066447089585E-6, -2.25742250174119E-7, -8.64367795924377E-7, 1.0641127524068E-8}, {2.41782935157918E-8, -3.65762298303819E-8, -6.93420659586875E-8, -3.97316214341991E-8, -2.0876781648639E-8}, {6.38293030383436E-8, 1.1137793633447E-8, 6.91424941454782E-9, 1.39887159955004E-9, 5.25428749022906E-9}, {1.09291268489958E-8, 1.23935926756516E-10, 3.92917259954515E-10, -1.79144682483562E-10, -9.11802874917597E-10}, {-4.40957607823325E-9, 1.45751390560667E-10, 1.24641258165301E-10, -6.45810339804674E-11, -8.92894658893326E-12}, {0.0, 0.0, 0.0, 0.0, 0.0}, {1.54754294162102E-8, -1.60154742388847E-6, -4.08425188394881E-7, 6.18170290113531E-9, -2.58919765162122E-7}, {1.37130642286873E-8, -6.67813955828458E-8, -7.01410996605609E-9, 3.82732572660461E-8, -2.73381870915135E-8}, {2.19113155379218E-8, 4.11027496396868E-9, 6.33816020485226E-9, -1.49242411327524E-9, -6.14224941851705E-10}, {6.26573021218961E-9, 5.17137416480052E-10, -3.49784328298676E-10, 1.13578756343208E-10, 2.80414613398411E-10}, {1.65048133258794E-11, 1.00047239417239E-10, 1.05124654878499E-10, -3.03826002621926E-11, 4.57155388334682E-11}, {6.20221691418381E-11, 9.75852610098156E-12, -5.46716005756984E-12, 1.31643349569537E-11, 3.6161877571547E-12}, {0.0, 0.0, 0.0, 0.0, 0.0}, {-1.03938913012708E-6, -1.78417431315664E-7, 2.86040141364439E-7, 1.83508599345952E-8, -1.34452220464346E-7}, {-4.36557481393662E-8, 7.49780206868834E-9, -8.62829428674082E-9, 5.50577793039009E-9, -9.46897502333254E-9}, {3.43193738406672E-10, 1.13545447306468E-8, 1.25242388852214E-9, 6.0322150195962E-10, 1.5717207036118E-9}, {-4.73307591021391E-10, 1.70855824051391E-10, -2.62470421477037E-11, 2.04525835988874E-10, -1.17859695928164E-10}, {-3.36185995299839E-10, 3.19243054562183E-11, 1.17589412418126E-10, -1.35478747434514E-12, 5.11192214558542E-11}, {3.19640547592136E-11, 2.94297823804643E-12, -1.0065152627699E-11, -1.67028733953153E-12, 3.03938833625503E-12}, {1.68928641118173E-11, -7.90032886682002E-13, -1.40899773539137E-12, 7.76937592393354E-13, 7.32539820298651E-13}, {0.0, 0.0, 0.0, 0.0, 0.0}, {2.32949756055277E-7, 1.46237594908093E-7, -1.07770884952484E-7, 1.26824870644476E-7, -2.36345735961108E-8}, {8.89572676497766E-8, 7.24810004121931E-8, 2.67583556180119E-8, 2.48434796111361E-8, -3.55004782858686E-9}, {-1.00823909773603E-8, 8.84433929029076E-10, -2.55502517594511E-10, -5.48034274059119E-10, -8.50241938494079E-10}, {1.13259819566467E-9, 5.55186945221216E-10, 7.63679807785295E-11, -1.70067998092043E-11, 1.57081965572493E-10}, {-2.37748192185353E-10, 2.45463764948E-11, 3.2320841480286E-11, -2.72624834520723E-12, 8.144491836665E-12}, {-1.54977633126025E-11, 4.58754903157884E-12, -1.25864665839074E-12, 2.44139868157872E-12, -1.82827441958193E-12}, {3.28285563794513E-12, -1.10072329225465E-12, -7.23470501810935E-13, 5.85309745620389E-13, 4.11317589687125E-13}, {4.5759697438417E-13, 9.84198128213558E-14, 3.3450381770283E-14, 7.08431086558307E-15, 2.79891177268807E-14}, {0.0, 0.0, 0.0, 0.0, 0.0}, {-3.6782071915558E-7, 6.98497901205902E-7, 1.833973887503E-7, 2.39730262495372E-7, -2.58441984368194E-7}, {5.17793954077994E-8, 5.54614175977835E-8, 1.75026214305232E-9, -2.55518450411346E-9, -6.12272723006537E-9}, {-7.94292648157198E-9, -1.01709107852895E-9, -1.4925124181231E-9, 9.32827213605682E-10, -8.24490722043118E-10}, {1.36410408475679E-11, 2.16390220454971E-10, 1.24934806872235E-10, -6.82507825145903E-11, -4.01575177719668E-11}, {-1.41619917600555E-11, -1.54733230409082E-11, 1.36792829351538E-11, 1.11157862104733E-12, 2.08548465892268E-11}, {-3.56521723755846E-12, 4.47877185884557E-12, -6.34096209274637E-16, -1.13010624512348E-12, -2.82018136861041E-13}, {2.22758955943441E-12, -4.6387646555938E-13, -5.80688019272507E-13, 2.45878690598655E-13, 1.49997666808106E-13}, {-6.26833903786958E-14, 2.73416335780807E-14, 1.91842340758425E-14, 1.6740506112901E-14, -2.45268543953704E-17}, {1.81972870222228E-14, 5.43036245069085E-15, 1.92476637107321E-15, 8.78498602508626E-17, -1.42581647227657E-15}, {0.0, 0.0, 0.0, 0.0, 0.0}, {9.74322164613392E-7, -5.23101820582724E-7, -2.81997898176227E-7, 4.54762451707384E-8, -3.34645078118827E-8}, {-6.75813194549663E-9, 3.49744702199583E-8, -5.09170419895883E-9, 5.24359476874755E-9, 4.96664262534662E-9}, {4.53858847892396E-10, -1.49347392165963E-9, -2.00939511362154E-9, 9.30987163387955E-10, 9.74450200826854E-11}, {-4.92900885858693E-10, 5.34223033225688E-12, 1.08501839729368E-10, -6.43526142089173E-11, -3.11063319142619E-11}, {1.3846924638669E-11, -7.91180584906922E-12, 2.26641656746936E-13, 4.55251515177956E-12, 6.05270575117769E-12}, {4.02247935664225E-12, 1.82776657951829E-12, -1.28348801405445E-13, -2.1625730130035E-13, -5.54363979435025E-14}, {4.15005914461687E-13, -2.00647573581168E-13, -1.67278251942946E-13, 1.30332398257985E-13, 1.52742363652434E-13}, {6.36376500056974E-14, 1.65794532815776E-14, -3.80832559052662E-15, -6.40262894005341E-16, 2.42577181848072E-15}, {-5.55273521249151E-15, 3.69725182221479E-15, 2.02114207545759E-15, -4.50870833392161E-16, 9.62950493696677E-17}, {1.00935904205024E-17, 6.54751873609395E-17, -1.09138810997186E-16, -8.62396750098759E-17, -3.82788257844306E-17}, {0.0, 0.0, 0.0, 0.0, 0.0}, {4.21958510903678E-7, -8.30678271007705E-8, -3.47006439555247E-7, -3.36442823712421E-8, 9.90739768222027E-8}, {2.64389033612742E-8, 2.65825090066479E-9, -1.28895513428522E-8, -7.07182694980098E-10, 7.1090716530118E-9}, {6.31203524153492E-9, -1.67038260990134E-9, 1.33104703539822E-9, 8.34376495185149E-10, -2.52478613522612E-10}, {1.18414896299279E-10, -2.57745052288455E-11, 2.88295935685818E-11, -3.27782977418354E-11, -1.05705000036156E-11}, {-4.20826459055091E-12, -6.97430607432268E-12, -3.90660545970607E-12, -3.90449239948755E-13, -4.60384797517466E-13}, {-9.476683565582E-13, 6.53305025354881E-13, 2.6324018543496E-13, 1.40129115015734E-13, 3.85788887132074E-14}, {2.23947810407291E-13, 7.35262771548253E-15, -3.83348211931292E-14, 4.20376514344176E-14, 4.26445836468461E-14}, {-3.88008154470596E-16, 2.2856142466775E-15, -8.73599966653373E-16, 2.14321147947665E-15, 6.3863182507192E-16}, {-8.62165565535721E-15, 1.7974291214981E-15, 1.01541125038661E-15, -7.91027655831866E-17, -4.0650513282523E-16}, {-2.35355054392189E-16, -6.13997759731013E-17, -2.73490528665965E-17, 2.63895177155121E-17, -4.47531057245187E-18}, {6.0190970682353E-17, 5.35520010856833E-18, -2.15530106132531E-18, -2.46778496746231E-18, -7.09947296442799E-19}, {0.0, 0.0, 0.0, 0.0, 0.0}, {-3.75005956318736E-7, -5.39872297906819E-7, -1.19929654883034E-7, 4.52771083775007E-8, 1.82790552943564E-7}, {7.82606642505646E-9, -1.68890832383153E-8, -8.45995188378997E-9, 1.42958730598502E-9, 3.21075754133531E-9}, {4.28818421913782E-9, -1.07501469928219E-9, 8.84086350297418E-10, 9.74171228764155E-10, 8.59877149602304E-12}, {1.28983712172521E-10, -6.96375160373676E-11, -2.13481436408896E-11, 1.33516375568179E-11, -1.65864626508258E-11}, {-4.48914384622368E-12, 9.68953616831263E-13, -1.61372463422897E-12, -2.09683563440448E-12, -1.90096826314068E-12}, {-1.12626619779175E-13, 3.34903159106509E-14, -1.21721528343657E-13, 7.46246339290354E-14, 3.68424909859186E-13}, {5.0829427436779E-14, 2.8303615997709E-14, 1.48074873486387E-14, -9.59633528834945E-15, -1.262310609511E-14}, {-4.01464098583541E-16, 1.97047929526674E-15, -5.29967950447497E-16, -3.59120406619931E-16, 1.69690933982683E-16}, {-1.73919209873841E-15, 7.52792462841274E-16, 3.65589287101147E-16, -7.79247612043812E-17, -8.24599670368999E-17}, {-4.61555616150128E-17, 4.94529746019753E-19, -1.0985815721227E-17, 3.95550811124928E-18, 3.239723998841E-18}, {-2.27040686655766E-17, -3.27855689001215E-18, -3.30649011116861E-19, 9.08748546536849E-19, 8.92197599890994E-19}, {5.67241944733762E-18, 3.84449400209976E-19, 1.77668058015537E-19, 2.00432838283455E-20, -2.00801461564767E-19}};
        private static final double[][] BW_B = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}, {-9.56715196386889E-6, -3.6804063302042E-8, 1.27846786489883E-7, 1.32525487755973E-6, 1.53075361125066E-6}, {0.0, 0.0, 0.0, 0.0, 0.0}, {-7.17682617983607E-6, 2.89994188119445E-6, -2.97763578173405E-7, 8.95742089134942E-7, 3.44416325304006E-7}, {-8.0266113228521E-7, 3.66738692077244E-7, -3.0288096572328E-7, 3.54144282036103E-7, -1.68873066391463E-7}, {0.0, 0.0, 0.0, 0.0, 0.0}, {-2.89640569283461E-6, -7.83566373343614E-7, -8.36667214682577E-7, -7.41891843549121E-7, -9.23922655636489E-8}, {-1.06144662284862E-6, 1.57709930505924E-7, 1.04203025714319E-7, 1.20783300488461E-7, -1.38726055821134E-7}, {-4.16549018672265E-7, -1.35220897698872E-7, -6.40269964829901E-8, 1.63258283210837E-8, -2.57958025095959E-8}, {0.0, 0.0, 0.0, 0.0, 0.0}, {3.52324885892419E-6, -2.26705543513814E-7, 1.53835589488292E-6, -3.75263061267433E-7, 3.69384057396017E-7}, {-2.06569149157664E-7, -9.36260183227175E-8, -3.55985284353048E-8, -9.13671163891094E-8, 6.931562565626E-9}, {1.32437594740782E-7, 4.44349887272663E-8, -3.38192451721674E-8, -3.97263855781102E-8, -1.930878229958E-9}, {-1.29595244818942E-7, -1.40852985547683E-8, 1.4258759293976E-9, 7.05779876554001E-9, -1.00996269264535E-8}, {0.0, 0.0, 0.0, 0.0, 0.0}, {4.06960756215938E-6, -1.97898540226986E-6, 7.21905857553588E-8, -1.19908881538755E-6, -5.67561861536903E-8}, {6.53369660286999E-8, -2.42818687866392E-7, -1.66203004559493E-8, -2.41512414151897E-8, 4.45426333411018E-8}, {1.44650670663281E-7, 8.50666367433859E-9, -4.61165612004307E-9, 4.88527987491045E-9, 1.06277326713172E-8}, {1.86770937103513E-8, -6.4419794028893E-10, -7.60456736846174E-9, -9.97186468682689E-10, 8.73229752697716E-10}, {-1.00206566229113E-8, 1.33934372663121E-9, 1.4169150343922E-9, 8.72352590578753E-10, -8.04561626629829E-10}, {0.0, 0.0, 0.0, 0.0, 0.0}, {3.07161843116618E-6, 1.8296208565647E-6, 1.87728623016069E-7, 7.10611617623261E-7, 2.26499092250481E-7}, {4.50766403064905E-8, -1.67752393078256E-7, 2.4784472363907E-8, -3.56484348424869E-9, -1.56634836636584E-8}, {3.7701165188109E-8, -7.23045828480496E-9, 5.22995988863761E-9, -1.03740320341306E-9, 4.57839777217789E-9}, {8.09495635883121E-9, -3.01977244420529E-10, -2.30104544933093E-9, 3.63658580939428E-10, 4.39320811714867E-10}, {9.37087629961269E-11, 1.00780920426635E-9, 1.2814053991335E-10, -6.65795285522138E-12, 4.71732796198631E-11}, {-8.88504487069155E-11, -1.63253810435461E-10, 7.22669710644299E-11, 5.64715132584527E-11, -1.08949308197617E-12}, {0.0, 0.0, 0.0, 0.0, 0.0}, {-2.64054293284174E-7, -2.37611606117256E-6, -1.83671059706264E-6, -3.12199354841993E-7, -1.05598289276114E-7}, {7.41706968747147E-8, -1.64359098062646E-8, -3.09750224040234E-8, -9.68640079410317E-9, -7.90399057863403E-8}, {-1.00254376564271E-8, 1.12528248631191E-8, -2.678415491741E-9, -2.69481819323647E-9, 1.56550607475331E-9}, {-2.18568129350729E-9, 6.2642205697745E-10, 1.95007291427316E-9, 3.14226463591125E-10, -3.62000388344482E-10}, {-9.30451291747549E-10, 5.62175549482704E-11, 1.01022849902012E-10, 5.18675856498499E-11, 5.37561696283235E-11}, {5.33151334468794E-11, 1.07571307336725E-10, -1.31714567944652E-11, -4.17524405900018E-11, -2.16737797893502E-12}, {4.69916869001309E-11, -4.34516364859583E-12, -6.61054225868897E-12, -5.75845818545368E-12, -2.32180293529175E-12}, {0.0, 0.0, 0.0, 0.0, 0.0}, {-3.50305843086926E-6, 1.76085131953403E-6, 8.16661224478572E-7, 4.09111042640801E-7, -9.85414469804995E-8}, {1.44670876127274E-7, -1.41331228923029E-8, -3.06530152369269E-8, -1.46732098927996E-8, -2.30660839364244E-8}, {-2.00043052422933E-8, 1.72145861031776E-9, 2.13714615094209E-9, 1.02982676689194E-9, -1.64945224692217E-10}, {1.23552540016991E-9, 1.42028470911613E-9, 8.79622616627508E-10, -7.44465600265154E-10, -7.17124672589442E-11}, {-6.67749524914644E-10, -5.7772287493405E-11, 3.40077806879472E-11, 4.2617607654184E-11, 8.23189659748212E-11}, {-4.62771648935992E-11, -7.24005305716782E-13, 1.18233730497485E-12, 5.18156973532267E-12, -1.53329687155297E-12}, {4.75581699468619E-12, -3.79782291469732E-12, 1.33077109836853E-12, -1.0242602010712E-12, 3.1038501924913E-13}, {1.66486090578792E-12, 1.08573672403649E-12, 1.26268044166279E-13, -1.23509297742757E-13, -1.81842007284038E-13}, {0.0, 0.0, 0.0, 0.0, 0.0}, {9.93870680202303E-8, -1.85264736035628E-6, -5.58942734710854E-7, -5.5418344831627E-7, -3.95581289689398E-8}, {7.88329069002365E-8, 2.04810091451078E-8, 3.74588851000076E-9, 3.42429296613803E-8, -2.00840228416712E-8}, {-5.93700447329696E-10, -6.57499436973459E-10, -6.90560448220751E-9, 3.56586371051089E-9, 7.33310245621566E-11}, {-6.38101662363634E-11, 4.23668020216529E-10, -2.43764895979202E-10, -9.31466610703172E-11, -3.17491457845975E-10}, {1.5094372538247E-11, -6.11641188685078E-11, -4.37018785685645E-11, -2.32871158949602E-11, 4.19757251950526E-11}, {-1.18165328825853E-11, -9.91299557532438E-13, 6.40908678055865E-14, 2.41049422936434E-12, -8.20746054454953E-14}, {6.01892101914838E-12, -8.7848712287345E-13, -1.58887481332294E-12, -3.13556902469604E-13, 5.14523727801645E-14}, {-1.50791729401891E-13, -1.45234807159695E-13, 1.65302377570887E-13, -5.77094211651483E-15, 9.22218953528393E-14}, {-1.85618902787381E-14, 5.64333811864051E-14, -9.9431137794557E-15, -2.40992156199999E-15, -2.19196760659665E-14}, {0.0, 0.0, 0.0, 0.0, 0.0}, {-8.16252352075899E-8, 1.61725487723444E-6, 9.55522506715921E-7, 4.02436267433511E-7, -2.80682052597712E-7}, {7.6868479032863E-9, -5.00940723761353E-9, -2.43640127974386E-8, -2.59119930503129E-8, 3.35015169182094E-8}, {7.97903115186673E-9, 3.73803883416618E-9, 3.27888334636662E-9, 1.37481300578804E-9, -1.10677168734482E-10}, {-1.67853012769912E-9, -1.61405252173139E-10, -1.98841576520056E-10, -1.46591506832192E-11, 9.3571048780466E-11}, {4.08807084343221E-11, -3.74514169689568E-11, -3.0363849332391E-11, -5.02332555734577E-12, -8.03417498408344E-12}, {6.48922619024579E-12, 1.96166891023817E-12, -1.96968755122868E-12, -5.20970156382361E-12, -1.62656885103402E-12}, {1.28603518902875E-12, -4.88146958435109E-13, -3.3703488699184E-13, 1.37393696103E-14, 4.41398325716943E-14}, {1.48670014793021E-13, 4.41636026364555E-14, 2.06210477976005E-14, -3.4371758358539E-14, -1.21693704024213E-14}, {-1.67624180330244E-14, 6.59317111144238E-15, 2.57238525440646E-15, -3.21568425020512E-17, 5.29659568026553E-15}, {7.85453466393227E-16, 6.91252183915939E-16, -1.20540764178454E-15, -3.85803892583301E-16, 3.46606994632006E-16}, {0.0, 0.0, 0.0, 0.0, 0.0}, {2.86710087625579E-6, -1.68179842305865E-6, -8.4830677201687E-7, -7.08798062479598E-7, -1.27469453733635E-7}, {2.11824305734993E-9, 2.02274279084379E-8, 1.61862253091554E-8, 3.25597167111807E-8, 3.40868964045822E-9}, {1.21757111431438E-8, 1.68405530472906E-9, 1.55379338018638E-9, -3.81467795805531E-10, 2.53316405545058E-9}, {-9.98413758659768E-11, 5.38382145421318E-10, 3.92629628330704E-10, -1.43067134097778E-10, 3.74959329667113E-12}, {-1.57270407028909E-11, -9.02797202317592E-12, 8.4599705988769E-12, 4.71474382524218E-12, 5.41880986596427E-12}, {-1.20658618702054E-12, 7.12940685593433E-13, 1.02148613026937E-12, 1.63063852348169E-13, 1.74048793197708E-13}, {3.80559390991789E-13, 1.19678271353485E-13, 9.72859455604188E-14, 5.42642400031729E-14, 8.18796710714586E-14}, {-4.69629218656902E-14, 5.59889038686206E-15, 2.05363292795059E-15, 5.38599403288686E-15, -2.68929559474202E-15}, {-1.88759348081742E-14, 5.20975954705924E-15, -4.43585653096395E-16, 5.57436617793556E-16, -3.95922805817677E-16}, {-9.80871456373282E-16, 2.50857658461759E-17, -1.24253000050963E-16, 6.00857065211394E-17, 3.537996353115E-18}, {2.49370713054872E-16, -1.49119714269816E-17, -3.12276052640583E-17, -2.42001662334001E-17, -1.69766504318143E-17}, {0.0, 0.0, 0.0, 0.0, 0.0}, {-1.69222102455713E-6, 1.64277906173064E-6, 5.28855114364096E-7, 4.2815985326865E-7, -1.57362445882665E-7}, {1.67656782413678E-8, -3.77746114074055E-8, -2.21564555842165E-8, -3.37071806992217E-8, 1.474540087398E-8}, {1.06080499491408E-8, 3.21990403709678E-9, 3.87301757435359E-9, 2.92241827834347E-10, -1.86619473655742E-11}, {1.62399669665839E-10, 3.51322865845172E-10, 2.67086377702958E-11, -1.31596563625491E-10, 3.14164569507034E-11}, {-2.02180016657259E-11, 2.03305178342732E-11, 6.34969032565839E-12, 5.99522296668787E-12, -4.46275273451008E-12}, {-9.88409290158885E-13, -1.47692750858224E-13, 3.1465555073053E-13, -2.41857189187879E-13, 4.47727504501486E-13}, {1.71430777754854E-13, 1.73950835042486E-13, 5.92323956541558E-14, 8.06625710171825E-15, 2.33252485755634E-14}, {-1.74184545690134E-15, -8.18003353124179E-16, -6.62369006497819E-16, 4.16303374396147E-15, 7.06513748014024E-15}, {-6.02936238677014E-15, 1.89241084885229E-15, 1.9909788194427E-17, -6.9997429069664E-16, -2.69504942597709E-17}, {-4.65632962602379E-16, 3.70281995445114E-18, -9.04232973763345E-17, 2.20847370761932E-17, 7.62909453726566E-17}, {-6.25921477907943E-17, -2.10532795609842E-17, -1.03808073867183E-17, 1.15091380049019E-18, 4.66794445408388E-19}, {9.39427013576903E-18, 9.17044662931859E-19, 2.04132745117549E-18, -1.72364063154625E-19, -1.18098896532163E-18}};
        private static final double[][] CH_B = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}, {3.44092035729033E-5, -1.21876825440561E-5, -1.87490665238967E-5, -2.60980336247863E-5, 4.31639313264615E-6}, {0.0, 0.0, 0.0, 0.0, 0.0}, {-2.60125613000133E-5, 1.70570295762269E-5, 3.08331896996832E-5, 1.66256596588688E-5, -1.07841055501996E-5}, {8.74011641844073E-6, -2.25874169896607E-6, 6.50985196673747E-7, 1.30424765493752E-6, -1.85081244549542E-7}, {0.0, 0.0, 0.0, 0.0, 0.0}, {3.77496505484964E-5, -1.08198973553337E-5, -1.67717574544937E-5, -3.22476096673598E-5, 1.12281888201134E-5}, {-7.68623378647958E-7, -4.01400837153063E-6, -2.16390246700835E-6, -1.76912959937924E-6, -1.12740084951955E-6}, {-2.37092815818895E-6, -9.52317223759653E-7, -2.22722065579131E-7, -6.2515761977253E-8, 1.86582003894639E-8}, {0.0, 0.0, 0.0, 0.0, 0.0}, {-6.10254317785872E-5, -2.51815503068494E-5, 2.01046207874667E-5, 7.21107723367308E-6, -1.30692058660457E-5}, {-9.60655417241537E-6, -7.31381721742373E-6, -2.52767927589636E-6, 9.09039973214621E-7, -6.76454911344246E-7}, {-2.25743206384908E-8, 2.33058746737575E-7, 2.24746779293445E-7, 6.78551351968876E-8, 1.25076011387284E-7}, {-2.25744112770133E-7, -1.44429560891636E-7, -2.96810417448652E-8, -5.93858519742856E-8, -2.4321022945542E-8}, {0.0, 0.0, 0.0, 0.0, 0.0}, {7.45721015256308E-6, -3.8139682167641E-5, -1.41086198468687E-5, -2.28514517574713E-5, 7.28638705683277E-6}, {-5.77517778169692E-6, -3.93061211403839E-6, -2.17369763310752E-6, -1.48060935583664E-7, -2.74200485662814E-7}, {4.52962035878238E-7, 9.80990375495214E-7, 4.67492045269286E-7, -8.31032252212116E-9, 1.6942602342774E-7}, {7.20536791795515E-10, 2.75612253452141E-9, 2.47772119382536E-9, 4.30621825021233E-9, -2.86498479499428E-8}, {-2.46253956492716E-8, -3.10300833499669E-9, 8.06559148724445E-9, 2.98197408430123E-10, 6.32503656532846E-9}, {0.0, 0.0, 0.0, 0.0, 0.0}, {-6.01147094179306E-5, -3.16631758509869E-5, 4.1003811510001E-6, 3.55215057231403E-7, -2.23606515237408E-6}, {-2.85937516921923E-6, -3.6777570661063E-6, -5.06445540401637E-7, 8.21776759711184E-7, -5.98690271725558E-7}, {7.77122595418965E-7, 3.60896376754085E-7, 3.88610487893381E-7, -4.39533892679537E-8, -6.26882227849174E-8}, {1.05759993661891E-7, 2.58009912408833E-8, -1.51356049060972E-8, -1.13335813107412E-9, 5.3747085785037E-10}, {7.99831506181984E-9, 1.67423735327465E-9, 2.94736760548677E-9, -1.56727133704788E-9, 8.46186800849124E-10}, {3.07727104043851E-9, 3.93584215798484E-10, 3.86721562770643E-11, 1.72181091277391E-10, -2.16915737920145E-10}, {0.0, 0.0, 0.0, 0.0, 0.0}, {-1.16335389078126E-5, -1.39864676661484E-5, 2.52546278407717E-6, -8.79152625440188E-6, -8.97665132187974E-6}, {-3.95874550504316E-6, -1.1797626252873E-7, 7.031899263693E-7, 3.38907065351535E-7, -3.67714052493558E-7}, {2.2908244937044E-7, 5.72961531093329E-7, 4.21969662578894E-8, 1.24112958141431E-8, 9.56404486571888E-8}, {1.44631865298671E-9, 6.19368473895584E-9, 1.67110424041236E-9, 2.57979463602951E-9, -6.90806907510366E-9}, {1.77235802019153E-9, -8.1438884622897E-10, 4.50421956523579E-9, 5.67452314909707E-10, 2.4761044367556E-9}, {4.85932343880617E-10, 2.24864117422804E-10, -2.22534534468511E-10, -7.96395824973477E-11, 3.12587399902493E-12}, {-3.20173937255409E-11, -1.29872402028088E-11, -4.24092901203818E-11, 2.66570185704416E-11, -5.25164954403909E-12}, {0.0, 0.0, 0.0, 0.0, 0.0}, {-1.36010179191872E-5, 1.77873053642413E-5, 4.80988546657119E-6, 3.46859608161212E-6, -1.73247520896541E-6}, {2.00020483116258E-6, 2.43393064079673E-6, 1.21478843695862E-6, 1.95582820041644E-7, -3.11847995109088E-7}, {-8.1328721897931E-9, 1.05206830238665E-8, 6.54040136224164E-9, -1.9640266057599E-8, -1.40379796070732E-8}, {4.0129102031074E-8, 2.92634301047947E-8, 6.04179709273169E-9, 8.61849065020545E-10, 5.98065429697245E-9}, {-1.06149335032911E-9, -4.39748495862323E-10, 8.83040310269353E-10, 3.49392227277679E-10, 8.57722299002622E-10}, {-1.2504988890939E-11, 2.05203288281631E-10, 1.37817670505319E-11, 6.82057794430145E-11, -9.41515631694254E-11}, {7.4719602264413E-12, -2.51369898528782E-11, -2.121966878092E-11, 1.55282119505201E-11, 9.99224438231805E-12}, {-7.90534019004874E-13, 3.55824506982589E-12, 8.00835777767281E-13, 8.73460019069655E-13, 1.34176126600106E-12}, {0.0, 0.0, 0.0, 0.0, 0.0}, {3.12855262465316E-5, 1.31629386003608E-5, 2.65598119437581E-6, 8.68923340949135E-6, -7.51164082949678E-6}, {1.56870792650533E-6, 1.8922730168537E-6, 4.15620385341985E-7, -2.74253787880603E-7, -4.288262101192E-7}, {-9.99176994565587E-8, -1.10785129426286E-7, -1.10318125091182E-7, 6.22726507350764E-9, -3.3921456638625E-8}, {1.24872975018433E-8, 1.10663206077249E-8, 5.40658975901469E-9, -2.79119137105115E-9, -2.47500096192502E-9}, {1.1151891715406E-10, -4.21965763244849E-10, 3.26786005211229E-10, 1.93488254914545E-10, 7.00774679999972E-10}, {1.50889220040757E-10, 1.03130002661366E-10, -3.09481760816903E-11, -4.47656630703759E-11, -7.362450218038E-12}, {-1.91144562110285E-12, -1.11355583995978E-11, -1.76207323352556E-11, 8.15289793192265E-12, 3.45078925412654E-12}, {-2.73248710476019E-12, -1.65089342283056E-13, -2.20125355220819E-13, 5.32589191504356E-13, 5.70008982140874E-13}, {8.06636928368811E-13, 1.30893069976672E-13, 9.72079137767479E-14, 3.87410156264322E-14, -5.56410013263563E-14}, {0.0, 0.0, 0.0, 0.0, 0.0}, {2.02454485403216E-5, -9.77720471118669E-6, -4.35467548126223E-6, 2.19599868869063E-6, -3.2667081904369E-6}, {-3.2183925631054E-8, 8.38760368015005E-7, -5.0805883572406E-7, 4.16177282491396E-8, 1.5384259276212E-7}, {-1.57377633165313E-7, -7.86803586842404E-8, -7.40444711426898E-8, 3.15259864117954E-8, 5.60536231567172E-9}, {-3.26080428920229E-10, -3.14576780695439E-9, 8.46796096612981E-10, -2.59329379174262E-9, -8.01054756588382E-10}, {-4.58725236153576E-11, -6.87847958546571E-11, 8.18226480126754E-12, 1.81082075625897E-10, 1.74510532938256E-10}, {7.60233505328792E-11, 4.76463939581321E-11, -2.47198455442033E-11, -8.83439688929965E-12, 5.93967446277316E-13}, {-8.92919292558887E-12, -4.38524572312029E-12, -4.02709146060896E-12, 4.84344426425295E-12, 5.1286904278152E-12}, {1.91518361809952E-12, 3.06846255371817E-13, -2.44830265306345E-13, 7.86297493099244E-14, 2.7234780580198E-13}, {9.09936624159538E-14, 7.20650818861447E-15, 2.45383991578283E-14, -4.79580974186462E-15, 3.64604724046944E-14}, {-4.63611142770709E-14, 1.73908246420636E-15, -4.41651410674801E-15, -6.61409045306922E-16, -1.60016049099639E-15}, {0.0, 0.0, 0.0, 0.0, 0.0}, {6.17105245892845E-6, -1.04342983738457E-5, -1.72711741097994E-5, -8.16815967888426E-7, 3.42789959967593E-6}, {-2.44014060833825E-7, 2.06991837444652E-7, -3.85805819475679E-7, 1.67162359832166E-8, 4.15139610402483E-7}, {8.1819900680402E-8, -3.20013409049159E-8, 5.94000906771151E-8, 2.24122167188946E-8, -1.33796186160409E-8}, {7.66269294674338E-11, -6.07862178874828E-10, 4.95795757186248E-10, -3.07589245481422E-10, 3.44456287710689E-10}, {-1.84076250254929E-10, -1.30985312312781E-10, -1.52547325533276E-10, -2.51000125929512E-11, -1.93924012590455E-11}, {-2.93307452197665E-11, 2.88627386757582E-11, 5.58812021182217E-12, -1.68692874069187E-13, 1.80464313900575E-12}, {-9.59053874473003E-13, 6.04803122874761E-13, -9.80015608958536E-13, 1.70530372034214E-12, 1.70458664160775E-12}, {2.80169588226043E-13, 9.09573148053551E-14, 2.16449186617004E-14, 1.15550091496353E-13, 4.97772796761321E-14}, {-3.04524400761371E-14, 3.42845631349694E-14, 2.44230630602064E-14, 5.76017546103056E-16, -9.74409465961093E-15}, {5.98765340844291E-15, -2.63942474859535E-15, -1.80204805804437E-15, -1.84981819321183E-16, -5.8507339216366E-16}, {-2.37069441910133E-15, 2.87429226086856E-16, -1.67055963193389E-16, 2.7211068491409E-18, 8.46646962667892E-17}, {0.0, 0.0, 0.0, 0.0, 0.0}, {-2.71386164105722E-5, -1.41834938338454E-5, -2.00777928859929E-7, 5.94329804681196E-7, 8.61856994375586E-6}, {-3.93656495458664E-8, -6.36432821807576E-7, -2.47887475106438E-7, -2.64906446204966E-8, 1.10689794197004E-7}, {5.25319489188562E-8, 9.00866357158695E-9, 5.00693379572512E-8, 2.47269011056404E-8, -7.27648556194598E-9}, {1.87207107149043E-9, -1.46428282396138E-9, -2.71812237167257E-10, 8.44902265891466E-10, -5.62683870906027E-10}, {-1.08295119666184E-10, 4.75553388543793E-11, -5.49429386495686E-11, -6.60907871731611E-11, -5.97347322824822E-11}, {-4.95118306815571E-12, 5.3108373523497E-13, -1.93679746327378E-12, -1.6177052184051E-12, 1.2327672720251E-11}, {6.685826829099E-13, 7.38288575160449E-13, 5.47630483499201E-13, -1.00770258118914E-13, -1.65564928475981E-13}, {5.80963409268471E-14, 6.93474288078737E-14, 6.60728092794315E-15, -5.21029056725202E-15, -1.11283532854883E-16}, {-4.10567742688903E-15, 1.62252646805882E-14, 1.00774699865989E-14, -2.44793214897877E-16, -1.59283906414563E-15}, {1.84669506619904E-17, 8.28473337813919E-17, -1.53400662078899E-16, -5.01060672199689E-17, -2.20727935766132E-16}, {2.65355116203636E-16, -3.70233146147684E-17, 3.52689394451586E-18, -8.62215942516328E-18, 9.26909361974526E-18}, {9.94266950643135E-17, 4.17028699663441E-18, -7.65153491125819E-21, -5.62131270981041E-18, -3.03732817297438E-18}};
        private static final double[][] CW_B = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}, {-2.09104872912563E-4, -1.4153027497354E-5, 3.00318745764815E-5, -1.82864291318284E-5, -7.62965409959238E-6}, {0.0, 0.0, 0.0, 0.0, 0.0}, {-1.86336519900275E-4, 1.91256553935638E-4, 7.28356195304996E-5, 3.59637869639906E-5, -2.53927226167388E-5}, {1.08195343799485E-4, -6.97050977217619E-5, -6.68037133871099E-5, 2.30387653190503E-5, -1.22735483925784E-5}, {0.0, 0.0, 0.0, 0.0, 0.0}, {1.19941091277039E-4, -7.70547844186875E-5, -8.15376297964528E-5, 1.06005789545203E-5, 2.3117723226872E-5}, {-1.77494760217164E-5, -1.37061385686605E-5, -1.74805936475816E-5, -6.91745900867532E-7, -7.10231790947787E-6}, {-1.47564103733219E-5, 2.0889078548526E-6, 3.19876879447867E-6, 9.43984664503715E-7, -4.90480527577521E-6}, {0.0, 0.0, 0.0, 0.0, 0.0}, {4.93300138389457E-5, -6.77641298460617E-5, -3.25043347246397E-5, 8.33226714911921E-6, 8.11499972792905E-6}, {-2.80449863471272E-5, -1.04367606414606E-5, 1.64473584641163E-7, -3.57420965807816E-6, 2.95887156564038E-6}, {1.88835280111533E-6, 5.69125761193702E-7, -2.22757382799409E-6, -1.96699131032252E-7, -2.91861219283659E-7}, {-4.6991897143668E-6, -7.00778948636735E-7, 2.97544157334673E-9, 3.8610051254441E-7, 2.30939653701027E-7}, {0.0, 0.0, 0.0, 0.0, 0.0}, {1.77050610394149E-5, -3.18353071311574E-5, 3.04232260950316E-5, -6.26821316488169E-5, -1.75094810002378E-6}, {9.25605901565775E-6, -8.25179123302247E-6, 6.74032752408358E-6, 3.22192289084524E-6, 6.09414500075259E-6}, {4.282338252422E-6, 2.10470570087927E-7, -4.75050074985668E-7, -4.89382663470592E-7, 8.75232347469207E-7}, {8.50393520366934E-7, 1.58764911467186E-7, -2.1626763832121E-7, -7.43341300487416E-10, 1.7513172981323E-7}, {-2.87064111623119E-7, 4.5039389310283E-8, 6.6331504441669E-8, 7.61199387418853E-8, -6.05694385243652E-9}, {0.0, 0.0, 0.0, 0.0, 0.0}, {-1.95692079507947E-5, 5.15486098887851E-5, 3.00852761598173E-5, 1.21485028343416E-5, -6.72450521493428E-6}, {5.34496867088158E-6, 3.90973451680699E-6, 3.70148924718425E-6, 5.73731499938212E-8, 5.5225822028878E-7}, {3.39950838185315E-7, -5.63443976772634E-7, 4.52082211980595E-7, -2.57094645806243E-7, -6.84885762924729E-8}, {2.15793276880684E-7, 2.05911354090873E-7, 1.33747872341142E-8, -2.07997626478952E-8, -3.69812938736019E-8}, {2.11952749403224E-9, 4.04317822544732E-8, 2.4097202488365E-9, 8.56289126938059E-9, 2.310352834902E-8}, {-2.08402298813248E-9, -8.50243600879112E-9, 2.60895410117768E-9, -6.69156841738591E-10, -5.16280278087006E-9}, {0.0, 0.0, 0.0, 0.0, 0.0}, {1.24901291436683E-4, -5.70770326719086E-5, -8.44887248105015E-5, -3.11442665354698E-5, -1.12982893252046E-5}, {-8.38934444233944E-6, 1.56860091415414E-6, -1.77704563531825E-6, -5.70219068898717E-8, -4.30377735031244E-6}, {3.72965318017681E-7, 6.98175439446187E-7, 1.75760544807919E-8, 1.59731284857151E-7, 3.62363848767891E-7}, {-2.32148850787091E-7, -4.21888751852973E-8, 8.35926113952108E-8, -2.24572480575674E-8, -6.92114100904503E-8}, {-2.92635642210745E-9, 3.38086229163415E-9, 4.72186694662901E-9, -8.32354437305758E-11, 4.19673890995627E-9}, {-1.264528876929E-9, 1.91309690886864E-9, 1.54755631983655E-9, -1.09865169400249E-9, 1.83645326319994E-10}, {9.92539437011905E-10, -2.963182034883E-10, 1.17466020823486E-10, -5.00185957995526E-10, -8.54777591408537E-11}, {0.0, 0.0, 0.0, 0.0, 0.0}, {-1.82885335404854E-4, 7.27424724520089E-5, 3.05286278023427E-5, 2.55324463432562E-5, -6.39859510763234E-6}, {-5.21449265232557E-6, -6.70572386081398E-6, -3.95473351292738E-6, -6.41023334372861E-7, -3.11616331059009E-6}, {2.37090789071727E-7, 3.58427517014705E-7, 2.55709192777007E-7, 8.44593804408541E-8, 9.27243162355359E-9}, {7.24370898432057E-8, -7.4394512033771E-9, 8.61751911975683E-10, -2.34651212610623E-8, 2.94052921681456E-9}, {-1.22127317934425E-8, -3.89758984276768E-9, 4.12890383904924E-11, 2.06528068002723E-9, 1.7348869697227E-9}, {-5.4413740690762E-10, -4.81034553189921E-10, -2.56101759039694E-11, 3.21880564410154E-10, -2.7019534316525E-11}, {1.08394225300546E-10, -7.99525492688661E-11, 1.73850287030654E-10, -8.06390014426271E-11, -7.6314336429116E-13}, {-3.41446959267441E-11, 2.72675729042792E-11, 5.69674704865345E-12, -3.38402998344892E-12, -2.96732381931007E-12}, {0.0, 0.0, 0.0, 0.0, 0.0}, {2.9116131598725E-5, -7.24641166590735E-5, -8.58323519857884E-6, -1.1403744425582E-5, 1.32244819451517E-5}, {1.24266748259826E-6, -4.13127038469802E-6, -8.47496394492885E-7, 5.48722958754267E-7, -1.98288551821205E-6}, {-1.70671245196917E-8, 1.3689112708354E-8, -2.8090197224987E-7, -5.45369793946222E-9, -9.58796303763498E-8}, {1.14115335901746E-8, 2.79308166429178E-8, -1.71144803132413E-8, 4.8611624356538E-9, -8.1306145995228E-9}, {-1.19144311035824E-9, -1.28197815211763E-9, -1.22313592972373E-9, 6.23116336753674E-10, 2.11527825898689E-9}, {4.94618645030426E-10, -1.01554483531252E-10, -3.58808808952276E-10, 1.23499783028794E-10, -1.21017599361833E-10}, {1.33959569836451E-10, -1.87140898812283E-11, -3.04265350158941E-11, -1.42907553051431E-11, -1.09873858099638E-11}, {1.30277419203512E-11, -4.95312627777245E-12, 2.23070215544358E-12, 1.66450226016423E-12, 6.26222944728474E-12}, {-4.40721204874728E-12, 2.99575133064885E-12, -1.54917262009097E-12, 8.9001566452706E-14, -1.59135267012937E-12}, {0.0, 0.0, 0.0, 0.0, 0.0}, {-4.1766721132316E-5, 1.39005215116294E-5, 1.46521361817829E-5, 3.23485458024416E-5, -8.57936261085263E-6}, {9.4849102652445E-7, 1.67749735481991E-6, 6.80159475477603E-7, -1.34558044496631E-6, 1.62108231492249E-6}, {-2.67545753355631E-7, -3.31848493018159E-8, 1.05837219557465E-7, 1.555876554794E-7, -2.84996014386667E-8}, {-5.15113778734878E-8, 8.83630725241303E-9, 3.36579455982772E-9, -6.22350102096402E-9, 5.03959133095369E-9}, {2.04635880823035E-11, -1.07923589059151E-9, -6.96482137669712E-10, -4.70238500452793E-10, -6.60277903598297E-10}, {-2.41897168749189E-11, 1.33547763615216E-10, -5.13534673658908E-11, -8.32767177662817E-11, 5.72614717082428E-11}, {7.5517056235994E-12, -1.57123461699055E-11, -1.48874069619124E-11, -7.10529462981252E-13, -7.99006335025107E-12}, {2.4188315673896E-12, 2.97346980183361E-12, 1.2871997773145E-12, -2.49240876894143E-12, 6.71155595793198E-13}, {4.16995565336914E-13, -1.71584521275288E-13, -7.23064067359978E-14, 2.45405880599037E-13, 4.4353293490583E-13}, {3.56937508828997E-14, 2.430125112603E-14, -7.96090778289326E-14, -1.59548529636358E-14, 8.99103763000507E-15}, {0.0, 0.0, 0.0, 0.0, 0.0}, {1.17579258399489E-4, -4.52648448635772E-5, -2.69130037097862E-5, -3.82266335794366E-5, -4.36549257701084E-6}, {-1.43270371215502E-6, 1.21565440183855E-6, 8.53701136074284E-7, 1.52709810023665E-6, 1.22382663462904E-6}, {3.06089147519664E-7, 9.79084123751975E-8, 7.96524661441178E-8, 4.54770947973458E-8, 2.22842369458882E-7}, {-9.94254707745127E-9, 1.43251376378012E-8, 1.9391175368516E-8, -6.52214645690987E-9, -1.97114016452408E-9}, {-9.20751919828404E-10, -9.44312829629076E-10, 7.24196738163952E-11, -6.71801072324561E-11, 2.33146774065873E-10}, {-1.4354429895641E-11, 1.78464235318769E-10, 7.69950023012326E-11, -4.22390057304453E-12, 3.05176324574816E-11}, {-7.8805375397399E-12, -3.20207793051003E-12, 1.01527407317625E-12, 6.02788185858449E-12, 1.14919530900453E-11}, {-1.21558899266069E-12, 5.31300597882986E-13, 3.44023865079264E-13, -6.22598216726224E-14, -5.47031650765402E-14}, {-4.15627948750943E-13, 2.77620907292721E-13, -8.99784134364011E-14, 1.07254247320864E-13, 6.85990080564196E-14}, {-3.91837863922901E-14, 9.7471497681618E-15, 6.79982450963903E-15, -2.41420876658572E-15, -2.20889384455344E-15}, {9.25912068402776E-15, -4.02621719248224E-15, -2.43952036351187E-15, -1.97006876049866E-15, 1.03065621527869E-16}, {0.0, 0.0, 0.0, 0.0, 0.0}, {-1.03762036940193E-4, 4.38145356960292E-5, 2.43406920349913E-5, 7.89103527673736E-6, -1.6684146533916E-5}, {-1.18428449371744E-6, -1.30188721737259E-6, -1.8801355711665E-6, -1.01342046295303E-6, 9.21813037802502E-7}, {1.5183606871246E-7, 1.11362553803933E-7, 1.55375052233052E-7, 1.94450910788747E-9, -1.73093755828342E-8}, {-3.77758211813121E-9, 1.2332396958361E-8, 1.72510045250302E-9, -1.88609789458597E-9, 1.28937597985937E-9}, {-1.07947760393523E-9, 5.26051570105365E-10, -3.67657536332496E-11, 3.1611012352384E-10, -3.2427319824217E-10}, {-2.0038564920982E-12, 2.5470386968239E-11, 4.08563622440851E-12, -4.83350348928636E-11, -3.98153443845079E-13}, {2.73094467727215E-12, 5.08900664114903E-12, -7.66669089075134E-13, 2.50015592643012E-12, 4.29763262853853E-12}, {6.5394648753789E-13, -2.24958413781008E-13, 6.74638861781238E-15, 3.28537647613903E-14, 2.54199700290116E-13}, {-1.09122051193505E-13, 8.36362392931501E-14, -3.907501539123E-14, -5.4491591074195E-14, 2.43816947219217E-14}, {-1.41882561550134E-14, 1.00455397812713E-14, 2.63347255121581E-15, 1.53043256823601E-15, 2.49081021428095E-15}, {-1.17256193152654E-15, 1.05648985031971E-16, 1.31778372453016E-16, 1.44815198666577E-16, -3.7253276861848E-16}, {2.66203457773766E-16, -7.67224608659658E-17, 3.51487351031864E-18, 4.10287131339291E-17, -6.72171711728514E-17}};

        LegendreFunctions() {
        }

        public double getAnmBh(int n, int m) {
            return BH_A[n][m];
        }

        public double getAnmBw(int n, int m) {
            return BW_A[n][m];
        }

        public double getAnmCh(int n, int m) {
            return CH_A[n][m];
        }

        public double getAnmCw(int n, int m) {
            return CW_A[n][m];
        }

        public double getBnmBh(int n, int m) {
            return BH_B[n][m];
        }

        public double getBnmBw(int n, int m) {
            return BW_B[n][m];
        }

        public double getBnmCh(int n, int m) {
            return CH_B[n][m];
        }

        public double getBnmCw(int n, int m) {
            return CW_B[n][m];
        }
    }

    private class LegendrePolynomials {
        private double[][] pCoef;

        LegendrePolynomials(int degree, int order) {
            this.pCoef = new double[degree + 1][order + 1];
            double polarDist = 1.5707963267948966 - ViennaThreeModel.this.latitude;
            double t = FastMath.cos(polarDist);
            double t2 = t * t;
            for (int n = 0; n <= degree; ++n) {
                for (int m = 0; m <= FastMath.min(n, order); ++m) {
                    int r = (n - m) / 2;
                    double sum = 0.0;
                    for (int k = 0; k <= r; ++k) {
                        double term = FastMath.pow(-1.0, k) * CombinatoricsUtils.factorialDouble(2 * n - 2 * k) / (CombinatoricsUtils.factorialDouble(k) * CombinatoricsUtils.factorialDouble(n - k) * CombinatoricsUtils.factorialDouble(n - m - 2 * k)) * FastMath.pow(t, n - m - 2 * k);
                        sum += term;
                    }
                    this.pCoef[n][m] = FastMath.pow(2.0, -n) * FastMath.pow(1.0 - t2, 0.5 * (double)m) * sum;
                }
            }
        }

        public double getPnm(int n, int m) {
            return this.pCoef[n][m];
        }
    }
}

