/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.FDSFactory;
import org.hipparchus.analysis.differentiation.FieldDerivativeStructure;
import org.hipparchus.analysis.interpolation.FieldHermiteInterpolator;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.CircularOrbit;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldCircularOrbit<T extends RealFieldElement<T>>
extends FieldOrbit<T> {
    private static final Map<Field<? extends RealFieldElement<?>>, FDSFactory<? extends RealFieldElement<?>>> FACTORIES = new HashMap();
    private final T a;
    private final T ex;
    private final T ey;
    private final T i;
    private final T raan;
    private final T alphaV;
    private final T aDot;
    private final T exDot;
    private final T eyDot;
    private final T iDot;
    private final T raanDot;
    private final T alphaVDot;
    private FieldPVCoordinates<T> partialPV;
    private final T one;
    private final T zero;

    public FieldCircularOrbit(T a, T ex, T ey, T i, T raan, T alpha, PositionAngle type, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(a, ex, ey, i, raan, alpha, null, null, null, null, null, null, type, frame, (FieldAbsoluteDate<Object>)date, mu);
    }

    public FieldCircularOrbit(T a, T ex, T ey, T i, T raan, T alpha, T aDot, T exDot, T eyDot, T iDot, T raanDot, T alphaDot, PositionAngle type, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        super(frame, date, mu);
        if (ex.getReal() * ex.getReal() + ey.getReal() * ey.getReal() >= 1.0) {
            throw new OrekitIllegalArgumentException(OrekitMessages.HYPERBOLIC_ORBIT_NOT_HANDLED_AS, this.getClass().getName());
        }
        if (!FACTORIES.containsKey(a.getField())) {
            FACTORIES.put(a.getField(), new FDSFactory(a.getField(), 1, 1));
        }
        this.a = a;
        this.aDot = aDot;
        this.ex = ex;
        this.exDot = exDot;
        this.ey = ey;
        this.eyDot = eyDot;
        this.i = i;
        this.iDot = iDot;
        this.raan = raan;
        this.raanDot = raanDot;
        this.one = (RealFieldElement)a.getField().getOne();
        this.zero = (RealFieldElement)a.getField().getZero();
        if (this.hasDerivatives()) {
            FieldDerivativeStructure alphavDS;
            FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(a.getField());
            FieldDerivativeStructure exDS = factory.build(new RealFieldElement[]{ex, exDot});
            FieldDerivativeStructure eyDS = factory.build(new RealFieldElement[]{ey, eyDot});
            FieldDerivativeStructure alphaDS = factory.build(new RealFieldElement[]{alpha, alphaDot});
            switch (type) {
                case MEAN: {
                    alphavDS = FieldCircularOrbit.eccentricToTrue(FieldCircularOrbit.meanToEccentric(alphaDS, exDS, eyDS), exDS, eyDS);
                    break;
                }
                case ECCENTRIC: {
                    alphavDS = FieldCircularOrbit.eccentricToTrue(alphaDS, exDS, eyDS);
                    break;
                }
                case TRUE: {
                    alphavDS = alphaDS;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            this.alphaV = alphavDS.getValue();
            this.alphaVDot = alphavDS.getPartialDerivative(1);
        } else {
            switch (type) {
                case MEAN: {
                    this.alphaV = FieldCircularOrbit.eccentricToTrue(FieldCircularOrbit.meanToEccentric(alpha, ex, ey), ex, ey);
                    break;
                }
                case ECCENTRIC: {
                    this.alphaV = FieldCircularOrbit.eccentricToTrue(alpha, ex, ey);
                    break;
                }
                case TRUE: {
                    this.alphaV = alpha;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            this.alphaVDot = null;
        }
        this.partialPV = null;
    }

    public FieldCircularOrbit(TimeStampedFieldPVCoordinates<T> pvCoordinates, Frame frame, T mu) throws IllegalArgumentException {
        super(pvCoordinates, frame, mu);
        FieldVector3D pvP = pvCoordinates.getPosition();
        FieldVector3D pvV = pvCoordinates.getVelocity();
        FieldVector3D<RealFieldElement> pvA = pvCoordinates.getAcceleration();
        Object r2 = pvP.getNormSq();
        RealFieldElement r = (RealFieldElement)r2.sqrt();
        Object V2 = pvV.getNormSq();
        RealFieldElement rV2OnMu = (RealFieldElement)((RealFieldElement)r.multiply(V2)).divide(mu);
        this.zero = (RealFieldElement)r.getField().getZero();
        this.one = (RealFieldElement)r.getField().getOne();
        if (rV2OnMu.getReal() > 2.0) {
            throw new OrekitIllegalArgumentException(OrekitMessages.HYPERBOLIC_ORBIT_NOT_HANDLED_AS, this.getClass().getName());
        }
        this.a = (RealFieldElement)r.divide(((RealFieldElement)rV2OnMu.negate()).add(2.0));
        FieldVector3D momentum = pvCoordinates.getMomentum();
        FieldVector3D plusK = FieldVector3D.getPlusK(r.getField());
        this.i = FieldVector3D.angle(momentum, plusK);
        FieldVector3D node = FieldVector3D.crossProduct(plusK, momentum);
        this.raan = (RealFieldElement)node.getY().atan2(node.getX());
        RealFieldElement cosRaan = (RealFieldElement)this.raan.cos();
        RealFieldElement sinRaan = (RealFieldElement)this.raan.sin();
        RealFieldElement cosI = (RealFieldElement)this.i.cos();
        RealFieldElement sinI = (RealFieldElement)this.i.sin();
        RealFieldElement xP = pvP.getX();
        RealFieldElement yP = pvP.getY();
        RealFieldElement zP = pvP.getZ();
        RealFieldElement x2 = (RealFieldElement)xP.multiply((RealFieldElement)cosRaan).add(yP.multiply((RealFieldElement)sinRaan)).divide(this.a);
        RealFieldElement y2 = (RealFieldElement)yP.multiply((RealFieldElement)cosRaan).subtract(xP.multiply((RealFieldElement)sinRaan)).multiply(cosI).add(zP.multiply((RealFieldElement)sinI)).divide(this.a);
        RealFieldElement eSE = (RealFieldElement)FieldVector3D.dotProduct(pvP, pvV).divide(((RealFieldElement)this.a.multiply(mu)).sqrt());
        RealFieldElement eCE = (RealFieldElement)rV2OnMu.subtract(1.0);
        RealFieldElement e2 = eCE.multiply(eCE).add(eSE.multiply(eSE));
        RealFieldElement f = eCE.subtract(e2);
        RealFieldElement g = (RealFieldElement)eSE.multiply(((RealFieldElement)((RealFieldElement)e2.negate()).add(1.0)).sqrt());
        RealFieldElement aOnR = this.a.divide((RealFieldElement)r);
        RealFieldElement a2OnR2 = aOnR.multiply(aOnR);
        this.ex = a2OnR2.multiply(f.multiply(x2).add(g.multiply(y2)));
        this.ey = a2OnR2.multiply(f.multiply(y2).subtract(g.multiply(x2)));
        RealFieldElement beta = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.ex.multiply(this.ex)).add(this.ey.multiply(this.ey))).negate()).add(1.0)).sqrt()).add(1.0)).reciprocal();
        this.alphaV = FieldCircularOrbit.eccentricToTrue((RealFieldElement)((RealFieldElement)((RealFieldElement)y2.add(this.ey)).add(eSE.multiply(beta).multiply(this.ex))).atan2(((RealFieldElement)x2.add(this.ex)).subtract(eSE.multiply(beta).multiply(this.ey))), this.ex, this.ey);
        this.partialPV = pvCoordinates;
        if (!FACTORIES.containsKey(this.a.getField())) {
            FACTORIES.put(this.a.getField(), new FDSFactory(this.a.getField(), 1, 1));
        }
        if (FieldCircularOrbit.hasNonKeplerianAcceleration(pvCoordinates, mu)) {
            RealFieldElement[][] jacobian = (RealFieldElement[][])MathArrays.buildArray(this.a.getField(), 6, 6);
            this.getJacobianWrtCartesian(PositionAngle.MEAN, jacobian);
            FieldVector3D<RealFieldElement> keplerianAcceleration = new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)((RealFieldElement)r.multiply(r2)).reciprocal()).multiply(mu.negate()), pvP);
            FieldVector3D<RealFieldElement> nonKeplerianAcceleration = pvA.subtract(keplerianAcceleration);
            RealFieldElement aX = nonKeplerianAcceleration.getX();
            RealFieldElement aY = nonKeplerianAcceleration.getY();
            RealFieldElement aZ = nonKeplerianAcceleration.getZ();
            this.aDot = jacobian[0][3].multiply(aX).add(jacobian[0][4].multiply(aY)).add(jacobian[0][5].multiply(aZ));
            this.exDot = jacobian[1][3].multiply(aX).add(jacobian[1][4].multiply(aY)).add(jacobian[1][5].multiply(aZ));
            this.eyDot = jacobian[2][3].multiply(aX).add(jacobian[2][4].multiply(aY)).add(jacobian[2][5].multiply(aZ));
            this.iDot = jacobian[3][3].multiply(aX).add(jacobian[3][4].multiply(aY)).add(jacobian[3][5].multiply(aZ));
            this.raanDot = jacobian[4][3].multiply(aX).add(jacobian[4][4].multiply(aY)).add(jacobian[4][5].multiply(aZ));
            RealFieldElement alphaMDot = this.getKeplerianMeanMotion().add((RealFieldElement)jacobian[5][3].multiply(aX)).add(jacobian[5][4].multiply(aY)).add(jacobian[5][5].multiply(aZ));
            FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(this.a.getField());
            FieldDerivativeStructure exDS = factory.build(new RealFieldElement[]{this.ex, this.exDot});
            FieldDerivativeStructure eyDS = factory.build(new RealFieldElement[]{this.ey, this.eyDot});
            FieldDerivativeStructure alphaMDS = factory.build(new RealFieldElement[]{this.getAlphaM(), alphaMDot});
            FieldDerivativeStructure alphavDS = FieldCircularOrbit.eccentricToTrue(FieldCircularOrbit.meanToEccentric(alphaMDS, exDS, eyDS), exDS, eyDS);
            this.alphaVDot = alphavDS.getPartialDerivative(1);
        } else {
            this.aDot = null;
            this.exDot = null;
            this.eyDot = null;
            this.iDot = null;
            this.raanDot = null;
            this.alphaVDot = null;
        }
    }

    public FieldCircularOrbit(FieldPVCoordinates<T> PVCoordinates2, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(new TimeStampedFieldPVCoordinates<T>(date, PVCoordinates2), frame, mu);
    }

    public FieldCircularOrbit(FieldOrbit<T> op) {
        super(op.getFrame(), op.getDate(), op.getMu());
        this.a = op.getA();
        this.i = op.getI();
        T hx = op.getHx();
        T hy = op.getHy();
        RealFieldElement h2 = (RealFieldElement)((RealFieldElement)hx.multiply(hx)).add(hy.multiply(hy));
        RealFieldElement h = (RealFieldElement)h2.sqrt();
        this.raan = (RealFieldElement)hy.atan2(hx);
        RealFieldElement cosRaan = h.getReal() == 0.0 ? (RealFieldElement)this.raan.cos() : hx.divide((RealFieldElement)h);
        RealFieldElement sinRaan = h.getReal() == 0.0 ? (RealFieldElement)this.raan.sin() : hy.divide((RealFieldElement)h);
        RealFieldElement equiEx = op.getEquinoctialEx();
        RealFieldElement equiEy = op.getEquinoctialEy();
        this.ex = equiEx.multiply((RealFieldElement)cosRaan).add(equiEy.multiply((RealFieldElement)sinRaan));
        this.ey = equiEy.multiply((RealFieldElement)cosRaan).subtract(equiEx.multiply((RealFieldElement)sinRaan));
        this.alphaV = (RealFieldElement)op.getLv().subtract(this.raan);
        if (!FACTORIES.containsKey(this.a.getField())) {
            FACTORIES.put(this.a.getField(), new FDSFactory(this.a.getField(), 1, 1));
        }
        if (op.hasDerivatives()) {
            this.aDot = op.getADot();
            T hxDot = op.getHxDot();
            T hyDot = op.getHyDot();
            this.iDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)cosRaan.multiply(hxDot)).add(sinRaan.multiply(hyDot))).multiply(2)).divide(h2.add(1.0));
            this.raanDot = ((RealFieldElement)((RealFieldElement)hx.multiply(hyDot)).subtract(hy.multiply(hxDot))).divide(h2);
            T equiExDot = op.getEquinoctialExDot();
            T equiEyDot = op.getEquinoctialEyDot();
            this.exDot = ((RealFieldElement)equiExDot.add(equiEy.multiply(this.raanDot))).multiply(cosRaan).add(((RealFieldElement)equiEyDot.subtract(equiEx.multiply(this.raanDot))).multiply(sinRaan));
            this.eyDot = ((RealFieldElement)equiEyDot.subtract(equiEx.multiply(this.raanDot))).multiply(cosRaan).subtract(((RealFieldElement)equiExDot.add(equiEy.multiply(this.raanDot))).multiply(sinRaan));
            this.alphaVDot = (RealFieldElement)op.getLvDot().subtract(this.raanDot);
        } else {
            this.aDot = null;
            this.exDot = null;
            this.eyDot = null;
            this.iDot = null;
            this.raanDot = null;
            this.alphaVDot = null;
        }
        this.partialPV = null;
        this.one = (RealFieldElement)this.a.getField().getOne();
        this.zero = (RealFieldElement)this.a.getField().getZero();
    }

    @Override
    public OrbitType getType() {
        return OrbitType.CIRCULAR;
    }

    @Override
    public T getA() {
        return this.a;
    }

    @Override
    public T getADot() {
        return this.aDot;
    }

    @Override
    public T getEquinoctialEx() {
        return (T)((RealFieldElement)((RealFieldElement)this.ex.multiply(this.raan.cos())).subtract(this.ey.multiply(this.raan.sin())));
    }

    @Override
    public T getEquinoctialExDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        RealFieldElement cosRaan = (RealFieldElement)this.raan.cos();
        RealFieldElement sinRaan = (RealFieldElement)this.raan.sin();
        return (T)((RealFieldElement)this.exDot.subtract(this.ey.multiply(this.raanDot))).multiply(cosRaan).subtract(((RealFieldElement)this.eyDot.add(this.ex.multiply(this.raanDot))).multiply(sinRaan));
    }

    @Override
    public T getEquinoctialEy() {
        return (T)((RealFieldElement)((RealFieldElement)this.ey.multiply(this.raan.cos())).add(this.ex.multiply(this.raan.sin())));
    }

    @Override
    public T getEquinoctialEyDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        RealFieldElement cosRaan = (RealFieldElement)this.raan.cos();
        RealFieldElement sinRaan = (RealFieldElement)this.raan.sin();
        return (T)((RealFieldElement)this.eyDot.add(this.ex.multiply(this.raanDot))).multiply(cosRaan).add(((RealFieldElement)this.exDot.subtract(this.ey.multiply(this.raanDot))).multiply(sinRaan));
    }

    public T getCircularEx() {
        return this.ex;
    }

    public T getCircularExDot() {
        return this.exDot;
    }

    public T getCircularEy() {
        return this.ey;
    }

    public T getCircularEyDot() {
        return this.eyDot;
    }

    @Override
    public T getHx() {
        if (FastMath.abs(this.i.getReal() - Math.PI) < 1.0E-10) {
            return (T)((RealFieldElement)this.zero.add(Double.NaN));
        }
        return (T)((RealFieldElement)((RealFieldElement)this.raan.cos()).multiply(((RealFieldElement)this.i.divide(2.0)).tan()));
    }

    @Override
    public T getHxDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        if (FastMath.abs(this.i.getReal() - Math.PI) < 1.0E-10) {
            return (T)((RealFieldElement)this.zero.add(Double.NaN));
        }
        RealFieldElement cosRaan = (RealFieldElement)this.raan.cos();
        RealFieldElement sinRaan = (RealFieldElement)this.raan.sin();
        RealFieldElement tan = (RealFieldElement)((RealFieldElement)this.i.multiply(0.5)).tan();
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)cosRaan.multiply(0.5)).multiply(tan.multiply(tan).add(1.0))).multiply(this.iDot)).subtract(sinRaan.multiply(tan).multiply(this.raanDot)));
    }

    @Override
    public T getHy() {
        if (FastMath.abs(this.i.getReal() - Math.PI) < 1.0E-10) {
            return (T)((RealFieldElement)this.zero.add(Double.NaN));
        }
        return (T)((RealFieldElement)((RealFieldElement)this.raan.sin()).multiply(((RealFieldElement)this.i.divide(2.0)).tan()));
    }

    @Override
    public T getHyDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        if (FastMath.abs(this.i.getReal() - Math.PI) < 1.0E-10) {
            return (T)((RealFieldElement)this.zero.add(Double.NaN));
        }
        RealFieldElement cosRaan = (RealFieldElement)this.raan.cos();
        RealFieldElement sinRaan = (RealFieldElement)this.raan.sin();
        RealFieldElement tan = (RealFieldElement)((RealFieldElement)this.i.multiply(0.5)).tan();
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)sinRaan.multiply(0.5)).multiply(tan.multiply(tan).add(1.0))).multiply(this.iDot)).add(cosRaan.multiply(tan).multiply(this.raanDot)));
    }

    public T getAlphaV() {
        return this.alphaV;
    }

    public T getAlphaVDot() {
        return this.alphaVDot;
    }

    public T getAlphaE() {
        return FieldCircularOrbit.trueToEccentric(this.alphaV, this.ex, this.ey);
    }

    public T getAlphaEDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(this.a.getField());
        FieldDerivativeStructure alphaVDS = factory.build(new RealFieldElement[]{this.alphaV, this.alphaVDot});
        FieldDerivativeStructure exDS = factory.build(new RealFieldElement[]{this.ex, this.exDot});
        FieldDerivativeStructure eyDS = factory.build(new RealFieldElement[]{this.ey, this.eyDot});
        FieldDerivativeStructure alphaEDS = FieldCircularOrbit.trueToEccentric(alphaVDS, exDS, eyDS);
        return alphaEDS.getPartialDerivative(1);
    }

    public T getAlphaM() {
        return FieldCircularOrbit.eccentricToMean(FieldCircularOrbit.trueToEccentric(this.alphaV, this.ex, this.ey), this.ex, this.ey);
    }

    public T getAlphaMDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(this.a.getField());
        FieldDerivativeStructure alphaVDS = factory.build(new RealFieldElement[]{this.alphaV, this.alphaVDot});
        FieldDerivativeStructure exDS = factory.build(new RealFieldElement[]{this.ex, this.exDot});
        FieldDerivativeStructure eyDS = factory.build(new RealFieldElement[]{this.ey, this.eyDot});
        FieldDerivativeStructure alphaMDS = FieldCircularOrbit.eccentricToMean(FieldCircularOrbit.trueToEccentric(alphaVDS, exDS, eyDS), exDS, eyDS);
        return alphaMDS.getPartialDerivative(1);
    }

    public T getAlpha(PositionAngle type) {
        return type == PositionAngle.MEAN ? this.getAlphaM() : (type == PositionAngle.ECCENTRIC ? this.getAlphaE() : this.getAlphaV());
    }

    public T getAlphaDot(PositionAngle type) {
        return type == PositionAngle.MEAN ? this.getAlphaMDot() : (type == PositionAngle.ECCENTRIC ? this.getAlphaEDot() : this.getAlphaVDot());
    }

    public static <T extends RealFieldElement<T>> T eccentricToTrue(T alphaE, T ex, T ey) {
        RealFieldElement epsilon = (RealFieldElement)((RealFieldElement)((RealFieldElement)ex.multiply(ex).add(ey.multiply(ey)).negate()).add(1.0)).sqrt();
        RealFieldElement cosAlphaE = (RealFieldElement)alphaE.cos();
        RealFieldElement sinAlphaE = (RealFieldElement)alphaE.sin();
        return (T)((RealFieldElement)alphaE.add(((RealFieldElement)ex.multiply((RealFieldElement)sinAlphaE).subtract(ey.multiply((RealFieldElement)cosAlphaE)).divide(((RealFieldElement)epsilon.add(1.0)).subtract(ex.multiply((RealFieldElement)cosAlphaE)).subtract(ey.multiply((RealFieldElement)sinAlphaE))).atan()).multiply(2)));
    }

    public static <T extends RealFieldElement<T>> T trueToEccentric(T alphaV, T ex, T ey) {
        RealFieldElement epsilon = (RealFieldElement)((RealFieldElement)((RealFieldElement)ex.multiply(ex).add(ey.multiply(ey)).negate()).add(1.0)).sqrt();
        RealFieldElement cosAlphaV = (RealFieldElement)alphaV.cos();
        RealFieldElement sinAlphaV = (RealFieldElement)alphaV.sin();
        return (T)((RealFieldElement)alphaV.add(((RealFieldElement)ey.multiply((RealFieldElement)cosAlphaV).subtract(ex.multiply((RealFieldElement)sinAlphaV)).divide(((RealFieldElement)epsilon.add(1.0)).add(ex.multiply((RealFieldElement)cosAlphaV).add(ey.multiply((RealFieldElement)sinAlphaV)))).atan()).multiply(2)));
    }

    public static <T extends RealFieldElement<T>> T meanToEccentric(T alphaM, T ex, T ey) {
        Object alphaE = alphaM;
        RealFieldElement shift = (RealFieldElement)alphaM.getField().getZero();
        RealFieldElement alphaEMalphaM = (RealFieldElement)alphaM.getField().getZero();
        RealFieldElement cosAlphaE = (RealFieldElement)alphaE.cos();
        RealFieldElement sinAlphaE = (RealFieldElement)alphaE.sin();
        int iter = 0;
        do {
            RealFieldElement f2 = ex.multiply((RealFieldElement)sinAlphaE).subtract(ey.multiply((RealFieldElement)cosAlphaE));
            RealFieldElement f1 = (RealFieldElement)((RealFieldElement)ex.negate()).multiply(cosAlphaE).subtract(ey.multiply((RealFieldElement)sinAlphaE)).add(1.0);
            RealFieldElement f0 = alphaEMalphaM.subtract(f2);
            RealFieldElement f12 = (RealFieldElement)f1.multiply(2);
            shift = f0.multiply(f12).divide(f1.multiply(f12).subtract(f0.multiply(f2)));
            alphaEMalphaM = alphaEMalphaM.subtract(shift);
            alphaE = alphaM.add((RealFieldElement)alphaEMalphaM);
            cosAlphaE = (RealFieldElement)alphaE.cos();
            sinAlphaE = (RealFieldElement)alphaE.sin();
        } while (++iter < 50 && FastMath.abs(shift.getReal()) > 1.0E-12);
        return (T)alphaE;
    }

    public static <T extends RealFieldElement<T>> T eccentricToMean(T alphaE, T ex, T ey) {
        return (T)((RealFieldElement)alphaE.subtract(((RealFieldElement)ex.multiply(alphaE.sin())).subtract(ey.multiply(alphaE.cos()))));
    }

    @Override
    public T getE() {
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.ex.multiply(this.ex)).add(this.ey.multiply(this.ey))).sqrt());
    }

    @Override
    public T getEDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.ex.multiply(this.exDot)).add(this.ey.multiply(this.eyDot))).divide(this.getE()));
    }

    @Override
    public T getI() {
        return this.i;
    }

    @Override
    public T getIDot() {
        return this.iDot;
    }

    public T getRightAscensionOfAscendingNode() {
        return this.raan;
    }

    public T getRightAscensionOfAscendingNodeDot() {
        return this.raanDot;
    }

    @Override
    public T getLv() {
        return (T)((RealFieldElement)this.alphaV.add(this.raan));
    }

    @Override
    public T getLvDot() {
        return (T)(this.hasDerivatives() ? (RealFieldElement)this.alphaVDot.add(this.raanDot) : null);
    }

    @Override
    public T getLE() {
        return (T)((RealFieldElement)this.getAlphaE().add(this.raan));
    }

    @Override
    public T getLEDot() {
        return (T)(this.hasDerivatives() ? (RealFieldElement)this.getAlphaEDot().add(this.raanDot) : null);
    }

    @Override
    public T getLM() {
        return (T)((RealFieldElement)this.getAlphaM().add(this.raan));
    }

    @Override
    public T getLMDot() {
        return (T)(this.hasDerivatives() ? (RealFieldElement)this.getAlphaMDot().add(this.raanDot) : null);
    }

    @Override
    public boolean hasDerivatives() {
        return this.aDot != null;
    }

    private void computePVWithoutA() {
        if (this.partialPV != null) {
            return;
        }
        T equEx = this.getEquinoctialEx();
        T equEy = this.getEquinoctialEy();
        T hx = this.getHx();
        T hy = this.getHy();
        T lE = this.getLE();
        RealFieldElement hx2 = (RealFieldElement)hx.multiply(hx);
        RealFieldElement hy2 = (RealFieldElement)hy.multiply(hy);
        RealFieldElement factH = (RealFieldElement)((RealFieldElement)hx2.add(1.0)).add(hy2).reciprocal();
        RealFieldElement ux = ((RealFieldElement)hx2.add(1.0)).subtract(hy2).multiply(factH);
        RealFieldElement uy = ((RealFieldElement)((RealFieldElement)hx.multiply((int)2)).multiply(hy)).multiply(factH);
        RealFieldElement uz = ((RealFieldElement)hy.multiply((int)-2)).multiply(factH);
        RealFieldElement vx = uy;
        RealFieldElement vy = ((RealFieldElement)hy2.subtract(hx2).add(1.0)).multiply(factH);
        RealFieldElement vz = (RealFieldElement)hx.multiply((RealFieldElement)factH).multiply(2);
        RealFieldElement exey = (RealFieldElement)equEx.multiply(equEy);
        RealFieldElement ex2 = (RealFieldElement)equEx.multiply(equEx);
        RealFieldElement ey2 = (RealFieldElement)equEy.multiply(equEy);
        RealFieldElement e2 = ex2.add(ey2);
        RealFieldElement eta = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)e2.negate()).add(1.0)).sqrt()).add(1.0);
        RealFieldElement beta = (RealFieldElement)eta.reciprocal();
        RealFieldElement cLe = (RealFieldElement)lE.cos();
        RealFieldElement sLe = (RealFieldElement)lE.sin();
        RealFieldElement exCeyS = equEx.multiply((RealFieldElement)cLe).add(equEy.multiply((RealFieldElement)sLe));
        RealFieldElement x = (RealFieldElement)this.a.multiply(((RealFieldElement)((RealFieldElement)beta.negate()).multiply(ey2).add(1.0)).multiply(cLe).add(beta.multiply(exey).multiply(sLe)).subtract(equEx));
        RealFieldElement y = (RealFieldElement)this.a.multiply(((RealFieldElement)((RealFieldElement)beta.negate()).multiply(ex2).add(1.0)).multiply(sLe).add(beta.multiply(exey).multiply(cLe)).subtract(equEy));
        RealFieldElement factor = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.one.add(this.getMu())).divide(this.a)).sqrt()).divide(((RealFieldElement)exCeyS.negate()).add(1.0));
        RealFieldElement xdot = factor.multiply(((RealFieldElement)beta.multiply(equEy)).multiply(exCeyS).subtract(sLe));
        RealFieldElement ydot = factor.multiply(cLe.subtract(((RealFieldElement)beta.multiply(equEx)).multiply(exCeyS)));
        FieldVector3D<RealFieldElement> position = new FieldVector3D<RealFieldElement>(x.multiply(ux).add(y.multiply(vx)), x.multiply(uy).add(y.multiply(vy)), x.multiply(uz).add(y.multiply(vz)));
        FieldVector3D<RealFieldElement> velocity = new FieldVector3D<RealFieldElement>(xdot.multiply(ux).add(ydot.multiply(vx)), xdot.multiply(uy).add(ydot.multiply(vy)), xdot.multiply(uz).add(ydot.multiply(vz)));
        this.partialPV = new FieldPVCoordinates<RealFieldElement>(position, velocity);
    }

    private FieldVector3D<T> nonKeplerianAcceleration() {
        RealFieldElement[][] dCdP = (RealFieldElement[][])MathArrays.buildArray(this.a.getField(), 6, 6);
        this.getJacobianWrtParameters(PositionAngle.MEAN, dCdP);
        RealFieldElement nonKeplerianMeanMotion = (RealFieldElement)this.getAlphaMDot().subtract(this.getKeplerianMeanMotion());
        RealFieldElement nonKeplerianAx = ((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)dCdP[3][0].multiply(this.aDot)).add(dCdP[3][1].multiply(this.exDot))).add(dCdP[3][2].multiply(this.eyDot))).add(dCdP[3][3].multiply(this.iDot))).add(dCdP[3][4].multiply(this.raanDot))).add(dCdP[3][5].multiply(nonKeplerianMeanMotion));
        RealFieldElement nonKeplerianAy = ((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)dCdP[4][0].multiply(this.aDot)).add(dCdP[4][1].multiply(this.exDot))).add(dCdP[4][2].multiply(this.eyDot))).add(dCdP[4][3].multiply(this.iDot))).add(dCdP[4][4].multiply(this.raanDot))).add(dCdP[4][5].multiply(nonKeplerianMeanMotion));
        RealFieldElement nonKeplerianAz = ((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)dCdP[5][0].multiply(this.aDot)).add(dCdP[5][1].multiply(this.exDot))).add(dCdP[5][2].multiply(this.eyDot))).add(dCdP[5][3].multiply(this.iDot))).add(dCdP[5][4].multiply(this.raanDot))).add(dCdP[5][5].multiply(nonKeplerianMeanMotion));
        return new FieldVector3D<RealFieldElement>(nonKeplerianAx, nonKeplerianAy, nonKeplerianAz);
    }

    @Override
    protected TimeStampedFieldPVCoordinates<T> initPVCoordinates() {
        this.computePVWithoutA();
        Object r2 = this.partialPV.getPosition().getNormSq();
        FieldVector3D<RealFieldElement> keplerianAcceleration = new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)((RealFieldElement)r2.multiply(r2.sqrt())).reciprocal()).multiply(this.getMu().negate()), this.partialPV.getPosition());
        FieldVector3D<RealFieldElement> acceleration = this.hasDerivatives() ? keplerianAcceleration.add(this.nonKeplerianAcceleration()) : keplerianAcceleration;
        return new TimeStampedFieldPVCoordinates<RealFieldElement>(this.getDate(), this.partialPV.getPosition(), this.partialPV.getVelocity(), acceleration);
    }

    @Override
    public FieldCircularOrbit<T> shiftedBy(double dt) {
        return this.shiftedBy((RealFieldElement)((RealFieldElement)this.getDate().getField().getZero()).add(dt));
    }

    @Override
    public FieldCircularOrbit<T> shiftedBy(T dt) {
        FieldCircularOrbit<RealFieldElement> keplerianShifted = new FieldCircularOrbit<RealFieldElement>((RealFieldElement)this.a, (RealFieldElement)this.ex, (RealFieldElement)this.ey, (RealFieldElement)this.i, (RealFieldElement)this.raan, (RealFieldElement)this.getAlphaM().add(this.getKeplerianMeanMotion().multiply(dt)), PositionAngle.MEAN, this.getFrame(), this.getDate().shiftedBy(dt), (RealFieldElement)this.getMu());
        if (this.hasDerivatives()) {
            FieldVector3D<T> nonKeplerianAcceleration = this.nonKeplerianAcceleration();
            super.computePVWithoutA();
            FieldVector3D<RealFieldElement> fixedP = new FieldVector3D<RealFieldElement>((RealFieldElement)this.one, (FieldVector3D<RealFieldElement>)keplerianShifted.partialPV.getPosition(), (RealFieldElement)((RealFieldElement)dt.multiply(dt)).multiply(0.5), (FieldVector3D<RealFieldElement>)nonKeplerianAcceleration);
            RealFieldElement fixedR2 = fixedP.getNormSq();
            RealFieldElement fixedR = (RealFieldElement)fixedR2.sqrt();
            FieldVector3D<T> fixedV = new FieldVector3D<T>(this.one, keplerianShifted.partialPV.getVelocity(), dt, nonKeplerianAcceleration);
            FieldVector3D<RealFieldElement> fixedA = new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)fixedR2.multiply(fixedR).reciprocal()).multiply(this.getMu().negate()), (FieldVector3D<RealFieldElement>)keplerianShifted.partialPV.getPosition(), (RealFieldElement)this.one, (FieldVector3D<RealFieldElement>)nonKeplerianAcceleration);
            return new FieldCircularOrbit<RealFieldElement>(new TimeStampedFieldPVCoordinates<RealFieldElement>(keplerianShifted.getDate(), fixedP, fixedV, fixedA), keplerianShifted.getFrame(), (RealFieldElement)keplerianShifted.getMu());
        }
        return keplerianShifted;
    }

    @Override
    public FieldCircularOrbit<T> interpolate(FieldAbsoluteDate<T> date, Stream<FieldOrbit<T>> sample) {
        List list = sample.collect(Collectors.toList());
        boolean useDerivatives = true;
        for (FieldOrbit orbit : list) {
            useDerivatives = useDerivatives && orbit.hasDerivatives();
        }
        FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
        FieldAbsoluteDate previousDate = null;
        RealFieldElement previousRAAN = (RealFieldElement)this.zero.add(Double.NaN);
        RealFieldElement previousAlphaM = (RealFieldElement)this.zero.add(Double.NaN);
        for (FieldOrbit orbit : list) {
            Object continuousAlphaM;
            Object continuousRAAN;
            FieldCircularOrbit circ = (FieldCircularOrbit)OrbitType.CIRCULAR.convertType(orbit);
            if (previousDate == null) {
                continuousRAAN = circ.getRightAscensionOfAscendingNode();
                continuousAlphaM = circ.getAlphaM();
            } else {
                Object dt = circ.getDate().durationFrom(previousDate);
                RealFieldElement keplerAM = (RealFieldElement)previousAlphaM.add(circ.getKeplerianMeanMotion().multiply(dt));
                continuousRAAN = FieldCircularOrbit.normalizeAngle(circ.getRightAscensionOfAscendingNode(), previousRAAN);
                continuousAlphaM = FieldCircularOrbit.normalizeAngle(circ.getAlphaM(), keplerAM);
            }
            previousDate = circ.getDate();
            previousRAAN = continuousRAAN;
            previousAlphaM = continuousAlphaM;
            RealFieldElement[] toAdd = (RealFieldElement[])MathArrays.buildArray(this.one.getField(), 6);
            toAdd[0] = circ.getA();
            toAdd[1] = circ.getCircularEx();
            toAdd[2] = circ.getCircularEy();
            toAdd[3] = circ.getI();
            toAdd[4] = continuousRAAN;
            toAdd[5] = continuousAlphaM;
            if (useDerivatives) {
                RealFieldElement[] toAddDot = (RealFieldElement[])MathArrays.buildArray(this.one.getField(), 6);
                toAddDot[0] = circ.getADot();
                toAddDot[1] = circ.getCircularExDot();
                toAddDot[2] = circ.getCircularEyDot();
                toAddDot[3] = circ.getIDot();
                toAddDot[4] = circ.getRightAscensionOfAscendingNodeDot();
                toAddDot[5] = circ.getAlphaMDot();
                interpolator.addSamplePoint((FieldElement)circ.getDate().durationFrom(date), new RealFieldElement[][]{toAdd, toAddDot});
                continue;
            }
            interpolator.addSamplePoint((FieldElement)circ.getDate().durationFrom(date), new RealFieldElement[][]{toAdd});
        }
        RealFieldElement[][] interpolated = (RealFieldElement[][])interpolator.derivatives((FieldElement)this.zero, 1);
        return new FieldCircularOrbit<RealFieldElement>(interpolated[0][0], interpolated[0][1], interpolated[0][2], interpolated[0][3], interpolated[0][4], interpolated[0][5], interpolated[1][0], interpolated[1][1], interpolated[1][2], interpolated[1][3], interpolated[1][4], interpolated[1][5], PositionAngle.MEAN, this.getFrame(), (FieldAbsoluteDate<RealFieldElement>)date, (RealFieldElement)this.getMu());
    }

    @Override
    protected T[][] computeJacobianMeanWrtCartesian() {
        RealFieldElement[][] jacobian = (RealFieldElement[][])MathArrays.buildArray(this.one.getField(), 6, 6);
        this.computePVWithoutA();
        FieldVector3D<T> position = this.partialPV.getPosition();
        FieldVector3D<T> velocity = this.partialPV.getVelocity();
        RealFieldElement x = position.getX();
        RealFieldElement y = position.getY();
        RealFieldElement z = position.getZ();
        T vx = velocity.getX();
        T vy = velocity.getY();
        T vz = velocity.getZ();
        RealFieldElement pv = FieldVector3D.dotProduct(position, velocity);
        RealFieldElement r2 = position.getNormSq();
        RealFieldElement r = (RealFieldElement)r2.sqrt();
        T v2 = velocity.getNormSq();
        Object mu = this.getMu();
        RealFieldElement oOsqrtMuA = (RealFieldElement)this.one.divide(((RealFieldElement)this.a.multiply(mu)).sqrt());
        RealFieldElement rOa = (RealFieldElement)r.divide(this.a);
        RealFieldElement aOr = this.a.divide((RealFieldElement)r);
        RealFieldElement aOr2 = (RealFieldElement)this.a.divide(r2);
        RealFieldElement a2 = (RealFieldElement)this.a.multiply(this.a);
        RealFieldElement ex2 = (RealFieldElement)this.ex.multiply(this.ex);
        RealFieldElement ey2 = (RealFieldElement)this.ey.multiply(this.ey);
        RealFieldElement e2 = ex2.add(ey2);
        RealFieldElement epsilon = (RealFieldElement)((RealFieldElement)((RealFieldElement)e2.negate()).add(1.0)).sqrt();
        RealFieldElement beta = (RealFieldElement)((RealFieldElement)epsilon.add(1.0)).reciprocal();
        RealFieldElement eCosE = (RealFieldElement)((RealFieldElement)rOa.negate()).add(1.0);
        RealFieldElement eSinE = pv.multiply((RealFieldElement)oOsqrtMuA);
        RealFieldElement cosI = (RealFieldElement)this.i.cos();
        RealFieldElement sinI = (RealFieldElement)this.i.sin();
        RealFieldElement cosRaan = (RealFieldElement)this.raan.cos();
        RealFieldElement sinRaan = (RealFieldElement)this.raan.sin();
        this.fillHalfRow(((RealFieldElement)aOr.multiply(2.0)).multiply(aOr2), position, jacobian[0], 0);
        this.fillHalfRow((RealFieldElement)a2.multiply(((RealFieldElement)mu.divide(2.0)).reciprocal()), velocity, jacobian[0], 3);
        FieldVector3D<RealFieldElement> danP = new FieldVector3D<RealFieldElement>((RealFieldElement)v2, (FieldVector3D<RealFieldElement>)position, (RealFieldElement)pv.negate(), (FieldVector3D<RealFieldElement>)velocity);
        FieldVector3D<RealFieldElement> danV = new FieldVector3D<RealFieldElement>(r2, velocity, (RealFieldElement)pv.negate(), position);
        RealFieldElement recip = (RealFieldElement)this.partialPV.getMomentum().getNorm().reciprocal();
        RealFieldElement recip2 = recip.multiply(recip);
        RealFieldElement recip2N = (RealFieldElement)recip2.negate();
        FieldVector3D<RealFieldElement> dwXP = new FieldVector3D<RealFieldElement>(recip, new FieldVector3D<RealFieldElement>((RealFieldElement)this.zero, (RealFieldElement)vz, (RealFieldElement)vy.negate()), recip2N.multiply(sinRaan).multiply(sinI), danP);
        FieldVector3D<RealFieldElement> dwYP = new FieldVector3D<RealFieldElement>(recip, new FieldVector3D<RealFieldElement>((RealFieldElement)vz.negate(), (RealFieldElement)this.zero, (RealFieldElement)vx), recip2.multiply(cosRaan).multiply(sinI), danP);
        FieldVector3D<RealFieldElement> dwZP = new FieldVector3D<RealFieldElement>(recip, new FieldVector3D<RealFieldElement>((RealFieldElement)vy, (RealFieldElement)vx.negate(), (RealFieldElement)this.zero), recip2N.multiply(cosI), danP);
        FieldVector3D<RealFieldElement> dwXV = new FieldVector3D<RealFieldElement>(recip, new FieldVector3D<RealFieldElement>((RealFieldElement)this.zero, (RealFieldElement)z.negate(), y), recip2N.multiply(sinRaan).multiply(sinI), danV);
        FieldVector3D<RealFieldElement> dwYV = new FieldVector3D<RealFieldElement>(recip, new FieldVector3D<RealFieldElement>(z, (RealFieldElement)this.zero, (RealFieldElement)x.negate()), recip2.multiply(cosRaan).multiply(sinI), danV);
        FieldVector3D<RealFieldElement> dwZV = new FieldVector3D<RealFieldElement>(recip, new FieldVector3D<RealFieldElement>((RealFieldElement)y.negate(), x, (RealFieldElement)this.zero), recip2N.multiply(cosI), danV);
        this.fillHalfRow(sinRaan.multiply(cosI), dwXP, ((RealFieldElement)cosRaan.negate()).multiply(cosI), dwYP, (RealFieldElement)sinI.negate(), dwZP, jacobian[3], 0);
        this.fillHalfRow(sinRaan.multiply(cosI), dwXV, ((RealFieldElement)cosRaan.negate()).multiply(cosI), dwYV, (RealFieldElement)sinI.negate(), dwZV, jacobian[3], 3);
        this.fillHalfRow(sinRaan.divide(sinI), dwYP, cosRaan.divide(sinI), dwXP, jacobian[4], 0);
        this.fillHalfRow(sinRaan.divide(sinI), dwYV, cosRaan.divide(sinI), dwXV, jacobian[4], 3);
        RealFieldElement u = x.multiply((RealFieldElement)cosRaan).add(y.multiply((RealFieldElement)sinRaan));
        RealFieldElement cv = ((RealFieldElement)x.negate()).multiply(sinRaan).add(y.multiply((RealFieldElement)cosRaan));
        RealFieldElement v = cv.multiply(cosI).add(z.multiply((RealFieldElement)sinI));
        FieldVector3D<RealFieldElement> duP = new FieldVector3D<RealFieldElement>(cv.multiply(cosRaan).divide(sinI), dwXP, cv.multiply(sinRaan).divide(sinI), dwYP, (RealFieldElement)this.one, new FieldVector3D<RealFieldElement>(cosRaan, sinRaan, (RealFieldElement)this.zero));
        FieldVector3D<RealFieldElement> duV = new FieldVector3D<RealFieldElement>(cv.multiply(cosRaan).divide(sinI), dwXV, cv.multiply(sinRaan).divide(sinI), dwYV);
        FieldVector3D<RealFieldElement> dvP = new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)u.negate()).multiply(cosRaan).multiply(cosI).divide(sinI).add(sinRaan.multiply(z)), dwXP, (RealFieldElement)((RealFieldElement)u.negate()).multiply(sinRaan).multiply(cosI).divide(sinI).subtract(cosRaan.multiply(z)), dwYP, cv, dwZP, (RealFieldElement)this.one, new FieldVector3D<RealFieldElement>(((RealFieldElement)sinRaan.negate()).multiply(cosI), cosRaan.multiply(cosI), sinI));
        FieldVector3D<RealFieldElement> dvV = new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)u.negate()).multiply(cosRaan).multiply(cosI).divide(sinI).add(sinRaan.multiply(z)), dwXV, (RealFieldElement)((RealFieldElement)u.negate()).multiply(sinRaan).multiply(cosI).divide(sinI).subtract(cosRaan.multiply(z)), dwYV, cv, dwZV);
        FieldVector3D<RealFieldElement> dc1P = new FieldVector3D<RealFieldElement>((RealFieldElement)aOr2.multiply(((RealFieldElement)((RealFieldElement)eSinE.multiply(eSinE).multiply(2)).add(1.0)).subtract(eCosE)).divide(r2), position, ((RealFieldElement)aOr2.multiply(-2)).multiply(eSinE).multiply(oOsqrtMuA), velocity);
        FieldVector3D<RealFieldElement> dc1V = new FieldVector3D<RealFieldElement>(((RealFieldElement)aOr2.multiply(-2)).multiply(eSinE).multiply(oOsqrtMuA), position, (RealFieldElement)((RealFieldElement)this.zero.add(2.0)).divide(mu), velocity);
        FieldVector3D<RealFieldElement> dc2P = new FieldVector3D<RealFieldElement>(((RealFieldElement)aOr2.multiply(eSinE).multiply(eSinE.multiply(eSinE).subtract(((RealFieldElement)e2.negate()).add(1.0)))).divide(r2.multiply((RealFieldElement)epsilon)), position, aOr2.multiply(((RealFieldElement)((RealFieldElement)e2.negate()).add(1.0)).subtract(eSinE.multiply(eSinE))).multiply(oOsqrtMuA).divide(epsilon), velocity);
        FieldVector3D<RealFieldElement> dc2V = new FieldVector3D<RealFieldElement>(aOr2.multiply(((RealFieldElement)((RealFieldElement)e2.negate()).add(1.0)).subtract(eSinE.multiply(eSinE))).multiply(oOsqrtMuA).divide(epsilon), position, (RealFieldElement)eSinE.divide(epsilon.multiply(mu)), velocity);
        RealFieldElement cof1 = aOr2.multiply(eCosE.subtract(e2));
        RealFieldElement cof2 = aOr2.multiply(epsilon).multiply(eSinE);
        FieldVector3D<RealFieldElement> dexP = new FieldVector3D<RealFieldElement>(u, dc1P, v, dc2P, cof1, duP, cof2, dvP);
        FieldVector3D<RealFieldElement> dexV = new FieldVector3D<RealFieldElement>(u, dc1V, v, dc2V, cof1, duV, cof2, dvV);
        FieldVector3D<RealFieldElement> deyP = new FieldVector3D<RealFieldElement>(v, dc1P, (RealFieldElement)u.negate(), dc2P, cof1, dvP, (RealFieldElement)cof2.negate(), duP);
        FieldVector3D<RealFieldElement> deyV = new FieldVector3D<RealFieldElement>(v, dc1V, (RealFieldElement)u.negate(), dc2V, cof1, dvV, (RealFieldElement)cof2.negate(), duV);
        this.fillHalfRow((RealFieldElement)this.one, dexP, jacobian[1], 0);
        this.fillHalfRow((RealFieldElement)this.one, dexV, jacobian[1], 3);
        this.fillHalfRow((RealFieldElement)this.one, deyP, jacobian[2], 0);
        this.fillHalfRow((RealFieldElement)this.one, deyV, jacobian[2], 3);
        RealFieldElement cle = (RealFieldElement)((RealFieldElement)((RealFieldElement)u.divide(this.a)).add(this.ex)).subtract(eSinE.multiply(beta).multiply(this.ey));
        RealFieldElement sle = (RealFieldElement)((RealFieldElement)((RealFieldElement)v.divide(this.a)).add(this.ey)).add(eSinE.multiply(beta).multiply(this.ex));
        RealFieldElement m1 = beta.multiply(eCosE);
        RealFieldElement m2 = (RealFieldElement)((RealFieldElement)m1.multiply(eCosE).negate()).add(1.0);
        RealFieldElement m3 = (RealFieldElement)((RealFieldElement)((RealFieldElement)u.multiply(this.ey)).subtract(v.multiply(this.ex))).add(eSinE.multiply(beta).multiply(((RealFieldElement)u.multiply(this.ex)).add(v.multiply(this.ey))));
        RealFieldElement m4 = ((RealFieldElement)sle.negate()).add(cle.multiply(eSinE).multiply(beta));
        RealFieldElement m5 = cle.add(sle.multiply(eSinE).multiply(beta));
        RealFieldElement kk = (RealFieldElement)((RealFieldElement)m3.multiply(2)).divide(r).add(aOr.multiply(eSinE)).add(m1.multiply(eSinE).multiply(((RealFieldElement)m1.add(1.0)).subtract(((RealFieldElement)aOr.add(1.0)).multiply(m2))).divide(epsilon)).divide(r2);
        RealFieldElement jj = ((RealFieldElement)m1.multiply(m2).divide(epsilon).subtract(1.0)).multiply(oOsqrtMuA);
        this.fillHalfRow(kk, position, jj, velocity, m4, dexP, m5, deyP, (RealFieldElement)((RealFieldElement)sle.negate()).divide(this.a), duP, (RealFieldElement)cle.divide(this.a), dvP, jacobian[5], 0);
        RealFieldElement ll = ((RealFieldElement)m1.multiply(m2).divide(epsilon).subtract(1.0)).multiply(oOsqrtMuA);
        RealFieldElement mm = (RealFieldElement)((RealFieldElement)((RealFieldElement)m3.multiply(2)).add(eSinE.multiply(this.a))).add(m1.multiply(eSinE).multiply(r).multiply(((RealFieldElement)eCosE.multiply(beta).multiply(2)).subtract(aOr.multiply(m2))).divide(epsilon)).divide(mu);
        this.fillHalfRow(ll, position, mm, velocity, m4, dexV, m5, deyV, (RealFieldElement)((RealFieldElement)sle.negate()).divide(this.a), duV, (RealFieldElement)cle.divide(this.a), dvV, jacobian[5], 3);
        return jacobian;
    }

    @Override
    protected T[][] computeJacobianEccentricWrtCartesian() {
        RealFieldElement[][] jacobian = this.computeJacobianMeanWrtCartesian();
        T alphaE = this.getAlphaE();
        RealFieldElement cosAe = (RealFieldElement)alphaE.cos();
        RealFieldElement sinAe = (RealFieldElement)alphaE.sin();
        RealFieldElement aOr = this.one.divide((RealFieldElement)this.one.subtract((RealFieldElement)this.ex.multiply((RealFieldElement)cosAe)).subtract(this.ey.multiply((RealFieldElement)sinAe)));
        RealFieldElement[] rowEx = jacobian[1];
        RealFieldElement[] rowEy = jacobian[2];
        RealFieldElement[] rowL = jacobian[5];
        for (int j = 0; j < 6; ++j) {
            rowL[j] = aOr.multiply(rowL[j].add(sinAe.multiply(rowEx[j])).subtract(cosAe.multiply(rowEy[j])));
        }
        jacobian[5] = rowL;
        return jacobian;
    }

    @Override
    protected T[][] computeJacobianTrueWrtCartesian() {
        RealFieldElement[][] jacobian = this.computeJacobianEccentricWrtCartesian();
        T alphaE = this.getAlphaE();
        RealFieldElement cosAe = (RealFieldElement)alphaE.cos();
        RealFieldElement sinAe = (RealFieldElement)alphaE.sin();
        RealFieldElement eSinE = this.ex.multiply((RealFieldElement)sinAe).subtract(this.ey.multiply((RealFieldElement)cosAe));
        RealFieldElement ecosE = this.ex.multiply((RealFieldElement)cosAe).add(this.ey.multiply((RealFieldElement)sinAe));
        RealFieldElement e2 = (RealFieldElement)((RealFieldElement)this.ex.multiply(this.ex)).add(this.ey.multiply(this.ey));
        RealFieldElement epsilon = (RealFieldElement)this.one.subtract((RealFieldElement)e2).sqrt();
        RealFieldElement onePeps = this.one.add((RealFieldElement)epsilon);
        RealFieldElement d = onePeps.subtract(ecosE);
        RealFieldElement cT = (RealFieldElement)d.multiply(d).add(eSinE.multiply(eSinE)).divide(2.0);
        RealFieldElement cE = ecosE.multiply(onePeps).subtract(e2);
        RealFieldElement cX = ((RealFieldElement)this.ex.multiply((RealFieldElement)eSinE).divide(epsilon).subtract(this.ey)).add(sinAe.multiply(onePeps));
        RealFieldElement cY = ((RealFieldElement)this.ey.multiply((RealFieldElement)eSinE).divide(epsilon).add(this.ex)).subtract(cosAe.multiply(onePeps));
        RealFieldElement factorLe = cT.add(cE).divide(cT);
        RealFieldElement factorEx = cX.divide(cT);
        RealFieldElement factorEy = cY.divide(cT);
        RealFieldElement[] rowEx = jacobian[1];
        RealFieldElement[] rowEy = jacobian[2];
        RealFieldElement[] rowA = jacobian[5];
        for (int j = 0; j < 6; ++j) {
            rowA[j] = factorLe.multiply(rowA[j]).add(factorEx.multiply(rowEx[j])).add(factorEy.multiply(rowEy[j]));
        }
        return jacobian;
    }

    @Override
    public void addKeplerContribution(PositionAngle type, T gm, T[] pDot) {
        RealFieldElement n = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.a.reciprocal()).multiply(gm)).sqrt()).divide(this.a);
        switch (type) {
            case MEAN: {
                pDot[5] = pDot[5].add((RealFieldElement)n);
                break;
            }
            case ECCENTRIC: {
                RealFieldElement oMe2 = (RealFieldElement)((RealFieldElement)this.one.subtract(this.ex.multiply(this.ex))).subtract(this.ey.multiply(this.ey));
                RealFieldElement ksi = (RealFieldElement)((RealFieldElement)this.one.add(this.ex.multiply(this.alphaV.cos()))).add(this.ey.multiply(this.alphaV.sin()));
                pDot[5] = pDot[5].add((RealFieldElement)n.multiply(ksi).divide(oMe2));
                break;
            }
            case TRUE: {
                RealFieldElement oMe2 = (RealFieldElement)((RealFieldElement)this.one.subtract(this.ex.multiply(this.ex))).subtract(this.ey.multiply(this.ey));
                RealFieldElement ksi = (RealFieldElement)((RealFieldElement)this.one.add(this.ex.multiply(this.alphaV.cos()))).add(this.ey.multiply(this.alphaV.sin()));
                pDot[5] = (RealFieldElement)pDot[5].add(n.multiply(ksi).multiply(ksi).divide(oMe2.multiply(oMe2.sqrt())));
                break;
            }
            default: {
                throw new OrekitInternalError(null);
            }
        }
    }

    public String toString() {
        return new StringBuffer().append("circular parameters: ").append('{').append("a: ").append(this.a.getReal()).append(", ex: ").append(this.ex.getReal()).append(", ey: ").append(this.ey.getReal()).append(", i: ").append(FastMath.toDegrees(this.i.getReal())).append(", raan: ").append(FastMath.toDegrees(this.raan.getReal())).append(", alphaV: ").append(FastMath.toDegrees(this.alphaV.getReal())).append(";}").toString();
    }

    public static <T extends RealFieldElement<T>> T normalizeAngle(T a, T center) {
        return (T)((RealFieldElement)a.subtract(Math.PI * 2 * FastMath.floor((a.getReal() + Math.PI - center.getReal()) / (Math.PI * 2))));
    }

    @Override
    public CircularOrbit toOrbit() {
        if (this.hasDerivatives()) {
            return new CircularOrbit(this.a.getReal(), this.ex.getReal(), this.ey.getReal(), this.i.getReal(), this.raan.getReal(), this.alphaV.getReal(), this.aDot.getReal(), this.exDot.getReal(), this.eyDot.getReal(), this.iDot.getReal(), this.raanDot.getReal(), this.alphaVDot.getReal(), PositionAngle.TRUE, this.getFrame(), this.getDate().toAbsoluteDate(), this.getMu().getReal());
        }
        return new CircularOrbit(this.a.getReal(), this.ex.getReal(), this.ey.getReal(), this.i.getReal(), this.raan.getReal(), this.alphaV.getReal(), PositionAngle.TRUE, this.getFrame(), this.getDate().toAbsoluteDate(), this.getMu().getReal());
    }
}

