/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import java.util.Arrays;
import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.CircularOrbit;
import org.orekit.orbits.EquinoctialOrbit;
import org.orekit.orbits.FieldCartesianOrbit;
import org.orekit.orbits.FieldCircularOrbit;
import org.orekit.orbits.FieldEquinoctialOrbit;
import org.orekit.orbits.FieldKeplerianOrbit;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.PositionAngle;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public enum OrbitType {
    CARTESIAN{

        @Override
        public CartesianOrbit convertType(Orbit orbit) {
            return orbit.getType() == this ? (CartesianOrbit)orbit : new CartesianOrbit(orbit);
        }

        @Override
        public void mapOrbitToArray(Orbit orbit, PositionAngle type, double[] stateVector, double[] stateVectorDot) {
            TimeStampedPVCoordinates pv = orbit.getPVCoordinates();
            Vector3D p = pv.getPosition();
            Vector3D v = pv.getVelocity();
            stateVector[0] = p.getX();
            stateVector[1] = p.getY();
            stateVector[2] = p.getZ();
            stateVector[3] = v.getX();
            stateVector[4] = v.getY();
            stateVector[5] = v.getZ();
            if (stateVectorDot != null) {
                Vector3D a = pv.getAcceleration();
                stateVectorDot[0] = v.getX();
                stateVectorDot[1] = v.getY();
                stateVectorDot[2] = v.getZ();
                stateVectorDot[3] = a.getX();
                stateVectorDot[4] = a.getY();
                stateVectorDot[5] = a.getZ();
            }
        }

        @Override
        public CartesianOrbit mapArrayToOrbit(double[] stateVector, double[] stateVectorDot, PositionAngle type, AbsoluteDate date, double mu, Frame frame) {
            Vector3D p = new Vector3D(stateVector[0], stateVector[1], stateVector[2]);
            Vector3D v = new Vector3D(stateVector[3], stateVector[4], stateVector[5]);
            if (stateVectorDot == null) {
                return new CartesianOrbit(new PVCoordinates(p, v), frame, date, mu);
            }
            Vector3D a = new Vector3D(stateVectorDot[3], stateVectorDot[4], stateVectorDot[5]);
            return new CartesianOrbit(new PVCoordinates(p, v, a), frame, date, mu);
        }

        public <T extends RealFieldElement<T>> FieldCartesianOrbit<T> convertType(FieldOrbit<T> orbit) {
            return orbit.getType() == this ? (FieldCartesianOrbit)orbit : new FieldCartesianOrbit<T>(orbit);
        }

        @Override
        public <T extends RealFieldElement<T>> void mapOrbitToArray(FieldOrbit<T> orbit, PositionAngle type, T[] stateVector, T[] stateVectorDot) {
            TimeStampedFieldPVCoordinates<T> pv = orbit.getPVCoordinates();
            FieldVector3D p = pv.getPosition();
            FieldVector3D v = pv.getVelocity();
            stateVector[0] = p.getX();
            stateVector[1] = p.getY();
            stateVector[2] = p.getZ();
            stateVector[3] = v.getX();
            stateVector[4] = v.getY();
            stateVector[5] = v.getZ();
            if (stateVectorDot != null) {
                FieldVector3D a = pv.getAcceleration();
                stateVectorDot[0] = v.getX();
                stateVectorDot[1] = v.getY();
                stateVectorDot[2] = v.getZ();
                stateVectorDot[3] = a.getX();
                stateVectorDot[4] = a.getY();
                stateVectorDot[5] = a.getZ();
            }
        }

        public <T extends RealFieldElement<T>> FieldCartesianOrbit<T> mapArrayToOrbit(T[] stateVector, T[] stateVectorDot, PositionAngle type, FieldAbsoluteDate<T> date, T mu, Frame frame) {
            FieldVector3D<T> p = new FieldVector3D<T>(stateVector[0], stateVector[1], stateVector[2]);
            FieldVector3D<T> v = new FieldVector3D<T>(stateVector[3], stateVector[4], stateVector[5]);
            if (stateVectorDot == null) {
                return new FieldCartesianOrbit<T>(new FieldPVCoordinates<T>(p, v), frame, date, mu);
            }
            FieldVector3D<T> a = new FieldVector3D<T>(stateVectorDot[3], stateVectorDot[4], stateVectorDot[5]);
            return new FieldCartesianOrbit<T>(new FieldPVCoordinates<T>(p, v, a), frame, date, mu);
        }

        @Override
        public ParameterDriversList getDrivers(double dP, Orbit orbit, PositionAngle type) {
            ParameterDriversList drivers = new ParameterDriversList();
            double[] array = new double[6];
            this.mapOrbitToArray(orbit, type, array, null);
            double[] scale = this.scale(dP, orbit);
            drivers.add(new ParameterDriver(OrbitType.POS_X, array[0], scale[0], Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            drivers.add(new ParameterDriver(OrbitType.POS_Y, array[1], scale[1], Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            drivers.add(new ParameterDriver(OrbitType.POS_Z, array[2], scale[2], Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            drivers.add(new ParameterDriver(OrbitType.VEL_X, array[3], scale[3], Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            drivers.add(new ParameterDriver(OrbitType.VEL_Y, array[4], scale[4], Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            drivers.add(new ParameterDriver(OrbitType.VEL_Z, array[5], scale[5], Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            return drivers;
        }
    }
    ,
    CIRCULAR{

        @Override
        public CircularOrbit convertType(Orbit orbit) {
            return orbit.getType() == this ? (CircularOrbit)orbit : new CircularOrbit(orbit);
        }

        @Override
        public void mapOrbitToArray(Orbit orbit, PositionAngle type, double[] stateVector, double[] stateVectorDot) {
            CircularOrbit circularOrbit = (CircularOrbit)CIRCULAR.convertType(orbit);
            stateVector[0] = circularOrbit.getA();
            stateVector[1] = circularOrbit.getCircularEx();
            stateVector[2] = circularOrbit.getCircularEy();
            stateVector[3] = circularOrbit.getI();
            stateVector[4] = circularOrbit.getRightAscensionOfAscendingNode();
            stateVector[5] = circularOrbit.getAlpha(type);
            if (stateVectorDot != null) {
                if (orbit.hasDerivatives()) {
                    stateVectorDot[0] = circularOrbit.getADot();
                    stateVectorDot[1] = circularOrbit.getCircularExDot();
                    stateVectorDot[2] = circularOrbit.getCircularEyDot();
                    stateVectorDot[3] = circularOrbit.getIDot();
                    stateVectorDot[4] = circularOrbit.getRightAscensionOfAscendingNodeDot();
                    stateVectorDot[5] = circularOrbit.getAlphaDot(type);
                } else {
                    Arrays.fill(stateVectorDot, 0, 6, Double.NaN);
                }
            }
        }

        @Override
        public CircularOrbit mapArrayToOrbit(double[] stateVector, double[] stateVectorDot, PositionAngle type, AbsoluteDate date, double mu, Frame frame) {
            if (stateVectorDot == null) {
                return new CircularOrbit(stateVector[0], stateVector[1], stateVector[2], stateVector[3], stateVector[4], stateVector[5], type, frame, date, mu);
            }
            return new CircularOrbit(stateVector[0], stateVector[1], stateVector[2], stateVector[3], stateVector[4], stateVector[5], stateVectorDot[0], stateVectorDot[1], stateVectorDot[2], stateVectorDot[3], stateVectorDot[4], stateVectorDot[5], type, frame, date, mu);
        }

        public <T extends RealFieldElement<T>> FieldCircularOrbit<T> convertType(FieldOrbit<T> orbit) {
            return orbit.getType() == this ? (FieldCircularOrbit)orbit : new FieldCircularOrbit<T>(orbit);
        }

        @Override
        public <T extends RealFieldElement<T>> void mapOrbitToArray(FieldOrbit<T> orbit, PositionAngle type, T[] stateVector, T[] stateVectorDot) {
            FieldCircularOrbit circularOrbit = (FieldCircularOrbit)CIRCULAR.convertType(orbit);
            stateVector[0] = circularOrbit.getA();
            stateVector[1] = circularOrbit.getCircularEx();
            stateVector[2] = circularOrbit.getCircularEy();
            stateVector[3] = circularOrbit.getI();
            stateVector[4] = circularOrbit.getRightAscensionOfAscendingNode();
            stateVector[5] = circularOrbit.getAlpha(type);
            if (stateVectorDot != null) {
                if (orbit.hasDerivatives()) {
                    stateVectorDot[0] = circularOrbit.getADot();
                    stateVectorDot[1] = circularOrbit.getCircularExDot();
                    stateVectorDot[2] = circularOrbit.getCircularEyDot();
                    stateVectorDot[3] = circularOrbit.getIDot();
                    stateVectorDot[4] = circularOrbit.getRightAscensionOfAscendingNodeDot();
                    stateVectorDot[5] = circularOrbit.getAlphaDot(type);
                } else {
                    Arrays.fill(stateVectorDot, 0, 6, ((RealFieldElement)orbit.getDate().getField().getZero()).add(Double.NaN));
                }
            }
        }

        public <T extends RealFieldElement<T>> FieldCircularOrbit<T> mapArrayToOrbit(T[] stateVector, T[] stateVectorDot, PositionAngle type, FieldAbsoluteDate<T> date, T mu, Frame frame) {
            if (stateVectorDot == null) {
                return new FieldCircularOrbit<T>(stateVector[0], stateVector[1], stateVector[2], stateVector[3], stateVector[4], stateVector[5], type, frame, date, mu);
            }
            return new FieldCircularOrbit<T>(stateVector[0], stateVector[1], stateVector[2], stateVector[3], stateVector[4], stateVector[5], stateVectorDot[0], stateVectorDot[1], stateVectorDot[2], stateVectorDot[3], stateVectorDot[4], stateVectorDot[5], type, frame, date, mu);
        }

        @Override
        public ParameterDriversList getDrivers(double dP, Orbit orbit, PositionAngle type) {
            ParameterDriversList drivers = new ParameterDriversList();
            double[] array = new double[6];
            this.mapOrbitToArray(orbit, type, array, null);
            double[] scale = this.scale(dP, orbit);
            String name = type == PositionAngle.MEAN ? OrbitType.MEAN_LAT_ARG : (type == PositionAngle.ECCENTRIC ? OrbitType.ECC_LAT_ARG : OrbitType.TRUE_LAT_ARG);
            drivers.add(new ParameterDriver(OrbitType.A, array[0], scale[0], 0.0, Double.POSITIVE_INFINITY));
            drivers.add(new ParameterDriver(OrbitType.E_X, array[1], scale[1], -1.0, 1.0));
            drivers.add(new ParameterDriver(OrbitType.E_Y, array[2], scale[2], -1.0, 1.0));
            drivers.add(new ParameterDriver(OrbitType.INC, array[3], scale[3], 0.0, Math.PI));
            drivers.add(new ParameterDriver(OrbitType.RAAN, array[4], scale[4], Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            drivers.add(new ParameterDriver(name, array[5], scale[5], Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            return drivers;
        }
    }
    ,
    EQUINOCTIAL{

        @Override
        public EquinoctialOrbit convertType(Orbit orbit) {
            return orbit.getType() == this ? (EquinoctialOrbit)orbit : new EquinoctialOrbit(orbit);
        }

        @Override
        public void mapOrbitToArray(Orbit orbit, PositionAngle type, double[] stateVector, double[] stateVectorDot) {
            EquinoctialOrbit equinoctialOrbit = (EquinoctialOrbit)EQUINOCTIAL.convertType(orbit);
            stateVector[0] = equinoctialOrbit.getA();
            stateVector[1] = equinoctialOrbit.getEquinoctialEx();
            stateVector[2] = equinoctialOrbit.getEquinoctialEy();
            stateVector[3] = equinoctialOrbit.getHx();
            stateVector[4] = equinoctialOrbit.getHy();
            stateVector[5] = equinoctialOrbit.getL(type);
            if (stateVectorDot != null) {
                if (orbit.hasDerivatives()) {
                    stateVectorDot[0] = equinoctialOrbit.getADot();
                    stateVectorDot[1] = equinoctialOrbit.getEquinoctialExDot();
                    stateVectorDot[2] = equinoctialOrbit.getEquinoctialEyDot();
                    stateVectorDot[3] = equinoctialOrbit.getHxDot();
                    stateVectorDot[4] = equinoctialOrbit.getHyDot();
                    stateVectorDot[5] = equinoctialOrbit.getLDot(type);
                } else {
                    Arrays.fill(stateVectorDot, 0, 6, Double.NaN);
                }
            }
        }

        @Override
        public EquinoctialOrbit mapArrayToOrbit(double[] stateVector, double[] stateVectorDot, PositionAngle type, AbsoluteDate date, double mu, Frame frame) {
            if (stateVectorDot == null) {
                return new EquinoctialOrbit(stateVector[0], stateVector[1], stateVector[2], stateVector[3], stateVector[4], stateVector[5], type, frame, date, mu);
            }
            return new EquinoctialOrbit(stateVector[0], stateVector[1], stateVector[2], stateVector[3], stateVector[4], stateVector[5], stateVectorDot[0], stateVectorDot[1], stateVectorDot[2], stateVectorDot[3], stateVectorDot[4], stateVectorDot[5], type, frame, date, mu);
        }

        public <T extends RealFieldElement<T>> FieldEquinoctialOrbit<T> convertType(FieldOrbit<T> orbit) {
            return orbit.getType() == this ? (FieldEquinoctialOrbit)orbit : new FieldEquinoctialOrbit<T>(orbit);
        }

        @Override
        public <T extends RealFieldElement<T>> void mapOrbitToArray(FieldOrbit<T> orbit, PositionAngle type, T[] stateVector, T[] stateVectorDot) {
            FieldEquinoctialOrbit equinoctialOrbit = (FieldEquinoctialOrbit)EQUINOCTIAL.convertType(orbit);
            stateVector[0] = equinoctialOrbit.getA();
            stateVector[1] = equinoctialOrbit.getEquinoctialEx();
            stateVector[2] = equinoctialOrbit.getEquinoctialEy();
            stateVector[3] = equinoctialOrbit.getHx();
            stateVector[4] = equinoctialOrbit.getHy();
            stateVector[5] = equinoctialOrbit.getL(type);
            if (stateVectorDot != null) {
                if (orbit.hasDerivatives()) {
                    stateVectorDot[0] = equinoctialOrbit.getADot();
                    stateVectorDot[1] = equinoctialOrbit.getEquinoctialExDot();
                    stateVectorDot[2] = equinoctialOrbit.getEquinoctialEyDot();
                    stateVectorDot[3] = equinoctialOrbit.getHxDot();
                    stateVectorDot[4] = equinoctialOrbit.getHyDot();
                    stateVectorDot[5] = equinoctialOrbit.getLDot(type);
                } else {
                    Arrays.fill(stateVectorDot, 0, 6, ((RealFieldElement)orbit.getDate().getField().getZero()).add(Double.NaN));
                }
            }
        }

        public <T extends RealFieldElement<T>> FieldEquinoctialOrbit<T> mapArrayToOrbit(T[] stateVector, T[] stateVectorDot, PositionAngle type, FieldAbsoluteDate<T> date, T mu, Frame frame) {
            if (stateVectorDot == null) {
                return new FieldEquinoctialOrbit<T>(stateVector[0], stateVector[1], stateVector[2], stateVector[3], stateVector[4], stateVector[5], type, frame, date, mu);
            }
            return new FieldEquinoctialOrbit<T>(stateVector[0], stateVector[1], stateVector[2], stateVector[3], stateVector[4], stateVector[5], stateVectorDot[0], stateVectorDot[1], stateVectorDot[2], stateVectorDot[3], stateVectorDot[4], stateVectorDot[5], type, frame, date, mu);
        }

        @Override
        public ParameterDriversList getDrivers(double dP, Orbit orbit, PositionAngle type) {
            ParameterDriversList drivers = new ParameterDriversList();
            double[] array = new double[6];
            this.mapOrbitToArray(orbit, type, array, null);
            double[] scale = this.scale(dP, orbit);
            String name = type == PositionAngle.MEAN ? OrbitType.MEAN_LON_ARG : (type == PositionAngle.ECCENTRIC ? OrbitType.ECC_LON_ARG : OrbitType.TRUE_LON_ARG);
            drivers.add(new ParameterDriver(OrbitType.A, array[0], scale[0], 0.0, Double.POSITIVE_INFINITY));
            drivers.add(new ParameterDriver(OrbitType.E_X, array[1], scale[1], -1.0, 1.0));
            drivers.add(new ParameterDriver(OrbitType.E_Y, array[2], scale[2], -1.0, 1.0));
            drivers.add(new ParameterDriver(OrbitType.H_X, array[3], scale[3], Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            drivers.add(new ParameterDriver(OrbitType.H_Y, array[4], scale[4], Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            drivers.add(new ParameterDriver(name, array[5], scale[5], Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            return drivers;
        }
    }
    ,
    KEPLERIAN{

        @Override
        public KeplerianOrbit convertType(Orbit orbit) {
            return orbit.getType() == this ? (KeplerianOrbit)orbit : new KeplerianOrbit(orbit);
        }

        @Override
        public void mapOrbitToArray(Orbit orbit, PositionAngle type, double[] stateVector, double[] stateVectorDot) {
            KeplerianOrbit keplerianOrbit = (KeplerianOrbit)KEPLERIAN.convertType(orbit);
            stateVector[0] = keplerianOrbit.getA();
            stateVector[1] = keplerianOrbit.getE();
            stateVector[2] = keplerianOrbit.getI();
            stateVector[3] = keplerianOrbit.getPerigeeArgument();
            stateVector[4] = keplerianOrbit.getRightAscensionOfAscendingNode();
            stateVector[5] = keplerianOrbit.getAnomaly(type);
            if (stateVectorDot != null) {
                if (orbit.hasDerivatives()) {
                    stateVectorDot[0] = keplerianOrbit.getADot();
                    stateVectorDot[1] = keplerianOrbit.getEDot();
                    stateVectorDot[2] = keplerianOrbit.getIDot();
                    stateVectorDot[3] = keplerianOrbit.getPerigeeArgumentDot();
                    stateVectorDot[4] = keplerianOrbit.getRightAscensionOfAscendingNodeDot();
                    stateVectorDot[5] = keplerianOrbit.getAnomalyDot(type);
                } else {
                    Arrays.fill(stateVectorDot, 0, 6, Double.NaN);
                }
            }
        }

        @Override
        public KeplerianOrbit mapArrayToOrbit(double[] stateVector, double[] stateVectorDot, PositionAngle type, AbsoluteDate date, double mu, Frame frame) {
            if (stateVectorDot == null) {
                return new KeplerianOrbit(stateVector[0], stateVector[1], stateVector[2], stateVector[3], stateVector[4], stateVector[5], type, frame, date, mu);
            }
            return new KeplerianOrbit(stateVector[0], stateVector[1], stateVector[2], stateVector[3], stateVector[4], stateVector[5], stateVectorDot[0], stateVectorDot[1], stateVectorDot[2], stateVectorDot[3], stateVectorDot[4], stateVectorDot[5], type, frame, date, mu);
        }

        public <T extends RealFieldElement<T>> FieldKeplerianOrbit<T> convertType(FieldOrbit<T> orbit) {
            return orbit.getType() == this ? (FieldKeplerianOrbit)orbit : new FieldKeplerianOrbit<T>(orbit);
        }

        @Override
        public <T extends RealFieldElement<T>> void mapOrbitToArray(FieldOrbit<T> orbit, PositionAngle type, T[] stateVector, T[] stateVectorDot) {
            FieldKeplerianOrbit keplerianOrbit = (FieldKeplerianOrbit)KEPLERIAN.convertType(orbit);
            stateVector[0] = keplerianOrbit.getA();
            stateVector[1] = keplerianOrbit.getE();
            stateVector[2] = keplerianOrbit.getI();
            stateVector[3] = keplerianOrbit.getPerigeeArgument();
            stateVector[4] = keplerianOrbit.getRightAscensionOfAscendingNode();
            stateVector[5] = keplerianOrbit.getAnomaly(type);
            if (stateVectorDot != null) {
                if (orbit.hasDerivatives()) {
                    stateVectorDot[0] = keplerianOrbit.getADot();
                    stateVectorDot[1] = keplerianOrbit.getEDot();
                    stateVectorDot[2] = keplerianOrbit.getIDot();
                    stateVectorDot[3] = keplerianOrbit.getPerigeeArgumentDot();
                    stateVectorDot[4] = keplerianOrbit.getRightAscensionOfAscendingNodeDot();
                    stateVectorDot[5] = keplerianOrbit.getAnomalyDot(type);
                } else {
                    Arrays.fill(stateVectorDot, 0, 6, ((RealFieldElement)orbit.getDate().getField().getZero()).add(Double.NaN));
                }
            }
        }

        public <T extends RealFieldElement<T>> FieldKeplerianOrbit<T> mapArrayToOrbit(T[] stateVector, T[] stateVectorDot, PositionAngle type, FieldAbsoluteDate<T> date, T mu, Frame frame) {
            if (stateVectorDot == null) {
                return new FieldKeplerianOrbit<T>(stateVector[0], stateVector[1], stateVector[2], stateVector[3], stateVector[4], stateVector[5], type, frame, date, mu);
            }
            return new FieldKeplerianOrbit<T>(stateVector[0], stateVector[1], stateVector[2], stateVector[3], stateVector[4], stateVector[5], stateVectorDot[0], stateVectorDot[1], stateVectorDot[2], stateVectorDot[3], stateVectorDot[4], stateVectorDot[5], type, frame, date, mu);
        }

        @Override
        public ParameterDriversList getDrivers(double dP, Orbit orbit, PositionAngle type) {
            ParameterDriversList drivers = new ParameterDriversList();
            double[] array = new double[6];
            this.mapOrbitToArray(orbit, type, array, null);
            double[] scale = this.scale(dP, orbit);
            String name = type == PositionAngle.MEAN ? OrbitType.MEAN_ANOM : (type == PositionAngle.ECCENTRIC ? OrbitType.ECC_ANOM : OrbitType.TRUE_ANOM);
            drivers.add(new ParameterDriver(OrbitType.A, array[0], scale[0], 0.0, Double.POSITIVE_INFINITY));
            drivers.add(new ParameterDriver(OrbitType.ECC, array[1], scale[1], 0.0, 1.0));
            drivers.add(new ParameterDriver(OrbitType.INC, array[2], scale[2], 0.0, Math.PI));
            drivers.add(new ParameterDriver(OrbitType.PA, array[3], scale[3], Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            drivers.add(new ParameterDriver(OrbitType.RAAN, array[4], scale[4], Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            drivers.add(new ParameterDriver(name, array[5], scale[5], Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            return drivers;
        }
    };

    private static final String POS_X = "Px";
    private static final String POS_Y = "Py";
    private static final String POS_Z = "Pz";
    private static final String VEL_X = "Vx";
    private static final String VEL_Y = "Vy";
    private static final String VEL_Z = "Vz";
    private static final String A = "a";
    private static final String ECC = "e";
    private static final String E_X = "ex";
    private static final String E_Y = "ey";
    private static final String INC = "i";
    private static final String H_X = "hx";
    private static final String H_Y = "hy";
    private static final String PA = "\u03c9";
    private static final String RAAN = "\u03a9";
    private static final String MEAN_ANOM = "M";
    private static final String ECC_ANOM = "E";
    private static final String TRUE_ANOM = "v";
    private static final String MEAN_LAT_ARG = "\u03b1M";
    private static final String ECC_LAT_ARG = "\u03b1E";
    private static final String TRUE_LAT_ARG = "\u03b1v";
    private static final String MEAN_LON_ARG = "\u03bbM";
    private static final String ECC_LON_ARG = "\u03bbE";
    private static final String TRUE_LON_ARG = "\u03bbv";

    public abstract Orbit convertType(Orbit var1);

    public abstract void mapOrbitToArray(Orbit var1, PositionAngle var2, double[] var3, double[] var4);

    public abstract Orbit mapArrayToOrbit(double[] var1, double[] var2, PositionAngle var3, AbsoluteDate var4, double var5, Frame var7);

    public abstract <T extends RealFieldElement<T>> FieldOrbit<T> convertType(FieldOrbit<T> var1);

    public abstract <T extends RealFieldElement<T>> void mapOrbitToArray(FieldOrbit<T> var1, PositionAngle var2, T[] var3, T[] var4);

    public abstract <T extends RealFieldElement<T>> FieldOrbit<T> mapArrayToOrbit(T[] var1, T[] var2, PositionAngle var3, FieldAbsoluteDate<T> var4, T var5, Frame var6);

    public abstract ParameterDriversList getDrivers(double var1, Orbit var3, PositionAngle var4);

    protected double[] scale(double dP, Orbit orbit) {
        TimeStampedPVCoordinates pv = orbit.getPVCoordinates();
        double r2 = pv.getPosition().getNormSq();
        double v = pv.getVelocity().getNorm();
        double dV = orbit.getMu() * dP / (v * r2);
        double[] scale = new double[6];
        double[][] jacobian = new double[6][6];
        Orbit converted = this.convertType(orbit);
        converted.getJacobianWrtCartesian(PositionAngle.TRUE, jacobian);
        for (int i = 0; i < 6; ++i) {
            double[] row = jacobian[i];
            scale[i] = FastMath.abs(row[0]) * dP + FastMath.abs(row[1]) * dP + FastMath.abs(row[2]) * dP + FastMath.abs(row[3]) * dV + FastMath.abs(row[4]) * dV + FastMath.abs(row[5]) * dV;
            if (!Double.isNaN(scale[i])) continue;
            throw new OrekitException((Localizable)OrekitMessages.SINGULAR_JACOBIAN_FOR_ORBIT_TYPE, new Object[]{this});
        }
        return scale;
    }
}

