/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.gnss;

import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.Precision;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalPropagator;
import org.orekit.propagation.analytical.gnss.GNSSOrbitalElements;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;

public abstract class AbstractGNSSPropagator
extends AbstractAnalyticalPropagator {
    private static final double A;
    private static final double B;
    private final GNSSOrbitalElements gnssOrbit;
    private final double av;
    private final double cycleDuration;
    private final double mass;
    private final double mu;
    private final Frame eci;
    private final Frame ecef;
    private final DSFactory factory;

    protected AbstractGNSSPropagator(GNSSOrbitalElements gnssOrbit, AttitudeProvider attitudeProvider, Frame eci, Frame ecef, double mass, double av, double cycleDuration, double mu) {
        super(attitudeProvider);
        this.gnssOrbit = gnssOrbit;
        this.av = av;
        this.cycleDuration = cycleDuration;
        this.mass = mass;
        this.mu = mu;
        this.factory = new DSFactory(1, 2);
        this.eci = eci;
        this.ecef = ecef;
        this.setStartDate(gnssOrbit.getDate());
    }

    private double getTk(AbsoluteDate date) {
        double tk;
        for (tk = date.durationFrom(this.gnssOrbit.getDate()); tk > 0.5 * this.cycleDuration; tk -= this.cycleDuration) {
        }
        while (tk < -0.5 * this.cycleDuration) {
            tk += this.cycleDuration;
        }
        return tk;
    }

    public PVCoordinates propagateInEcef(AbsoluteDate date) {
        DerivativeStructure tk = this.factory.variable(0, this.getTk(date));
        DerivativeStructure mk = tk.multiply(this.gnssOrbit.getMeanMotion()).add(this.gnssOrbit.getM0());
        DerivativeStructure ek = this.getEccentricAnomaly(mk);
        DerivativeStructure vk = this.getTrueAnomaly(ek);
        DerivativeStructure phik = vk.add(this.gnssOrbit.getPa());
        DerivativeStructure twoPhik = phik.multiply(2);
        DerivativeStructure c2phi = twoPhik.cos();
        DerivativeStructure s2phi = twoPhik.sin();
        DerivativeStructure dphik = c2phi.multiply(this.gnssOrbit.getCuc()).add(s2phi.multiply(this.gnssOrbit.getCus()));
        DerivativeStructure drk = c2phi.multiply(this.gnssOrbit.getCrc()).add(s2phi.multiply(this.gnssOrbit.getCrs()));
        DerivativeStructure dik = c2phi.multiply(this.gnssOrbit.getCic()).add(s2phi.multiply(this.gnssOrbit.getCis()));
        DerivativeStructure uk = phik.add(dphik);
        DerivativeStructure rk = ek.cos().multiply(-this.gnssOrbit.getE()).add(1.0).multiply(this.gnssOrbit.getSma()).add(drk);
        DerivativeStructure ik = tk.multiply(this.gnssOrbit.getIDot()).add(this.gnssOrbit.getI0()).add(dik);
        DerivativeStructure cik = ik.cos();
        DerivativeStructure xk = uk.cos().multiply(rk);
        DerivativeStructure yk = uk.sin().multiply(rk);
        DerivativeStructure omk = tk.multiply(this.gnssOrbit.getOmegaDot() - this.av).add(this.gnssOrbit.getOmega0() - this.av * this.gnssOrbit.getTime());
        DerivativeStructure comk = omk.cos();
        DerivativeStructure somk = omk.sin();
        FieldVector3D<DerivativeStructure> positionwithDerivatives = new FieldVector3D<DerivativeStructure>(xk.multiply(comk).subtract(yk.multiply(somk).multiply(cik)), xk.multiply(somk).add(yk.multiply(comk).multiply(cik)), yk.multiply(ik.sin()));
        return new PVCoordinates(positionwithDerivatives);
    }

    private DerivativeStructure getEccentricAnomaly(DerivativeStructure mk) {
        DerivativeStructure ek;
        double[] mlDerivatives = mk.getAllDerivatives();
        mlDerivatives[0] = MathUtils.normalizeAngle(mlDerivatives[0], 0.0);
        DerivativeStructure reducedM = mk.getFactory().build(mlDerivatives);
        if (FastMath.abs(reducedM.getValue()) < 0.16666666666666666) {
            ek = FastMath.abs(reducedM.getValue()) < Precision.SAFE_MIN ? reducedM : reducedM.add(reducedM.multiply(6).cbrt().subtract(reducedM).multiply(this.gnssOrbit.getE()));
        } else if (reducedM.getValue() < 0.0) {
            DerivativeStructure w = reducedM.add(Math.PI);
            ek = reducedM.add(w.multiply(-A).divide(w.subtract(B)).subtract(Math.PI).subtract(reducedM).multiply(this.gnssOrbit.getE()));
        } else {
            DerivativeStructure minusW = reducedM.subtract(Math.PI);
            ek = reducedM.add(minusW.multiply(A).divide(minusW.add(B)).add(Math.PI).subtract(reducedM).multiply(this.gnssOrbit.getE()));
        }
        double e1 = 1.0 - this.gnssOrbit.getE();
        boolean noCancellationRisk = e1 + ek.getValue() * ek.getValue() / 6.0 >= 0.1;
        for (int j = 0; j < 2; ++j) {
            DerivativeStructure fd;
            DerivativeStructure f;
            DerivativeStructure fdd = ek.sin().multiply(this.gnssOrbit.getE());
            DerivativeStructure fddd = ek.cos().multiply(this.gnssOrbit.getE());
            if (noCancellationRisk) {
                f = ek.subtract(fdd).subtract(reducedM);
                fd = fddd.subtract(1.0).negate();
            } else {
                f = this.eMeSinE(ek).subtract(reducedM);
                DerivativeStructure s = ek.multiply(0.5).sin();
                fd = s.multiply(s).multiply(2.0 * this.gnssOrbit.getE()).add(e1);
            }
            DerivativeStructure dee = f.multiply(fd).divide(f.multiply(0.5).multiply(fdd).subtract(fd.multiply(fd)));
            DerivativeStructure w = fd.add(dee.multiply(0.5).multiply(fdd.add(dee.multiply(fdd).divide(3.0))));
            fd = fd.add(dee.multiply(fdd.add(dee.multiply(0.5).multiply(fdd))));
            ek = ek.subtract(f.subtract(dee.multiply(fd.subtract(w))).divide(fd));
        }
        ek = ek.add(mk.getValue() - reducedM.getValue());
        return ek;
    }

    private DerivativeStructure eMeSinE(DerivativeStructure E) {
        DerivativeStructure x = E.sin().multiply(1.0 - this.gnssOrbit.getE());
        DerivativeStructure mE2 = E.negate().multiply(E);
        DerivativeStructure term = E;
        DerivativeStructure d = E.getField().getZero();
        DerivativeStructure x0 = d.add(Double.NaN);
        while (!Double.valueOf(x.getValue()).equals(x0.getValue())) {
            d = d.add(2.0);
            term = term.multiply(mE2.divide(d.multiply(d.add(1.0))));
            x0 = x;
            x = x.subtract(term);
        }
        return x;
    }

    private DerivativeStructure getTrueAnomaly(DerivativeStructure ek) {
        DerivativeStructure svk = ek.sin().multiply(FastMath.sqrt(1.0 - this.gnssOrbit.getE() * this.gnssOrbit.getE()));
        DerivativeStructure cvk = ek.cos().subtract(this.gnssOrbit.getE());
        return svk.atan2(cvk);
    }

    @Override
    protected Orbit propagateOrbit(AbsoluteDate date) {
        PVCoordinates pvaInECEF = this.propagateInEcef(date);
        PVCoordinates pvaInECI = this.ecef.getTransformTo(this.eci, date).transformPVCoordinates(pvaInECEF);
        return new CartesianOrbit(pvaInECI, this.eci, date, this.mu);
    }

    public double getMU() {
        return this.mu;
    }

    @Override
    public Frame getFrame() {
        return this.eci;
    }

    @Override
    protected double getMass(AbsoluteDate date) {
        return this.mass;
    }

    @Override
    public void resetInitialState(SpacecraftState state) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    protected void resetIntermediateState(SpacecraftState state, boolean forward) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    public Frame getECI() {
        return this.eci;
    }

    public Frame getECEF() {
        return this.ecef;
    }

    static {
        double k1 = 11.42477796076938;
        double k2 = 2.141592653589793;
        double k3 = 17.84955592153876;
        A = 1.2043347651023166;
        B = 4.64788969626918;
    }
}

