/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.gnss;

import org.orekit.attitudes.AttitudeProvider;
import org.orekit.frames.Frame;
import org.orekit.frames.FramesFactory;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.analytical.gnss.AbstractGNSSPropagator;
import org.orekit.propagation.analytical.gnss.GalileoOrbitalElements;
import org.orekit.utils.IERSConventions;

public class GalileoPropagator
extends AbstractGNSSPropagator {
    private static final double GALILEO_AV = 7.2921151467E-5;
    private static final double GALILEO_CYCLE_DURATION = 2.4772608E9;
    private final GalileoOrbitalElements galileoOrbit;

    private GalileoPropagator(Builder builder) {
        super(builder.orbit, builder.attitudeProvider, builder.eci, builder.ecef, builder.mass, 7.2921151467E-5, 2.4772608E9, 3.986004418E14);
        this.galileoOrbit = builder.orbit;
    }

    public GalileoOrbitalElements getGalileoOrbitalElements() {
        return this.galileoOrbit;
    }

    public static class Builder {
        private final GalileoOrbitalElements orbit;
        private AttitudeProvider attitudeProvider = Propagator.DEFAULT_LAW;
        private double mass = 1000.0;
        private Frame eci = null;
        private Frame ecef = null;

        public Builder(GalileoOrbitalElements galileoOrbElt) {
            this.orbit = galileoOrbElt;
            this.eci = FramesFactory.getEME2000();
            this.ecef = FramesFactory.getITRF(IERSConventions.IERS_2010, true);
        }

        public Builder attitudeProvider(AttitudeProvider userProvider) {
            this.attitudeProvider = userProvider;
            return this;
        }

        public Builder mass(double userMass) {
            this.mass = userMass;
            return this;
        }

        public Builder eci(Frame inertial) {
            this.eci = inertial;
            return this;
        }

        public Builder ecef(Frame bodyFixed) {
            this.ecef = bodyFixed;
            return this;
        }

        public GalileoPropagator build() {
            return new GalileoPropagator(this);
        }
    }
}

