/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.tle;

import org.hipparchus.util.FastMath;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.propagation.analytical.tle.TLE;
import org.orekit.propagation.analytical.tle.TLEPropagator;

public class SGP4
extends TLEPropagator {
    private boolean lessThan220;
    private double delM0;
    private double d2;
    private double d3;
    private double d4;
    private double t3cof;
    private double t4cof;
    private double t5cof;
    private double sinM0;
    private double omgcof;
    private double xmcof;
    private double c5;

    public SGP4(TLE initialTLE, AttitudeProvider attitudeProvider, double mass) {
        super(initialTLE, attitudeProvider, mass);
    }

    @Override
    protected void sxpInitialize() {
        boolean bl = this.lessThan220 = this.perige < 220.0;
        if (!this.lessThan220) {
            double c1sq = this.c1 * this.c1;
            this.delM0 = 1.0 + this.eta * FastMath.cos(this.tle.getMeanAnomaly());
            this.delM0 *= this.delM0 * this.delM0;
            this.d2 = 4.0 * this.a0dp * this.tsi * c1sq;
            double temp = this.d2 * this.tsi * this.c1 / 3.0;
            this.d3 = (17.0 * this.a0dp + this.s4) * temp;
            this.d4 = 0.5 * temp * this.a0dp * this.tsi * (221.0 * this.a0dp + 31.0 * this.s4) * this.c1;
            this.t3cof = this.d2 + 2.0 * c1sq;
            this.t4cof = 0.25 * (3.0 * this.d3 + this.c1 * (12.0 * this.d2 + 10.0 * c1sq));
            this.t5cof = 0.2 * (3.0 * this.d4 + 12.0 * this.c1 * this.d3 + 6.0 * this.d2 * this.d2 + 15.0 * c1sq * (2.0 * this.d2 + c1sq));
            this.sinM0 = FastMath.sin(this.tle.getMeanAnomaly());
            if (this.tle.getE() < 1.0E-4) {
                this.omgcof = 0.0;
                this.xmcof = 0.0;
            } else {
                double c3 = this.coef * this.tsi * 0.004690139440023056 * this.xn0dp * 1.0 * this.sini0 / this.tle.getE();
                this.xmcof = -0.6666666666666666 * this.coef * this.tle.getBStar() * 1.0 / this.eeta;
                this.omgcof = this.tle.getBStar() * c3 * FastMath.cos(this.tle.getPerigeeArgument());
            }
        }
        this.c5 = 2.0 * this.coef1 * this.a0dp * this.beta02 * (1.0 + 2.75 * (this.etasq + this.eeta) + this.eeta * this.etasq);
    }

    @Override
    protected void sxpPropagate(double tSince) {
        double xmdf = this.tle.getMeanAnomaly() + this.xmdot * tSince;
        double omgadf = this.tle.getPerigeeArgument() + this.omgdot * tSince;
        double xn0ddf = this.tle.getRaan() + this.xnodot * tSince;
        this.omega = omgadf;
        double xmp = xmdf;
        double tsq = tSince * tSince;
        this.xnode = xn0ddf + this.xnodcf * tsq;
        double tempa = 1.0 - this.c1 * tSince;
        double tempe = this.tle.getBStar() * this.c4 * tSince;
        double templ = this.t2cof * tsq;
        if (!this.lessThan220) {
            double delomg = this.omgcof * tSince;
            double delm = 1.0 + this.eta * FastMath.cos(xmdf);
            delm = this.xmcof * (delm * delm * delm - this.delM0);
            double temp = delomg + delm;
            xmp = xmdf + temp;
            this.omega = omgadf - temp;
            double tcube = tsq * tSince;
            double tfour = tSince * tcube;
            tempa = tempa - this.d2 * tsq - this.d3 * tcube - this.d4 * tfour;
            tempe += this.tle.getBStar() * this.c5 * (FastMath.sin(xmp) - this.sinM0);
            templ = templ + this.t3cof * tcube + tfour * (this.t4cof + tSince * this.t5cof);
        }
        this.a = this.a0dp * tempa * tempa;
        this.e = this.tle.getE() - tempe;
        if (this.e < 1.0E-6) {
            this.e = 1.0E-6;
        }
        this.xl = xmp + this.omega + this.xnode + this.xn0dp * templ;
        this.i = this.tle.getI();
    }
}

