/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import java.util.List;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.frames.Frame;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.conversion.PropagatorBuilder;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;
import org.orekit.utils.ParameterObserver;

public abstract class AbstractPropagatorBuilder
implements PropagatorBuilder {
    private static final double MU_SCALE = FastMath.scalb(1.0, 32);
    private AbsoluteDate initialOrbitDate;
    private final Frame frame;
    private double mu;
    private final ParameterDriversList orbitalDrivers;
    private ParameterDriversList propagationDrivers;
    private final OrbitType orbitType;
    private final PositionAngle positionAngle;
    private final double positionScale;

    protected AbstractPropagatorBuilder(Orbit templateOrbit, PositionAngle positionAngle, double positionScale, boolean addDriverForCentralAttraction) {
        this.initialOrbitDate = templateOrbit.getDate();
        this.frame = templateOrbit.getFrame();
        this.mu = templateOrbit.getMu();
        this.propagationDrivers = new ParameterDriversList();
        this.orbitType = templateOrbit.getType();
        this.positionAngle = positionAngle;
        this.positionScale = positionScale;
        this.orbitalDrivers = this.orbitType.getDrivers(positionScale, templateOrbit, positionAngle);
        for (ParameterDriversList.DelegatingDriver driver : this.orbitalDrivers.getDrivers()) {
            driver.setSelected(true);
        }
        if (addDriverForCentralAttraction) {
            ParameterDriver muDriver = new ParameterDriver("central attraction coefficient", this.mu, MU_SCALE, 0.0, Double.POSITIVE_INFINITY);
            muDriver.addObserver(new ParameterObserver(){

                @Override
                public void valueChanged(double previousValue, ParameterDriver driver) {
                    AbstractPropagatorBuilder.this.mu = driver.getValue();
                }
            });
            this.propagationDrivers.add(muDriver);
        }
    }

    @Override
    public OrbitType getOrbitType() {
        return this.orbitType;
    }

    @Override
    public PositionAngle getPositionAngle() {
        return this.positionAngle;
    }

    @Override
    public AbsoluteDate getInitialOrbitDate() {
        return this.initialOrbitDate;
    }

    @Override
    public Frame getFrame() {
        return this.frame;
    }

    @Override
    public ParameterDriversList getOrbitalParametersDrivers() {
        return this.orbitalDrivers;
    }

    @Override
    public ParameterDriversList getPropagationParametersDrivers() {
        return this.propagationDrivers;
    }

    public double getPositionScale() {
        return this.positionScale;
    }

    public double getMu() {
        return this.mu;
    }

    private int getNbSelected() {
        int count = 0;
        for (ParameterDriver parameterDriver : this.orbitalDrivers.getDrivers()) {
            if (!parameterDriver.isSelected()) continue;
            ++count;
        }
        for (ParameterDriver parameterDriver : this.propagationDrivers.getDrivers()) {
            if (!parameterDriver.isSelected()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public double[] getSelectedNormalizedParameters() {
        double[] selected = new double[this.getNbSelected()];
        int index = 0;
        for (ParameterDriver parameterDriver : this.orbitalDrivers.getDrivers()) {
            if (!parameterDriver.isSelected()) continue;
            selected[index++] = parameterDriver.getNormalizedValue();
        }
        for (ParameterDriver parameterDriver : this.propagationDrivers.getDrivers()) {
            if (!parameterDriver.isSelected()) continue;
            selected[index++] = parameterDriver.getNormalizedValue();
        }
        return selected;
    }

    protected Orbit createInitialOrbit() {
        double[] unNormalized = new double[this.orbitalDrivers.getNbParams()];
        for (int i = 0; i < unNormalized.length; ++i) {
            unNormalized[i] = this.orbitalDrivers.getDrivers().get(i).getValue();
        }
        return this.getOrbitType().mapArrayToOrbit(unNormalized, null, this.positionAngle, this.initialOrbitDate, this.mu, this.frame);
    }

    protected void setParameters(double[] normalizedParameters) {
        if (normalizedParameters.length != this.getNbSelected()) {
            throw new OrekitIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, normalizedParameters.length, this.getNbSelected());
        }
        int index = 0;
        for (ParameterDriver parameterDriver : this.orbitalDrivers.getDrivers()) {
            if (!parameterDriver.isSelected()) continue;
            parameterDriver.setNormalizedValue(normalizedParameters[index++]);
        }
        for (ParameterDriver parameterDriver : this.propagationDrivers.getDrivers()) {
            if (!parameterDriver.isSelected()) continue;
            parameterDriver.setNormalizedValue(normalizedParameters[index++]);
        }
    }

    protected void addSupportedParameter(ParameterDriver driver) {
        this.propagationDrivers.add(driver);
        this.propagationDrivers.sort();
    }

    public void resetOrbit(Orbit newOrbit) {
        double[] orbitArray = new double[6];
        this.orbitType.mapOrbitToArray(newOrbit, this.getPositionAngle(), orbitArray, null);
        List<ParameterDriversList.DelegatingDriver> orbitalDriversList = this.getOrbitalParametersDrivers().getDrivers();
        int i = 0;
        for (ParameterDriversList.DelegatingDriver driver : orbitalDriversList) {
            driver.setReferenceValue(orbitArray[i]);
            driver.setValue(orbitArray[i++]);
        }
        this.initialOrbitDate = newOrbit.getDate();
    }
}

