/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.analytical.tle.TLE;
import org.orekit.propagation.analytical.tle.TLEPropagator;
import org.orekit.propagation.conversion.AbstractPropagatorBuilder;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterObserver;

public class TLEPropagatorBuilder
extends AbstractPropagatorBuilder {
    public static final String B_STAR = "BSTAR";
    private static final double B_STAR_SCALE = FastMath.scalb(1.0, -20);
    private final int satelliteNumber;
    private final char classification;
    private final int launchYear;
    private final int launchNumber;
    private final String launchPiece;
    private final int elementNumber;
    private final int revolutionNumberAtEpoch;
    private double bStar;

    public TLEPropagatorBuilder(TLE templateTLE, PositionAngle positionAngle, double positionScale) {
        super(TLEPropagator.selectExtrapolator(templateTLE).getInitialState().getOrbit(), positionAngle, positionScale, false);
        this.satelliteNumber = templateTLE.getSatelliteNumber();
        this.classification = templateTLE.getClassification();
        this.launchYear = templateTLE.getLaunchYear();
        this.launchNumber = templateTLE.getLaunchNumber();
        this.launchPiece = templateTLE.getLaunchPiece();
        this.elementNumber = templateTLE.getElementNumber();
        this.revolutionNumberAtEpoch = templateTLE.getRevolutionNumberAtEpoch();
        this.bStar = 0.0;
        try {
            ParameterDriver driver = new ParameterDriver(B_STAR, this.bStar, B_STAR_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
            driver.addObserver(new ParameterObserver(){

                @Override
                public void valueChanged(double previousValue, ParameterDriver driver) {
                    TLEPropagatorBuilder.this.bStar = driver.getValue();
                }
            });
            this.addSupportedParameter(driver);
        }
        catch (OrekitException oe) {
            throw new OrekitInternalError(oe);
        }
    }

    @Override
    public Propagator buildPropagator(double[] normalizedParameters) {
        this.setParameters(normalizedParameters);
        Orbit orbit = this.createInitialOrbit();
        KeplerianOrbit kep = (KeplerianOrbit)OrbitType.KEPLERIAN.convertType(orbit);
        TLE tle = new TLE(this.satelliteNumber, this.classification, this.launchYear, this.launchNumber, this.launchPiece, 0, this.elementNumber, orbit.getDate(), kep.getKeplerianMeanMotion(), 0.0, 0.0, kep.getE(), MathUtils.normalizeAngle(orbit.getI(), Math.PI), MathUtils.normalizeAngle(kep.getPerigeeArgument(), Math.PI), MathUtils.normalizeAngle(kep.getRightAscensionOfAscendingNode(), Math.PI), MathUtils.normalizeAngle(kep.getMeanAnomaly(), Math.PI), this.revolutionNumberAtEpoch, this.bStar);
        return TLEPropagator.selectExtrapolator(tle);
    }
}

