/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.RealFieldElement;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.frames.Frame;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.propagation.events.handlers.FieldStopOnIncreasing;

public class FieldNodeDetector<T extends RealFieldElement<T>>
extends FieldAbstractDetector<FieldNodeDetector<T>, T> {
    private final Frame frame;

    public FieldNodeDetector(FieldOrbit<T> orbit, Frame frame) {
        this((RealFieldElement)orbit.getKeplerianPeriod().multiply(1.0E-13), orbit, frame);
    }

    public FieldNodeDetector(T threshold, FieldOrbit<T> orbit, Frame frame) {
        this((RealFieldElement)((RealFieldElement)orbit.getA().getField().getZero()).add(2.0 * FieldNodeDetector.estimateNodesTimeSeparation(orbit.toOrbit()) / 3.0), (RealFieldElement)threshold, 100, new FieldStopOnIncreasing(), frame);
    }

    private FieldNodeDetector(T maxCheck, T threshold, int maxIter, FieldEventHandler<? super FieldNodeDetector<T>, T> handler, Frame frame) {
        super(maxCheck, threshold, maxIter, handler);
        this.frame = frame;
    }

    @Override
    protected FieldNodeDetector<T> create(T newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<? super FieldNodeDetector<T>, T> newHandler) {
        return new FieldNodeDetector<T>(newMaxCheck, newThreshold, newMaxIter, newHandler, this.frame);
    }

    private static double estimateNodesTimeSeparation(Orbit orbit) {
        KeplerianOrbit keplerian = (KeplerianOrbit)OrbitType.KEPLERIAN.convertType(orbit);
        double ascendingM = new KeplerianOrbit(keplerian.getA(), keplerian.getE(), keplerian.getI(), keplerian.getPerigeeArgument(), keplerian.getRightAscensionOfAscendingNode(), -keplerian.getPerigeeArgument(), PositionAngle.TRUE, keplerian.getFrame(), keplerian.getDate(), keplerian.getMu()).getMeanAnomaly();
        double descendingM = new KeplerianOrbit(keplerian.getA(), keplerian.getE(), keplerian.getI(), keplerian.getPerigeeArgument(), keplerian.getRightAscensionOfAscendingNode(), Math.PI - keplerian.getPerigeeArgument(), PositionAngle.TRUE, keplerian.getFrame(), keplerian.getDate(), keplerian.getMu()).getMeanAnomaly();
        double delta1 = MathUtils.normalizeAngle(ascendingM, descendingM + Math.PI) - descendingM;
        double delta2 = Math.PI * 2 - delta1;
        return FastMath.min(delta1, delta2) / keplerian.getKeplerianMeanMotion();
    }

    public Frame getFrame() {
        return this.frame;
    }

    @Override
    public T g(FieldSpacecraftState<T> s) {
        return s.getPVCoordinates(this.frame).getPosition().getZ();
    }
}

