/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.geometry.enclosing.EnclosingBall;
import org.hipparchus.geometry.spherical.twod.S2Point;
import org.hipparchus.geometry.spherical.twod.Sphere2D;
import org.hipparchus.geometry.spherical.twod.SphericalPolygonsSet;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnIncreasing;

public class GeographicZoneDetector
extends AbstractDetector<GeographicZoneDetector> {
    private BodyShape body;
    private final SphericalPolygonsSet zone;
    private final EnclosingBall<Sphere2D, S2Point> cap;
    private final double margin;

    public GeographicZoneDetector(BodyShape body, SphericalPolygonsSet zone, double margin) {
        this(600.0, 1.0E-6, body, zone, margin);
    }

    public GeographicZoneDetector(double maxCheck, double threshold, BodyShape body, SphericalPolygonsSet zone, double margin) {
        this(maxCheck, threshold, 100, new StopOnIncreasing(), body, zone, zone.getEnclosingCap(), margin);
    }

    private GeographicZoneDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super GeographicZoneDetector> handler, BodyShape body, SphericalPolygonsSet zone, EnclosingBall<Sphere2D, S2Point> cap, double margin) {
        super(maxCheck, threshold, maxIter, handler);
        this.body = body;
        this.zone = zone;
        this.cap = cap;
        this.margin = margin;
    }

    @Override
    protected GeographicZoneDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super GeographicZoneDetector> newHandler) {
        return new GeographicZoneDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.body, this.zone, this.cap, this.margin);
    }

    public GeographicZoneDetector withMargin(double newMargin) {
        return new GeographicZoneDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), this.body, this.zone, this.cap, newMargin);
    }

    public BodyShape getBody() {
        return this.body;
    }

    public SphericalPolygonsSet getZone() {
        return this.zone;
    }

    public double getMargin() {
        return this.margin;
    }

    @Override
    public double g(SpacecraftState s) {
        GeodeticPoint gp = this.body.transform(s.getPVCoordinates().getPosition(), s.getFrame(), s.getDate());
        S2Point s2p = new S2Point(gp.getLongitude(), 1.5707963267948966 - gp.getLatitude());
        double crudeDistance = this.cap.getCenter().distance(s2p) - this.cap.getRadius();
        if (crudeDistance - this.margin > FastMath.max(FastMath.abs(this.margin), 0.01)) {
            return crudeDistance - this.margin;
        }
        return this.zone.projectToBoundary(s2p).getOffset() - this.margin;
    }
}

