/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnIncreasing;

public class LongitudeExtremumDetector
extends AbstractDetector<LongitudeExtremumDetector> {
    private OneAxisEllipsoid body;

    public LongitudeExtremumDetector(OneAxisEllipsoid body) {
        this(600.0, 1.0E-6, body);
    }

    public LongitudeExtremumDetector(double maxCheck, double threshold, OneAxisEllipsoid body) {
        this(maxCheck, threshold, 100, new StopOnIncreasing(), body);
    }

    private LongitudeExtremumDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super LongitudeExtremumDetector> handler, OneAxisEllipsoid body) {
        super(maxCheck, threshold, maxIter, handler);
        this.body = body;
    }

    @Override
    protected LongitudeExtremumDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super LongitudeExtremumDetector> newHandler) {
        return new LongitudeExtremumDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.body);
    }

    public BodyShape getBody() {
        return this.body;
    }

    @Override
    public double g(SpacecraftState s) {
        FieldGeodeticPoint<DerivativeStructure> gp = this.body.transform(s.getPVCoordinates(), s.getFrame(), s.getDate());
        return gp.getLongitude().getPartialDerivative(1);
    }
}

