/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.numerical;

import java.util.IdentityHashMap;
import java.util.Map;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.ForceModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.integration.AdditionalEquations;
import org.orekit.propagation.numerical.DSConverter;
import org.orekit.propagation.numerical.JacobiansMapper;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;

public class PartialDerivativesEquations
implements AdditionalEquations {
    private final NumericalPropagator propagator;
    private ParameterDriversList selected;
    private Map<ParameterDriver, Integer> map;
    private final String name;
    private boolean initialized;

    public PartialDerivativesEquations(String name, NumericalPropagator propagator) {
        this.name = name;
        this.selected = null;
        this.map = null;
        this.propagator = propagator;
        this.initialized = false;
        propagator.addAdditionalEquations(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void freezeParametersSelection() {
        if (this.selected == null) {
            this.selected = new ParameterDriversList();
            for (ForceModel provider : this.propagator.getAllForceModels()) {
                for (ParameterDriver driver : provider.getParametersDrivers()) {
                    this.selected.add(driver);
                }
            }
            this.selected.filter(true);
            this.selected.sort();
            this.map = new IdentityHashMap<ParameterDriver, Integer>();
            int parameterIndex = 0;
            for (ParameterDriver parameterDriver : this.selected.getDrivers()) {
                for (ForceModel provider : this.propagator.getAllForceModels()) {
                    for (ParameterDriver driver : provider.getParametersDrivers()) {
                        if (!driver.getName().equals(parameterDriver.getName())) continue;
                        this.map.put(driver, parameterIndex);
                    }
                }
                ++parameterIndex;
            }
        }
    }

    public ParameterDriversList getSelectedParameters() {
        this.freezeParametersSelection();
        return this.selected;
    }

    public SpacecraftState setInitialJacobians(SpacecraftState s0) {
        this.freezeParametersSelection();
        int stateDimension = 6;
        double[][] dYdY0 = new double[6][6];
        double[][] dYdP = new double[6][this.selected.getNbParams()];
        for (int i = 0; i < 6; ++i) {
            dYdY0[i][i] = 1.0;
        }
        return this.setInitialJacobians(s0, dYdY0, dYdP);
    }

    public SpacecraftState setInitialJacobians(SpacecraftState s1, double[][] dY1dY0, double[][] dY1dP) {
        this.freezeParametersSelection();
        int stateDim = dY1dY0.length;
        if (stateDim != 6 || stateDim != dY1dY0[0].length) {
            throw new OrekitException((Localizable)OrekitMessages.STATE_JACOBIAN_NOT_6X6, stateDim, dY1dY0[0].length);
        }
        if (dY1dP != null && stateDim != dY1dP.length) {
            throw new OrekitException((Localizable)OrekitMessages.STATE_AND_PARAMETERS_JACOBIANS_ROWS_MISMATCH, stateDim, dY1dP.length);
        }
        if (dY1dP == null && this.selected.getNbParams() != 0 || dY1dP != null && this.selected.getNbParams() != dY1dP[0].length) {
            throw new OrekitException(new OrekitException((Localizable)OrekitMessages.INITIAL_MATRIX_AND_PARAMETERS_NUMBER_MISMATCH, dY1dP == null ? 0 : dY1dP[0].length, this.selected.getNbParams()));
        }
        this.initialized = true;
        JacobiansMapper mapper = this.getMapper();
        double[] p = new double[mapper.getAdditionalStateDimension()];
        mapper.setInitialJacobians(s1, dY1dY0, dY1dP, p);
        return s1.addAdditionalState(this.name, p);
    }

    public JacobiansMapper getMapper() {
        if (!this.initialized) {
            throw new OrekitException((Localizable)OrekitMessages.STATE_JACOBIAN_NOT_INITIALIZED, new Object[0]);
        }
        return new JacobiansMapper(this.name, this.selected, this.propagator.getOrbitType(), this.propagator.getPositionAngleType());
    }

    @Override
    public double[] computeDerivatives(SpacecraftState s, double[] pDot) {
        int paramDim = this.selected.getNbParams();
        int dim = 3;
        double[][] dAccdParam = new double[3][paramDim];
        double[][] dAccdPos = new double[3][3];
        double[][] dAccdVel = new double[3][3];
        DSConverter fullConverter = new DSConverter(s, 6, this.propagator.getAttitudeProvider());
        DSConverter posOnlyConverter = new DSConverter(s, 3, this.propagator.getAttitudeProvider());
        for (ForceModel forceModel : this.propagator.getAllForceModels()) {
            DSConverter converter = forceModel.dependsOnPositionOnly() ? posOnlyConverter : fullConverter;
            FieldSpacecraftState<DerivativeStructure> dsState = converter.getState(forceModel);
            RealFieldElement[] parameters = converter.getParameters(dsState, forceModel);
            FieldVector3D acceleration = forceModel.acceleration(dsState, parameters);
            double[] derivativesX = ((DerivativeStructure)acceleration.getX()).getAllDerivatives();
            double[] derivativesY = ((DerivativeStructure)acceleration.getY()).getAllDerivatives();
            double[] derivativesZ = ((DerivativeStructure)acceleration.getZ()).getAllDerivatives();
            this.addToRow(derivativesX, 0, converter.getFreeStateParameters(), dAccdPos, dAccdVel);
            this.addToRow(derivativesY, 1, converter.getFreeStateParameters(), dAccdPos, dAccdVel);
            this.addToRow(derivativesZ, 2, converter.getFreeStateParameters(), dAccdPos, dAccdVel);
            int index = converter.getFreeStateParameters();
            for (ParameterDriver driver : forceModel.getParametersDrivers()) {
                if (!driver.isSelected()) continue;
                int parameterIndex = this.map.get(driver);
                double[] dArray = dAccdParam[0];
                int n = parameterIndex;
                dArray[n] = dArray[n] + derivativesX[++index];
                double[] dArray2 = dAccdParam[1];
                int n2 = parameterIndex;
                dArray2[n2] = dArray2[n2] + derivativesY[index];
                double[] dArray3 = dAccdParam[2];
                int n3 = parameterIndex;
                dArray3[n3] = dArray3[n3] + derivativesZ[index];
            }
        }
        int stateDim = 6;
        double[] p = s.getAdditionalState(this.getName());
        System.arraycopy(p, 18, pDot, 0, 18);
        for (int i = 0; i < 3; ++i) {
            double[] dAdPi = dAccdPos[i];
            double[] dAdVi = dAccdVel[i];
            for (int j = 0; j < 6; ++j) {
                pDot[(3 + i) * 6 + j] = dAdPi[0] * p[j] + dAdPi[1] * p[j + 6] + dAdPi[2] * p[j + 12] + dAdVi[0] * p[j + 18] + dAdVi[1] * p[j + 24] + dAdVi[2] * p[j + 30];
            }
        }
        for (int k = 0; k < paramDim; ++k) {
            int columnTop = 36 + k;
            pDot[columnTop] = p[columnTop + 3 * paramDim];
            pDot[columnTop + paramDim] = p[columnTop + 4 * paramDim];
            pDot[columnTop + 2 * paramDim] = p[columnTop + 5 * paramDim];
            for (int i = 0; i < 3; ++i) {
                double[] dAdPi = dAccdPos[i];
                double[] dAdVi = dAccdVel[i];
                pDot[columnTop + (3 + i) * paramDim] = dAccdParam[i][k] + dAdPi[0] * p[columnTop] + dAdPi[1] * p[columnTop + paramDim] + dAdPi[2] * p[columnTop + 2 * paramDim] + dAdVi[0] * p[columnTop + 3 * paramDim] + dAdVi[1] * p[columnTop + 4 * paramDim] + dAdVi[2] * p[columnTop + 5 * paramDim];
            }
        }
        return null;
    }

    private void addToRow(double[] derivatives, int index, int freeStateParameters, double[][] dAccdPos, double[][] dAccdVel) {
        int i;
        for (i = 0; i < 3; ++i) {
            double[] dArray = dAccdPos[index];
            int n = i;
            dArray[n] = dArray[n] + derivatives[i + 1];
        }
        if (freeStateParameters > 3) {
            for (i = 0; i < 3; ++i) {
                double[] dArray = dAccdVel[index];
                int n = i;
                dArray[n] = dArray[n] + derivatives[i + 4];
            }
        }
    }
}

