/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.sampling;

import org.hipparchus.util.FastMath;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.OrekitFixedStepHandler;
import org.orekit.propagation.sampling.OrekitStepHandler;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;

public class OrekitStepNormalizer
implements OrekitStepHandler {
    private double h;
    private OrekitFixedStepHandler handler;
    private SpacecraftState lastState;
    private boolean forward;

    public OrekitStepNormalizer(double h, OrekitFixedStepHandler handler) {
        this.h = FastMath.abs(h);
        this.handler = handler;
        this.lastState = null;
        this.forward = true;
    }

    public boolean requiresDenseOutput() {
        return true;
    }

    @Override
    public void init(SpacecraftState s0, AbsoluteDate t) {
        this.lastState = null;
        this.forward = true;
        this.handler.init(s0, t, this.h);
    }

    @Override
    public void handleStep(OrekitStepInterpolator interpolator, boolean isLast) {
        AbsoluteDate nextTime;
        if (this.lastState == null) {
            this.lastState = interpolator.getPreviousState();
        }
        double step = this.h;
        this.forward = interpolator.isForward();
        if (!this.forward) {
            step = -this.h;
        }
        boolean nextInStep = this.forward ^ (nextTime = this.lastState.getDate().shiftedBy(step)).compareTo(interpolator.getCurrentState().getDate()) > 0;
        while (nextInStep) {
            this.handler.handleStep(this.lastState, false);
            this.lastState = interpolator.getInterpolatedState(nextTime);
            nextTime = nextTime.shiftedBy(step);
            nextInStep = this.forward ^ nextTime.compareTo(interpolator.getCurrentState().getDate()) > 0;
        }
        if (isLast) {
            this.handler.handleStep(this.lastState, true);
        }
    }
}

