/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.differentiation.FDSFactory;
import org.hipparchus.analysis.differentiation.FieldDerivativeStructure;
import org.hipparchus.util.CombinatoricsUtils;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.bodies.CelestialBody;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTThirdBodyContext;
import org.orekit.propagation.semianalytical.dsst.forces.FieldDSSTThirdBodyContext;
import org.orekit.propagation.semianalytical.dsst.forces.FieldShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.forces.ShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.CjSjCoefficient;
import org.orekit.propagation.semianalytical.dsst.utilities.CoefficientsFactory;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldCjSjCoefficient;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldShortPeriodicsInterpolatedCoefficient;
import org.orekit.propagation.semianalytical.dsst.utilities.JacobiPolynomials;
import org.orekit.propagation.semianalytical.dsst.utilities.ShortPeriodicsInterpolatedCoefficient;
import org.orekit.propagation.semianalytical.dsst.utilities.hansen.FieldHansenThirdBodyLinear;
import org.orekit.propagation.semianalytical.dsst.utilities.hansen.HansenThirdBodyLinear;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldTimeSpanMap;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;

public class DSSTThirdBody
implements DSSTForceModel {
    public static final String SHORT_PERIOD_PREFIX = "DSST-3rd-body-";
    public static final String ATTRACTION_COEFFICIENT = " attraction coefficient";
    private static final double MU_SCALE = FastMath.scalb(1.0, 32);
    private static final int I = 1;
    private static final int INTERPOLATION_POINTS = 3;
    private static final int MAX_ECCPOWER_SP = 4;
    private static final int MAX_POWER = 22;
    private final TreeMap<CoefficientsFactory.NSKey, Double> Vns;
    private int maxFreqF;
    private int maxFieldFreqF;
    private final CelestialBody body;
    private ThirdBodyShortPeriodicCoefficients shortPeriods;
    private Map<Field<?>, FieldThirdBodyShortPeriodicCoefficients<?>> fieldShortPeriods;
    private final ParameterDriver bodyParameterDriver;
    private final ParameterDriver gmParameterDriver;
    private HansenObjects hansen;
    private Map<Field<?>, FieldHansenObjects<?>> fieldHansen;
    private DSFactory factory;
    private Map<Field<?>, FDSFactory<?>> fieldFactory;
    private boolean pendingInitialization;

    public DSSTThirdBody(CelestialBody body, double mu) {
        this.bodyParameterDriver = new ParameterDriver(body.getName() + ATTRACTION_COEFFICIENT, body.getGM(), MU_SCALE, 0.0, Double.POSITIVE_INFINITY);
        this.gmParameterDriver = new ParameterDriver("central attraction coefficient", mu, MU_SCALE, 0.0, Double.POSITIVE_INFINITY);
        this.body = body;
        this.Vns = CoefficientsFactory.computeVns(22);
        this.pendingInitialization = true;
        this.fieldShortPeriods = new HashMap();
        this.fieldHansen = new HashMap();
        this.fieldFactory = new HashMap();
    }

    public CelestialBody getBody() {
        return this.body;
    }

    @Override
    public List<ShortPeriodTerms> initialize(AuxiliaryElements auxiliaryElements, PropagationType type, double[] parameters) {
        DSSTThirdBodyContext context = this.initializeStep(auxiliaryElements, parameters);
        this.maxFreqF = context.getMaxFreqF();
        this.hansen = new HansenObjects();
        this.factory = new DSFactory(1, 1);
        int jMax = this.maxFreqF;
        this.shortPeriods = new ThirdBodyShortPeriodicCoefficients(jMax, 3, this.maxFreqF, this.body.getName(), new TimeSpanMap<Slot>(new Slot(jMax, 3)));
        ArrayList<ShortPeriodTerms> list = new ArrayList<ShortPeriodTerms>();
        list.add(this.shortPeriods);
        return list;
    }

    @Override
    public <T extends RealFieldElement<T>> List<FieldShortPeriodTerms<T>> initialize(FieldAuxiliaryElements<T> auxiliaryElements, PropagationType type, T[] parameters) {
        Field<T> field = auxiliaryElements.getDate().getField();
        if (this.pendingInitialization) {
            FieldDSSTThirdBodyContext context = this.initializeStep(auxiliaryElements, (RealFieldElement[])parameters);
            this.maxFieldFreqF = context.getMaxFreqF();
            this.fieldFactory.put(field, new FDSFactory<T>(field, 1, 1));
            this.fieldHansen.put(field, new FieldHansenObjects<T>(field));
            this.pendingInitialization = false;
        }
        int jMax = this.maxFieldFreqF;
        FieldThirdBodyShortPeriodicCoefficients ftbspc = new FieldThirdBodyShortPeriodicCoefficients(jMax, 3, this.maxFieldFreqF, this.body.getName(), new FieldTimeSpanMap(new FieldSlot(jMax, 3), field));
        this.fieldShortPeriods.put(field, ftbspc);
        return Collections.singletonList(ftbspc);
    }

    private DSSTThirdBodyContext initializeStep(AuxiliaryElements auxiliaryElements, double[] parameters) {
        return new DSSTThirdBodyContext(auxiliaryElements, this.body, parameters);
    }

    private <T extends RealFieldElement<T>> FieldDSSTThirdBodyContext<T> initializeStep(FieldAuxiliaryElements<T> auxiliaryElements, T[] parameters) {
        return new FieldDSSTThirdBodyContext(auxiliaryElements, this.body, parameters);
    }

    @Override
    public double[] getMeanElementRate(SpacecraftState currentState, AuxiliaryElements auxiliaryElements, double[] parameters) {
        DSSTThirdBodyContext context = this.initializeStep(auxiliaryElements, parameters);
        UAnddU udu = new UAnddU(context, this.hansen);
        double UAlphaGamma = context.getAlpha() * udu.getdUdGa() - context.getGamma() * udu.getdUdAl();
        double UBetaGamma = context.getBeta() * udu.getdUdGa() - context.getGamma() * udu.getdUdBe();
        double pUAGmIqUBGoAB = (auxiliaryElements.getP() * UAlphaGamma - 1.0 * auxiliaryElements.getQ() * UBetaGamma) * context.getOoAB();
        double da = 0.0;
        double dh = context.getBoA() * udu.getdUdk() + auxiliaryElements.getK() * pUAGmIqUBGoAB;
        double dk = -context.getBoA() * udu.getdUdh() - auxiliaryElements.getH() * pUAGmIqUBGoAB;
        double dp = context.getMCo2AB() * UBetaGamma;
        double dq = context.getMCo2AB() * UAlphaGamma * 1.0;
        double dM = context.getM2aoA() * udu.getdUda() + context.getBoABpo() * (auxiliaryElements.getH() * udu.getdUdh() + auxiliaryElements.getK() * udu.getdUdk()) + pUAGmIqUBGoAB;
        return new double[]{0.0, dk, dh, dq, dp, dM};
    }

    @Override
    public <T extends RealFieldElement<T>> T[] getMeanElementRate(FieldSpacecraftState<T> currentState, FieldAuxiliaryElements<T> auxiliaryElements, T[] parameters) {
        Field<T> field = currentState.getDate().getField();
        RealFieldElement zero = (RealFieldElement)field.getZero();
        FieldDSSTThirdBodyContext context = this.initializeStep(auxiliaryElements, (RealFieldElement[])parameters);
        FieldHansenObjects<?> fho = this.fieldHansen.get(field);
        FieldUAnddU udu = new FieldUAnddU(context, fho);
        RealFieldElement UAlphaGamma = (RealFieldElement)((RealFieldElement)udu.getdUdGa().multiply(context.getAlpha())).subtract(udu.getdUdAl().multiply(context.getGamma()));
        RealFieldElement UBetaGamma = (RealFieldElement)((RealFieldElement)udu.getdUdGa().multiply(context.getBeta())).subtract(udu.getdUdBe().multiply(context.getGamma()));
        RealFieldElement pUAGmIqUBGoAB = (RealFieldElement)((RealFieldElement)((RealFieldElement)UAlphaGamma.multiply(auxiliaryElements.getP())).subtract(((RealFieldElement)UBetaGamma.multiply(auxiliaryElements.getQ())).multiply(true))).multiply(context.getOoAB());
        RealFieldElement da = zero;
        RealFieldElement dh = (RealFieldElement)((RealFieldElement)udu.getdUdk().multiply(context.getBoA())).add(pUAGmIqUBGoAB.multiply(auxiliaryElements.getK()));
        RealFieldElement dk = (RealFieldElement)((RealFieldElement)((RealFieldElement)udu.getdUdh().multiply(context.getBoA())).negate()).subtract(pUAGmIqUBGoAB.multiply(auxiliaryElements.getH()));
        RealFieldElement dp = (RealFieldElement)UBetaGamma.multiply(context.getMCo2AB());
        RealFieldElement dq = (RealFieldElement)((RealFieldElement)UAlphaGamma.multiply(true)).multiply(context.getMCo2AB());
        RealFieldElement dM = (RealFieldElement)((RealFieldElement)pUAGmIqUBGoAB.add(udu.getdUda().multiply(context.getM2aoA()))).add(((RealFieldElement)((RealFieldElement)udu.getdUdh().multiply(auxiliaryElements.getH())).add(udu.getdUdk().multiply(auxiliaryElements.getK()))).multiply(context.getBoABpo()));
        RealFieldElement[] elements = (RealFieldElement[])MathArrays.buildArray(field, 6);
        elements[0] = da;
        elements[1] = dk;
        elements[2] = dh;
        elements[3] = dq;
        elements[4] = dp;
        elements[5] = dM;
        return elements;
    }

    @Override
    public void updateShortPeriodTerms(double[] parameters, SpacecraftState ... meanStates) {
        Slot slot = this.shortPeriods.createSlot(meanStates);
        for (SpacecraftState meanState : meanStates) {
            AuxiliaryElements auxiliaryElements = new AuxiliaryElements(meanState.getOrbit(), 1);
            DSSTThirdBodyContext context = this.initializeStep(auxiliaryElements, parameters);
            GeneratingFunctionCoefficients gfCoefs = new GeneratingFunctionCoefficients(context.getMaxAR3Pow(), 4, context.getMaxAR3Pow() + 1, context, this.hansen);
            double ax2oAn = -context.getM2aoA() / context.getMeanMotion();
            double BoAn = context.getBoA() / context.getMeanMotion();
            double ooABn = context.getOoAB() / context.getMeanMotion();
            double Co2ABn = -context.getMCo2AB() / context.getMeanMotion();
            double BoABpon = context.getBoABpo() / context.getMeanMotion();
            double m3onA = -3.0 / (context.getA() * context.getMeanMotion());
            for (int j = 1; j < slot.cij.length; ++j) {
                double[] currentCij = new double[6];
                double SAlphaGammaCj = context.getAlpha() * gfCoefs.getdSdgammaCj(j) - context.getGamma() * gfCoefs.getdSdalphaCj(j);
                double SAlphaBetaCj = context.getAlpha() * gfCoefs.getdSdbetaCj(j) - context.getBeta() * gfCoefs.getdSdalphaCj(j);
                double SBetaGammaCj = context.getBeta() * gfCoefs.getdSdgammaCj(j) - context.getGamma() * gfCoefs.getdSdbetaCj(j);
                double ShkCj = auxiliaryElements.getH() * gfCoefs.getdSdkCj(j) - auxiliaryElements.getK() * gfCoefs.getdSdhCj(j);
                double pSagmIqSbgoABnCj = (auxiliaryElements.getP() * SAlphaGammaCj - 1.0 * auxiliaryElements.getQ() * SBetaGammaCj) * ooABn;
                double ShkmSabmdSdlCj = ShkCj - SAlphaBetaCj - gfCoefs.getdSdlambdaCj(j);
                currentCij[0] = ax2oAn * gfCoefs.getdSdlambdaCj(j);
                currentCij[1] = -(BoAn * gfCoefs.getdSdhCj(j) + auxiliaryElements.getH() * pSagmIqSbgoABnCj + auxiliaryElements.getK() * BoABpon * gfCoefs.getdSdlambdaCj(j));
                currentCij[2] = BoAn * gfCoefs.getdSdkCj(j) + auxiliaryElements.getK() * pSagmIqSbgoABnCj - auxiliaryElements.getH() * BoABpon * gfCoefs.getdSdlambdaCj(j);
                currentCij[3] = Co2ABn * (auxiliaryElements.getQ() * ShkmSabmdSdlCj - 1.0 * SAlphaGammaCj);
                currentCij[4] = Co2ABn * (auxiliaryElements.getP() * ShkmSabmdSdlCj - SBetaGammaCj);
                currentCij[5] = -ax2oAn * gfCoefs.getdSdaCj(j) + BoABpon * (auxiliaryElements.getH() * gfCoefs.getdSdhCj(j) + auxiliaryElements.getK() * gfCoefs.getdSdkCj(j)) + pSagmIqSbgoABnCj + m3onA * gfCoefs.getSCj(j);
                slot.cij[j].addGridPoint(meanState.getDate(), currentCij);
                double[] currentSij = new double[6];
                double SAlphaGammaSj = context.getAlpha() * gfCoefs.getdSdgammaSj(j) - context.getGamma() * gfCoefs.getdSdalphaSj(j);
                double SAlphaBetaSj = context.getAlpha() * gfCoefs.getdSdbetaSj(j) - context.getBeta() * gfCoefs.getdSdalphaSj(j);
                double SBetaGammaSj = context.getBeta() * gfCoefs.getdSdgammaSj(j) - context.getGamma() * gfCoefs.getdSdbetaSj(j);
                double ShkSj = auxiliaryElements.getH() * gfCoefs.getdSdkSj(j) - auxiliaryElements.getK() * gfCoefs.getdSdhSj(j);
                double pSagmIqSbgoABnSj = (auxiliaryElements.getP() * SAlphaGammaSj - 1.0 * auxiliaryElements.getQ() * SBetaGammaSj) * ooABn;
                double ShkmSabmdSdlSj = ShkSj - SAlphaBetaSj - gfCoefs.getdSdlambdaSj(j);
                currentSij[0] = ax2oAn * gfCoefs.getdSdlambdaSj(j);
                currentSij[1] = -(BoAn * gfCoefs.getdSdhSj(j) + auxiliaryElements.getH() * pSagmIqSbgoABnSj + auxiliaryElements.getK() * BoABpon * gfCoefs.getdSdlambdaSj(j));
                currentSij[2] = BoAn * gfCoefs.getdSdkSj(j) + auxiliaryElements.getK() * pSagmIqSbgoABnSj - auxiliaryElements.getH() * BoABpon * gfCoefs.getdSdlambdaSj(j);
                currentSij[3] = Co2ABn * (auxiliaryElements.getQ() * ShkmSabmdSdlSj - 1.0 * SAlphaGammaSj);
                currentSij[4] = Co2ABn * (auxiliaryElements.getP() * ShkmSabmdSdlSj - SBetaGammaSj);
                currentSij[5] = -ax2oAn * gfCoefs.getdSdaSj(j) + BoABpon * (auxiliaryElements.getH() * gfCoefs.getdSdhSj(j) + auxiliaryElements.getK() * gfCoefs.getdSdkSj(j)) + pSagmIqSbgoABnSj + m3onA * gfCoefs.getSSj(j);
                slot.sij[j].addGridPoint(meanState.getDate(), currentSij);
                if (j != 1) continue;
                double[] value = new double[6];
                for (int i = 0; i < 6; ++i) {
                    value[i] = currentCij[i] * auxiliaryElements.getK() / 2.0 + currentSij[i] * auxiliaryElements.getH() / 2.0;
                }
                slot.cij[0].addGridPoint(meanState.getDate(), value);
            }
        }
    }

    @Override
    public <T extends RealFieldElement<T>> void updateShortPeriodTerms(T[] parameters, FieldSpacecraftState<T> ... meanStates) {
        Field<T> field = meanStates[0].getDate().getField();
        FieldThirdBodyShortPeriodicCoefficients<?> ftbspc = this.fieldShortPeriods.get(field);
        FieldSlot<?> slot = ftbspc.createSlot(meanStates);
        for (FieldSpacecraftState<T> meanState : meanStates) {
            FieldAuxiliaryElements<T> auxiliaryElements = new FieldAuxiliaryElements<T>(meanState.getOrbit(), 1);
            FieldDSSTThirdBodyContext context = this.initializeStep(auxiliaryElements, (RealFieldElement[])parameters);
            FieldHansenObjects<?> fho = this.fieldHansen.get(field);
            FieldGeneratingFunctionCoefficients gfCoefs = new FieldGeneratingFunctionCoefficients(context.getMaxAR3Pow(), 4, context.getMaxAR3Pow() + 1, context, fho, field);
            RealFieldElement ax2oAn = (RealFieldElement)((RealFieldElement)context.getM2aoA().negate()).divide(context.getMeanMotion());
            RealFieldElement BoAn = (RealFieldElement)context.getBoA().divide(context.getMeanMotion());
            RealFieldElement ooABn = (RealFieldElement)context.getOoAB().divide(context.getMeanMotion());
            RealFieldElement Co2ABn = (RealFieldElement)((RealFieldElement)context.getMCo2AB().negate()).divide(context.getMeanMotion());
            RealFieldElement BoABpon = (RealFieldElement)context.getBoABpo().divide(context.getMeanMotion());
            RealFieldElement m3onA = (RealFieldElement)((RealFieldElement)((RealFieldElement)context.getA().multiply(context.getMeanMotion())).divide(-3.0)).reciprocal();
            for (int j = 1; j < ((FieldSlot)slot).cij.length; ++j) {
                RealFieldElement[] currentCij = (RealFieldElement[])MathArrays.buildArray(field, 6);
                RealFieldElement SAlphaGammaCj = (RealFieldElement)((RealFieldElement)context.getAlpha().multiply(gfCoefs.getdSdgammaCj(j))).subtract(context.getGamma().multiply(gfCoefs.getdSdalphaCj(j)));
                RealFieldElement SAlphaBetaCj = (RealFieldElement)((RealFieldElement)context.getAlpha().multiply(gfCoefs.getdSdbetaCj(j))).subtract(context.getBeta().multiply(gfCoefs.getdSdalphaCj(j)));
                RealFieldElement SBetaGammaCj = (RealFieldElement)((RealFieldElement)context.getBeta().multiply(gfCoefs.getdSdgammaCj(j))).subtract(context.getGamma().multiply(gfCoefs.getdSdbetaCj(j)));
                RealFieldElement ShkCj = (RealFieldElement)((RealFieldElement)auxiliaryElements.getH().multiply(gfCoefs.getdSdkCj(j))).subtract(auxiliaryElements.getK().multiply(gfCoefs.getdSdhCj(j)));
                RealFieldElement pSagmIqSbgoABnCj = (RealFieldElement)ooABn.multiply(auxiliaryElements.getP().multiply((RealFieldElement)SAlphaGammaCj).subtract(auxiliaryElements.getQ().multiply((RealFieldElement)SBetaGammaCj).multiply(true)));
                RealFieldElement ShkmSabmdSdlCj = (RealFieldElement)ShkCj.subtract(SAlphaBetaCj).subtract(gfCoefs.getdSdlambdaCj(j));
                currentCij[0] = (RealFieldElement)ax2oAn.multiply(gfCoefs.getdSdlambdaCj(j));
                currentCij[1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)BoAn.multiply(gfCoefs.getdSdhCj(j))).add(auxiliaryElements.getH().multiply((RealFieldElement)pSagmIqSbgoABnCj)).add(auxiliaryElements.getK().multiply((RealFieldElement)BoABpon).multiply(gfCoefs.getdSdlambdaCj(j)))).negate();
                currentCij[2] = (RealFieldElement)((RealFieldElement)BoAn.multiply(gfCoefs.getdSdkCj(j))).add(auxiliaryElements.getK().multiply((RealFieldElement)pSagmIqSbgoABnCj)).subtract(auxiliaryElements.getH().multiply((RealFieldElement)BoABpon).multiply(gfCoefs.getdSdlambdaCj(j)));
                currentCij[3] = (RealFieldElement)Co2ABn.multiply(auxiliaryElements.getQ().multiply((RealFieldElement)ShkmSabmdSdlCj).subtract(SAlphaGammaCj.multiply(true)));
                currentCij[4] = Co2ABn.multiply(auxiliaryElements.getP().multiply((RealFieldElement)ShkmSabmdSdlCj).subtract(SBetaGammaCj));
                currentCij[5] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)ax2oAn.negate()).multiply(gfCoefs.getdSdaCj(j))).add(BoABpon.multiply(((RealFieldElement)auxiliaryElements.getH().multiply(gfCoefs.getdSdhCj(j))).add(auxiliaryElements.getK().multiply(gfCoefs.getdSdkCj(j)))))).add(pSagmIqSbgoABnCj).add(m3onA.multiply(gfCoefs.getSCj(j)));
                ((FieldSlot)slot).cij[j].addGridPoint(meanState.getDate(), currentCij);
                RealFieldElement[] currentSij = (RealFieldElement[])MathArrays.buildArray(field, 6);
                RealFieldElement SAlphaGammaSj = (RealFieldElement)((RealFieldElement)context.getAlpha().multiply(gfCoefs.getdSdgammaSj(j))).subtract(context.getGamma().multiply(gfCoefs.getdSdalphaSj(j)));
                RealFieldElement SAlphaBetaSj = (RealFieldElement)((RealFieldElement)context.getAlpha().multiply(gfCoefs.getdSdbetaSj(j))).subtract(context.getBeta().multiply(gfCoefs.getdSdalphaSj(j)));
                RealFieldElement SBetaGammaSj = (RealFieldElement)((RealFieldElement)context.getBeta().multiply(gfCoefs.getdSdgammaSj(j))).subtract(context.getGamma().multiply(gfCoefs.getdSdbetaSj(j)));
                RealFieldElement ShkSj = (RealFieldElement)((RealFieldElement)auxiliaryElements.getH().multiply(gfCoefs.getdSdkSj(j))).subtract(auxiliaryElements.getK().multiply(gfCoefs.getdSdhSj(j)));
                RealFieldElement pSagmIqSbgoABnSj = (RealFieldElement)ooABn.multiply(auxiliaryElements.getP().multiply((RealFieldElement)SAlphaGammaSj).subtract(auxiliaryElements.getQ().multiply((RealFieldElement)SBetaGammaSj).multiply(true)));
                RealFieldElement ShkmSabmdSdlSj = (RealFieldElement)ShkSj.subtract(SAlphaBetaSj).subtract(gfCoefs.getdSdlambdaSj(j));
                currentSij[0] = (RealFieldElement)ax2oAn.multiply(gfCoefs.getdSdlambdaSj(j));
                currentSij[1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)BoAn.multiply(gfCoefs.getdSdhSj(j))).add(auxiliaryElements.getH().multiply((RealFieldElement)pSagmIqSbgoABnSj)).add(auxiliaryElements.getK().multiply((RealFieldElement)BoABpon).multiply(gfCoefs.getdSdlambdaSj(j)))).negate();
                currentSij[2] = (RealFieldElement)((RealFieldElement)BoAn.multiply(gfCoefs.getdSdkSj(j))).add(auxiliaryElements.getK().multiply((RealFieldElement)pSagmIqSbgoABnSj)).subtract(auxiliaryElements.getH().multiply((RealFieldElement)BoABpon).multiply(gfCoefs.getdSdlambdaSj(j)));
                currentSij[3] = (RealFieldElement)Co2ABn.multiply(auxiliaryElements.getQ().multiply((RealFieldElement)ShkmSabmdSdlSj).subtract(SAlphaGammaSj.multiply(true)));
                currentSij[4] = Co2ABn.multiply(auxiliaryElements.getP().multiply((RealFieldElement)ShkmSabmdSdlSj).subtract(SBetaGammaSj));
                currentSij[5] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)ax2oAn.negate()).multiply(gfCoefs.getdSdaSj(j))).add(BoABpon.multiply(((RealFieldElement)auxiliaryElements.getH().multiply(gfCoefs.getdSdhSj(j))).add(auxiliaryElements.getK().multiply(gfCoefs.getdSdkSj(j)))))).add(pSagmIqSbgoABnSj).add(m3onA.multiply(gfCoefs.getSSj(j)));
                ((FieldSlot)slot).sij[j].addGridPoint(meanState.getDate(), currentSij);
                if (j != 1) continue;
                RealFieldElement[] value = (RealFieldElement[])MathArrays.buildArray(field, 6);
                for (int i = 0; i < 6; ++i) {
                    value[i] = (RealFieldElement)((RealFieldElement)((RealFieldElement)currentCij[i].multiply(auxiliaryElements.getK())).divide(2.0)).add(((RealFieldElement)currentSij[i].multiply(auxiliaryElements.getH())).divide(2.0));
                }
                ((FieldSlot)slot).cij[0].addGridPoint(meanState.getDate(), value);
            }
        }
    }

    @Override
    public EventDetector[] getEventsDetectors() {
        return null;
    }

    @Override
    public <T extends RealFieldElement<T>> FieldEventDetector<T>[] getFieldEventsDetectors(Field<T> field) {
        return null;
    }

    @Override
    public void registerAttitudeProvider(AttitudeProvider provider) {
    }

    @Override
    public ParameterDriver[] getParametersDrivers() {
        return new ParameterDriver[]{this.bodyParameterDriver, this.gmParameterDriver};
    }

    private static class FieldHansenObjects<T extends RealFieldElement<T>> {
        private static final int MAX_POWER = 22;
        private final FieldHansenThirdBodyLinear<T>[] hansenObjects = (FieldHansenThirdBodyLinear[])Array.newInstance(FieldHansenThirdBodyLinear.class, 23);

        FieldHansenObjects(Field<T> field) {
            for (int s = 0; s <= 22; ++s) {
                this.hansenObjects[s] = new FieldHansenThirdBodyLinear<T>(22, s, field);
            }
        }

        public void computeHansenObjectsInitValues(FieldDSSTThirdBodyContext<T> context, T B, int element) {
            this.hansenObjects[element].computeInitValues(B, context.getBB(), context.getBBB());
        }

        public FieldHansenThirdBodyLinear<T>[] getHansenObjects() {
            return this.hansenObjects;
        }
    }

    private static class HansenObjects {
        private static final int MAX_POWER = 22;
        private final HansenThirdBodyLinear[] hansenObjects = new HansenThirdBodyLinear[23];

        HansenObjects() {
            for (int s = 0; s <= 22; ++s) {
                this.hansenObjects[s] = new HansenThirdBodyLinear(22, s);
            }
        }

        public void computeHansenObjectsInitValues(DSSTThirdBodyContext context, double B, int element) {
            this.hansenObjects[element].computeInitValues(B, context.getBB(), context.getBBB());
        }

        public HansenThirdBodyLinear[] getHansenObjects() {
            return this.hansenObjects;
        }
    }

    private class FieldUAnddU<T extends RealFieldElement<T>> {
        private T U;
        private T dUda;
        private T dUdk;
        private T dUdh;
        private T dUdAl;
        private T dUdBe;
        private T dUdGa;

        FieldUAnddU(FieldDSSTThirdBodyContext<T> context, FieldHansenObjects<T> hansen) {
            FieldAuxiliaryElements auxiliaryElements = context.getFieldAuxiliaryElements();
            Field field = auxiliaryElements.getDate().getField();
            RealFieldElement zero = (RealFieldElement)field.getZero();
            RealFieldElement[][] GsHs = CoefficientsFactory.computeGsHs(auxiliaryElements.getK(), auxiliaryElements.getH(), context.getAlpha(), context.getBeta(), (int)context.getMaxEccPow(), field);
            this.U = zero;
            this.dUda = zero;
            this.dUdk = zero;
            this.dUdh = zero;
            this.dUdAl = zero;
            this.dUdBe = zero;
            this.dUdGa = zero;
            for (int s = 0; s <= context.getMaxEccPow(); ++s) {
                hansen.computeHansenObjectsInitValues(context, auxiliaryElements.getB(), s);
                RealFieldElement gs = GsHs[0][s];
                RealFieldElement dGsdh = zero;
                RealFieldElement dGsdk = zero;
                RealFieldElement dGsdAl = zero;
                RealFieldElement dGsdBe = zero;
                if (s > 0) {
                    RealFieldElement sxGsm1 = (RealFieldElement)GsHs[0][s - 1].multiply(s);
                    RealFieldElement sxHsm1 = (RealFieldElement)GsHs[1][s - 1].multiply(s);
                    dGsdh = (RealFieldElement)((RealFieldElement)sxGsm1.multiply(context.getBeta())).subtract(sxHsm1.multiply(context.getAlpha()));
                    dGsdk = (RealFieldElement)((RealFieldElement)sxGsm1.multiply(context.getAlpha())).add(sxHsm1.multiply(context.getBeta()));
                    dGsdAl = (RealFieldElement)((RealFieldElement)sxGsm1.multiply(auxiliaryElements.getK())).subtract(sxHsm1.multiply(auxiliaryElements.getH()));
                    dGsdBe = (RealFieldElement)((RealFieldElement)sxGsm1.multiply(auxiliaryElements.getH())).add(sxHsm1.multiply(auxiliaryElements.getK()));
                }
                RealFieldElement delta0s = (RealFieldElement)zero.add(s == 0 ? 1.0 : 2.0);
                for (int n = FastMath.max(2, s); n <= context.getMaxAR3Pow(); ++n) {
                    if ((n - s) % 2 != 0) continue;
                    T kns = hansen.getHansenObjects()[s].getValue(n, auxiliaryElements.getB());
                    T dkns = hansen.getHansenObjects()[s].getDerivative(n, auxiliaryElements.getB());
                    double vns = (Double)DSSTThirdBody.this.Vns.get(new CoefficientsFactory.NSKey(n, s));
                    RealFieldElement coef0 = ((RealFieldElement)delta0s.multiply(vns)).multiply(context.getAoR3Pow()[n]);
                    RealFieldElement coef1 = coef0.multiply(context.getQns()[n][s]);
                    RealFieldElement coef2 = (RealFieldElement)coef1.multiply(kns);
                    RealFieldElement dqns = n == s ? zero : context.getQns()[n][s + 1];
                    this.U = this.U.add((RealFieldElement)coef2.multiply(gs));
                    this.dUda = this.dUda.add((RealFieldElement)((RealFieldElement)coef2.multiply(n)).multiply(gs));
                    this.dUdh = (RealFieldElement)this.dUdh.add(coef1.multiply(((RealFieldElement)dGsdh.multiply(kns)).add(context.getHXXX().multiply((RealFieldElement)gs).multiply(dkns))));
                    this.dUdk = (RealFieldElement)this.dUdk.add(coef1.multiply(((RealFieldElement)dGsdk.multiply(kns)).add(context.getKXXX().multiply((RealFieldElement)gs).multiply(dkns))));
                    this.dUdAl = this.dUdAl.add((RealFieldElement)coef2.multiply(dGsdAl));
                    this.dUdBe = this.dUdBe.add((RealFieldElement)coef2.multiply(dGsdBe));
                    this.dUdGa = this.dUdGa.add((RealFieldElement)((RealFieldElement)coef0.multiply(kns)).multiply(dqns).multiply(gs));
                }
            }
            this.U = (RealFieldElement)this.U.multiply(context.getMuoR3());
            this.dUda = (RealFieldElement)this.dUda.multiply(context.getMuoR3().divide(auxiliaryElements.getSma()));
            this.dUdk = (RealFieldElement)this.dUdk.multiply(context.getMuoR3());
            this.dUdh = (RealFieldElement)this.dUdh.multiply(context.getMuoR3());
            this.dUdAl = (RealFieldElement)this.dUdAl.multiply(context.getMuoR3());
            this.dUdBe = (RealFieldElement)this.dUdBe.multiply(context.getMuoR3());
            this.dUdGa = (RealFieldElement)this.dUdGa.multiply(context.getMuoR3());
        }

        public T getU() {
            return this.U;
        }

        public T getdUda() {
            return this.dUda;
        }

        public T getdUdk() {
            return this.dUdk;
        }

        public T getdUdh() {
            return this.dUdh;
        }

        public T getdUdAl() {
            return this.dUdAl;
        }

        public T getdUdBe() {
            return this.dUdBe;
        }

        public T getdUdGa() {
            return this.dUdGa;
        }
    }

    private class UAnddU {
        private double U;
        private double dUda;
        private double dUdk;
        private double dUdh;
        private double dUdAl;
        private double dUdBe;
        private double dUdGa;

        UAnddU(DSSTThirdBodyContext context, HansenObjects hansen) {
            AuxiliaryElements auxiliaryElements = context.getAuxiliaryElements();
            double[][] GsHs = CoefficientsFactory.computeGsHs(auxiliaryElements.getK(), auxiliaryElements.getH(), context.getAlpha(), context.getBeta(), context.getMaxEccPow());
            this.U = 0.0;
            this.dUda = 0.0;
            this.dUdk = 0.0;
            this.dUdh = 0.0;
            this.dUdAl = 0.0;
            this.dUdBe = 0.0;
            this.dUdGa = 0.0;
            for (int s = 0; s <= context.getMaxEccPow(); ++s) {
                hansen.computeHansenObjectsInitValues(context, auxiliaryElements.getB(), s);
                double gs = GsHs[0][s];
                double dGsdh = 0.0;
                double dGsdk = 0.0;
                double dGsdAl = 0.0;
                double dGsdBe = 0.0;
                if (s > 0) {
                    double sxGsm1 = (double)s * GsHs[0][s - 1];
                    double sxHsm1 = (double)s * GsHs[1][s - 1];
                    dGsdh = context.getBeta() * sxGsm1 - context.getAlpha() * sxHsm1;
                    dGsdk = context.getAlpha() * sxGsm1 + context.getBeta() * sxHsm1;
                    dGsdAl = auxiliaryElements.getK() * sxGsm1 - auxiliaryElements.getH() * sxHsm1;
                    dGsdBe = auxiliaryElements.getH() * sxGsm1 + auxiliaryElements.getK() * sxHsm1;
                }
                double delta0s = s == 0 ? 1.0 : 2.0;
                for (int n = FastMath.max(2, s); n <= context.getMaxAR3Pow(); ++n) {
                    if ((n - s) % 2 != 0) continue;
                    double kns = hansen.getHansenObjects()[s].getValue(n, auxiliaryElements.getB());
                    double dkns = hansen.getHansenObjects()[s].getDerivative(n, auxiliaryElements.getB());
                    double vns = (Double)DSSTThirdBody.this.Vns.get(new CoefficientsFactory.NSKey(n, s));
                    double coef0 = delta0s * context.getAoR3Pow()[n] * vns;
                    double coef1 = coef0 * context.getQns()[n][s];
                    double coef2 = coef1 * kns;
                    double dqns = n == s ? 0.0 : context.getQns()[n][s + 1];
                    this.U += coef2 * gs;
                    this.dUda += coef2 * (double)n * gs;
                    this.dUdh += coef1 * (kns * dGsdh + context.getHXXX() * gs * dkns);
                    this.dUdk += coef1 * (kns * dGsdk + context.getKXXX() * gs * dkns);
                    this.dUdAl += coef2 * dGsdAl;
                    this.dUdBe += coef2 * dGsdBe;
                    this.dUdGa += coef0 * kns * dqns * gs;
                }
            }
            this.U *= context.getMuoR3();
            this.dUda = this.dUda * context.getMuoR3() / auxiliaryElements.getSma();
            this.dUdk *= context.getMuoR3();
            this.dUdh *= context.getMuoR3();
            this.dUdAl *= context.getMuoR3();
            this.dUdBe *= context.getMuoR3();
            this.dUdGa *= context.getMuoR3();
        }

        public double getU() {
            return this.U;
        }

        public double getdUda() {
            return this.dUda;
        }

        public double getdUdk() {
            return this.dUdk;
        }

        public double getdUdh() {
            return this.dUdh;
        }

        public double getdUdAl() {
            return this.dUdAl;
        }

        public double getdUdBe() {
            return this.dUdBe;
        }

        public double getdUdGa() {
            return this.dUdGa;
        }
    }

    private static class FieldSlot<T extends RealFieldElement<T>> {
        private final FieldShortPeriodicsInterpolatedCoefficient<T>[] cij;
        private final FieldShortPeriodicsInterpolatedCoefficient<T>[] sij;

        FieldSlot(int jMax, int interpolationPoints) {
            this.cij = (FieldShortPeriodicsInterpolatedCoefficient[])Array.newInstance(FieldShortPeriodicsInterpolatedCoefficient.class, jMax + 1);
            this.sij = (FieldShortPeriodicsInterpolatedCoefficient[])Array.newInstance(FieldShortPeriodicsInterpolatedCoefficient.class, jMax + 1);
            for (int j = 0; j <= jMax; ++j) {
                this.cij[j] = new FieldShortPeriodicsInterpolatedCoefficient(interpolationPoints);
                this.sij[j] = new FieldShortPeriodicsInterpolatedCoefficient(interpolationPoints);
            }
        }
    }

    private static class Slot {
        private final ShortPeriodicsInterpolatedCoefficient[] cij;
        private final ShortPeriodicsInterpolatedCoefficient[] sij;

        Slot(int jMax, int interpolationPoints) {
            this.cij = new ShortPeriodicsInterpolatedCoefficient[jMax + 1];
            this.sij = new ShortPeriodicsInterpolatedCoefficient[jMax + 1];
            for (int j = 0; j <= jMax; ++j) {
                this.cij[j] = new ShortPeriodicsInterpolatedCoefficient(interpolationPoints);
                this.sij[j] = new ShortPeriodicsInterpolatedCoefficient(interpolationPoints);
            }
        }
    }

    private static class FieldThirdBodyShortPeriodicCoefficients<T extends RealFieldElement<T>>
    implements FieldShortPeriodTerms<T> {
        private final int jMax;
        private final int interpolationPoints;
        private final int maxFreqF;
        private final String prefix;
        private final transient FieldTimeSpanMap<FieldSlot<T>, T> slots;

        FieldThirdBodyShortPeriodicCoefficients(int jMax, int interpolationPoints, int maxFreqF, String bodyName, FieldTimeSpanMap<FieldSlot<T>, T> slots) {
            this.jMax = jMax;
            this.interpolationPoints = interpolationPoints;
            this.maxFreqF = maxFreqF;
            this.prefix = DSSTThirdBody.SHORT_PERIOD_PREFIX + bodyName + "-";
            this.slots = slots;
        }

        public FieldSlot<T> createSlot(FieldSpacecraftState<T> ... meanStates) {
            FieldAbsoluteDate<T> last;
            FieldSlot slot = new FieldSlot(this.jMax, this.interpolationPoints);
            FieldAbsoluteDate<T> first = meanStates[0].getDate();
            if (first.compareTo(last = meanStates[meanStates.length - 1].getDate()) <= 0) {
                this.slots.addValidAfter(slot, first);
            } else {
                this.slots.addValidBefore(slot, first);
            }
            return slot;
        }

        @Override
        public T[] value(FieldOrbit<T> meanOrbit) {
            FieldSlot<T> slot = this.slots.get(meanOrbit.getDate());
            int F = meanOrbit.getLE();
            RealFieldElement[] shortPeriodic = ((FieldSlot)slot).cij[0].value(meanOrbit.getDate());
            for (int j = 1; j <= this.maxFreqF; ++j) {
                RealFieldElement cosjF = FastMath.cos((RealFieldElement)F.multiply((int)j));
                RealFieldElement sinjF = FastMath.sin((RealFieldElement)F.multiply((int)j));
                RealFieldElement[] c = ((FieldSlot)slot).cij[j].value(meanOrbit.getDate());
                RealFieldElement[] s = ((FieldSlot)slot).sij[j].value(meanOrbit.getDate());
                for (int i = 0; i < 6; ++i) {
                    shortPeriodic[i] = shortPeriodic[i].add(c[i].multiply(cosjF).add(s[i].multiply(sinjF)));
                }
            }
            return shortPeriodic;
        }

        @Override
        public String getCoefficientsKeyPrefix() {
            return this.prefix;
        }

        @Override
        public Map<String, T[]> getCoefficients(FieldAbsoluteDate<T> date, Set<String> selected) {
            FieldSlot<T> slot = this.slots.get(date);
            HashMap<String, T[]> coefficients = new HashMap<String, T[]>(2 * this.maxFreqF + 1);
            this.storeIfSelected(coefficients, selected, ((FieldSlot)slot).cij[0].value(date), "c", new int[]{0});
            for (int j = 1; j <= this.maxFreqF; ++j) {
                this.storeIfSelected(coefficients, selected, ((FieldSlot)slot).cij[j].value(date), "c", new int[]{j});
                this.storeIfSelected(coefficients, selected, ((FieldSlot)slot).sij[j].value(date), "s", new int[]{j});
            }
            return coefficients;
        }

        private void storeIfSelected(Map<String, T[]> map, Set<String> selected, T[] value, String id, int ... indices) {
            StringBuilder keyBuilder = new StringBuilder(this.getCoefficientsKeyPrefix());
            keyBuilder.append(id);
            for (int index : indices) {
                keyBuilder.append('[').append(index).append(']');
            }
            String key = keyBuilder.toString();
            if (selected.isEmpty() || selected.contains(key)) {
                map.put(key, value);
            }
        }
    }

    private static class ThirdBodyShortPeriodicCoefficients
    implements ShortPeriodTerms {
        private final int jMax;
        private final int interpolationPoints;
        private final int maxFreqF;
        private final String prefix;
        private final transient TimeSpanMap<Slot> slots;

        ThirdBodyShortPeriodicCoefficients(int jMax, int interpolationPoints, int maxFreqF, String bodyName, TimeSpanMap<Slot> slots) {
            this.jMax = jMax;
            this.interpolationPoints = interpolationPoints;
            this.maxFreqF = maxFreqF;
            this.prefix = DSSTThirdBody.SHORT_PERIOD_PREFIX + bodyName + "-";
            this.slots = slots;
        }

        public Slot createSlot(SpacecraftState ... meanStates) {
            AbsoluteDate last;
            Slot slot = new Slot(this.jMax, this.interpolationPoints);
            AbsoluteDate first = meanStates[0].getDate();
            if (first.compareTo(last = meanStates[meanStates.length - 1].getDate()) <= 0) {
                this.slots.addValidAfter(slot, first);
            } else {
                this.slots.addValidBefore(slot, first);
            }
            return slot;
        }

        @Override
        public double[] value(Orbit meanOrbit) {
            Slot slot = this.slots.get(meanOrbit.getDate());
            double F = meanOrbit.getLE();
            double[] shortPeriodic = slot.cij[0].value(meanOrbit.getDate());
            for (int j = 1; j <= this.maxFreqF; ++j) {
                double cosjF = FastMath.cos((double)j * F);
                double sinjF = FastMath.sin((double)j * F);
                double[] c = slot.cij[j].value(meanOrbit.getDate());
                double[] s = slot.sij[j].value(meanOrbit.getDate());
                for (int i = 0; i < 6; ++i) {
                    int n = i;
                    shortPeriodic[n] = shortPeriodic[n] + (c[i] * cosjF + s[i] * sinjF);
                }
            }
            return shortPeriodic;
        }

        @Override
        public String getCoefficientsKeyPrefix() {
            return this.prefix;
        }

        @Override
        public Map<String, double[]> getCoefficients(AbsoluteDate date, Set<String> selected) {
            Slot slot = this.slots.get(date);
            HashMap<String, double[]> coefficients = new HashMap<String, double[]>(2 * this.maxFreqF + 1);
            this.storeIfSelected(coefficients, selected, slot.cij[0].value(date), "c", 0);
            for (int j = 1; j <= this.maxFreqF; ++j) {
                this.storeIfSelected(coefficients, selected, slot.cij[j].value(date), "c", j);
                this.storeIfSelected(coefficients, selected, slot.sij[j].value(date), "s", j);
            }
            return coefficients;
        }

        private void storeIfSelected(Map<String, double[]> map, Set<String> selected, double[] value, String id, int ... indices) {
            StringBuilder keyBuilder = new StringBuilder(this.getCoefficientsKeyPrefix());
            keyBuilder.append(id);
            for (int index : indices) {
                keyBuilder.append('[').append(index).append(']');
            }
            String key = keyBuilder.toString();
            if (selected.isEmpty() || selected.contains(key)) {
                map.put(key, value);
            }
        }
    }

    private class FieldGeneratingFunctionCoefficients<T extends RealFieldElement<T>> {
        private final FieldFourierCjSjCoefficients<T> cjsjFourier;
        private final int jMax;
        private final T[][] cjCoefs;
        private final T[][] sjCoefs;

        FieldGeneratingFunctionCoefficients(int nMax, int sMax, int jMax, FieldDSSTThirdBodyContext<T> context, FieldHansenObjects<T> hansen, Field<T> field) {
            this.jMax = jMax;
            this.cjsjFourier = new FieldFourierCjSjCoefficients<T>(nMax, sMax, jMax, context, field);
            this.cjCoefs = (RealFieldElement[][])MathArrays.buildArray(field, 8, jMax + 1);
            this.sjCoefs = (RealFieldElement[][])MathArrays.buildArray(field, 8, jMax + 1);
            this.computeGeneratingFunctionCoefficients(context, hansen);
        }

        private void computeGeneratingFunctionCoefficients(FieldDSSTThirdBodyContext<T> context, FieldHansenObjects<T> hansenObjects) {
            FieldAuxiliaryElements auxiliaryElements = context.getFieldAuxiliaryElements();
            FieldUAnddU<T> udu = new FieldUAnddU<T>(context, hansenObjects);
            for (int j = 1; j <= this.jMax; ++j) {
                this.cjCoefs[0][j] = this.cjsjFourier.getCj(j);
                this.cjCoefs[1][j] = this.cjsjFourier.getdCjda(j);
                this.cjCoefs[2][j] = (RealFieldElement)this.cjsjFourier.getdCjdk(j).subtract(((RealFieldElement)this.cjsjFourier.getSjLambda(j - 1).subtract(this.cjsjFourier.getSjLambda(j + 1))).divide(2.0));
                this.cjCoefs[3][j] = (RealFieldElement)this.cjsjFourier.getdCjdh(j).subtract(((RealFieldElement)this.cjsjFourier.getCjLambda(j - 1).add(this.cjsjFourier.getCjLambda(j + 1))).divide(2.0));
                this.cjCoefs[4][j] = this.cjsjFourier.getdCjdalpha(j);
                this.cjCoefs[5][j] = this.cjsjFourier.getdCjdbeta(j);
                this.cjCoefs[6][j] = this.cjsjFourier.getdCjdgamma(j);
                this.cjCoefs[7][j] = this.cjsjFourier.getCjLambda(j);
                this.sjCoefs[0][j] = this.cjsjFourier.getSj(j);
                this.sjCoefs[1][j] = this.cjsjFourier.getdSjda(j);
                this.sjCoefs[2][j] = (RealFieldElement)this.cjsjFourier.getdSjdk(j).add(((RealFieldElement)this.cjsjFourier.getCjLambda(j - 1).subtract(this.cjsjFourier.getCjLambda(j + 1))).divide(2.0));
                this.sjCoefs[3][j] = (RealFieldElement)this.cjsjFourier.getdSjdh(j).subtract(((RealFieldElement)this.cjsjFourier.getSjLambda(j - 1).add(this.cjsjFourier.getSjLambda(j + 1))).divide(2.0));
                this.sjCoefs[4][j] = this.cjsjFourier.getdSjdalpha(j);
                this.sjCoefs[5][j] = this.cjsjFourier.getdSjdbeta(j);
                this.sjCoefs[6][j] = this.cjsjFourier.getdSjdgamma(j);
                this.sjCoefs[7][j] = this.cjsjFourier.getSjLambda(j);
                if (j != 1) continue;
                this.cjCoefs[0][j] = (RealFieldElement)this.cjCoefs[0][j].add(((RealFieldElement)auxiliaryElements.getH().negate()).multiply(udu.getU()));
                this.cjCoefs[1][j] = (RealFieldElement)this.cjCoefs[1][j].add(((RealFieldElement)auxiliaryElements.getH().negate()).multiply(udu.getdUda()));
                this.cjCoefs[2][j] = (RealFieldElement)this.cjCoefs[2][j].add(((RealFieldElement)auxiliaryElements.getH().negate()).multiply(udu.getdUdk()));
                this.cjCoefs[3][j] = (RealFieldElement)this.cjCoefs[3][j].add(((RealFieldElement)((RealFieldElement)((RealFieldElement)auxiliaryElements.getH().multiply(udu.getdUdh())).add(udu.getU())).add(this.cjsjFourier.getC0Lambda())).negate());
                this.cjCoefs[4][j] = (RealFieldElement)this.cjCoefs[4][j].add(((RealFieldElement)auxiliaryElements.getH().negate()).multiply(udu.getdUdAl()));
                this.cjCoefs[5][j] = (RealFieldElement)this.cjCoefs[5][j].add(((RealFieldElement)auxiliaryElements.getH().negate()).multiply(udu.getdUdBe()));
                this.cjCoefs[6][j] = (RealFieldElement)this.cjCoefs[6][j].add(((RealFieldElement)auxiliaryElements.getH().negate()).multiply(udu.getdUdGa()));
                this.sjCoefs[0][j] = (RealFieldElement)this.sjCoefs[0][j].add(auxiliaryElements.getK().multiply(udu.getU()));
                this.sjCoefs[1][j] = (RealFieldElement)this.sjCoefs[1][j].add(auxiliaryElements.getK().multiply(udu.getdUda()));
                this.sjCoefs[2][j] = (RealFieldElement)this.sjCoefs[2][j].add(((RealFieldElement)((RealFieldElement)auxiliaryElements.getK().multiply(udu.getdUdk())).add(udu.getU())).add(this.cjsjFourier.getC0Lambda()));
                this.sjCoefs[3][j] = (RealFieldElement)this.sjCoefs[3][j].add(auxiliaryElements.getK().multiply(udu.getdUdh()));
                this.sjCoefs[4][j] = (RealFieldElement)this.sjCoefs[4][j].add(auxiliaryElements.getK().multiply(udu.getdUdAl()));
                this.sjCoefs[5][j] = (RealFieldElement)this.sjCoefs[5][j].add(auxiliaryElements.getK().multiply(udu.getdUdBe()));
                this.sjCoefs[6][j] = (RealFieldElement)this.sjCoefs[6][j].add(auxiliaryElements.getK().multiply(udu.getdUdGa()));
            }
        }

        public T getSCj(int j) {
            return this.cjCoefs[0][j];
        }

        public T getSSj(int j) {
            return this.sjCoefs[0][j];
        }

        public T getdSdaCj(int j) {
            return this.cjCoefs[1][j];
        }

        public T getdSdaSj(int j) {
            return this.sjCoefs[1][j];
        }

        public T getdSdkCj(int j) {
            return this.cjCoefs[2][j];
        }

        public T getdSdkSj(int j) {
            return this.sjCoefs[2][j];
        }

        public T getdSdhCj(int j) {
            return this.cjCoefs[3][j];
        }

        public T getdSdhSj(int j) {
            return this.sjCoefs[3][j];
        }

        public T getdSdalphaCj(int j) {
            return this.cjCoefs[4][j];
        }

        public T getdSdalphaSj(int j) {
            return this.sjCoefs[4][j];
        }

        public T getdSdbetaCj(int j) {
            return this.cjCoefs[5][j];
        }

        public T getdSdbetaSj(int j) {
            return this.sjCoefs[5][j];
        }

        public T getdSdgammaCj(int j) {
            return this.cjCoefs[6][j];
        }

        public T getdSdgammaSj(int j) {
            return this.sjCoefs[6][j];
        }

        public T getdSdlambdaCj(int j) {
            return this.cjCoefs[7][j];
        }

        public T getdSdlambdaSj(int j) {
            return this.sjCoefs[7][j];
        }
    }

    private class GeneratingFunctionCoefficients {
        private final FourierCjSjCoefficients cjsjFourier;
        private final int jMax;
        private final double[][] cjCoefs;
        private final double[][] sjCoefs;

        GeneratingFunctionCoefficients(int nMax, int sMax, int jMax, DSSTThirdBodyContext context, HansenObjects hansen) {
            this.jMax = jMax;
            this.cjsjFourier = new FourierCjSjCoefficients(nMax, sMax, jMax, context);
            this.cjCoefs = new double[8][jMax + 1];
            this.sjCoefs = new double[8][jMax + 1];
            this.computeGeneratingFunctionCoefficients(context, hansen);
        }

        private void computeGeneratingFunctionCoefficients(DSSTThirdBodyContext context, HansenObjects hansenObjects) {
            AuxiliaryElements auxiliaryElements = context.getAuxiliaryElements();
            UAnddU udu = new UAnddU(context, hansenObjects);
            for (int j = 1; j <= this.jMax; ++j) {
                this.cjCoefs[0][j] = this.cjsjFourier.getCj(j);
                this.cjCoefs[1][j] = this.cjsjFourier.getdCjda(j);
                this.cjCoefs[2][j] = this.cjsjFourier.getdCjdk(j) - (this.cjsjFourier.getSjLambda(j - 1) - this.cjsjFourier.getSjLambda(j + 1)) / 2.0;
                this.cjCoefs[3][j] = this.cjsjFourier.getdCjdh(j) - (this.cjsjFourier.getCjLambda(j - 1) + this.cjsjFourier.getCjLambda(j + 1)) / 2.0;
                this.cjCoefs[4][j] = this.cjsjFourier.getdCjdalpha(j);
                this.cjCoefs[5][j] = this.cjsjFourier.getdCjdbeta(j);
                this.cjCoefs[6][j] = this.cjsjFourier.getdCjdgamma(j);
                this.cjCoefs[7][j] = this.cjsjFourier.getCjLambda(j);
                this.sjCoefs[0][j] = this.cjsjFourier.getSj(j);
                this.sjCoefs[1][j] = this.cjsjFourier.getdSjda(j);
                this.sjCoefs[2][j] = this.cjsjFourier.getdSjdk(j) + (this.cjsjFourier.getCjLambda(j - 1) - this.cjsjFourier.getCjLambda(j + 1)) / 2.0;
                this.sjCoefs[3][j] = this.cjsjFourier.getdSjdh(j) - (this.cjsjFourier.getSjLambda(j - 1) + this.cjsjFourier.getSjLambda(j + 1)) / 2.0;
                this.sjCoefs[4][j] = this.cjsjFourier.getdSjdalpha(j);
                this.sjCoefs[5][j] = this.cjsjFourier.getdSjdbeta(j);
                this.sjCoefs[6][j] = this.cjsjFourier.getdSjdgamma(j);
                this.sjCoefs[7][j] = this.cjsjFourier.getSjLambda(j);
                if (j != 1) continue;
                double[] dArray = this.cjCoefs[0];
                int n = j;
                dArray[n] = dArray[n] + -auxiliaryElements.getH() * udu.getU();
                double[] dArray2 = this.cjCoefs[1];
                int n2 = j;
                dArray2[n2] = dArray2[n2] + -auxiliaryElements.getH() * udu.getdUda();
                double[] dArray3 = this.cjCoefs[2];
                int n3 = j;
                dArray3[n3] = dArray3[n3] + -auxiliaryElements.getH() * udu.getdUdk();
                double[] dArray4 = this.cjCoefs[3];
                int n4 = j;
                dArray4[n4] = dArray4[n4] + -(auxiliaryElements.getH() * udu.getdUdh() + udu.getU() + this.cjsjFourier.getC0Lambda());
                double[] dArray5 = this.cjCoefs[4];
                int n5 = j;
                dArray5[n5] = dArray5[n5] + -auxiliaryElements.getH() * udu.getdUdAl();
                double[] dArray6 = this.cjCoefs[5];
                int n6 = j;
                dArray6[n6] = dArray6[n6] + -auxiliaryElements.getH() * udu.getdUdBe();
                double[] dArray7 = this.cjCoefs[6];
                int n7 = j;
                dArray7[n7] = dArray7[n7] + -auxiliaryElements.getH() * udu.getdUdGa();
                double[] dArray8 = this.sjCoefs[0];
                int n8 = j;
                dArray8[n8] = dArray8[n8] + auxiliaryElements.getK() * udu.getU();
                double[] dArray9 = this.sjCoefs[1];
                int n9 = j;
                dArray9[n9] = dArray9[n9] + auxiliaryElements.getK() * udu.getdUda();
                double[] dArray10 = this.sjCoefs[2];
                int n10 = j;
                dArray10[n10] = dArray10[n10] + (auxiliaryElements.getK() * udu.getdUdk() + udu.getU() + this.cjsjFourier.getC0Lambda());
                double[] dArray11 = this.sjCoefs[3];
                int n11 = j;
                dArray11[n11] = dArray11[n11] + auxiliaryElements.getK() * udu.getdUdh();
                double[] dArray12 = this.sjCoefs[4];
                int n12 = j;
                dArray12[n12] = dArray12[n12] + auxiliaryElements.getK() * udu.getdUdAl();
                double[] dArray13 = this.sjCoefs[5];
                int n13 = j;
                dArray13[n13] = dArray13[n13] + auxiliaryElements.getK() * udu.getdUdBe();
                double[] dArray14 = this.sjCoefs[6];
                int n14 = j;
                dArray14[n14] = dArray14[n14] + auxiliaryElements.getK() * udu.getdUdGa();
            }
        }

        public double getSCj(int j) {
            return this.cjCoefs[0][j];
        }

        public double getSSj(int j) {
            return this.sjCoefs[0][j];
        }

        public double getdSdaCj(int j) {
            return this.cjCoefs[1][j];
        }

        public double getdSdaSj(int j) {
            return this.sjCoefs[1][j];
        }

        public double getdSdkCj(int j) {
            return this.cjCoefs[2][j];
        }

        public double getdSdkSj(int j) {
            return this.sjCoefs[2][j];
        }

        public double getdSdhCj(int j) {
            return this.cjCoefs[3][j];
        }

        public double getdSdhSj(int j) {
            return this.sjCoefs[3][j];
        }

        public double getdSdalphaCj(int j) {
            return this.cjCoefs[4][j];
        }

        public double getdSdalphaSj(int j) {
            return this.sjCoefs[4][j];
        }

        public double getdSdbetaCj(int j) {
            return this.cjCoefs[5][j];
        }

        public double getdSdbetaSj(int j) {
            return this.sjCoefs[5][j];
        }

        public double getdSdgammaCj(int j) {
            return this.cjCoefs[6][j];
        }

        public double getdSdgammaSj(int j) {
            return this.sjCoefs[6][j];
        }

        public double getdSdlambdaCj(int j) {
            return this.cjCoefs[7][j];
        }

        public double getdSdlambdaSj(int j) {
            return this.sjCoefs[7][j];
        }
    }

    private static class FieldCjSjAlphaBetaKH<T extends RealFieldElement<T>> {
        private final FieldCjSjCoefficient<T> cjsjkh;
        private final FieldCjSjCoefficient<T> cjsjalbe;
        private final T[] coefAandDeriv;
        private final T[] coefBandDeriv;
        private final T[] coefDandDeriv;
        private final T[] coefEandDeriv;

        FieldCjSjAlphaBetaKH(FieldDSSTThirdBodyContext<T> context, Field<T> field) {
            FieldAuxiliaryElements auxiliaryElements = context.getFieldAuxiliaryElements();
            this.cjsjkh = new FieldCjSjCoefficient(auxiliaryElements.getK(), auxiliaryElements.getH(), field);
            this.cjsjalbe = new FieldCjSjCoefficient<T>(context.getAlpha(), context.getBeta(), field);
            this.coefAandDeriv = (RealFieldElement[])MathArrays.buildArray(field, 5);
            this.coefBandDeriv = (RealFieldElement[])MathArrays.buildArray(field, 5);
            this.coefDandDeriv = (RealFieldElement[])MathArrays.buildArray(field, 5);
            this.coefEandDeriv = (RealFieldElement[])MathArrays.buildArray(field, 5);
        }

        public void computeCoefficients(int j, int s) {
            int sign = j < s ? -1 : 1;
            int absJmS = FastMath.abs(j - s);
            int jps = j + s;
            this.coefAandDeriv[0] = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.cjsjalbe.getCj(s).multiply(this.cjsjkh.getSj(absJmS))).multiply(sign)).add(this.cjsjalbe.getSj(s).multiply(this.cjsjkh.getCj(absJmS)));
            this.coefAandDeriv[1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.cjsjalbe.getCj(s).multiply(this.cjsjkh.getDsjDk(absJmS))).multiply(sign)).add(this.cjsjalbe.getSj(s).multiply(this.cjsjkh.getDcjDk(absJmS)));
            this.coefAandDeriv[2] = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.cjsjalbe.getCj(s).multiply(this.cjsjkh.getDsjDh(absJmS))).multiply(sign)).add(this.cjsjalbe.getSj(s).multiply(this.cjsjkh.getDcjDh(absJmS)));
            this.coefAandDeriv[3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.cjsjalbe.getDcjDk(s).multiply(this.cjsjkh.getSj(absJmS))).multiply(sign)).add(this.cjsjalbe.getDsjDk(s).multiply(this.cjsjkh.getCj(absJmS)));
            this.coefAandDeriv[4] = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.cjsjalbe.getDcjDh(s).multiply(this.cjsjkh.getSj(absJmS))).multiply(sign)).add(this.cjsjalbe.getDsjDh(s).multiply(this.cjsjkh.getCj(absJmS)));
            this.coefBandDeriv[0] = (RealFieldElement)((RealFieldElement)this.cjsjalbe.getCj(s).multiply(this.cjsjkh.getSj(jps))).subtract(this.cjsjalbe.getSj(s).multiply(this.cjsjkh.getCj(jps)));
            this.coefBandDeriv[1] = (RealFieldElement)((RealFieldElement)this.cjsjalbe.getCj(s).multiply(this.cjsjkh.getDsjDk(jps))).subtract(this.cjsjalbe.getSj(s).multiply(this.cjsjkh.getDcjDk(jps)));
            this.coefBandDeriv[2] = (RealFieldElement)((RealFieldElement)this.cjsjalbe.getCj(s).multiply(this.cjsjkh.getDsjDh(jps))).subtract(this.cjsjalbe.getSj(s).multiply(this.cjsjkh.getDcjDh(jps)));
            this.coefBandDeriv[3] = (RealFieldElement)((RealFieldElement)this.cjsjalbe.getDcjDk(s).multiply(this.cjsjkh.getSj(jps))).subtract(this.cjsjalbe.getDsjDk(s).multiply(this.cjsjkh.getCj(jps)));
            this.coefBandDeriv[4] = (RealFieldElement)((RealFieldElement)this.cjsjalbe.getDcjDh(s).multiply(this.cjsjkh.getSj(jps))).subtract(this.cjsjalbe.getDsjDh(s).multiply(this.cjsjkh.getCj(jps)));
            this.coefDandDeriv[0] = (RealFieldElement)((RealFieldElement)this.cjsjalbe.getCj(s).multiply(this.cjsjkh.getCj(absJmS))).subtract(((RealFieldElement)this.cjsjalbe.getSj(s).multiply(this.cjsjkh.getSj(absJmS))).multiply(sign));
            this.coefDandDeriv[1] = (RealFieldElement)((RealFieldElement)this.cjsjalbe.getCj(s).multiply(this.cjsjkh.getDcjDk(absJmS))).subtract(((RealFieldElement)this.cjsjalbe.getSj(s).multiply(this.cjsjkh.getDsjDk(absJmS))).multiply(sign));
            this.coefDandDeriv[2] = (RealFieldElement)((RealFieldElement)this.cjsjalbe.getCj(s).multiply(this.cjsjkh.getDcjDh(absJmS))).subtract(((RealFieldElement)this.cjsjalbe.getSj(s).multiply(this.cjsjkh.getDsjDh(absJmS))).multiply(sign));
            this.coefDandDeriv[3] = (RealFieldElement)((RealFieldElement)this.cjsjalbe.getDcjDk(s).multiply(this.cjsjkh.getCj(absJmS))).subtract(((RealFieldElement)this.cjsjalbe.getDsjDk(s).multiply(this.cjsjkh.getSj(absJmS))).multiply(sign));
            this.coefDandDeriv[4] = (RealFieldElement)((RealFieldElement)this.cjsjalbe.getDcjDh(s).multiply(this.cjsjkh.getCj(absJmS))).subtract(((RealFieldElement)this.cjsjalbe.getDsjDh(s).multiply(this.cjsjkh.getSj(absJmS))).multiply(sign));
            this.coefEandDeriv[0] = (RealFieldElement)((RealFieldElement)this.cjsjalbe.getCj(s).multiply(this.cjsjkh.getCj(jps))).add(this.cjsjalbe.getSj(s).multiply(this.cjsjkh.getSj(jps)));
            this.coefEandDeriv[1] = (RealFieldElement)((RealFieldElement)this.cjsjalbe.getCj(s).multiply(this.cjsjkh.getDcjDk(jps))).add(this.cjsjalbe.getSj(s).multiply(this.cjsjkh.getDsjDk(jps)));
            this.coefEandDeriv[2] = (RealFieldElement)((RealFieldElement)this.cjsjalbe.getCj(s).multiply(this.cjsjkh.getDcjDh(jps))).add(this.cjsjalbe.getSj(s).multiply(this.cjsjkh.getDsjDh(jps)));
            this.coefEandDeriv[3] = (RealFieldElement)((RealFieldElement)this.cjsjalbe.getDcjDk(s).multiply(this.cjsjkh.getCj(jps))).add(this.cjsjalbe.getDsjDk(s).multiply(this.cjsjkh.getSj(jps)));
            this.coefEandDeriv[4] = (RealFieldElement)((RealFieldElement)this.cjsjalbe.getDcjDh(s).multiply(this.cjsjkh.getCj(jps))).add(this.cjsjalbe.getDsjDh(s).multiply(this.cjsjkh.getSj(jps)));
        }

        public T getCoefA() {
            return this.coefAandDeriv[0];
        }

        public T getdCoefAdk() {
            return this.coefAandDeriv[1];
        }

        public T getdCoefAdh() {
            return this.coefAandDeriv[2];
        }

        public T getdCoefAdalpha() {
            return this.coefAandDeriv[3];
        }

        public T getdCoefAdbeta() {
            return this.coefAandDeriv[4];
        }

        public T getCoefB() {
            return this.coefBandDeriv[0];
        }

        public T getdCoefBdk() {
            return this.coefBandDeriv[1];
        }

        public T getdCoefBdh() {
            return this.coefBandDeriv[2];
        }

        public T getdCoefBdalpha() {
            return this.coefBandDeriv[3];
        }

        public T getdCoefBdbeta() {
            return this.coefBandDeriv[4];
        }

        public T getCoefD() {
            return this.coefDandDeriv[0];
        }

        public T getdCoefDdk() {
            return this.coefDandDeriv[1];
        }

        public T getdCoefDdh() {
            return this.coefDandDeriv[2];
        }

        public T getdCoefDdalpha() {
            return this.coefDandDeriv[3];
        }

        public T getdCoefDdbeta() {
            return this.coefDandDeriv[4];
        }

        public T getCoefE() {
            return this.coefEandDeriv[0];
        }

        public T getdCoefEdk() {
            return this.coefEandDeriv[1];
        }

        public T getdCoefEdh() {
            return this.coefEandDeriv[2];
        }

        public T getdCoefEdalpha() {
            return this.coefEandDeriv[3];
        }

        public T getdCoefEdbeta() {
            return this.coefEandDeriv[4];
        }
    }

    private static class CjSjAlphaBetaKH {
        private final CjSjCoefficient cjsjkh;
        private final CjSjCoefficient cjsjalbe;
        private final double[] coefAandDeriv;
        private final double[] coefBandDeriv;
        private final double[] coefDandDeriv;
        private final double[] coefEandDeriv;

        CjSjAlphaBetaKH(DSSTThirdBodyContext context) {
            AuxiliaryElements auxiliaryElements = context.getAuxiliaryElements();
            this.cjsjkh = new CjSjCoefficient(auxiliaryElements.getK(), auxiliaryElements.getH());
            this.cjsjalbe = new CjSjCoefficient(context.getAlpha(), context.getBeta());
            this.coefAandDeriv = new double[5];
            this.coefBandDeriv = new double[5];
            this.coefDandDeriv = new double[5];
            this.coefEandDeriv = new double[5];
        }

        public void computeCoefficients(int j, int s) {
            int sign = j < s ? -1 : 1;
            int absJmS = FastMath.abs(j - s);
            int jps = j + s;
            this.coefAandDeriv[0] = (double)sign * this.cjsjalbe.getCj(s) * this.cjsjkh.getSj(absJmS) + this.cjsjalbe.getSj(s) * this.cjsjkh.getCj(absJmS);
            this.coefAandDeriv[1] = (double)sign * this.cjsjalbe.getCj(s) * this.cjsjkh.getDsjDk(absJmS) + this.cjsjalbe.getSj(s) * this.cjsjkh.getDcjDk(absJmS);
            this.coefAandDeriv[2] = (double)sign * this.cjsjalbe.getCj(s) * this.cjsjkh.getDsjDh(absJmS) + this.cjsjalbe.getSj(s) * this.cjsjkh.getDcjDh(absJmS);
            this.coefAandDeriv[3] = (double)sign * this.cjsjalbe.getDcjDk(s) * this.cjsjkh.getSj(absJmS) + this.cjsjalbe.getDsjDk(s) * this.cjsjkh.getCj(absJmS);
            this.coefAandDeriv[4] = (double)sign * this.cjsjalbe.getDcjDh(s) * this.cjsjkh.getSj(absJmS) + this.cjsjalbe.getDsjDh(s) * this.cjsjkh.getCj(absJmS);
            this.coefBandDeriv[0] = this.cjsjalbe.getCj(s) * this.cjsjkh.getSj(jps) - this.cjsjalbe.getSj(s) * this.cjsjkh.getCj(jps);
            this.coefBandDeriv[1] = this.cjsjalbe.getCj(s) * this.cjsjkh.getDsjDk(jps) - this.cjsjalbe.getSj(s) * this.cjsjkh.getDcjDk(jps);
            this.coefBandDeriv[2] = this.cjsjalbe.getCj(s) * this.cjsjkh.getDsjDh(jps) - this.cjsjalbe.getSj(s) * this.cjsjkh.getDcjDh(jps);
            this.coefBandDeriv[3] = this.cjsjalbe.getDcjDk(s) * this.cjsjkh.getSj(jps) - this.cjsjalbe.getDsjDk(s) * this.cjsjkh.getCj(jps);
            this.coefBandDeriv[4] = this.cjsjalbe.getDcjDh(s) * this.cjsjkh.getSj(jps) - this.cjsjalbe.getDsjDh(s) * this.cjsjkh.getCj(jps);
            this.coefDandDeriv[0] = this.cjsjalbe.getCj(s) * this.cjsjkh.getCj(absJmS) - (double)sign * this.cjsjalbe.getSj(s) * this.cjsjkh.getSj(absJmS);
            this.coefDandDeriv[1] = this.cjsjalbe.getCj(s) * this.cjsjkh.getDcjDk(absJmS) - (double)sign * this.cjsjalbe.getSj(s) * this.cjsjkh.getDsjDk(absJmS);
            this.coefDandDeriv[2] = this.cjsjalbe.getCj(s) * this.cjsjkh.getDcjDh(absJmS) - (double)sign * this.cjsjalbe.getSj(s) * this.cjsjkh.getDsjDh(absJmS);
            this.coefDandDeriv[3] = this.cjsjalbe.getDcjDk(s) * this.cjsjkh.getCj(absJmS) - (double)sign * this.cjsjalbe.getDsjDk(s) * this.cjsjkh.getSj(absJmS);
            this.coefDandDeriv[4] = this.cjsjalbe.getDcjDh(s) * this.cjsjkh.getCj(absJmS) - (double)sign * this.cjsjalbe.getDsjDh(s) * this.cjsjkh.getSj(absJmS);
            this.coefEandDeriv[0] = this.cjsjalbe.getCj(s) * this.cjsjkh.getCj(jps) + this.cjsjalbe.getSj(s) * this.cjsjkh.getSj(jps);
            this.coefEandDeriv[1] = this.cjsjalbe.getCj(s) * this.cjsjkh.getDcjDk(jps) + this.cjsjalbe.getSj(s) * this.cjsjkh.getDsjDk(jps);
            this.coefEandDeriv[2] = this.cjsjalbe.getCj(s) * this.cjsjkh.getDcjDh(jps) + this.cjsjalbe.getSj(s) * this.cjsjkh.getDsjDh(jps);
            this.coefEandDeriv[3] = this.cjsjalbe.getDcjDk(s) * this.cjsjkh.getCj(jps) + this.cjsjalbe.getDsjDk(s) * this.cjsjkh.getSj(jps);
            this.coefEandDeriv[4] = this.cjsjalbe.getDcjDh(s) * this.cjsjkh.getCj(jps) + this.cjsjalbe.getDsjDh(s) * this.cjsjkh.getSj(jps);
        }

        public double getCoefA() {
            return this.coefAandDeriv[0];
        }

        public double getdCoefAdk() {
            return this.coefAandDeriv[1];
        }

        public double getdCoefAdh() {
            return this.coefAandDeriv[2];
        }

        public double getdCoefAdalpha() {
            return this.coefAandDeriv[3];
        }

        public double getdCoefAdbeta() {
            return this.coefAandDeriv[4];
        }

        public double getCoefB() {
            return this.coefBandDeriv[0];
        }

        public double getdCoefBdk() {
            return this.coefBandDeriv[1];
        }

        public double getdCoefBdh() {
            return this.coefBandDeriv[2];
        }

        public double getdCoefBdalpha() {
            return this.coefBandDeriv[3];
        }

        public double getdCoefBdbeta() {
            return this.coefBandDeriv[4];
        }

        public double getCoefD() {
            return this.coefDandDeriv[0];
        }

        public double getdCoefDdk() {
            return this.coefDandDeriv[1];
        }

        public double getdCoefDdh() {
            return this.coefDandDeriv[2];
        }

        public double getdCoefDdalpha() {
            return this.coefDandDeriv[3];
        }

        public double getdCoefDdbeta() {
            return this.coefDandDeriv[4];
        }

        public double getCoefE() {
            return this.coefEandDeriv[0];
        }

        public double getdCoefEdk() {
            return this.coefEandDeriv[1];
        }

        public double getdCoefEdh() {
            return this.coefEandDeriv[2];
        }

        public double getdCoefEdalpha() {
            return this.coefEandDeriv[3];
        }

        public double getdCoefEdbeta() {
            return this.coefEandDeriv[4];
        }
    }

    private class FieldGnsCoefficients<T extends RealFieldElement<T>> {
        private final int nMax;
        private final int sMax;
        private final T[][] gns;
        private final T[][] dgnsda;
        private final T[][] dgnsdgamma;

        FieldGnsCoefficients(int nMax, int sMax, FieldDSSTThirdBodyContext<T> context, Field<T> field) {
            this.nMax = nMax;
            this.sMax = sMax;
            int rows = nMax + 1;
            int columns = sMax + 1;
            this.gns = (RealFieldElement[][])MathArrays.buildArray(field, rows, columns);
            this.dgnsda = (RealFieldElement[][])MathArrays.buildArray(field, rows, columns);
            this.dgnsdgamma = (RealFieldElement[][])MathArrays.buildArray(field, rows, columns);
            this.generateCoefficients(context, field);
        }

        private void generateCoefficients(FieldDSSTThirdBodyContext<T> context, Field<T> field) {
            RealFieldElement zero = (RealFieldElement)field.getZero();
            FieldAuxiliaryElements auxiliaryElements = context.getFieldAuxiliaryElements();
            for (int s = 0; s <= this.sMax; ++s) {
                int minN;
                for (int n = minN = FastMath.max(2, s); n <= this.nMax; ++n) {
                    if ((n - s) % 2 == 0) {
                        RealFieldElement delta0s = s == 0 ? (RealFieldElement)zero.add(1.0) : (RealFieldElement)zero.add(2.0);
                        double vns = (Double)DSSTThirdBody.this.Vns.get(new CoefficientsFactory.NSKey(n, s));
                        RealFieldElement coef0 = ((RealFieldElement)((RealFieldElement)context.getAoR3Pow()[n].multiply(vns)).multiply(context.getMuoR3())).multiply(delta0s);
                        RealFieldElement coef1 = coef0.multiply(context.getQns()[n][s]);
                        RealFieldElement dqns = n == s ? zero : context.getQns()[n][s + 1];
                        this.gns[n][s] = coef1;
                        this.dgnsda[n][s] = (RealFieldElement)((RealFieldElement)coef1.multiply(n)).divide(auxiliaryElements.getSma());
                        this.dgnsdgamma[n][s] = coef0.multiply(dqns);
                        continue;
                    }
                    this.gns[n][s] = zero;
                    this.dgnsda[n][s] = zero;
                    this.dgnsdgamma[n][s] = zero;
                }
            }
        }

        public T getGns(int n, int s) {
            return this.gns[n][s];
        }

        public T getdGnsda(int n, int s) {
            return this.dgnsda[n][s];
        }

        public T getdGnsdgamma(int n, int s) {
            return this.dgnsdgamma[n][s];
        }
    }

    private class GnsCoefficients {
        private final int nMax;
        private final int sMax;
        private final double[][] gns;
        private final double[][] dgnsda;
        private final double[][] dgnsdgamma;

        GnsCoefficients(int nMax, int sMax, DSSTThirdBodyContext context) {
            this.nMax = nMax;
            this.sMax = sMax;
            int rows = nMax + 1;
            int columns = sMax + 1;
            this.gns = new double[rows][columns];
            this.dgnsda = new double[rows][columns];
            this.dgnsdgamma = new double[rows][columns];
            this.generateCoefficients(context);
        }

        private void generateCoefficients(DSSTThirdBodyContext context) {
            AuxiliaryElements auxiliaryElements = context.getAuxiliaryElements();
            for (int s = 0; s <= this.sMax; ++s) {
                int minN;
                for (int n = minN = FastMath.max(2, s); n <= this.nMax; ++n) {
                    if ((n - s) % 2 == 0) {
                        double delta0s = s == 0 ? 1.0 : 2.0;
                        double vns = (Double)DSSTThirdBody.this.Vns.get(new CoefficientsFactory.NSKey(n, s));
                        double coef0 = delta0s * context.getAoR3Pow()[n] * vns * context.getMuoR3();
                        double coef1 = coef0 * context.getQns()[n][s];
                        double dqns = n == s ? 0.0 : context.getQns()[n][s + 1];
                        this.gns[n][s] = coef1;
                        this.dgnsda[n][s] = coef1 * (double)n / auxiliaryElements.getSma();
                        this.dgnsdgamma[n][s] = coef0 * dqns;
                        continue;
                    }
                    this.gns[n][s] = 0.0;
                    this.dgnsda[n][s] = 0.0;
                    this.dgnsdgamma[n][s] = 0.0;
                }
            }
        }

        public double getGns(int n, int s) {
            return this.gns[n][s];
        }

        public double getdGnsda(int n, int s) {
            return this.dgnsda[n][s];
        }

        public double getdGnsdgamma(int n, int s) {
            return this.dgnsdgamma[n][s];
        }
    }

    private class FieldWnsjEtomjmsCoefficient<T extends RealFieldElement<T>> {
        private final T c;
        private final T dbdh;
        private final T dbdk;
        private final T dcdh;
        private final T dcdk;
        private final T[] omc2tn;
        private final T[] opc2tn;
        private final T[] btjms;

        FieldWnsjEtomjmsCoefficient(FieldDSSTThirdBodyContext<T> context, Field<T> field) {
            int i;
            FieldAuxiliaryElements auxiliaryElements = context.getFieldAuxiliaryElements();
            RealFieldElement zero = (RealFieldElement)field.getZero();
            this.c = (RealFieldElement)auxiliaryElements.getEcc().multiply(context.getb());
            RealFieldElement c2 = (RealFieldElement)this.c.multiply(this.c);
            RealFieldElement b2Chi = (RealFieldElement)((RealFieldElement)context.getb().multiply(context.getb())).multiply(context.getX());
            this.dbdh = auxiliaryElements.getH().multiply((RealFieldElement)b2Chi);
            this.dbdk = auxiliaryElements.getK().multiply((RealFieldElement)b2Chi);
            if (auxiliaryElements.getEcc().getReal() == 0.0) {
                this.dcdh = (RealFieldElement)((RealFieldElement)auxiliaryElements.getEcc().multiply(this.dbdh)).add(context.getb());
                this.dcdk = (RealFieldElement)auxiliaryElements.getEcc().multiply(this.dbdk);
            } else {
                this.dcdh = (RealFieldElement)((RealFieldElement)auxiliaryElements.getEcc().multiply(this.dbdh)).add(((RealFieldElement)context.getb().multiply(auxiliaryElements.getH())).divide(auxiliaryElements.getEcc()));
                this.dcdk = (RealFieldElement)((RealFieldElement)auxiliaryElements.getEcc().multiply(this.dbdk)).add(((RealFieldElement)context.getb().multiply(auxiliaryElements.getK())).divide(auxiliaryElements.getEcc()));
            }
            this.omc2tn = (RealFieldElement[])MathArrays.buildArray(field, context.getMaxAR3Pow() + context.getMaxFreqF() + 2);
            this.opc2tn = (RealFieldElement[])MathArrays.buildArray(field, context.getMaxAR3Pow() + context.getMaxFreqF() + 2);
            RealFieldElement omc2 = (RealFieldElement)((RealFieldElement)c2.negate()).add(1.0);
            RealFieldElement opc2 = (RealFieldElement)c2.add(1.0);
            this.omc2tn[0] = (RealFieldElement)zero.add(1.0);
            this.opc2tn[0] = (RealFieldElement)zero.add(1.0);
            for (i = 1; i <= context.getMaxAR3Pow() + context.getMaxFreqF() + 1; ++i) {
                this.omc2tn[i] = this.omc2tn[i - 1].multiply((RealFieldElement)omc2);
                this.opc2tn[i] = this.opc2tn[i - 1].multiply((RealFieldElement)opc2);
            }
            this.btjms = (RealFieldElement[])MathArrays.buildArray(field, context.getMaxAR3Pow() + context.getMaxFreqF() + 1);
            this.btjms[0] = (RealFieldElement)zero.add(1.0);
            for (i = 1; i <= context.getMaxAR3Pow() + context.getMaxFreqF(); ++i) {
                this.btjms[i] = (RealFieldElement)this.btjms[i - 1].multiply(context.getb());
            }
        }

        public T[] computeWjnsEmjmsAndDeriv(int j, int s, int n, FieldDSSTThirdBodyContext<T> context, Field<T> field) {
            int l;
            RealFieldElement factCoef;
            RealFieldElement zero = (RealFieldElement)field.getZero();
            Object[] wjnsemjms = (RealFieldElement[])MathArrays.buildArray(field, 3);
            Arrays.fill(wjnsemjms, zero);
            int absJ = FastMath.abs(j);
            int absS = FastMath.abs(s);
            int absJmS = FastMath.abs(j - s);
            int absJpS = FastMath.abs(j + s);
            if (absS > absJ) {
                factCoef = (RealFieldElement)zero.add(CombinatoricsUtils.factorialDouble(n + s) / CombinatoricsUtils.factorialDouble(n + j) * (CombinatoricsUtils.factorialDouble(n - s) / CombinatoricsUtils.factorialDouble(n - j)));
                l = n - absS;
            } else {
                factCoef = (RealFieldElement)zero.add(1.0);
                l = n - absJ;
            }
            RealFieldElement sign = absJmS % 2 != 0 ? (RealFieldElement)zero.add(-1.0) : (RealFieldElement)zero.add(1.0);
            RealFieldElement coef1 = (RealFieldElement)this.omc2tn[l].divide(this.opc2tn[n]);
            RealFieldElement coef2 = this.btjms[absJmS].multiply((RealFieldElement)sign);
            FDSFactory fdsf = (FDSFactory)DSSTThirdBody.this.fieldFactory.get(field);
            FieldDerivativeStructure<T> jac = JacobiPolynomials.getValue(l, absJmS, absJpS, fdsf.variable(0, context.getX()));
            RealFieldElement dcoef1dc = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)coef1.negate()).multiply(2.0)).multiply(this.c)).multiply(((RealFieldElement)((RealFieldElement)this.opc2tn[1].reciprocal()).multiply(n)).add(((RealFieldElement)this.omc2tn[1].reciprocal()).multiply(l)));
            RealFieldElement dcoef1dh = (RealFieldElement)dcoef1dc.multiply(this.dcdh);
            RealFieldElement dcoef1dk = (RealFieldElement)dcoef1dc.multiply(this.dcdk);
            RealFieldElement dcoef2db = absJmS == 0 ? zero : (RealFieldElement)((RealFieldElement)sign.multiply(absJmS)).multiply(this.btjms[absJmS - 1]);
            RealFieldElement dcoef2dh = (RealFieldElement)dcoef2db.multiply(this.dbdh);
            RealFieldElement dcoef2dk = (RealFieldElement)dcoef2db.multiply(this.dbdk);
            T jacobi = jac.getValue();
            RealFieldElement djacobidh = (RealFieldElement)jac.getPartialDerivative(1).multiply(context.getHXXX());
            RealFieldElement djacobidk = (RealFieldElement)jac.getPartialDerivative(1).multiply(context.getKXXX());
            RealFieldElement term1 = factCoef.multiply(coef1).multiply(coef2);
            RealFieldElement term2 = (RealFieldElement)factCoef.multiply(coef1).multiply(jacobi);
            RealFieldElement term3 = (RealFieldElement)factCoef.multiply(coef2).multiply(jacobi);
            wjnsemjms[0] = (RealFieldElement)term1.multiply(jacobi);
            wjnsemjms[1] = dcoef1dk.multiply(term3).add(dcoef2dk.multiply(term2)).add(djacobidk.multiply(term1));
            wjnsemjms[2] = dcoef1dh.multiply(term3).add(dcoef2dh.multiply(term2)).add(djacobidh.multiply(term1));
            return wjnsemjms;
        }
    }

    private class WnsjEtomjmsCoefficient {
        private final double c;
        private final double dbdh;
        private final double dbdk;
        private final double dcdh;
        private final double dcdk;
        private final double[] omc2tn;
        private final double[] opc2tn;
        private final double[] btjms;

        WnsjEtomjmsCoefficient(DSSTThirdBodyContext context) {
            int i;
            AuxiliaryElements auxiliaryElements = context.getAuxiliaryElements();
            this.c = auxiliaryElements.getEcc() * context.getb();
            double c2 = this.c * this.c;
            double b2Chi = context.getb() * context.getb() * context.getX();
            this.dbdh = auxiliaryElements.getH() * b2Chi;
            this.dbdk = auxiliaryElements.getK() * b2Chi;
            if (auxiliaryElements.getEcc() == 0.0) {
                this.dcdh = auxiliaryElements.getEcc() * this.dbdh + context.getb();
                this.dcdk = auxiliaryElements.getEcc() * this.dbdk;
            } else {
                this.dcdh = auxiliaryElements.getEcc() * this.dbdh + context.getb() * auxiliaryElements.getH() / auxiliaryElements.getEcc();
                this.dcdk = auxiliaryElements.getEcc() * this.dbdk + context.getb() * auxiliaryElements.getK() / auxiliaryElements.getEcc();
            }
            this.omc2tn = new double[context.getMaxAR3Pow() + context.getMaxFreqF() + 2];
            this.opc2tn = new double[context.getMaxAR3Pow() + context.getMaxFreqF() + 2];
            double omc2 = 1.0 - c2;
            double opc2 = 1.0 + c2;
            this.omc2tn[0] = 1.0;
            this.opc2tn[0] = 1.0;
            for (i = 1; i <= context.getMaxAR3Pow() + context.getMaxFreqF() + 1; ++i) {
                this.omc2tn[i] = this.omc2tn[i - 1] * omc2;
                this.opc2tn[i] = this.opc2tn[i - 1] * opc2;
            }
            this.btjms = new double[context.getMaxAR3Pow() + context.getMaxFreqF() + 1];
            this.btjms[0] = 1.0;
            for (i = 1; i <= context.getMaxAR3Pow() + context.getMaxFreqF(); ++i) {
                this.btjms[i] = this.btjms[i - 1] * context.getb();
            }
        }

        public double[] computeWjnsEmjmsAndDeriv(int j, int s, int n, DSSTThirdBodyContext context) {
            int l;
            double factCoef;
            double[] wjnsemjms = new double[]{0.0, 0.0, 0.0};
            int absJ = FastMath.abs(j);
            int absS = FastMath.abs(s);
            int absJmS = FastMath.abs(j - s);
            int absJpS = FastMath.abs(j + s);
            if (absS > absJ) {
                factCoef = CombinatoricsUtils.factorialDouble(n + s) / CombinatoricsUtils.factorialDouble(n + j) * (CombinatoricsUtils.factorialDouble(n - s) / CombinatoricsUtils.factorialDouble(n - j));
                l = n - absS;
            } else {
                factCoef = 1.0;
                l = n - absJ;
            }
            double sign = absJmS % 2 != 0 ? -1.0 : 1.0;
            double coef1 = this.omc2tn[l] / this.opc2tn[n];
            double coef2 = sign * this.btjms[absJmS];
            DerivativeStructure jac = JacobiPolynomials.getValue(l, absJmS, absJpS, DSSTThirdBody.this.factory.variable(0, context.getX()));
            double dcoef1dc = -coef1 * 2.0 * this.c * ((double)n / this.opc2tn[1] + (double)l / this.omc2tn[1]);
            double dcoef1dh = dcoef1dc * this.dcdh;
            double dcoef1dk = dcoef1dc * this.dcdk;
            double dcoef2db = absJmS == 0 ? 0.0 : sign * (double)absJmS * this.btjms[absJmS - 1];
            double dcoef2dh = dcoef2db * this.dbdh;
            double dcoef2dk = dcoef2db * this.dbdk;
            double jacobi = jac.getValue();
            double djacobidh = jac.getPartialDerivative(1) * context.getHXXX();
            double djacobidk = jac.getPartialDerivative(1) * context.getKXXX();
            double term1 = factCoef * coef1 * coef2;
            double term2 = factCoef * coef1 * jacobi;
            double term3 = factCoef * coef2 * jacobi;
            wjnsemjms[0] = term1 * jacobi;
            wjnsemjms[1] = dcoef1dk * term3 + dcoef2dk * term2 + djacobidk * term1;
            wjnsemjms[2] = dcoef1dh * term3 + dcoef2dh * term2 + djacobidh * term1;
            return wjnsemjms;
        }
    }

    private class FieldFourierCjSjCoefficients<T extends RealFieldElement<T>> {
        private final FieldGnsCoefficients<T> gns;
        private final FieldWnsjEtomjmsCoefficient<T> wnsjEtomjmsCoefficient;
        private final FieldCjSjAlphaBetaKH<T> ABDECoefficients;
        private final T[][] cj;
        private final T[][] sj;
        private final T[] cjlambda;
        private final T[] sjlambda;
        private final T zero;
        private final int nMax;
        private final int sMax;
        private final int jMax;

        FieldFourierCjSjCoefficients(int nMax, int sMax, int jMax, FieldDSSTThirdBodyContext<T> context, Field<T> field) {
            this.zero = (RealFieldElement)field.getZero();
            this.nMax = nMax;
            this.sMax = sMax;
            this.jMax = jMax;
            this.wnsjEtomjmsCoefficient = new FieldWnsjEtomjmsCoefficient<T>(context, field);
            this.ABDECoefficients = new FieldCjSjAlphaBetaKH<T>(context, field);
            this.gns = new FieldGnsCoefficients<T>(nMax, sMax, context, field);
            this.cj = (RealFieldElement[][])MathArrays.buildArray(field, 7, jMax + 1);
            this.sj = (RealFieldElement[][])MathArrays.buildArray(field, 7, jMax + 1);
            this.cjlambda = (RealFieldElement[])MathArrays.buildArray(field, jMax);
            this.sjlambda = (RealFieldElement[])MathArrays.buildArray(field, jMax);
            this.computeCoefficients(context, field);
        }

        private void computeCoefficients(FieldDSSTThirdBodyContext<T> context, Field<T> field) {
            FieldAuxiliaryElements auxiliaryElements = context.getFieldAuxiliaryElements();
            for (int j = 1; j <= this.jMax; ++j) {
                int i;
                for (i = 0; i <= 6; ++i) {
                    this.cj[i][j] = this.zero;
                    this.sj[i][j] = this.zero;
                }
                if (j < this.jMax) {
                    this.cjlambda[j] = this.zero;
                    this.sjlambda[j] = this.zero;
                }
                for (int s = 0; s <= this.sMax; ++s) {
                    int minN;
                    this.ABDECoefficients.computeCoefficients(j, s);
                    for (int n = minN = FastMath.max(2, FastMath.max(j - 1, s)); n <= this.nMax; ++n) {
                        if ((n - s) % 2 != 0) continue;
                        RealFieldElement[] wjnp1semjms = this.wnsjEtomjmsCoefficient.computeWjnsEmjmsAndDeriv(j, s, n + 1, context, field);
                        RealFieldElement[] wmjnp1semjms = this.wnsjEtomjmsCoefficient.computeWjnsEmjmsAndDeriv(-j, s, n + 1, context, field);
                        RealFieldElement coef1 = (RealFieldElement)((RealFieldElement)((RealFieldElement)wjnp1semjms[0].multiply(this.ABDECoefficients.getCoefA())).add(wmjnp1semjms[0].multiply(this.ABDECoefficients.getCoefB()))).negate();
                        RealFieldElement coef2 = (RealFieldElement)((RealFieldElement)wjnp1semjms[0].multiply(this.ABDECoefficients.getCoefD())).add(wmjnp1semjms[0].multiply(this.ABDECoefficients.getCoefE()));
                        this.cj[0][j] = this.cj[0][j].add((RealFieldElement)this.gns.getGns(n, s).multiply((RealFieldElement)coef1));
                        this.cj[1][j] = this.cj[1][j].add((RealFieldElement)this.gns.getdGnsda(n, s).multiply((RealFieldElement)coef1));
                        this.cj[2][j] = (RealFieldElement)this.cj[2][j].add(((RealFieldElement)this.gns.getGns(n, s).negate()).multiply(((RealFieldElement)((RealFieldElement)((RealFieldElement)wjnp1semjms[1].multiply(this.ABDECoefficients.getCoefA())).add(wjnp1semjms[0].multiply(this.ABDECoefficients.getdCoefAdk()))).add(wmjnp1semjms[1].multiply(this.ABDECoefficients.getCoefB()))).add(wmjnp1semjms[0].multiply(this.ABDECoefficients.getdCoefBdk()))));
                        this.cj[3][j] = (RealFieldElement)this.cj[3][j].add(((RealFieldElement)this.gns.getGns(n, s).negate()).multiply(((RealFieldElement)((RealFieldElement)((RealFieldElement)wjnp1semjms[2].multiply(this.ABDECoefficients.getCoefA())).add(wjnp1semjms[0].multiply(this.ABDECoefficients.getdCoefAdh()))).add(wmjnp1semjms[2].multiply(this.ABDECoefficients.getCoefB()))).add(wmjnp1semjms[0].multiply(this.ABDECoefficients.getdCoefBdh()))));
                        this.cj[4][j] = (RealFieldElement)this.cj[4][j].add(((RealFieldElement)this.gns.getGns(n, s).negate()).multiply(((RealFieldElement)wjnp1semjms[0].multiply(this.ABDECoefficients.getdCoefAdalpha())).add(wmjnp1semjms[0].multiply(this.ABDECoefficients.getdCoefBdalpha()))));
                        this.cj[5][j] = (RealFieldElement)this.cj[5][j].add(((RealFieldElement)this.gns.getGns(n, s).negate()).multiply(((RealFieldElement)wjnp1semjms[0].multiply(this.ABDECoefficients.getdCoefAdbeta())).add(wmjnp1semjms[0].multiply(this.ABDECoefficients.getdCoefBdbeta()))));
                        this.cj[6][j] = this.cj[6][j].add((RealFieldElement)this.gns.getdGnsdgamma(n, s).multiply((RealFieldElement)coef1));
                        this.sj[0][j] = this.sj[0][j].add((RealFieldElement)this.gns.getGns(n, s).multiply((RealFieldElement)coef2));
                        this.sj[1][j] = this.sj[1][j].add((RealFieldElement)this.gns.getdGnsda(n, s).multiply((RealFieldElement)coef2));
                        this.sj[2][j] = (RealFieldElement)this.sj[2][j].add(this.gns.getGns(n, s).multiply(((RealFieldElement)((RealFieldElement)((RealFieldElement)wjnp1semjms[1].multiply(this.ABDECoefficients.getCoefD())).add(wjnp1semjms[0].multiply(this.ABDECoefficients.getdCoefDdk()))).add(wmjnp1semjms[1].multiply(this.ABDECoefficients.getCoefE()))).add(wmjnp1semjms[0].multiply(this.ABDECoefficients.getdCoefEdk()))));
                        this.sj[3][j] = (RealFieldElement)this.sj[3][j].add(this.gns.getGns(n, s).multiply(((RealFieldElement)((RealFieldElement)((RealFieldElement)wjnp1semjms[2].multiply(this.ABDECoefficients.getCoefD())).add(wjnp1semjms[0].multiply(this.ABDECoefficients.getdCoefDdh()))).add(wmjnp1semjms[2].multiply(this.ABDECoefficients.getCoefE()))).add(wmjnp1semjms[0].multiply(this.ABDECoefficients.getdCoefEdh()))));
                        this.sj[4][j] = (RealFieldElement)this.sj[4][j].add(this.gns.getGns(n, s).multiply(((RealFieldElement)wjnp1semjms[0].multiply(this.ABDECoefficients.getdCoefDdalpha())).add(wmjnp1semjms[0].multiply(this.ABDECoefficients.getdCoefEdalpha()))));
                        this.sj[5][j] = (RealFieldElement)this.sj[5][j].add(this.gns.getGns(n, s).multiply(((RealFieldElement)wjnp1semjms[0].multiply(this.ABDECoefficients.getdCoefDdbeta())).add(wmjnp1semjms[0].multiply(this.ABDECoefficients.getdCoefEdbeta()))));
                        this.sj[6][j] = this.sj[6][j].add((RealFieldElement)this.gns.getdGnsdgamma(n, s).multiply((RealFieldElement)coef2));
                        if (n < j || j >= this.jMax) continue;
                        RealFieldElement[] wjnsemjms = this.wnsjEtomjmsCoefficient.computeWjnsEmjmsAndDeriv(j, s, n, context, field);
                        RealFieldElement[] wmjnsemjms = this.wnsjEtomjmsCoefficient.computeWjnsEmjmsAndDeriv(-j, s, n, context, field);
                        this.cjlambda[j] = (RealFieldElement)this.cjlambda[j].add(this.gns.getGns(n, s).multiply(((RealFieldElement)wjnsemjms[0].multiply(this.ABDECoefficients.getCoefD())).add(wmjnsemjms[0].multiply(this.ABDECoefficients.getCoefE()))));
                        this.sjlambda[j] = (RealFieldElement)this.sjlambda[j].add(this.gns.getGns(n, s).multiply(((RealFieldElement)wjnsemjms[0].multiply(this.ABDECoefficients.getCoefA())).add(wmjnsemjms[0].multiply(this.ABDECoefficients.getCoefB()))));
                    }
                }
                for (i = 0; i <= 6; ++i) {
                    this.cj[i][j] = (RealFieldElement)this.cj[i][j].divide(j);
                    this.sj[i][j] = (RealFieldElement)this.sj[i][j].divide(j);
                }
            }
            this.cjlambda[0] = (RealFieldElement)((RealFieldElement)((RealFieldElement)auxiliaryElements.getK().multiply(this.cjlambda[1])).divide(2.0)).add(((RealFieldElement)auxiliaryElements.getH().multiply(this.sjlambda[1])).divide(2.0));
        }

        public T getCj(int j) {
            return this.cj[0][j];
        }

        public T getdCjda(int j) {
            return this.cj[1][j];
        }

        public T getdCjdk(int j) {
            return this.cj[2][j];
        }

        public T getdCjdh(int j) {
            return this.cj[3][j];
        }

        public T getdCjdalpha(int j) {
            return this.cj[4][j];
        }

        public T getdCjdbeta(int j) {
            return this.cj[5][j];
        }

        public T getdCjdgamma(int j) {
            return this.cj[6][j];
        }

        public T getSj(int j) {
            return this.sj[0][j];
        }

        public T getdSjda(int j) {
            return this.sj[1][j];
        }

        public T getdSjdk(int j) {
            return this.sj[2][j];
        }

        public T getdSjdh(int j) {
            return this.sj[3][j];
        }

        public T getdSjdalpha(int j) {
            return this.sj[4][j];
        }

        public T getdSjdbeta(int j) {
            return this.sj[5][j];
        }

        public T getdSjdgamma(int j) {
            return this.sj[6][j];
        }

        public T getC0Lambda() {
            return this.cjlambda[0];
        }

        public T getCjLambda(int j) {
            if (j < 1 || j >= this.jMax) {
                return this.zero;
            }
            return this.cjlambda[j];
        }

        public T getSjLambda(int j) {
            if (j < 1 || j >= this.jMax) {
                return this.zero;
            }
            return this.sjlambda[j];
        }
    }

    private class FourierCjSjCoefficients {
        private final GnsCoefficients gns;
        private final WnsjEtomjmsCoefficient wnsjEtomjmsCoefficient;
        private final CjSjAlphaBetaKH ABDECoefficients;
        private final double[][] cj;
        private final double[][] sj;
        private final double[] cjlambda;
        private final double[] sjlambda;
        private final int nMax;
        private final int sMax;
        private final int jMax;

        FourierCjSjCoefficients(int nMax, int sMax, int jMax, DSSTThirdBodyContext context) {
            this.nMax = nMax;
            this.sMax = sMax;
            this.jMax = jMax;
            this.wnsjEtomjmsCoefficient = new WnsjEtomjmsCoefficient(context);
            this.ABDECoefficients = new CjSjAlphaBetaKH(context);
            this.gns = new GnsCoefficients(nMax, sMax, context);
            this.cj = new double[7][jMax + 1];
            this.sj = new double[7][jMax + 1];
            this.cjlambda = new double[jMax];
            this.sjlambda = new double[jMax];
            this.computeCoefficients(context);
        }

        private void computeCoefficients(DSSTThirdBodyContext context) {
            AuxiliaryElements auxiliaryElements = context.getAuxiliaryElements();
            for (int j = 1; j <= this.jMax; ++j) {
                int i;
                for (i = 0; i <= 6; ++i) {
                    this.cj[i][j] = 0.0;
                    this.sj[i][j] = 0.0;
                }
                if (j < this.jMax) {
                    this.cjlambda[j] = 0.0;
                    this.sjlambda[j] = 0.0;
                }
                for (int s = 0; s <= this.sMax; ++s) {
                    int minN;
                    this.ABDECoefficients.computeCoefficients(j, s);
                    for (int n = minN = FastMath.max(2, FastMath.max(j - 1, s)); n <= this.nMax; ++n) {
                        if ((n - s) % 2 != 0) continue;
                        double[] wjnp1semjms = this.wnsjEtomjmsCoefficient.computeWjnsEmjmsAndDeriv(j, s, n + 1, context);
                        double[] wmjnp1semjms = this.wnsjEtomjmsCoefficient.computeWjnsEmjmsAndDeriv(-j, s, n + 1, context);
                        double coef1 = -(wjnp1semjms[0] * this.ABDECoefficients.getCoefA() + wmjnp1semjms[0] * this.ABDECoefficients.getCoefB());
                        double coef2 = wjnp1semjms[0] * this.ABDECoefficients.getCoefD() + wmjnp1semjms[0] * this.ABDECoefficients.getCoefE();
                        double[] dArray = this.cj[0];
                        int n2 = j;
                        dArray[n2] = dArray[n2] + this.gns.getGns(n, s) * coef1;
                        double[] dArray2 = this.cj[1];
                        int n3 = j;
                        dArray2[n3] = dArray2[n3] + this.gns.getdGnsda(n, s) * coef1;
                        double[] dArray3 = this.cj[2];
                        int n4 = j;
                        dArray3[n4] = dArray3[n4] + -this.gns.getGns(n, s) * (wjnp1semjms[1] * this.ABDECoefficients.getCoefA() + wjnp1semjms[0] * this.ABDECoefficients.getdCoefAdk() + wmjnp1semjms[1] * this.ABDECoefficients.getCoefB() + wmjnp1semjms[0] * this.ABDECoefficients.getdCoefBdk());
                        double[] dArray4 = this.cj[3];
                        int n5 = j;
                        dArray4[n5] = dArray4[n5] + -this.gns.getGns(n, s) * (wjnp1semjms[2] * this.ABDECoefficients.getCoefA() + wjnp1semjms[0] * this.ABDECoefficients.getdCoefAdh() + wmjnp1semjms[2] * this.ABDECoefficients.getCoefB() + wmjnp1semjms[0] * this.ABDECoefficients.getdCoefBdh());
                        double[] dArray5 = this.cj[4];
                        int n6 = j;
                        dArray5[n6] = dArray5[n6] + -this.gns.getGns(n, s) * (wjnp1semjms[0] * this.ABDECoefficients.getdCoefAdalpha() + wmjnp1semjms[0] * this.ABDECoefficients.getdCoefBdalpha());
                        double[] dArray6 = this.cj[5];
                        int n7 = j;
                        dArray6[n7] = dArray6[n7] + -this.gns.getGns(n, s) * (wjnp1semjms[0] * this.ABDECoefficients.getdCoefAdbeta() + wmjnp1semjms[0] * this.ABDECoefficients.getdCoefBdbeta());
                        double[] dArray7 = this.cj[6];
                        int n8 = j;
                        dArray7[n8] = dArray7[n8] + this.gns.getdGnsdgamma(n, s) * coef1;
                        double[] dArray8 = this.sj[0];
                        int n9 = j;
                        dArray8[n9] = dArray8[n9] + this.gns.getGns(n, s) * coef2;
                        double[] dArray9 = this.sj[1];
                        int n10 = j;
                        dArray9[n10] = dArray9[n10] + this.gns.getdGnsda(n, s) * coef2;
                        double[] dArray10 = this.sj[2];
                        int n11 = j;
                        dArray10[n11] = dArray10[n11] + this.gns.getGns(n, s) * (wjnp1semjms[1] * this.ABDECoefficients.getCoefD() + wjnp1semjms[0] * this.ABDECoefficients.getdCoefDdk() + wmjnp1semjms[1] * this.ABDECoefficients.getCoefE() + wmjnp1semjms[0] * this.ABDECoefficients.getdCoefEdk());
                        double[] dArray11 = this.sj[3];
                        int n12 = j;
                        dArray11[n12] = dArray11[n12] + this.gns.getGns(n, s) * (wjnp1semjms[2] * this.ABDECoefficients.getCoefD() + wjnp1semjms[0] * this.ABDECoefficients.getdCoefDdh() + wmjnp1semjms[2] * this.ABDECoefficients.getCoefE() + wmjnp1semjms[0] * this.ABDECoefficients.getdCoefEdh());
                        double[] dArray12 = this.sj[4];
                        int n13 = j;
                        dArray12[n13] = dArray12[n13] + this.gns.getGns(n, s) * (wjnp1semjms[0] * this.ABDECoefficients.getdCoefDdalpha() + wmjnp1semjms[0] * this.ABDECoefficients.getdCoefEdalpha());
                        double[] dArray13 = this.sj[5];
                        int n14 = j;
                        dArray13[n14] = dArray13[n14] + this.gns.getGns(n, s) * (wjnp1semjms[0] * this.ABDECoefficients.getdCoefDdbeta() + wmjnp1semjms[0] * this.ABDECoefficients.getdCoefEdbeta());
                        double[] dArray14 = this.sj[6];
                        int n15 = j;
                        dArray14[n15] = dArray14[n15] + this.gns.getdGnsdgamma(n, s) * coef2;
                        if (n < j || j >= this.jMax) continue;
                        double[] wjnsemjms = this.wnsjEtomjmsCoefficient.computeWjnsEmjmsAndDeriv(j, s, n, context);
                        double[] wmjnsemjms = this.wnsjEtomjmsCoefficient.computeWjnsEmjmsAndDeriv(-j, s, n, context);
                        int n16 = j;
                        this.cjlambda[n16] = this.cjlambda[n16] + this.gns.getGns(n, s) * (wjnsemjms[0] * this.ABDECoefficients.getCoefD() + wmjnsemjms[0] * this.ABDECoefficients.getCoefE());
                        int n17 = j;
                        this.sjlambda[n17] = this.sjlambda[n17] + this.gns.getGns(n, s) * (wjnsemjms[0] * this.ABDECoefficients.getCoefA() + wmjnsemjms[0] * this.ABDECoefficients.getCoefB());
                    }
                }
                for (i = 0; i <= 6; ++i) {
                    double[] dArray = this.cj[i];
                    int n = j;
                    dArray[n] = dArray[n] / (double)j;
                    double[] dArray15 = this.sj[i];
                    int n18 = j;
                    dArray15[n18] = dArray15[n18] / (double)j;
                }
            }
            this.cjlambda[0] = auxiliaryElements.getK() * this.cjlambda[1] / 2.0 + auxiliaryElements.getH() * this.sjlambda[1] / 2.0;
        }

        public double getCj(int j) {
            return this.cj[0][j];
        }

        public double getdCjda(int j) {
            return this.cj[1][j];
        }

        public double getdCjdk(int j) {
            return this.cj[2][j];
        }

        public double getdCjdh(int j) {
            return this.cj[3][j];
        }

        public double getdCjdalpha(int j) {
            return this.cj[4][j];
        }

        public double getdCjdbeta(int j) {
            return this.cj[5][j];
        }

        public double getdCjdgamma(int j) {
            return this.cj[6][j];
        }

        public double getSj(int j) {
            return this.sj[0][j];
        }

        public double getdSjda(int j) {
            return this.sj[1][j];
        }

        public double getdSjdk(int j) {
            return this.sj[2][j];
        }

        public double getdSjdh(int j) {
            return this.sj[3][j];
        }

        public double getdSjdalpha(int j) {
            return this.sj[4][j];
        }

        public double getdSjdbeta(int j) {
            return this.sj[5][j];
        }

        public double getdSjdgamma(int j) {
            return this.sj[6][j];
        }

        public double getC0Lambda() {
            return this.cjlambda[0];
        }

        public double getCjLambda(int j) {
            if (j < 1 || j >= this.jMax) {
                return 0.0;
            }
            return this.cjlambda[j];
        }

        public double getSjLambda(int j) {
            if (j < 1 || j >= this.jMax) {
                return 0.0;
            }
            return this.sjlambda[j];
        }
    }
}

