/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.util.CombinatoricsUtils;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTZonalContext;
import org.orekit.propagation.semianalytical.dsst.forces.FieldDSSTZonalContext;
import org.orekit.propagation.semianalytical.dsst.forces.FieldShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.forces.ShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.CjSjCoefficient;
import org.orekit.propagation.semianalytical.dsst.utilities.CoefficientsFactory;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldCjSjCoefficient;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldGHIJjsPolynomials;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldLnsCoefficients;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldShortPeriodicsInterpolatedCoefficient;
import org.orekit.propagation.semianalytical.dsst.utilities.GHIJjsPolynomials;
import org.orekit.propagation.semianalytical.dsst.utilities.LnsCoefficients;
import org.orekit.propagation.semianalytical.dsst.utilities.ShortPeriodicsInterpolatedCoefficient;
import org.orekit.propagation.semianalytical.dsst.utilities.UpperBounds;
import org.orekit.propagation.semianalytical.dsst.utilities.hansen.FieldHansenZonalLinear;
import org.orekit.propagation.semianalytical.dsst.utilities.hansen.HansenZonalLinear;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldTimeSpanMap;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;

public class DSSTZonal
implements DSSTForceModel {
    public static final String SHORT_PERIOD_PREFIX = "DSST-central-body-zonal-";
    private static final int I = 1;
    private static final int INTERPOLATION_POINTS = 3;
    private static final double TRUNCATION_TOLERANCE = 1.0E-4;
    private static final double MU_SCALE = FastMath.scalb(1.0, 32);
    private final TreeMap<CoefficientsFactory.NSKey, Double> Vns;
    private final UnnormalizedSphericalHarmonicsProvider provider;
    private final int maxDegree;
    private final int maxDegreeShortPeriodics;
    private final int maxEccPowShortPeriodics;
    private final int maxFrequencyShortPeriodics;
    private int maxEccPowMeanElements;
    private int maxEccPow;
    private ZonalShortPeriodicCoefficients zonalSPCoefs;
    private Map<Field<?>, FieldZonalShortPeriodicCoefficients<?>> zonalFieldSPCoefs;
    private final ParameterDriver gmParameterDriver;
    private HansenObjects hansen;
    private Map<Field<?>, FieldHansenObjects<?>> fieldHansen;
    private boolean pendingInitialization;

    public DSSTZonal(UnnormalizedSphericalHarmonicsProvider provider, int maxDegreeShortPeriodics, int maxEccPowShortPeriodics, int maxFrequencyShortPeriodics) {
        this.gmParameterDriver = new ParameterDriver("central attraction coefficient", provider.getMu(), MU_SCALE, 0.0, Double.POSITIVE_INFINITY);
        this.Vns = CoefficientsFactory.computeVns(provider.getMaxDegree() + 1);
        this.provider = provider;
        this.maxDegree = provider.getMaxDegree();
        this.checkIndexRange(maxDegreeShortPeriodics, 2, provider.getMaxDegree());
        this.maxDegreeShortPeriodics = maxDegreeShortPeriodics;
        this.checkIndexRange(maxEccPowShortPeriodics, 0, maxDegreeShortPeriodics - 1);
        this.maxEccPowShortPeriodics = maxEccPowShortPeriodics;
        this.checkIndexRange(maxFrequencyShortPeriodics, 1, 2 * maxDegreeShortPeriodics + 1);
        this.maxFrequencyShortPeriodics = maxFrequencyShortPeriodics;
        this.maxEccPowMeanElements = this.maxDegree == 2 ? 0 : Integer.MIN_VALUE;
        this.pendingInitialization = true;
        this.zonalFieldSPCoefs = new HashMap();
        this.fieldHansen = new HashMap();
    }

    private void checkIndexRange(int index, int min, int max) {
        if (index < min || index > max) {
            throw new OrekitException((Localizable)LocalizedCoreFormats.OUT_OF_RANGE_SIMPLE, index, min, max);
        }
    }

    public UnnormalizedSphericalHarmonicsProvider getProvider() {
        return this.provider;
    }

    @Override
    public List<ShortPeriodTerms> initialize(AuxiliaryElements auxiliaryElements, PropagationType type, double[] parameters) {
        this.computeMeanElementsTruncations(auxiliaryElements, parameters);
        switch (type) {
            case MEAN: {
                this.maxEccPow = this.maxEccPowMeanElements;
                break;
            }
            case OSCULATING: {
                this.maxEccPow = FastMath.max(this.maxEccPowMeanElements, this.maxEccPowShortPeriodics);
                break;
            }
            default: {
                throw new OrekitInternalError(null);
            }
        }
        this.hansen = new HansenObjects();
        ArrayList<ShortPeriodTerms> list = new ArrayList<ShortPeriodTerms>();
        this.zonalSPCoefs = new ZonalShortPeriodicCoefficients(this.maxFrequencyShortPeriodics, 3, new TimeSpanMap<Slot>(new Slot(this.maxFrequencyShortPeriodics, 3)));
        list.add(this.zonalSPCoefs);
        return list;
    }

    @Override
    public <T extends RealFieldElement<T>> List<FieldShortPeriodTerms<T>> initialize(FieldAuxiliaryElements<T> auxiliaryElements, PropagationType type, T[] parameters) {
        Field<T> field = auxiliaryElements.getDate().getField();
        if (this.pendingInitialization) {
            this.computeMeanElementsTruncations(auxiliaryElements, (RealFieldElement[])parameters, field);
            switch (type) {
                case MEAN: {
                    this.maxEccPow = this.maxEccPowMeanElements;
                    break;
                }
                case OSCULATING: {
                    this.maxEccPow = FastMath.max(this.maxEccPowMeanElements, this.maxEccPowShortPeriodics);
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            this.fieldHansen.put(field, new FieldHansenObjects<T>(field));
            this.pendingInitialization = false;
        }
        FieldZonalShortPeriodicCoefficients fzspc = new FieldZonalShortPeriodicCoefficients(this.maxFrequencyShortPeriodics, 3, new FieldTimeSpanMap(new FieldSlot(this.maxFrequencyShortPeriodics, 3), field));
        this.zonalFieldSPCoefs.put(field, fzspc);
        return Collections.singletonList(fzspc);
    }

    private void computeMeanElementsTruncations(AuxiliaryElements auxiliaryElements, double[] parameters) {
        DSSTZonalContext context = new DSSTZonalContext(auxiliaryElements, this.provider, parameters);
        if (this.maxDegree == 2) {
            this.maxEccPowMeanElements = 0;
        } else {
            UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics = this.provider.onDate(auxiliaryElements.getDate());
            double ax2or = 2.0 * auxiliaryElements.getSma() / this.provider.getAe();
            double xmuran = parameters[0] / auxiliaryElements.getSma();
            double eo2 = FastMath.max(0.0025, auxiliaryElements.getEcc() / 2.0);
            double x2o2 = context.getXX() / 2.0;
            double[] eccPwr = new double[this.maxDegree + 1];
            double[] chiPwr = new double[this.maxDegree + 1];
            double[] hafPwr = new double[this.maxDegree + 1];
            eccPwr[0] = 1.0;
            chiPwr[0] = context.getX();
            hafPwr[0] = 1.0;
            for (int i = 1; i <= this.maxDegree; ++i) {
                eccPwr[i] = eccPwr[i - 1] * eo2;
                chiPwr[i] = chiPwr[i - 1] * x2o2;
                hafPwr[i] = hafPwr[i - 1] * 0.5;
                xmuran /= ax2or;
            }
            this.maxEccPowMeanElements = 0;
            int maxDeg = this.maxDegree;
            do {
                double snm;
                double cnm;
                double csnm;
                int m = 0;
                while ((csnm = FastMath.hypot(cnm = harmonics.getUnnormalizedCnm(maxDeg, m), snm = harmonics.getUnnormalizedSnm(maxDeg, m))) != 0.0) {
                    double lastTerm = 0.0;
                    int nsld2 = (maxDeg - this.maxEccPowMeanElements - 1) / 2;
                    int l = maxDeg - 2 * nsld2;
                    double term = 0.0;
                    do {
                        if ((term = m < l ? csnm * xmuran * (CombinatoricsUtils.factorialDouble(maxDeg - l) / CombinatoricsUtils.factorialDouble(maxDeg - m)) * (CombinatoricsUtils.factorialDouble(maxDeg + l) / (CombinatoricsUtils.factorialDouble(nsld2) * CombinatoricsUtils.factorialDouble(nsld2 + l))) * eccPwr[l] * UpperBounds.getDnl(context.getXX(), chiPwr[l], maxDeg, l) * (UpperBounds.getRnml(auxiliaryElements.getGamma(), maxDeg, l, m, 1, 1) + UpperBounds.getRnml(auxiliaryElements.getGamma(), maxDeg, l, m, -1, 1)) : csnm * xmuran * (CombinatoricsUtils.factorialDouble(maxDeg + m) / (CombinatoricsUtils.factorialDouble(nsld2) * CombinatoricsUtils.factorialDouble(nsld2 + l))) * eccPwr[l] * hafPwr[m - l] * UpperBounds.getDnl(context.getXX(), chiPwr[l], maxDeg, l) * (UpperBounds.getRnml(auxiliaryElements.getGamma(), maxDeg, m, l, 1, 1) + UpperBounds.getRnml(auxiliaryElements.getGamma(), maxDeg, m, l, -1, 1))) >= 1.0E-4) {
                            this.maxEccPowMeanElements = l;
                        } else if (term < lastTerm) break;
                        lastTerm = term;
                        --nsld2;
                    } while ((l += 2) < maxDeg);
                    if (term >= 1.0E-4) {
                        this.maxEccPowMeanElements = FastMath.min(this.maxDegree - 2, this.maxEccPowMeanElements);
                        return;
                    }
                    if (++m <= FastMath.min(maxDeg, this.provider.getMaxOrder())) continue;
                }
                xmuran *= ax2or;
            } while (--maxDeg > this.maxEccPowMeanElements + 2);
            this.maxEccPowMeanElements = FastMath.min(this.maxDegree - 2, this.maxEccPowMeanElements);
        }
    }

    private <T extends RealFieldElement<T>> void computeMeanElementsTruncations(FieldAuxiliaryElements<T> auxiliaryElements, T[] parameters, Field<T> field) {
        RealFieldElement zero = (RealFieldElement)field.getZero();
        FieldDSSTZonalContext context = new FieldDSSTZonalContext(auxiliaryElements, this.provider, parameters);
        if (this.maxDegree == 2) {
            this.maxEccPowMeanElements = 0;
        } else {
            UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics = this.provider.onDate(auxiliaryElements.getDate().toAbsoluteDate());
            RealFieldElement ax2or = (RealFieldElement)((RealFieldElement)auxiliaryElements.getSma().multiply(2.0)).divide(this.provider.getAe());
            RealFieldElement xmuran = (RealFieldElement)parameters[0].divide(auxiliaryElements.getSma());
            RealFieldElement eo2 = FastMath.max((RealFieldElement)zero.add(0.0025), (RealFieldElement)auxiliaryElements.getEcc().divide(2.0));
            RealFieldElement x2o2 = (RealFieldElement)context.getXX().divide(2.0);
            RealFieldElement[] eccPwr = (RealFieldElement[])MathArrays.buildArray(field, this.maxDegree + 1);
            RealFieldElement[] chiPwr = (RealFieldElement[])MathArrays.buildArray(field, this.maxDegree + 1);
            RealFieldElement[] hafPwr = (RealFieldElement[])MathArrays.buildArray(field, this.maxDegree + 1);
            eccPwr[0] = (RealFieldElement)zero.add(1.0);
            chiPwr[0] = context.getX();
            hafPwr[0] = (RealFieldElement)zero.add(1.0);
            for (int i = 1; i <= this.maxDegree; ++i) {
                eccPwr[i] = eccPwr[i - 1].multiply(eo2);
                chiPwr[i] = chiPwr[i - 1].multiply(x2o2);
                hafPwr[i] = (RealFieldElement)hafPwr[i - 1].multiply(0.5);
                xmuran = xmuran.divide(ax2or);
            }
            this.maxEccPowMeanElements = 0;
            int maxDeg = this.maxDegree;
            do {
                RealFieldElement snm;
                RealFieldElement cnm;
                RealFieldElement csnm;
                int m = 0;
                while ((csnm = FastMath.hypot(cnm = (RealFieldElement)zero.add(harmonics.getUnnormalizedCnm(maxDeg, m)), snm = (RealFieldElement)zero.add(harmonics.getUnnormalizedSnm(maxDeg, m)))).getReal() != 0.0) {
                    RealFieldElement lastTerm = zero;
                    int nsld2 = (maxDeg - this.maxEccPowMeanElements - 1) / 2;
                    int l = maxDeg - 2 * nsld2;
                    RealFieldElement term = zero;
                    do {
                        if ((term = m < l ? (RealFieldElement)((RealFieldElement)csnm.multiply(xmuran).multiply(CombinatoricsUtils.factorialDouble(maxDeg - l) / CombinatoricsUtils.factorialDouble(maxDeg - m) * (CombinatoricsUtils.factorialDouble(maxDeg + l) / (CombinatoricsUtils.factorialDouble(nsld2) * CombinatoricsUtils.factorialDouble(nsld2 + l))))).multiply(eccPwr[l]).multiply(UpperBounds.getDnl(context.getXX(), chiPwr[l], maxDeg, l)).multiply(UpperBounds.getRnml(auxiliaryElements.getGamma(), maxDeg, l, m, 1, 1).add(UpperBounds.getRnml(auxiliaryElements.getGamma(), maxDeg, l, m, -1, 1))) : (RealFieldElement)((RealFieldElement)csnm.multiply(xmuran).multiply(CombinatoricsUtils.factorialDouble(maxDeg + m) / (CombinatoricsUtils.factorialDouble(nsld2) * CombinatoricsUtils.factorialDouble(nsld2 + l)))).multiply(eccPwr[l]).multiply(hafPwr[m - l]).multiply(UpperBounds.getDnl(context.getXX(), chiPwr[l], maxDeg, l)).multiply(UpperBounds.getRnml(auxiliaryElements.getGamma(), maxDeg, m, l, 1, 1).add(UpperBounds.getRnml(auxiliaryElements.getGamma(), maxDeg, m, l, -1, 1)))).getReal() >= 1.0E-4) {
                            this.maxEccPowMeanElements = l;
                        } else if (term.getReal() < lastTerm.getReal()) break;
                        lastTerm = term;
                        --nsld2;
                    } while ((l += 2) < maxDeg);
                    if (term.getReal() >= 1.0E-4) {
                        this.maxEccPowMeanElements = FastMath.min(this.maxDegree - 2, this.maxEccPowMeanElements);
                        return;
                    }
                    if (++m <= FastMath.min(maxDeg, this.provider.getMaxOrder())) continue;
                }
                xmuran = xmuran.multiply(ax2or);
            } while (--maxDeg > this.maxEccPowMeanElements + 2);
            this.maxEccPowMeanElements = FastMath.min(this.maxDegree - 2, this.maxEccPowMeanElements);
        }
    }

    private DSSTZonalContext initializeStep(AuxiliaryElements auxiliaryElements, double[] parameters) {
        return new DSSTZonalContext(auxiliaryElements, this.provider, parameters);
    }

    private <T extends RealFieldElement<T>> FieldDSSTZonalContext<T> initializeStep(FieldAuxiliaryElements<T> auxiliaryElements, T[] parameters) {
        return new FieldDSSTZonalContext(auxiliaryElements, this.provider, parameters);
    }

    @Override
    public double[] getMeanElementRate(SpacecraftState spacecraftState, AuxiliaryElements auxiliaryElements, double[] parameters) {
        DSSTZonalContext context = this.initializeStep(auxiliaryElements, parameters);
        UAnddU udu = new UAnddU(spacecraftState.getDate(), context, auxiliaryElements, this.hansen);
        return this.computeMeanElementRates(spacecraftState.getDate(), context, udu);
    }

    @Override
    public <T extends RealFieldElement<T>> T[] getMeanElementRate(FieldSpacecraftState<T> spacecraftState, FieldAuxiliaryElements<T> auxiliaryElements, T[] parameters) {
        Field<T> field = auxiliaryElements.getDate().getField();
        FieldDSSTZonalContext context = this.initializeStep(auxiliaryElements, (RealFieldElement[])parameters);
        FieldHansenObjects<?> fho = this.fieldHansen.get(field);
        FieldUAnddU<T> udu = new FieldUAnddU<T>(spacecraftState.getDate(), context, auxiliaryElements, fho);
        return this.computeMeanElementRates(spacecraftState.getDate(), context, udu);
    }

    @Override
    public EventDetector[] getEventsDetectors() {
        return null;
    }

    @Override
    public <T extends RealFieldElement<T>> FieldEventDetector<T>[] getFieldEventsDetectors(Field<T> field) {
        return null;
    }

    private double[] computeMeanElementRates(AbsoluteDate date, DSSTZonalContext context, UAnddU udu) {
        AuxiliaryElements auxiliaryElements = context.getAuxiliaryElements();
        double UAlphaGamma = auxiliaryElements.getAlpha() * udu.getdUdGa() - auxiliaryElements.getGamma() * udu.getdUdAl();
        double UBetaGamma = auxiliaryElements.getBeta() * udu.getdUdGa() - auxiliaryElements.getGamma() * udu.getdUdBe();
        double pUAGmIqUBGoAB = (auxiliaryElements.getP() * UAlphaGamma - 1.0 * auxiliaryElements.getQ() * UBetaGamma) * context.getOoAB();
        double da = 0.0;
        double dh = context.getBoA() * udu.getdUdk() + auxiliaryElements.getK() * pUAGmIqUBGoAB;
        double dk = -context.getBoA() * udu.getdUdh() - auxiliaryElements.getH() * pUAGmIqUBGoAB;
        double dp = context.getMCo2AB() * UBetaGamma;
        double dq = context.getMCo2AB() * UAlphaGamma * 1.0;
        double dM = context.getM2aoA() * udu.getdUda() + context.getBoABpo() * (auxiliaryElements.getH() * udu.getdUdh() + auxiliaryElements.getK() * udu.getdUdk()) + pUAGmIqUBGoAB;
        return new double[]{0.0, dk, dh, dq, dp, dM};
    }

    private <T extends RealFieldElement<T>> T[] computeMeanElementRates(FieldAbsoluteDate<T> date, FieldDSSTZonalContext<T> context, FieldUAnddU<T> udu) {
        FieldAuxiliaryElements auxiliaryElements = context.getFieldAuxiliaryElements();
        Field<T> field = date.getField();
        RealFieldElement UAlphaGamma = (RealFieldElement)((RealFieldElement)udu.getdUdGa().multiply(auxiliaryElements.getAlpha())).subtract(udu.getdUdAl().multiply(auxiliaryElements.getGamma()));
        RealFieldElement UBetaGamma = (RealFieldElement)((RealFieldElement)udu.getdUdGa().multiply(auxiliaryElements.getBeta())).subtract(udu.getdUdBe().multiply(auxiliaryElements.getGamma()));
        RealFieldElement pUAGmIqUBGoAB = (RealFieldElement)((RealFieldElement)((RealFieldElement)UAlphaGamma.multiply(auxiliaryElements.getP())).subtract(((RealFieldElement)UBetaGamma.multiply(true)).multiply(auxiliaryElements.getQ()))).multiply(context.getOoAB());
        RealFieldElement da = (RealFieldElement)field.getZero();
        RealFieldElement dh = (RealFieldElement)((RealFieldElement)udu.getdUdk().multiply(context.getBoA())).add(pUAGmIqUBGoAB.multiply(auxiliaryElements.getK()));
        RealFieldElement dk = (RealFieldElement)((RealFieldElement)((RealFieldElement)udu.getdUdh().multiply(context.getBoA())).negate()).subtract(pUAGmIqUBGoAB.multiply(auxiliaryElements.getH()));
        RealFieldElement dp = (RealFieldElement)UBetaGamma.multiply(context.getMCo2AB());
        RealFieldElement dq = (RealFieldElement)((RealFieldElement)UAlphaGamma.multiply(context.getMCo2AB())).multiply(true);
        RealFieldElement dM = (RealFieldElement)((RealFieldElement)pUAGmIqUBGoAB.add(udu.getdUda().multiply(context.getM2aoA()))).add(((RealFieldElement)((RealFieldElement)udu.getdUdh().multiply(auxiliaryElements.getH())).add(udu.getdUdk().multiply(auxiliaryElements.getK()))).multiply(context.getBoABpo()));
        RealFieldElement[] elements = (RealFieldElement[])MathArrays.buildArray(field, 6);
        elements[0] = da;
        elements[1] = dk;
        elements[2] = dh;
        elements[3] = dq;
        elements[4] = dp;
        elements[5] = dM;
        return elements;
    }

    @Override
    public void registerAttitudeProvider(AttitudeProvider attitudeProvider) {
    }

    private boolean isBetween(int index, int lowerBound, int upperBound) {
        return index >= lowerBound && index <= upperBound;
    }

    @Override
    public void updateShortPeriodTerms(double[] parameters, SpacecraftState ... meanStates) {
        Slot slot = this.zonalSPCoefs.createSlot(meanStates);
        for (SpacecraftState meanState : meanStates) {
            AuxiliaryElements auxiliaryElements = new AuxiliaryElements(meanState.getOrbit(), 1);
            DSSTZonalContext context = this.initializeStep(auxiliaryElements, parameters);
            UAnddU udu = new UAnddU(meanState.getDate(), context, auxiliaryElements, this.hansen);
            double[][] rhoSigma = this.computeRhoSigmaCoefficients(meanState.getDate(), slot, auxiliaryElements);
            this.computeDiCoefficients(meanState.getDate(), slot, context, udu);
            FourierCjSjCoefficients cjsj = new FourierCjSjCoefficients(meanState.getDate(), this.maxDegreeShortPeriodics, this.maxEccPowShortPeriodics, this.maxFrequencyShortPeriodics, context, this.hansen);
            this.computeCijSijCoefficients(meanState.getDate(), slot, cjsj, rhoSigma, context, auxiliaryElements, udu);
        }
    }

    @Override
    public <T extends RealFieldElement<T>> void updateShortPeriodTerms(T[] parameters, FieldSpacecraftState<T> ... meanStates) {
        Field<T> field = meanStates[0].getDate().getField();
        FieldZonalShortPeriodicCoefficients<?> fzspc = this.zonalFieldSPCoefs.get(field);
        FieldSlot<?> slot = fzspc.createSlot(meanStates);
        for (FieldSpacecraftState<T> meanState : meanStates) {
            FieldAuxiliaryElements<T> auxiliaryElements = new FieldAuxiliaryElements<T>(meanState.getOrbit(), 1);
            FieldDSSTZonalContext context = this.initializeStep(auxiliaryElements, (RealFieldElement[])parameters);
            FieldHansenObjects<?> fho = this.fieldHansen.get(field);
            FieldUAnddU<T> udu = new FieldUAnddU<T>(meanState.getDate(), context, auxiliaryElements, fho);
            RealFieldElement[][] rhoSigma = this.computeRhoSigmaCoefficients(meanState.getDate(), slot, auxiliaryElements, field);
            this.computeDiCoefficients(meanState.getDate(), slot, context, field, udu);
            FieldFourierCjSjCoefficients<T> cjsj = new FieldFourierCjSjCoefficients<T>(meanState.getDate(), this.maxDegreeShortPeriodics, this.maxEccPowShortPeriodics, this.maxFrequencyShortPeriodics, context, fho);
            this.computeCijSijCoefficients(meanState.getDate(), slot, cjsj, rhoSigma, context, auxiliaryElements, field, udu);
        }
    }

    @Override
    public ParameterDriver[] getParametersDrivers() {
        return new ParameterDriver[]{this.gmParameterDriver};
    }

    private void computeDiCoefficients(AbsoluteDate date, Slot slot, DSSTZonalContext context, UAnddU udu) {
        double[] meanElementRates = this.computeMeanElementRates(date, context, udu);
        double[] currentDi = new double[6];
        for (int i = 0; i < 6; ++i) {
            currentDi[i] = meanElementRates[i] / context.getMeanMotion();
            if (i != 5) continue;
            int n = i;
            currentDi[n] = currentDi[n] + -3.0 * udu.getU() * context.getOON2A2();
        }
        slot.di.addGridPoint(date, currentDi);
    }

    private <T extends RealFieldElement<T>> void computeDiCoefficients(FieldAbsoluteDate<T> date, FieldSlot<T> slot, FieldDSSTZonalContext<T> context, Field<T> field, FieldUAnddU<T> udu) {
        RealFieldElement[] meanElementRates = this.computeMeanElementRates(date, context, udu);
        RealFieldElement[] currentDi = (RealFieldElement[])MathArrays.buildArray(field, 6);
        for (int i = 0; i < 6; ++i) {
            currentDi[i] = (RealFieldElement)meanElementRates[i].divide(context.getMeanMotion());
            if (i != 5) continue;
            currentDi[i] = (RealFieldElement)currentDi[i].add(((RealFieldElement)((RealFieldElement)context.getOON2A2().multiply(udu.getU())).multiply(2.0)).multiply(-1.5));
        }
        ((FieldSlot)slot).di.addGridPoint(date, currentDi);
    }

    private void computeCijSijCoefficients(AbsoluteDate date, Slot slot, FourierCjSjCoefficients cjsj, double[][] rhoSigma, DSSTZonalContext context, AuxiliaryElements auxiliaryElements, UAnddU udu) {
        int nMax = this.maxDegreeShortPeriodics;
        double[] currentCi0 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        for (int j = 1; j < slot.cij.length; ++j) {
            double coef4;
            double coef3;
            double coef2;
            double coef1;
            double[] currentCij = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            double[] currentSij = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            if (j == 1) {
                coef1 = 4.0 * auxiliaryElements.getK() * udu.getU() - context.getHK() * cjsj.getCj(1) + context.getK2MH2O2() * cjsj.getSj(1);
                coef2 = 4.0 * auxiliaryElements.getH() * udu.getU() + context.getK2MH2O2() * cjsj.getCj(1) + context.getHK() * cjsj.getSj(1);
                coef3 = (auxiliaryElements.getK() * cjsj.getCj(1) + auxiliaryElements.getH() * cjsj.getSj(1)) / 4.0;
                coef4 = (8.0 * udu.getU() - auxiliaryElements.getH() * cjsj.getCj(1) + auxiliaryElements.getK() * cjsj.getSj(1)) / 4.0;
                currentCij[0] = currentCij[0] + coef1;
                currentSij[0] = currentSij[0] + coef2;
                currentCij[1] = currentCij[1] + coef4;
                currentSij[1] = currentSij[1] + coef3;
                currentCij[2] = currentCij[2] - coef3;
                currentSij[2] = currentSij[2] + coef4;
                currentCij[5] = currentCij[5] - coef2 / 2.0;
                currentSij[5] = currentSij[5] + coef1 / 2.0;
            }
            if (j == 2) {
                coef1 = context.getK2MH2() * udu.getU();
                coef2 = 2.0 * context.getHK() * udu.getU();
                coef3 = auxiliaryElements.getH() * udu.getU() / 2.0;
                coef4 = auxiliaryElements.getK() * udu.getU() / 2.0;
                currentCij[0] = currentCij[0] + coef1;
                currentSij[0] = currentSij[0] + coef2;
                currentCij[1] = currentCij[1] + coef4;
                currentSij[1] = currentSij[1] + coef3;
                currentCij[2] = currentCij[2] - coef3;
                currentSij[2] = currentSij[2] + coef4;
                currentCij[5] = currentCij[5] - coef2 / 2.0;
                currentSij[5] = currentSij[5] + coef1 / 2.0;
            }
            if (this.isBetween(j, 1, 2 * nMax - 3) && j + 2 < cjsj.jMax) {
                coef1 = (double)(j + 2) * (-context.getHK() * cjsj.getCj(j + 2) + context.getK2MH2O2() * cjsj.getSj(j + 2));
                coef2 = (double)(j + 2) * (context.getK2MH2O2() * cjsj.getCj(j + 2) + context.getHK() * cjsj.getSj(j + 2));
                coef3 = (double)(j + 2) * (auxiliaryElements.getK() * cjsj.getCj(j + 2) + auxiliaryElements.getH() * cjsj.getSj(j + 2)) / 4.0;
                coef4 = (double)(j + 2) * (auxiliaryElements.getH() * cjsj.getCj(j + 2) - auxiliaryElements.getK() * cjsj.getSj(j + 2)) / 4.0;
                currentCij[0] = currentCij[0] + coef1;
                currentSij[0] = currentSij[0] - coef2;
                currentCij[1] = currentCij[1] + -coef4;
                currentSij[1] = currentSij[1] - coef3;
                currentCij[2] = currentCij[2] - coef3;
                currentSij[2] = currentSij[2] + coef4;
                currentCij[5] = currentCij[5] - coef2 / 2.0;
                currentSij[5] = currentSij[5] + -coef1 / 2.0;
            }
            if (this.isBetween(j, 1, 2 * nMax - 2) && j + 1 < cjsj.jMax) {
                coef1 = (double)(2 * (j + 1)) * (-auxiliaryElements.getH() * cjsj.getCj(j + 1) + auxiliaryElements.getK() * cjsj.getSj(j + 1));
                coef2 = (double)(2 * (j + 1)) * (auxiliaryElements.getK() * cjsj.getCj(j + 1) + auxiliaryElements.getH() * cjsj.getSj(j + 1));
                coef3 = (double)(j + 1) * cjsj.getCj(j + 1);
                coef4 = (double)(j + 1) * cjsj.getSj(j + 1);
                currentCij[0] = currentCij[0] + coef1;
                currentSij[0] = currentSij[0] - coef2;
                currentCij[1] = currentCij[1] + coef4;
                currentSij[1] = currentSij[1] - coef3;
                currentCij[2] = currentCij[2] - coef3;
                currentSij[2] = currentSij[2] - coef4;
                currentCij[5] = currentCij[5] - coef2 / 2.0;
                currentSij[5] = currentSij[5] + -coef1 / 2.0;
            }
            if (this.isBetween(j, 2, 2 * nMax) && j - 1 < cjsj.jMax) {
                coef1 = (double)(2 * (j - 1)) * (auxiliaryElements.getH() * cjsj.getCj(j - 1) + auxiliaryElements.getK() * cjsj.getSj(j - 1));
                coef2 = (double)(2 * (j - 1)) * (auxiliaryElements.getK() * cjsj.getCj(j - 1) - auxiliaryElements.getH() * cjsj.getSj(j - 1));
                coef3 = (double)(j - 1) * cjsj.getCj(j - 1);
                coef4 = (double)(j - 1) * cjsj.getSj(j - 1);
                currentCij[0] = currentCij[0] + coef1;
                currentSij[0] = currentSij[0] - coef2;
                currentCij[1] = currentCij[1] + coef4;
                currentSij[1] = currentSij[1] - coef3;
                currentCij[2] = currentCij[2] + coef3;
                currentSij[2] = currentSij[2] + coef4;
                currentCij[5] = currentCij[5] + coef2 / 2.0;
                currentSij[5] = currentSij[5] + coef1 / 2.0;
            }
            if (this.isBetween(j, 3, 2 * nMax + 1) && j - 2 < cjsj.jMax) {
                coef1 = (double)(j - 2) * (context.getHK() * cjsj.getCj(j - 2) + context.getK2MH2O2() * cjsj.getSj(j - 2));
                coef2 = (double)(j - 2) * (-context.getK2MH2O2() * cjsj.getCj(j - 2) + context.getHK() * cjsj.getSj(j - 2));
                coef3 = (double)(j - 2) * (auxiliaryElements.getK() * cjsj.getCj(j - 2) - auxiliaryElements.getH() * cjsj.getSj(j - 2)) / 4.0;
                coef4 = (double)(j - 2) * (auxiliaryElements.getH() * cjsj.getCj(j - 2) + auxiliaryElements.getK() * cjsj.getSj(j - 2)) / 4.0;
                double coef5 = (double)(j - 2) * (context.getK2MH2O2() * cjsj.getCj(j - 2) - context.getHK() * cjsj.getSj(j - 2));
                currentCij[0] = currentCij[0] + coef1;
                currentSij[0] = currentSij[0] + coef2;
                currentCij[1] = currentCij[1] + coef4;
                currentSij[1] = currentSij[1] + -coef3;
                currentCij[2] = currentCij[2] + coef3;
                currentSij[2] = currentSij[2] + coef4;
                currentCij[5] = currentCij[5] + coef5 / 2.0;
                currentSij[5] = currentSij[5] + coef1 / 2.0;
            }
            currentCij[0] = currentCij[0] * context.getX3ON2A();
            currentSij[0] = currentSij[0] * context.getX3ON2A();
            currentCij[1] = currentCij[1] * context.getXON2A2();
            currentSij[1] = currentSij[1] * context.getXON2A2();
            currentCij[2] = currentCij[2] * context.getXON2A2();
            currentSij[2] = currentSij[2] * context.getXON2A2();
            currentCij[5] = currentCij[5] * context.getX2ON2A2XP1();
            currentSij[5] = currentSij[5] * context.getX2ON2A2XP1();
            if (this.isBetween(j, 1, 2 * nMax - 1) && j < cjsj.jMax) {
                double CjAlphaGamma = auxiliaryElements.getAlpha() * cjsj.getdCjdGamma(j) - auxiliaryElements.getGamma() * cjsj.getdCjdAlpha(j);
                double CjAlphaBeta = auxiliaryElements.getAlpha() * cjsj.getdCjdBeta(j) - auxiliaryElements.getBeta() * cjsj.getdCjdAlpha(j);
                double CjBetaGamma = auxiliaryElements.getBeta() * cjsj.getdCjdGamma(j) - auxiliaryElements.getGamma() * cjsj.getdCjdBeta(j);
                double CjHK = auxiliaryElements.getH() * cjsj.getdCjdK(j) - auxiliaryElements.getK() * cjsj.getdCjdH(j);
                double SjAlphaGamma = auxiliaryElements.getAlpha() * cjsj.getdSjdGamma(j) - auxiliaryElements.getGamma() * cjsj.getdSjdAlpha(j);
                double SjAlphaBeta = auxiliaryElements.getAlpha() * cjsj.getdSjdBeta(j) - auxiliaryElements.getBeta() * cjsj.getdSjdAlpha(j);
                double SjBetaGamma = auxiliaryElements.getBeta() * cjsj.getdSjdGamma(j) - auxiliaryElements.getGamma() * cjsj.getdSjdBeta(j);
                double SjHK = auxiliaryElements.getH() * cjsj.getdSjdK(j) - auxiliaryElements.getK() * cjsj.getdSjdH(j);
                double coef12 = context.getX3ON2A() * (3.0 - context.getBB()) * (double)j;
                currentCij[0] = currentCij[0] + coef12 * cjsj.getSj(j);
                currentSij[0] = currentSij[0] - coef12 * cjsj.getCj(j);
                double coef22 = auxiliaryElements.getP() * CjAlphaGamma - 1.0 * auxiliaryElements.getQ() * CjBetaGamma;
                double coef32 = auxiliaryElements.getP() * SjAlphaGamma - 1.0 * auxiliaryElements.getQ() * SjBetaGamma;
                currentCij[1] = currentCij[1] - context.getXON2A2() * (auxiliaryElements.getH() * coef22 + context.getBB() * cjsj.getdCjdH(j) - 1.5 * auxiliaryElements.getK() * (double)j * cjsj.getSj(j));
                currentSij[1] = currentSij[1] - context.getXON2A2() * (auxiliaryElements.getH() * coef32 + context.getBB() * cjsj.getdSjdH(j) + 1.5 * auxiliaryElements.getK() * (double)j * cjsj.getCj(j));
                currentCij[2] = currentCij[2] + context.getXON2A2() * (auxiliaryElements.getK() * coef22 + context.getBB() * cjsj.getdCjdK(j) + 1.5 * auxiliaryElements.getH() * (double)j * cjsj.getSj(j));
                currentSij[2] = currentSij[2] + context.getXON2A2() * (auxiliaryElements.getK() * coef32 + context.getBB() * cjsj.getdSjdK(j) - 1.5 * auxiliaryElements.getH() * (double)j * cjsj.getCj(j));
                double coef42 = CjHK - CjAlphaBeta - (double)j * cjsj.getSj(j);
                double coef5 = SjHK - SjAlphaBeta + (double)j * cjsj.getCj(j);
                currentCij[3] = context.getCXO2N2A2() * (-1.0 * CjAlphaGamma + auxiliaryElements.getQ() * coef42);
                currentSij[3] = context.getCXO2N2A2() * (-1.0 * SjAlphaGamma + auxiliaryElements.getQ() * coef5);
                currentCij[4] = context.getCXO2N2A2() * (-CjBetaGamma + auxiliaryElements.getP() * coef42);
                currentSij[4] = context.getCXO2N2A2() * (-SjBetaGamma + auxiliaryElements.getP() * coef5);
                double coef6 = auxiliaryElements.getH() * cjsj.getdCjdH(j) + auxiliaryElements.getK() * cjsj.getdCjdK(j);
                double coef7 = auxiliaryElements.getH() * cjsj.getdSjdH(j) + auxiliaryElements.getK() * cjsj.getdSjdK(j);
                currentCij[5] = currentCij[5] + context.getOON2A2() * (-2.0 * auxiliaryElements.getSma() * cjsj.getdCjdA(j) + coef6 / (context.getX() + 1.0) + context.getX() * coef22 - 3.0 * cjsj.getCj(j));
                currentSij[5] = currentSij[5] + context.getOON2A2() * (-2.0 * auxiliaryElements.getSma() * cjsj.getdSjdA(j) + coef7 / (context.getX() + 1.0) + context.getX() * coef32 - 3.0 * cjsj.getSj(j));
            }
            for (int i = 0; i < 6; ++i) {
                int n = i;
                currentCi0[n] = currentCi0[n] - (currentCij[i] * rhoSigma[j][0] + currentSij[i] * rhoSigma[j][1]);
            }
            slot.cij[j].addGridPoint(date, currentCij);
            slot.sij[j].addGridPoint(date, currentSij);
        }
        slot.cij[0].addGridPoint(date, currentCi0);
    }

    private <T extends RealFieldElement<T>> void computeCijSijCoefficients(FieldAbsoluteDate<T> date, FieldSlot<T> slot, FieldFourierCjSjCoefficients<T> cjsj, T[][] rhoSigma, FieldDSSTZonalContext<T> context, FieldAuxiliaryElements<T> auxiliaryElements, Field<T> field, FieldUAnddU<T> udu) {
        RealFieldElement zero = (RealFieldElement)field.getZero();
        int nMax = this.maxDegreeShortPeriodics;
        Object[] currentCi0 = (RealFieldElement[])MathArrays.buildArray(field, 6);
        Arrays.fill(currentCi0, zero);
        for (int j = 1; j < ((FieldSlot)slot).cij.length; ++j) {
            RealFieldElement coef4;
            RealFieldElement coef3;
            RealFieldElement coef2;
            RealFieldElement coef1;
            Object[] currentCij = (RealFieldElement[])MathArrays.buildArray(field, 6);
            Object[] currentSij = (RealFieldElement[])MathArrays.buildArray(field, 6);
            Arrays.fill(currentCij, zero);
            Arrays.fill(currentSij, zero);
            if (j == 1) {
                coef1 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)auxiliaryElements.getK().multiply(udu.getU())).multiply(4.0)).subtract(context.getHK().multiply(cjsj.getCj(1)))).add(context.getK2MH2O2().multiply(cjsj.getSj(1)));
                coef2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)auxiliaryElements.getH().multiply(udu.getU())).multiply(4.0)).add(context.getK2MH2O2().multiply(cjsj.getCj(1)))).add(context.getHK().multiply(cjsj.getSj(1)));
                coef3 = (RealFieldElement)((RealFieldElement)((RealFieldElement)auxiliaryElements.getK().multiply(cjsj.getCj(1))).add(auxiliaryElements.getH().multiply(cjsj.getSj(1)))).divide(4.0);
                coef4 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)udu.getU().multiply(8.0)).subtract(auxiliaryElements.getH().multiply(cjsj.getCj(1)))).add(auxiliaryElements.getK().multiply(cjsj.getSj(1)))).divide(4.0);
                currentCij[0] = currentCij[0].add(coef1);
                currentSij[0] = currentSij[0].add(coef2);
                currentCij[1] = currentCij[1].add(coef4);
                currentSij[1] = currentSij[1].add(coef3);
                currentCij[2] = currentCij[2].subtract(coef3);
                currentSij[2] = currentSij[2].add(coef4);
                currentCij[5] = (RealFieldElement)currentCij[5].subtract(coef2.divide(2.0));
                currentSij[5] = (RealFieldElement)currentSij[5].add(coef1.divide(2.0));
            }
            if (j == 2) {
                coef1 = (RealFieldElement)context.getK2MH2().multiply(udu.getU());
                coef2 = (RealFieldElement)((RealFieldElement)context.getHK().multiply(udu.getU())).multiply(2.0);
                coef3 = (RealFieldElement)((RealFieldElement)auxiliaryElements.getH().multiply(udu.getU())).divide(2.0);
                coef4 = (RealFieldElement)((RealFieldElement)auxiliaryElements.getK().multiply(udu.getU())).divide(2.0);
                currentCij[0] = currentCij[0].add(coef1);
                currentSij[0] = currentSij[0].add(coef2);
                currentCij[1] = currentCij[1].add(coef4);
                currentSij[1] = currentSij[1].add(coef3);
                currentCij[2] = currentCij[2].subtract(coef3);
                currentSij[2] = currentSij[2].add(coef4);
                currentCij[5] = (RealFieldElement)currentCij[5].subtract(coef2.divide(2.0));
                currentSij[5] = (RealFieldElement)currentSij[5].add(coef1.divide(2.0));
            }
            if (this.isBetween(j, 1, 2 * nMax - 3) && j + 2 < ((FieldFourierCjSjCoefficients)cjsj).jMax) {
                coef1 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)context.getHK().negate()).multiply(cjsj.getCj(j + 2))).add(context.getK2MH2O2().multiply(cjsj.getSj(j + 2)))).multiply(j + 2);
                coef2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)context.getK2MH2O2().multiply(cjsj.getCj(j + 2))).add(context.getHK().multiply(cjsj.getSj(j + 2)))).multiply(j + 2);
                coef3 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)auxiliaryElements.getK().multiply(cjsj.getCj(j + 2))).add(auxiliaryElements.getH().multiply(cjsj.getSj(j + 2)))).multiply(j + 2)).divide(4.0);
                coef4 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)auxiliaryElements.getH().multiply(cjsj.getCj(j + 2))).subtract(auxiliaryElements.getK().multiply(cjsj.getSj(j + 2)))).multiply(j + 2)).divide(4.0);
                currentCij[0] = currentCij[0].add(coef1);
                currentSij[0] = currentSij[0].subtract(coef2);
                currentCij[1] = (RealFieldElement)currentCij[1].add(coef4.negate());
                currentSij[1] = currentSij[1].subtract(coef3);
                currentCij[2] = currentCij[2].subtract(coef3);
                currentSij[2] = currentSij[2].add(coef4);
                currentCij[5] = (RealFieldElement)currentCij[5].subtract(coef2.divide(2.0));
                currentSij[5] = (RealFieldElement)currentSij[5].add(((RealFieldElement)coef1.negate()).divide(2.0));
            }
            if (this.isBetween(j, 1, 2 * nMax - 2) && j + 1 < ((FieldFourierCjSjCoefficients)cjsj).jMax) {
                coef1 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)auxiliaryElements.getH().negate()).multiply(cjsj.getCj(j + 1))).add(auxiliaryElements.getK().multiply(cjsj.getSj(j + 1)))).multiply(2.0 * (double)(j + 1));
                coef2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)auxiliaryElements.getK().multiply(cjsj.getCj(j + 1))).add(auxiliaryElements.getH().multiply(cjsj.getSj(j + 1)))).multiply(2.0 * (double)(j + 1));
                coef3 = (RealFieldElement)cjsj.getCj(j + 1).multiply((int)(j + 1));
                coef4 = (RealFieldElement)cjsj.getSj(j + 1).multiply((int)(j + 1));
                currentCij[0] = currentCij[0].add(coef1);
                currentSij[0] = currentSij[0].subtract(coef2);
                currentCij[1] = currentCij[1].add(coef4);
                currentSij[1] = currentSij[1].subtract(coef3);
                currentCij[2] = currentCij[2].subtract(coef3);
                currentSij[2] = currentSij[2].subtract(coef4);
                currentCij[5] = (RealFieldElement)currentCij[5].subtract(coef2.divide(2.0));
                currentSij[5] = (RealFieldElement)currentSij[5].add(((RealFieldElement)coef1.negate()).divide(2.0));
            }
            if (this.isBetween(j, 2, 2 * nMax) && j - 1 < ((FieldFourierCjSjCoefficients)cjsj).jMax) {
                coef1 = (RealFieldElement)((RealFieldElement)((RealFieldElement)auxiliaryElements.getH().multiply(cjsj.getCj(j - 1))).add(auxiliaryElements.getK().multiply(cjsj.getSj(j - 1)))).multiply(2 * (j - 1));
                coef2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)auxiliaryElements.getK().multiply(cjsj.getCj(j - 1))).subtract(auxiliaryElements.getH().multiply(cjsj.getSj(j - 1)))).multiply(2 * (j - 1));
                coef3 = (RealFieldElement)cjsj.getCj(j - 1).multiply((int)(j - 1));
                coef4 = (RealFieldElement)cjsj.getSj(j - 1).multiply((int)(j - 1));
                currentCij[0] = currentCij[0].add(coef1);
                currentSij[0] = currentSij[0].subtract(coef2);
                currentCij[1] = currentCij[1].add(coef4);
                currentSij[1] = currentSij[1].subtract(coef3);
                currentCij[2] = currentCij[2].add(coef3);
                currentSij[2] = currentSij[2].add(coef4);
                currentCij[5] = (RealFieldElement)currentCij[5].add(coef2.divide(2.0));
                currentSij[5] = (RealFieldElement)currentSij[5].add(coef1.divide(2.0));
            }
            if (this.isBetween(j, 3, 2 * nMax + 1) && j - 2 < ((FieldFourierCjSjCoefficients)cjsj).jMax) {
                coef1 = (RealFieldElement)((RealFieldElement)((RealFieldElement)context.getHK().multiply(cjsj.getCj(j - 2))).add(context.getK2MH2O2().multiply(cjsj.getSj(j - 2)))).multiply(j - 2);
                coef2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)context.getK2MH2O2().negate()).multiply(cjsj.getCj(j - 2))).add(context.getHK().multiply(cjsj.getSj(j - 2)))).multiply(j - 2);
                coef3 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)auxiliaryElements.getK().multiply(cjsj.getCj(j - 2))).subtract(auxiliaryElements.getH().multiply(cjsj.getSj(j - 2)))).multiply(j - 2)).divide(4.0);
                coef4 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)auxiliaryElements.getH().multiply(cjsj.getCj(j - 2))).add(auxiliaryElements.getK().multiply(cjsj.getSj(j - 2)))).multiply(j - 2)).divide(4.0);
                RealFieldElement coef5 = (RealFieldElement)((RealFieldElement)((RealFieldElement)context.getK2MH2O2().multiply(cjsj.getCj(j - 2))).subtract(context.getHK().multiply(cjsj.getSj(j - 2)))).multiply(j - 2);
                currentCij[0] = currentCij[0].add(coef1);
                currentSij[0] = currentSij[0].add(coef2);
                currentCij[1] = currentCij[1].add(coef4);
                currentSij[1] = (RealFieldElement)currentSij[1].add(coef3.negate());
                currentCij[2] = currentCij[2].add(coef3);
                currentSij[2] = currentSij[2].add(coef4);
                currentCij[5] = (RealFieldElement)currentCij[5].add(coef5.divide(2.0));
                currentSij[5] = (RealFieldElement)currentSij[5].add(coef1.divide(2.0));
            }
            currentCij[0] = (RealFieldElement)currentCij[0].multiply(context.getX3ON2A());
            currentSij[0] = (RealFieldElement)currentSij[0].multiply(context.getX3ON2A());
            currentCij[1] = (RealFieldElement)currentCij[1].multiply(context.getXON2A2());
            currentSij[1] = (RealFieldElement)currentSij[1].multiply(context.getXON2A2());
            currentCij[2] = (RealFieldElement)currentCij[2].multiply(context.getXON2A2());
            currentSij[2] = (RealFieldElement)currentSij[2].multiply(context.getXON2A2());
            currentCij[5] = (RealFieldElement)currentCij[5].multiply(context.getX2ON2A2XP1());
            currentSij[5] = (RealFieldElement)currentSij[5].multiply(context.getX2ON2A2XP1());
            if (this.isBetween(j, 1, 2 * nMax - 1) && j < ((FieldFourierCjSjCoefficients)cjsj).jMax) {
                RealFieldElement CjAlphaGamma = (RealFieldElement)((RealFieldElement)auxiliaryElements.getAlpha().multiply(cjsj.getdCjdGamma(j))).subtract(auxiliaryElements.getGamma().multiply(cjsj.getdCjdAlpha(j)));
                RealFieldElement CjAlphaBeta = (RealFieldElement)((RealFieldElement)auxiliaryElements.getAlpha().multiply(cjsj.getdCjdBeta(j))).subtract(auxiliaryElements.getBeta().multiply(cjsj.getdCjdAlpha(j)));
                RealFieldElement CjBetaGamma = (RealFieldElement)((RealFieldElement)auxiliaryElements.getBeta().multiply(cjsj.getdCjdGamma(j))).subtract(auxiliaryElements.getGamma().multiply(cjsj.getdCjdBeta(j)));
                RealFieldElement CjHK = (RealFieldElement)((RealFieldElement)auxiliaryElements.getH().multiply(cjsj.getdCjdK(j))).subtract(auxiliaryElements.getK().multiply(cjsj.getdCjdH(j)));
                RealFieldElement SjAlphaGamma = (RealFieldElement)((RealFieldElement)auxiliaryElements.getAlpha().multiply(cjsj.getdSjdGamma(j))).subtract(auxiliaryElements.getGamma().multiply(cjsj.getdSjdAlpha(j)));
                RealFieldElement SjAlphaBeta = (RealFieldElement)((RealFieldElement)auxiliaryElements.getAlpha().multiply(cjsj.getdSjdBeta(j))).subtract(auxiliaryElements.getBeta().multiply(cjsj.getdSjdAlpha(j)));
                RealFieldElement SjBetaGamma = (RealFieldElement)((RealFieldElement)auxiliaryElements.getBeta().multiply(cjsj.getdSjdGamma(j))).subtract(auxiliaryElements.getGamma().multiply(cjsj.getdSjdBeta(j)));
                RealFieldElement SjHK = (RealFieldElement)((RealFieldElement)auxiliaryElements.getH().multiply(cjsj.getdSjdK(j))).subtract(auxiliaryElements.getK().multiply(cjsj.getdSjdH(j)));
                RealFieldElement coef12 = (RealFieldElement)((RealFieldElement)context.getX3ON2A().multiply(((RealFieldElement)context.getBB().negate()).add(3.0))).multiply(j);
                currentCij[0] = (RealFieldElement)currentCij[0].add(coef12.multiply(cjsj.getSj(j)));
                currentSij[0] = (RealFieldElement)currentSij[0].subtract(coef12.multiply(cjsj.getCj(j)));
                RealFieldElement coef22 = (RealFieldElement)auxiliaryElements.getP().multiply((RealFieldElement)CjAlphaGamma).subtract(auxiliaryElements.getQ().multiply((RealFieldElement)CjBetaGamma).multiply(true));
                RealFieldElement coef32 = (RealFieldElement)auxiliaryElements.getP().multiply((RealFieldElement)SjAlphaGamma).subtract(auxiliaryElements.getQ().multiply((RealFieldElement)SjBetaGamma).multiply(true));
                currentCij[1] = (RealFieldElement)currentCij[1].subtract(context.getXON2A2().multiply(((RealFieldElement)auxiliaryElements.getH().multiply((RealFieldElement)coef22).add(context.getBB().multiply(cjsj.getdCjdH(j)))).subtract(((RealFieldElement)((RealFieldElement)auxiliaryElements.getK().multiply(1.5)).multiply(j)).multiply(cjsj.getSj(j)))));
                currentSij[1] = (RealFieldElement)currentSij[1].subtract(context.getXON2A2().multiply(((RealFieldElement)auxiliaryElements.getH().multiply((RealFieldElement)coef32).add(context.getBB().multiply(cjsj.getdSjdH(j)))).add(((RealFieldElement)((RealFieldElement)auxiliaryElements.getK().multiply(1.5)).multiply(j)).multiply(cjsj.getCj(j)))));
                currentCij[2] = (RealFieldElement)currentCij[2].add(context.getXON2A2().multiply(((RealFieldElement)auxiliaryElements.getK().multiply((RealFieldElement)coef22).add(context.getBB().multiply(cjsj.getdCjdK(j)))).add(((RealFieldElement)((RealFieldElement)auxiliaryElements.getH().multiply(1.5)).multiply(j)).multiply(cjsj.getSj(j)))));
                currentSij[2] = (RealFieldElement)currentSij[2].add(context.getXON2A2().multiply(((RealFieldElement)auxiliaryElements.getK().multiply((RealFieldElement)coef32).add(context.getBB().multiply(cjsj.getdSjdK(j)))).subtract(((RealFieldElement)((RealFieldElement)auxiliaryElements.getH().multiply(1.5)).multiply(j)).multiply(cjsj.getCj(j)))));
                RealFieldElement coef42 = (RealFieldElement)CjHK.subtract(CjAlphaBeta).subtract(cjsj.getSj(j).multiply((int)j));
                RealFieldElement coef5 = (RealFieldElement)SjHK.subtract(SjAlphaBeta).add(cjsj.getCj(j).multiply((int)j));
                currentCij[3] = context.getCXO2N2A2().multiply((RealFieldElement)((RealFieldElement)CjAlphaGamma.multiply(-1)).add(auxiliaryElements.getQ().multiply((RealFieldElement)coef42)));
                currentSij[3] = context.getCXO2N2A2().multiply((RealFieldElement)((RealFieldElement)SjAlphaGamma.multiply(-1)).add(auxiliaryElements.getQ().multiply((RealFieldElement)coef5)));
                currentCij[4] = context.getCXO2N2A2().multiply((RealFieldElement)((RealFieldElement)CjBetaGamma.negate()).add(auxiliaryElements.getP().multiply((RealFieldElement)coef42)));
                currentSij[4] = context.getCXO2N2A2().multiply((RealFieldElement)((RealFieldElement)SjBetaGamma.negate()).add(auxiliaryElements.getP().multiply((RealFieldElement)coef5)));
                RealFieldElement coef6 = (RealFieldElement)((RealFieldElement)auxiliaryElements.getH().multiply(cjsj.getdCjdH(j))).add(auxiliaryElements.getK().multiply(cjsj.getdCjdK(j)));
                RealFieldElement coef7 = (RealFieldElement)((RealFieldElement)auxiliaryElements.getH().multiply(cjsj.getdSjdH(j))).add(auxiliaryElements.getK().multiply(cjsj.getdSjdK(j)));
                currentCij[5] = (RealFieldElement)currentCij[5].add(context.getOON2A2().multiply(((RealFieldElement)((RealFieldElement)((RealFieldElement)auxiliaryElements.getSma().multiply(-2.0)).multiply(cjsj.getdCjdA(j))).add(coef6.divide(context.getX().add(1.0)))).add(context.getX().multiply((RealFieldElement)coef22)).subtract(cjsj.getCj(j).multiply(3.0))));
                currentSij[5] = (RealFieldElement)currentSij[5].add(context.getOON2A2().multiply(((RealFieldElement)((RealFieldElement)((RealFieldElement)auxiliaryElements.getSma().multiply(-2.0)).multiply(cjsj.getdSjdA(j))).add(coef7.divide(context.getX().add(1.0)))).add(context.getX().multiply((RealFieldElement)coef32)).subtract(cjsj.getSj(j).multiply(3.0))));
            }
            for (int i = 0; i < 6; ++i) {
                currentCi0[i] = (RealFieldElement)currentCi0[i].subtract(((RealFieldElement)currentCij[i].multiply(rhoSigma[j][0])).add(currentSij[i].multiply(rhoSigma[j][1])));
            }
            ((FieldSlot)slot).cij[j].addGridPoint(date, (RealFieldElement[])currentCij);
            ((FieldSlot)slot).sij[j].addGridPoint(date, (RealFieldElement[])currentSij);
        }
        ((FieldSlot)slot).cij[0].addGridPoint(date, (RealFieldElement[])currentCi0);
    }

    private double[][] computeRhoSigmaCoefficients(AbsoluteDate date, Slot slot, AuxiliaryElements auxiliaryElements) {
        CjSjCoefficient cjsjKH = new CjSjCoefficient(auxiliaryElements.getK(), auxiliaryElements.getH());
        double b = 1.0 / (1.0 + auxiliaryElements.getB());
        double mbtj = 1.0;
        double[][] rhoSigma = new double[slot.cij.length][2];
        for (int j = 1; j < rhoSigma.length; ++j) {
            double coef = (1.0 + (double)j * auxiliaryElements.getB()) * (mbtj *= -b);
            double rho = coef * cjsjKH.getCj(j);
            double sigma = coef * cjsjKH.getSj(j);
            rhoSigma[j][0] = rho;
            rhoSigma[j][1] = sigma;
        }
        return rhoSigma;
    }

    private <T extends RealFieldElement<T>> T[][] computeRhoSigmaCoefficients(FieldAbsoluteDate<T> date, FieldSlot<T> slot, FieldAuxiliaryElements<T> auxiliaryElements, Field<T> field) {
        RealFieldElement zero = (RealFieldElement)field.getZero();
        FieldCjSjCoefficient<T> cjsjKH = new FieldCjSjCoefficient<T>(auxiliaryElements.getK(), auxiliaryElements.getH(), field);
        RealFieldElement b = (RealFieldElement)((RealFieldElement)auxiliaryElements.getB().add(1.0)).reciprocal();
        RealFieldElement mbtj = (RealFieldElement)zero.add(1.0);
        RealFieldElement[][] rhoSigma = (RealFieldElement[][])MathArrays.buildArray(field, ((FieldSlot)slot).cij.length, 2);
        for (int j = 1; j < rhoSigma.length; ++j) {
            mbtj = (RealFieldElement)mbtj.multiply(b.negate());
            RealFieldElement coef = (RealFieldElement)mbtj.multiply(((RealFieldElement)auxiliaryElements.getB().multiply((int)j)).add(1.0));
            RealFieldElement rho = (RealFieldElement)coef.multiply(cjsjKH.getCj(j));
            RealFieldElement sigma = (RealFieldElement)coef.multiply(cjsjKH.getSj(j));
            rhoSigma[j][0] = rho;
            rhoSigma[j][1] = sigma;
        }
        return rhoSigma;
    }

    private class FieldHansenObjects<T extends RealFieldElement<T>> {
        private FieldHansenZonalLinear<T>[] hansenObjects;

        FieldHansenObjects(Field<T> field) {
            this.hansenObjects = (FieldHansenZonalLinear[])Array.newInstance(FieldHansenZonalLinear.class, DSSTZonal.this.maxEccPow + 1);
            for (int s = 0; s <= DSSTZonal.this.maxEccPow; ++s) {
                this.hansenObjects[s] = new FieldHansenZonalLinear<T>(DSSTZonal.this.maxDegree, s, field);
            }
        }

        public void computeHansenObjectsInitValues(FieldDSSTZonalContext<T> context, int element) {
            this.hansenObjects[element].computeInitValues(context.getX());
        }

        public FieldHansenZonalLinear<T>[] getHansenObjects() {
            return this.hansenObjects;
        }
    }

    private class HansenObjects {
        private HansenZonalLinear[] hansenObjects;

        HansenObjects() {
            this.hansenObjects = new HansenZonalLinear[DSSTZonal.this.maxEccPow + 1];
            for (int s = 0; s <= DSSTZonal.this.maxEccPow; ++s) {
                this.hansenObjects[s] = new HansenZonalLinear(DSSTZonal.this.maxDegree, s);
            }
        }

        public void computeHansenObjectsInitValues(DSSTZonalContext context, int element) {
            this.hansenObjects[element].computeInitValues(context.getX());
        }

        public HansenZonalLinear[] getHansenObjects() {
            return this.hansenObjects;
        }
    }

    private class FieldUAnddU<T extends RealFieldElement<T>> {
        private T U;
        private T dUda;
        private T dUdk;
        private T dUdh;
        private T dUdAl;
        private T dUdBe;
        private T dUdGa;

        FieldUAnddU(FieldAbsoluteDate<T> date, FieldDSSTZonalContext<T> context, FieldAuxiliaryElements<T> auxiliaryElements, FieldHansenObjects<T> hansen) {
            Field<T> field = date.getField();
            RealFieldElement zero = (RealFieldElement)field.getZero();
            UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics = DSSTZonal.this.provider.onDate(date.toAbsoluteDate());
            this.U = zero;
            RealFieldElement[][] GsHs = CoefficientsFactory.computeGsHs(auxiliaryElements.getK(), auxiliaryElements.getH(), auxiliaryElements.getAlpha(), auxiliaryElements.getBeta(), (int)DSSTZonal.this.maxEccPowMeanElements, field);
            RealFieldElement[][] Qns = CoefficientsFactory.computeQns(auxiliaryElements.getGamma(), (int)DSSTZonal.this.maxDegree, (int)DSSTZonal.this.maxEccPowMeanElements);
            RealFieldElement[] roaPow = (RealFieldElement[])MathArrays.buildArray(field, DSSTZonal.this.maxDegree + 1);
            roaPow[0] = (RealFieldElement)zero.add(1.0);
            for (int i = 1; i <= DSSTZonal.this.maxDegree; ++i) {
                roaPow[i] = (RealFieldElement)roaPow[i - 1].multiply(context.getRoa());
            }
            this.dUda = zero;
            this.dUdk = zero;
            this.dUdh = zero;
            this.dUdAl = zero;
            this.dUdBe = zero;
            this.dUdGa = zero;
            for (int s = 0; s <= DSSTZonal.this.maxEccPowMeanElements; ++s) {
                hansen.computeHansenObjectsInitValues(context, s);
                RealFieldElement gs = GsHs[0][s];
                RealFieldElement dGsdh = zero;
                RealFieldElement dGsdk = zero;
                RealFieldElement dGsdAl = zero;
                RealFieldElement dGsdBe = zero;
                if (s > 0) {
                    RealFieldElement sxgsm1 = (RealFieldElement)GsHs[0][s - 1].multiply(s);
                    RealFieldElement sxhsm1 = (RealFieldElement)GsHs[1][s - 1].multiply(s);
                    dGsdh = (RealFieldElement)((RealFieldElement)sxgsm1.multiply(auxiliaryElements.getBeta())).subtract(sxhsm1.multiply(auxiliaryElements.getAlpha()));
                    dGsdk = (RealFieldElement)((RealFieldElement)sxgsm1.multiply(auxiliaryElements.getAlpha())).add(sxhsm1.multiply(auxiliaryElements.getBeta()));
                    dGsdAl = (RealFieldElement)((RealFieldElement)sxgsm1.multiply(auxiliaryElements.getK())).subtract(sxhsm1.multiply(auxiliaryElements.getH()));
                    dGsdBe = (RealFieldElement)((RealFieldElement)sxgsm1.multiply(auxiliaryElements.getH())).add(sxhsm1.multiply(auxiliaryElements.getK()));
                }
                RealFieldElement d0s = (RealFieldElement)zero.add(s == 0 ? 1.0 : 2.0);
                for (int n = s + 2; n <= DSSTZonal.this.maxDegree; ++n) {
                    if ((n - s) % 2 != 0) continue;
                    T kns = hansen.getHansenObjects()[s].getValue(-n - 1, context.getX());
                    T dkns = hansen.getHansenObjects()[s].getDerivative(-n - 1, context.getX());
                    double vns = (Double)DSSTZonal.this.Vns.get(new CoefficientsFactory.NSKey(n, s));
                    RealFieldElement coef0 = (RealFieldElement)((RealFieldElement)d0s.multiply(roaPow[n]).multiply(vns)).multiply(-harmonics.getUnnormalizedCnm(n, 0));
                    RealFieldElement coef1 = coef0.multiply(Qns[n][s]);
                    RealFieldElement coef2 = (RealFieldElement)coef1.multiply(kns);
                    RealFieldElement coef3 = coef2.multiply(gs);
                    RealFieldElement dqns = Qns[n][s + 1];
                    this.U = this.U.add((RealFieldElement)coef3);
                    this.dUda = (RealFieldElement)this.dUda.add(coef3.multiply(n + 1));
                    this.dUdk = this.dUdk.add((RealFieldElement)coef1.multiply(((RealFieldElement)dGsdk.multiply(kns)).add(((RealFieldElement)((RealFieldElement)auxiliaryElements.getK().multiply(context.getXXX())).multiply(dkns)).multiply(gs))));
                    this.dUdh = this.dUdh.add((RealFieldElement)coef1.multiply(((RealFieldElement)dGsdh.multiply(kns)).add(((RealFieldElement)((RealFieldElement)auxiliaryElements.getH().multiply(context.getXXX())).multiply(dkns)).multiply(gs))));
                    this.dUdAl = this.dUdAl.add((RealFieldElement)coef2.multiply(dGsdAl));
                    this.dUdBe = this.dUdBe.add((RealFieldElement)coef2.multiply(dGsdBe));
                    this.dUdGa = this.dUdGa.add((RealFieldElement)((RealFieldElement)coef0.multiply(kns)).multiply(dqns).multiply(gs));
                }
            }
            this.U = (RealFieldElement)this.U.multiply(context.getMuoa().negate());
            this.dUda = (RealFieldElement)this.dUda.multiply(context.getMuoa().divide(auxiliaryElements.getSma()));
            this.dUdk = (RealFieldElement)((RealFieldElement)this.dUdk.multiply(context.getMuoa())).negate();
            this.dUdh = (RealFieldElement)((RealFieldElement)this.dUdh.multiply(context.getMuoa())).negate();
            this.dUdAl = (RealFieldElement)((RealFieldElement)this.dUdAl.multiply(context.getMuoa())).negate();
            this.dUdBe = (RealFieldElement)((RealFieldElement)this.dUdBe.multiply(context.getMuoa())).negate();
            this.dUdGa = (RealFieldElement)((RealFieldElement)this.dUdGa.multiply(context.getMuoa())).negate();
        }

        public T getU() {
            return this.U;
        }

        public T getdUda() {
            return this.dUda;
        }

        public T getdUdk() {
            return this.dUdk;
        }

        public T getdUdh() {
            return this.dUdh;
        }

        public T getdUdAl() {
            return this.dUdAl;
        }

        public T getdUdBe() {
            return this.dUdBe;
        }

        public T getdUdGa() {
            return this.dUdGa;
        }
    }

    private class UAnddU {
        private double U;
        private double dUda;
        private double dUdk;
        private double dUdh;
        private double dUdAl;
        private double dUdBe;
        private double dUdGa;

        UAnddU(AbsoluteDate date, DSSTZonalContext context, AuxiliaryElements auxiliaryElements, HansenObjects hansen) {
            UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics = DSSTZonal.this.provider.onDate(date);
            this.U = 0.0;
            double[][] GsHs = CoefficientsFactory.computeGsHs(auxiliaryElements.getK(), auxiliaryElements.getH(), auxiliaryElements.getAlpha(), auxiliaryElements.getBeta(), DSSTZonal.this.maxEccPowMeanElements);
            double[][] Qns = CoefficientsFactory.computeQns(auxiliaryElements.getGamma(), DSSTZonal.this.maxDegree, DSSTZonal.this.maxEccPowMeanElements);
            double[] roaPow = new double[DSSTZonal.this.maxDegree + 1];
            roaPow[0] = 1.0;
            for (int i = 1; i <= DSSTZonal.this.maxDegree; ++i) {
                roaPow[i] = context.getRoa() * roaPow[i - 1];
            }
            this.dUda = 0.0;
            this.dUdk = 0.0;
            this.dUdh = 0.0;
            this.dUdAl = 0.0;
            this.dUdBe = 0.0;
            this.dUdGa = 0.0;
            for (int s = 0; s <= DSSTZonal.this.maxEccPowMeanElements; ++s) {
                hansen.computeHansenObjectsInitValues(context, s);
                double gs = GsHs[0][s];
                double dGsdh = 0.0;
                double dGsdk = 0.0;
                double dGsdAl = 0.0;
                double dGsdBe = 0.0;
                if (s > 0) {
                    double sxgsm1 = (double)s * GsHs[0][s - 1];
                    double sxhsm1 = (double)s * GsHs[1][s - 1];
                    dGsdh = auxiliaryElements.getBeta() * sxgsm1 - auxiliaryElements.getAlpha() * sxhsm1;
                    dGsdk = auxiliaryElements.getAlpha() * sxgsm1 + auxiliaryElements.getBeta() * sxhsm1;
                    dGsdAl = auxiliaryElements.getK() * sxgsm1 - auxiliaryElements.getH() * sxhsm1;
                    dGsdBe = auxiliaryElements.getH() * sxgsm1 + auxiliaryElements.getK() * sxhsm1;
                }
                double d0s = s == 0 ? 1.0 : 2.0;
                for (int n = s + 2; n <= DSSTZonal.this.maxDegree; ++n) {
                    if ((n - s) % 2 != 0) continue;
                    double kns = hansen.getHansenObjects()[s].getValue(-n - 1, context.getX());
                    double dkns = hansen.getHansenObjects()[s].getDerivative(-n - 1, context.getX());
                    double vns = (Double)DSSTZonal.this.Vns.get(new CoefficientsFactory.NSKey(n, s));
                    double coef0 = d0s * roaPow[n] * vns * -harmonics.getUnnormalizedCnm(n, 0);
                    double coef1 = coef0 * Qns[n][s];
                    double coef2 = coef1 * kns;
                    double coef3 = coef2 * gs;
                    double dqns = Qns[n][s + 1];
                    this.U += coef3;
                    this.dUda += coef3 * (double)(n + 1);
                    this.dUdk += coef1 * (kns * dGsdk + auxiliaryElements.getK() * context.getXXX() * gs * dkns);
                    this.dUdh += coef1 * (kns * dGsdh + auxiliaryElements.getH() * context.getXXX() * gs * dkns);
                    this.dUdAl += coef2 * dGsdAl;
                    this.dUdBe += coef2 * dGsdBe;
                    this.dUdGa += coef0 * kns * dqns * gs;
                }
            }
            this.U = -context.getMuoa() * this.U;
            this.dUda = this.dUda * context.getMuoa() / auxiliaryElements.getSma();
            this.dUdk *= -context.getMuoa();
            this.dUdh *= -context.getMuoa();
            this.dUdAl *= -context.getMuoa();
            this.dUdBe *= -context.getMuoa();
            this.dUdGa *= -context.getMuoa();
        }

        public double getU() {
            return this.U;
        }

        public double getdUda() {
            return this.dUda;
        }

        public double getdUdk() {
            return this.dUdk;
        }

        public double getdUdh() {
            return this.dUdh;
        }

        public double getdUdAl() {
            return this.dUdAl;
        }

        public double getdUdBe() {
            return this.dUdBe;
        }

        public double getdUdGa() {
            return this.dUdGa;
        }
    }

    private static class FieldSlot<T extends RealFieldElement<T>> {
        private final FieldShortPeriodicsInterpolatedCoefficient<T> di;
        private final FieldShortPeriodicsInterpolatedCoefficient<T>[] cij;
        private final FieldShortPeriodicsInterpolatedCoefficient<T>[] sij;

        FieldSlot(int maxFrequencyShortPeriodics, int interpolationPoints) {
            int rows = maxFrequencyShortPeriodics + 1;
            this.di = new FieldShortPeriodicsInterpolatedCoefficient(interpolationPoints);
            this.cij = (FieldShortPeriodicsInterpolatedCoefficient[])Array.newInstance(FieldShortPeriodicsInterpolatedCoefficient.class, rows);
            this.sij = (FieldShortPeriodicsInterpolatedCoefficient[])Array.newInstance(FieldShortPeriodicsInterpolatedCoefficient.class, rows);
            for (int j = 0; j <= maxFrequencyShortPeriodics; ++j) {
                this.cij[j] = new FieldShortPeriodicsInterpolatedCoefficient(interpolationPoints);
                this.sij[j] = new FieldShortPeriodicsInterpolatedCoefficient(interpolationPoints);
            }
        }
    }

    private static class Slot {
        private final ShortPeriodicsInterpolatedCoefficient di;
        private final ShortPeriodicsInterpolatedCoefficient[] cij;
        private final ShortPeriodicsInterpolatedCoefficient[] sij;

        Slot(int maxFrequencyShortPeriodics, int interpolationPoints) {
            int rows = maxFrequencyShortPeriodics + 1;
            this.di = new ShortPeriodicsInterpolatedCoefficient(interpolationPoints);
            this.cij = new ShortPeriodicsInterpolatedCoefficient[rows];
            this.sij = new ShortPeriodicsInterpolatedCoefficient[rows];
            for (int j = 0; j <= maxFrequencyShortPeriodics; ++j) {
                this.cij[j] = new ShortPeriodicsInterpolatedCoefficient(interpolationPoints);
                this.sij[j] = new ShortPeriodicsInterpolatedCoefficient(interpolationPoints);
            }
        }
    }

    private class FieldFourierCjSjCoefficients<T extends RealFieldElement<T>> {
        private final FieldGHIJjsPolynomials<T> ghijCoef;
        private final FieldLnsCoefficients<T> lnsCoef;
        private final int nMax;
        private final int sMax;
        private final int jMax;
        private final T[][] cCoef;
        private final T[][] sCoef;
        private final T hXXX;
        private final T kXXX;

        FieldFourierCjSjCoefficients(FieldAbsoluteDate<T> date, int nMax, int sMax, int jMax, FieldDSSTZonalContext<T> context, FieldHansenObjects<T> hansenObjects) {
            Field<T> field = date.getField();
            FieldAuxiliaryElements auxiliaryElements = context.getFieldAuxiliaryElements();
            this.ghijCoef = new FieldGHIJjsPolynomials(auxiliaryElements.getK(), auxiliaryElements.getH(), auxiliaryElements.getAlpha(), auxiliaryElements.getBeta());
            RealFieldElement[][] Qns = CoefficientsFactory.computeQns(auxiliaryElements.getGamma(), (int)nMax, (int)nMax);
            this.lnsCoef = new FieldLnsCoefficients(nMax, nMax, Qns, DSSTZonal.this.Vns, context.getRoa(), field);
            this.nMax = nMax;
            this.sMax = sMax;
            this.jMax = jMax;
            this.hXXX = (RealFieldElement)auxiliaryElements.getH().multiply(context.getXXX());
            this.kXXX = (RealFieldElement)auxiliaryElements.getK().multiply(context.getXXX());
            this.cCoef = (RealFieldElement[][])MathArrays.buildArray(field, 7, jMax + 1);
            this.sCoef = (RealFieldElement[][])MathArrays.buildArray(field, 7, jMax + 1);
            for (int s = 0; s <= sMax; ++s) {
                hansenObjects.computeHansenObjectsInitValues(context, s);
            }
            this.generateCoefficients(date, context, auxiliaryElements, hansenObjects, field);
        }

        private void generateCoefficients(FieldAbsoluteDate<T> date, FieldDSSTZonalContext<T> context, FieldAuxiliaryElements<T> auxiliaryElements, FieldHansenObjects<T> hansenObjects, Field<T> field) {
            RealFieldElement zero = (RealFieldElement)field.getZero();
            UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics = DSSTZonal.this.provider.onDate(date.toAbsoluteDate());
            for (int j = 1; j <= this.jMax; ++j) {
                RealFieldElement coef4;
                RealFieldElement coef3;
                RealFieldElement coef2;
                T kns;
                RealFieldElement jn;
                T dlns;
                T lns;
                for (int i = 0; i <= 6; ++i) {
                    this.cCoef[i][j] = zero;
                    this.sCoef[i][j] = zero;
                }
                if (this.isBetween(j, 1, this.nMax - 1)) {
                    RealFieldElement coef42;
                    RealFieldElement coef32;
                    RealFieldElement coef22;
                    RealFieldElement coef1;
                    RealFieldElement coef0;
                    T dkns;
                    T kns2;
                    RealFieldElement jn2;
                    T dlns2;
                    int n;
                    int jms;
                    int s;
                    for (s = j; s <= FastMath.min(this.nMax - 1, this.sMax); ++s) {
                        jms = j - s;
                        int d0smj = s == j ? 1 : 2;
                        for (n = s + 1; n <= this.nMax; ++n) {
                            if ((n + jms) % 2 != 0) continue;
                            T lns2 = this.lnsCoef.getLns(n, -jms);
                            dlns2 = this.lnsCoef.getdLnsdGamma(n, -jms);
                            T hjs = this.ghijCoef.getHjs(s, -jms);
                            T dHjsdh = this.ghijCoef.getdHjsdh(s, -jms);
                            T dHjsdk = this.ghijCoef.getdHjsdk(s, -jms);
                            T dHjsdAlpha = this.ghijCoef.getdHjsdAlpha(s, -jms);
                            T dHjsdBeta = this.ghijCoef.getdHjsdBeta(s, -jms);
                            T gjs = this.ghijCoef.getGjs(s, -jms);
                            T dGjsdh = this.ghijCoef.getdGjsdh(s, -jms);
                            T dGjsdk = this.ghijCoef.getdGjsdk(s, -jms);
                            T dGjsdAlpha = this.ghijCoef.getdGjsdAlpha(s, -jms);
                            T dGjsdBeta = this.ghijCoef.getdGjsdBeta(s, -jms);
                            jn2 = (RealFieldElement)zero.subtract(harmonics.getUnnormalizedCnm(n, 0));
                            kns2 = hansenObjects.getHansenObjects()[s].getValue(-n - 1, context.getX());
                            dkns = hansenObjects.getHansenObjects()[s].getDerivative(-n - 1, context.getX());
                            coef0 = (RealFieldElement)jn2.multiply(d0smj);
                            coef1 = (RealFieldElement)coef0.multiply(lns2);
                            coef22 = (RealFieldElement)coef1.multiply(kns2);
                            coef32 = (RealFieldElement)coef22.multiply(hjs);
                            coef42 = (RealFieldElement)coef22.multiply(gjs);
                            this.cCoef[0][j] = this.cCoef[0][j].add((RealFieldElement)coef32);
                            this.cCoef[1][j] = (RealFieldElement)this.cCoef[1][j].add(coef32.multiply(n + 1));
                            this.cCoef[2][j] = (RealFieldElement)this.cCoef[2][j].add(coef1.multiply(((RealFieldElement)kns2.multiply(dHjsdh)).add(((RealFieldElement)hjs.multiply(this.hXXX)).multiply(dkns))));
                            this.cCoef[3][j] = (RealFieldElement)this.cCoef[3][j].add(coef1.multiply(((RealFieldElement)kns2.multiply(dHjsdk)).add(((RealFieldElement)hjs.multiply(this.kXXX)).multiply(dkns))));
                            this.cCoef[4][j] = (RealFieldElement)this.cCoef[4][j].add(coef22.multiply(dHjsdAlpha));
                            this.cCoef[5][j] = (RealFieldElement)this.cCoef[5][j].add(coef22.multiply(dHjsdBeta));
                            this.cCoef[6][j] = (RealFieldElement)this.cCoef[6][j].add(((RealFieldElement)((RealFieldElement)coef0.multiply(dlns2)).multiply(kns2)).multiply(hjs));
                            this.sCoef[0][j] = this.sCoef[0][j].add((RealFieldElement)coef42);
                            this.sCoef[1][j] = (RealFieldElement)this.sCoef[1][j].add(coef42.multiply(n + 1));
                            this.sCoef[2][j] = (RealFieldElement)this.sCoef[2][j].add(coef1.multiply(((RealFieldElement)kns2.multiply(dGjsdh)).add(((RealFieldElement)gjs.multiply(this.hXXX)).multiply(dkns))));
                            this.sCoef[3][j] = (RealFieldElement)this.sCoef[3][j].add(coef1.multiply(((RealFieldElement)kns2.multiply(dGjsdk)).add(((RealFieldElement)gjs.multiply(this.kXXX)).multiply(dkns))));
                            this.sCoef[4][j] = (RealFieldElement)this.sCoef[4][j].add(coef22.multiply(dGjsdAlpha));
                            this.sCoef[5][j] = (RealFieldElement)this.sCoef[5][j].add(coef22.multiply(dGjsdBeta));
                            this.sCoef[6][j] = (RealFieldElement)this.sCoef[6][j].add(((RealFieldElement)((RealFieldElement)coef0.multiply(dlns2)).multiply(kns2)).multiply(gjs));
                        }
                    }
                    for (s = 0; s <= FastMath.min(this.nMax - j, this.sMax); ++s) {
                        int jps = j + s;
                        double d0spj = s == -j ? 1.0 : 2.0;
                        for (int n2 = FastMath.max(j + s, j + 1); n2 <= this.nMax; ++n2) {
                            if ((n2 + jps) % 2 != 0) continue;
                            lns = this.lnsCoef.getLns(n2, jps);
                            dlns = this.lnsCoef.getdLnsdGamma(n2, jps);
                            T hjs = this.ghijCoef.getHjs(s, jps);
                            T dHjsdh = this.ghijCoef.getdHjsdh(s, jps);
                            T dHjsdk = this.ghijCoef.getdHjsdk(s, jps);
                            T dHjsdAlpha = this.ghijCoef.getdHjsdAlpha(s, jps);
                            T dHjsdBeta = this.ghijCoef.getdHjsdBeta(s, jps);
                            T gjs = this.ghijCoef.getGjs(s, jps);
                            T dGjsdh = this.ghijCoef.getdGjsdh(s, jps);
                            T dGjsdk = this.ghijCoef.getdGjsdk(s, jps);
                            T dGjsdAlpha = this.ghijCoef.getdGjsdAlpha(s, jps);
                            T dGjsdBeta = this.ghijCoef.getdGjsdBeta(s, jps);
                            jn = (RealFieldElement)zero.subtract(harmonics.getUnnormalizedCnm(n2, 0));
                            kns = hansenObjects.getHansenObjects()[s].getValue(-n2 - 1, context.getX());
                            T dkns2 = hansenObjects.getHansenObjects()[s].getDerivative(-n2 - 1, context.getX());
                            RealFieldElement coef02 = (RealFieldElement)jn.multiply(d0spj);
                            RealFieldElement coef12 = (RealFieldElement)coef02.multiply(lns);
                            coef2 = (RealFieldElement)coef12.multiply(kns);
                            coef3 = (RealFieldElement)coef2.multiply(hjs);
                            coef4 = (RealFieldElement)coef2.multiply(gjs);
                            this.cCoef[0][j] = this.cCoef[0][j].subtract((RealFieldElement)coef3);
                            this.cCoef[1][j] = (RealFieldElement)this.cCoef[1][j].subtract(coef3.multiply(n2 + 1));
                            this.cCoef[2][j] = (RealFieldElement)this.cCoef[2][j].subtract(coef12.multiply(((RealFieldElement)kns.multiply(dHjsdh)).add(((RealFieldElement)hjs.multiply(this.hXXX)).multiply(dkns2))));
                            this.cCoef[3][j] = (RealFieldElement)this.cCoef[3][j].subtract(coef12.multiply(((RealFieldElement)kns.multiply(dHjsdk)).add(((RealFieldElement)hjs.multiply(this.kXXX)).multiply(dkns2))));
                            this.cCoef[4][j] = (RealFieldElement)this.cCoef[4][j].subtract(coef2.multiply(dHjsdAlpha));
                            this.cCoef[5][j] = (RealFieldElement)this.cCoef[5][j].subtract(coef2.multiply(dHjsdBeta));
                            this.cCoef[6][j] = (RealFieldElement)this.cCoef[6][j].subtract(((RealFieldElement)((RealFieldElement)coef02.multiply(dlns)).multiply(kns)).multiply(hjs));
                            this.sCoef[0][j] = this.sCoef[0][j].add((RealFieldElement)coef4);
                            this.sCoef[1][j] = (RealFieldElement)this.sCoef[1][j].add(coef4.multiply(n2 + 1));
                            this.sCoef[2][j] = (RealFieldElement)this.sCoef[2][j].add(coef12.multiply(((RealFieldElement)kns.multiply(dGjsdh)).add(((RealFieldElement)gjs.multiply(this.hXXX)).multiply(dkns2))));
                            this.sCoef[3][j] = (RealFieldElement)this.sCoef[3][j].add(coef12.multiply(((RealFieldElement)kns.multiply(dGjsdk)).add(((RealFieldElement)gjs.multiply(this.kXXX)).multiply(dkns2))));
                            this.sCoef[4][j] = (RealFieldElement)this.sCoef[4][j].add(coef2.multiply(dGjsdAlpha));
                            this.sCoef[5][j] = (RealFieldElement)this.sCoef[5][j].add(coef2.multiply(dGjsdBeta));
                            this.sCoef[6][j] = (RealFieldElement)this.sCoef[6][j].add(((RealFieldElement)((RealFieldElement)coef02.multiply(dlns)).multiply(kns)).multiply(gjs));
                        }
                    }
                    for (s = 1; s <= FastMath.min(j, this.sMax); ++s) {
                        jms = j - s;
                        int d0smj = s == j ? 1 : 2;
                        for (n = j + 1; n <= this.nMax; ++n) {
                            if ((n + jms) % 2 != 0) continue;
                            T lns3 = this.lnsCoef.getLns(n, jms);
                            dlns2 = this.lnsCoef.getdLnsdGamma(n, jms);
                            T ijs = this.ghijCoef.getIjs(s, jms);
                            T dIjsdh = this.ghijCoef.getdIjsdh(s, jms);
                            T dIjsdk = this.ghijCoef.getdIjsdk(s, jms);
                            T dIjsdAlpha = this.ghijCoef.getdIjsdAlpha(s, jms);
                            T dIjsdBeta = this.ghijCoef.getdIjsdBeta(s, jms);
                            T jjs = this.ghijCoef.getJjs(s, jms);
                            T dJjsdh = this.ghijCoef.getdJjsdh(s, jms);
                            T dJjsdk = this.ghijCoef.getdJjsdk(s, jms);
                            T dJjsdAlpha = this.ghijCoef.getdJjsdAlpha(s, jms);
                            T dJjsdBeta = this.ghijCoef.getdJjsdBeta(s, jms);
                            jn2 = (RealFieldElement)zero.subtract(harmonics.getUnnormalizedCnm(n, 0));
                            kns2 = hansenObjects.getHansenObjects()[s].getValue(-n - 1, context.getX());
                            dkns = hansenObjects.getHansenObjects()[s].getDerivative(-n - 1, context.getX());
                            coef0 = (RealFieldElement)jn2.multiply(d0smj);
                            coef1 = (RealFieldElement)coef0.multiply(lns3);
                            coef22 = (RealFieldElement)coef1.multiply(kns2);
                            coef32 = (RealFieldElement)coef22.multiply(ijs);
                            coef42 = (RealFieldElement)coef22.multiply(jjs);
                            this.cCoef[0][j] = this.cCoef[0][j].subtract((RealFieldElement)coef32);
                            this.cCoef[1][j] = (RealFieldElement)this.cCoef[1][j].subtract(coef32.multiply(n + 1));
                            this.cCoef[2][j] = (RealFieldElement)this.cCoef[2][j].subtract(coef1.multiply(((RealFieldElement)kns2.multiply(dIjsdh)).add(((RealFieldElement)ijs.multiply(this.hXXX)).multiply(dkns))));
                            this.cCoef[3][j] = (RealFieldElement)this.cCoef[3][j].subtract(coef1.multiply(((RealFieldElement)kns2.multiply(dIjsdk)).add(((RealFieldElement)ijs.multiply(this.kXXX)).multiply(dkns))));
                            this.cCoef[4][j] = (RealFieldElement)this.cCoef[4][j].subtract(coef22.multiply(dIjsdAlpha));
                            this.cCoef[5][j] = (RealFieldElement)this.cCoef[5][j].subtract(coef22.multiply(dIjsdBeta));
                            this.cCoef[6][j] = (RealFieldElement)this.cCoef[6][j].subtract(((RealFieldElement)((RealFieldElement)coef0.multiply(dlns2)).multiply(kns2)).multiply(ijs));
                            this.sCoef[0][j] = this.sCoef[0][j].add((RealFieldElement)coef42);
                            this.sCoef[1][j] = (RealFieldElement)this.sCoef[1][j].add(coef42.multiply(n + 1));
                            this.sCoef[2][j] = (RealFieldElement)this.sCoef[2][j].add(coef1.multiply(((RealFieldElement)kns2.multiply(dJjsdh)).add(((RealFieldElement)jjs.multiply(this.hXXX)).multiply(dkns))));
                            this.sCoef[3][j] = (RealFieldElement)this.sCoef[3][j].add(coef1.multiply(((RealFieldElement)kns2.multiply(dJjsdk)).add(((RealFieldElement)jjs.multiply(this.kXXX)).multiply(dkns))));
                            this.sCoef[4][j] = (RealFieldElement)this.sCoef[4][j].add(coef22.multiply(dJjsdAlpha));
                            this.sCoef[5][j] = (RealFieldElement)this.sCoef[5][j].add(coef22.multiply(dJjsdBeta));
                            this.sCoef[6][j] = (RealFieldElement)this.sCoef[6][j].add(((RealFieldElement)((RealFieldElement)coef0.multiply(dlns2)).multiply(kns2)).multiply(jjs));
                        }
                    }
                }
                if (this.isBetween(j, 2, this.nMax)) {
                    RealFieldElement jj = (RealFieldElement)zero.subtract(harmonics.getUnnormalizedCnm(j, 0));
                    T kns3 = hansenObjects.getHansenObjects()[0].getValue(-j - 1, context.getX());
                    T dkns = hansenObjects.getHansenObjects()[0].getDerivative(-j - 1, context.getX());
                    T lns4 = this.lnsCoef.getLns(j, j);
                    T hjs = this.ghijCoef.getHjs(0, j);
                    T dHjsdh = this.ghijCoef.getdHjsdh(0, j);
                    T dHjsdk = this.ghijCoef.getdHjsdk(0, j);
                    T dHjsdAlpha = this.ghijCoef.getdHjsdAlpha(0, j);
                    T dHjsdBeta = this.ghijCoef.getdHjsdBeta(0, j);
                    T gjs = this.ghijCoef.getGjs(0, j);
                    T dGjsdh = this.ghijCoef.getdGjsdh(0, j);
                    T dGjsdk = this.ghijCoef.getdGjsdk(0, j);
                    T dGjsdAlpha = this.ghijCoef.getdGjsdAlpha(0, j);
                    T dGjsdBeta = this.ghijCoef.getdGjsdBeta(0, j);
                    RealFieldElement coef0 = (RealFieldElement)jj.multiply(2.0);
                    RealFieldElement coef1 = (RealFieldElement)coef0.multiply(lns4);
                    RealFieldElement coef23 = (RealFieldElement)coef1.multiply(kns3);
                    RealFieldElement coef33 = (RealFieldElement)coef23.multiply(hjs);
                    RealFieldElement coef43 = (RealFieldElement)coef23.multiply(gjs);
                    this.cCoef[0][j] = this.cCoef[0][j].subtract((RealFieldElement)coef33);
                    this.cCoef[1][j] = (RealFieldElement)this.cCoef[1][j].subtract(coef33.multiply(j + 1));
                    this.cCoef[2][j] = (RealFieldElement)this.cCoef[2][j].subtract(coef1.multiply(((RealFieldElement)kns3.multiply(dHjsdh)).add(((RealFieldElement)hjs.multiply(this.hXXX)).multiply(dkns))));
                    this.cCoef[3][j] = (RealFieldElement)this.cCoef[3][j].subtract(coef1.multiply(((RealFieldElement)kns3.multiply(dHjsdk)).add(((RealFieldElement)hjs.multiply(this.kXXX)).multiply(dkns))));
                    this.cCoef[4][j] = (RealFieldElement)this.cCoef[4][j].subtract(coef23.multiply(dHjsdAlpha));
                    this.cCoef[5][j] = (RealFieldElement)this.cCoef[5][j].subtract(coef23.multiply(dHjsdBeta));
                    this.sCoef[0][j] = this.sCoef[0][j].add((RealFieldElement)coef43);
                    this.sCoef[1][j] = (RealFieldElement)this.sCoef[1][j].add(coef43.multiply(j + 1));
                    this.sCoef[2][j] = (RealFieldElement)this.sCoef[2][j].add(coef1.multiply(((RealFieldElement)kns3.multiply(dGjsdh)).add(((RealFieldElement)gjs.multiply(this.hXXX)).multiply(dkns))));
                    this.sCoef[3][j] = (RealFieldElement)this.sCoef[3][j].add(coef1.multiply(((RealFieldElement)kns3.multiply(dGjsdk)).add(((RealFieldElement)gjs.multiply(this.kXXX)).multiply(dkns))));
                    this.sCoef[4][j] = (RealFieldElement)this.sCoef[4][j].add(coef23.multiply(dGjsdAlpha));
                    this.sCoef[5][j] = (RealFieldElement)this.sCoef[5][j].add(coef23.multiply(dGjsdBeta));
                    for (int s = 1; s <= FastMath.min(j - 1, this.sMax); ++s) {
                        int d0smj;
                        int jms = j - s;
                        int n = d0smj = s == j ? 1 : 2;
                        if (s % 2 != 0) continue;
                        kns3 = hansenObjects.getHansenObjects()[s].getValue(-j - 1, context.getX());
                        dkns = hansenObjects.getHansenObjects()[s].getDerivative(-j - 1, context.getX());
                        lns4 = this.lnsCoef.getLns(j, jms);
                        T dlns3 = this.lnsCoef.getdLnsdGamma(j, jms);
                        T ijs = this.ghijCoef.getIjs(s, jms);
                        T dIjsdh = this.ghijCoef.getdIjsdh(s, jms);
                        T dIjsdk = this.ghijCoef.getdIjsdk(s, jms);
                        T dIjsdAlpha = this.ghijCoef.getdIjsdAlpha(s, jms);
                        T dIjsdBeta = this.ghijCoef.getdIjsdBeta(s, jms);
                        T jjs = this.ghijCoef.getJjs(s, jms);
                        T dJjsdh = this.ghijCoef.getdJjsdh(s, jms);
                        T dJjsdk = this.ghijCoef.getdJjsdk(s, jms);
                        T dJjsdAlpha = this.ghijCoef.getdJjsdAlpha(s, jms);
                        T dJjsdBeta = this.ghijCoef.getdJjsdBeta(s, jms);
                        coef0 = (RealFieldElement)jj.multiply(d0smj);
                        coef1 = (RealFieldElement)coef0.multiply(lns4);
                        coef23 = (RealFieldElement)coef1.multiply(kns3);
                        coef33 = (RealFieldElement)coef23.multiply(ijs);
                        coef43 = (RealFieldElement)coef23.multiply(jjs);
                        this.cCoef[0][j] = this.cCoef[0][j].subtract((RealFieldElement)coef33);
                        this.cCoef[1][j] = (RealFieldElement)this.cCoef[1][j].subtract(coef33.multiply(j + 1));
                        this.cCoef[2][j] = (RealFieldElement)this.cCoef[2][j].subtract(coef1.multiply(((RealFieldElement)kns3.multiply(dIjsdh)).add(((RealFieldElement)ijs.multiply(this.hXXX)).multiply(dkns))));
                        this.cCoef[3][j] = (RealFieldElement)this.cCoef[3][j].subtract(coef1.multiply(((RealFieldElement)kns3.multiply(dIjsdk)).add(((RealFieldElement)ijs.multiply(this.kXXX)).multiply(dkns))));
                        this.cCoef[4][j] = (RealFieldElement)this.cCoef[4][j].subtract(coef23.multiply(dIjsdAlpha));
                        this.cCoef[5][j] = (RealFieldElement)this.cCoef[5][j].subtract(coef23.multiply(dIjsdBeta));
                        this.cCoef[6][j] = (RealFieldElement)this.cCoef[6][j].subtract(((RealFieldElement)((RealFieldElement)coef0.multiply(dlns3)).multiply(kns3)).multiply(ijs));
                        this.sCoef[0][j] = this.sCoef[0][j].add((RealFieldElement)coef43);
                        this.sCoef[1][j] = (RealFieldElement)this.sCoef[1][j].add(coef43.multiply(j + 1));
                        this.sCoef[2][j] = (RealFieldElement)this.sCoef[2][j].add(coef1.multiply(((RealFieldElement)kns3.multiply(dJjsdh)).add(((RealFieldElement)jjs.multiply(this.hXXX)).multiply(dkns))));
                        this.sCoef[3][j] = (RealFieldElement)this.sCoef[3][j].add(coef1.multiply(((RealFieldElement)kns3.multiply(dJjsdk)).add(((RealFieldElement)jjs.multiply(this.kXXX)).multiply(dkns))));
                        this.sCoef[4][j] = (RealFieldElement)this.sCoef[4][j].add(coef23.multiply(dJjsdAlpha));
                        this.sCoef[5][j] = (RealFieldElement)this.sCoef[5][j].add(coef23.multiply(dJjsdBeta));
                        this.sCoef[6][j] = (RealFieldElement)this.sCoef[6][j].add(((RealFieldElement)((RealFieldElement)coef0.multiply(dlns3)).multiply(kns3)).multiply(jjs));
                    }
                }
                if (this.isBetween(j, 3, 2 * this.nMax - 1)) {
                    T dJjsdBeta;
                    T dJjsdAlpha;
                    T dJjsdk;
                    T dJjsdh;
                    T jjs;
                    T dIjsdBeta;
                    T dIjsdAlpha;
                    T dIjsdk;
                    T dIjsdh;
                    T ijs;
                    int minjm1on = FastMath.min(j - 1, this.nMax);
                    if (j % 2 == 0) {
                        int s;
                        for (s = j - minjm1on; s <= FastMath.min(j / 2 - 1, this.sMax); ++s) {
                            int jms = j - s;
                            int d0smj = s == j ? 1 : 2;
                            for (int n = j - s; n <= minjm1on; ++n) {
                                if ((n + jms) % 2 != 0) continue;
                                lns = this.lnsCoef.getLns(n, jms);
                                dlns = this.lnsCoef.getdLnsdGamma(n, jms);
                                ijs = this.ghijCoef.getIjs(s, jms);
                                dIjsdh = this.ghijCoef.getdIjsdh(s, jms);
                                dIjsdk = this.ghijCoef.getdIjsdk(s, jms);
                                dIjsdAlpha = this.ghijCoef.getdIjsdAlpha(s, jms);
                                dIjsdBeta = this.ghijCoef.getdIjsdBeta(s, jms);
                                jjs = this.ghijCoef.getJjs(s, jms);
                                dJjsdh = this.ghijCoef.getdJjsdh(s, jms);
                                dJjsdk = this.ghijCoef.getdJjsdk(s, jms);
                                dJjsdAlpha = this.ghijCoef.getdJjsdAlpha(s, jms);
                                dJjsdBeta = this.ghijCoef.getdJjsdBeta(s, jms);
                                jn = (RealFieldElement)zero.subtract(harmonics.getUnnormalizedCnm(n, 0));
                                kns = hansenObjects.getHansenObjects()[s].getValue(-n - 1, context.getX());
                                T dkns = hansenObjects.getHansenObjects()[s].getDerivative(-n - 1, context.getX());
                                RealFieldElement coef0 = (RealFieldElement)jn.multiply(d0smj);
                                RealFieldElement coef1 = (RealFieldElement)coef0.multiply(lns);
                                coef2 = (RealFieldElement)coef1.multiply(kns);
                                coef3 = (RealFieldElement)coef2.multiply(ijs);
                                coef4 = (RealFieldElement)coef2.multiply(jjs);
                                this.cCoef[0][j] = this.cCoef[0][j].subtract((RealFieldElement)coef3);
                                this.cCoef[1][j] = (RealFieldElement)this.cCoef[1][j].subtract(coef3.multiply(n + 1));
                                this.cCoef[2][j] = (RealFieldElement)this.cCoef[2][j].subtract(coef1.multiply(((RealFieldElement)kns.multiply(dIjsdh)).add(((RealFieldElement)ijs.multiply(this.hXXX)).multiply(dkns))));
                                this.cCoef[3][j] = (RealFieldElement)this.cCoef[3][j].subtract(coef1.multiply(((RealFieldElement)kns.multiply(dIjsdk)).add(((RealFieldElement)ijs.multiply(this.kXXX)).multiply(dkns))));
                                this.cCoef[4][j] = (RealFieldElement)this.cCoef[4][j].subtract(coef2.multiply(dIjsdAlpha));
                                this.cCoef[5][j] = (RealFieldElement)this.cCoef[5][j].subtract(coef2.multiply(dIjsdBeta));
                                this.cCoef[6][j] = (RealFieldElement)this.cCoef[6][j].subtract(((RealFieldElement)((RealFieldElement)coef0.multiply(dlns)).multiply(kns)).multiply(ijs));
                                this.sCoef[0][j] = this.sCoef[0][j].add((RealFieldElement)coef4);
                                this.sCoef[1][j] = (RealFieldElement)this.sCoef[1][j].add(coef4.multiply(n + 1));
                                this.sCoef[2][j] = (RealFieldElement)this.sCoef[2][j].add(coef1.multiply(((RealFieldElement)kns.multiply(dJjsdh)).add(((RealFieldElement)jjs.multiply(this.hXXX)).multiply(dkns))));
                                this.sCoef[3][j] = (RealFieldElement)this.sCoef[3][j].add(coef1.multiply(((RealFieldElement)kns.multiply(dJjsdk)).add(((RealFieldElement)jjs.multiply(this.kXXX)).multiply(dkns))));
                                this.sCoef[4][j] = (RealFieldElement)this.sCoef[4][j].add(coef2.multiply(dJjsdAlpha));
                                this.sCoef[5][j] = (RealFieldElement)this.sCoef[5][j].add(coef2.multiply(dJjsdBeta));
                                this.sCoef[6][j] = (RealFieldElement)this.sCoef[6][j].add(((RealFieldElement)((RealFieldElement)coef0.multiply(dlns)).multiply(kns)).multiply(jjs));
                            }
                        }
                        for (s = j / 2; s <= FastMath.min(minjm1on - 1, this.sMax); ++s) {
                            int jms = j - s;
                            int d0smj = s == j ? 1 : 2;
                            for (int n = s + 1; n <= minjm1on; ++n) {
                                if ((n + jms) % 2 != 0) continue;
                                lns = this.lnsCoef.getLns(n, jms);
                                dlns = this.lnsCoef.getdLnsdGamma(n, jms);
                                ijs = this.ghijCoef.getIjs(s, jms);
                                dIjsdh = this.ghijCoef.getdIjsdh(s, jms);
                                dIjsdk = this.ghijCoef.getdIjsdk(s, jms);
                                dIjsdAlpha = this.ghijCoef.getdIjsdAlpha(s, jms);
                                dIjsdBeta = this.ghijCoef.getdIjsdBeta(s, jms);
                                jjs = this.ghijCoef.getJjs(s, jms);
                                dJjsdh = this.ghijCoef.getdJjsdh(s, jms);
                                dJjsdk = this.ghijCoef.getdJjsdk(s, jms);
                                dJjsdAlpha = this.ghijCoef.getdJjsdAlpha(s, jms);
                                dJjsdBeta = this.ghijCoef.getdJjsdBeta(s, jms);
                                jn = (RealFieldElement)zero.subtract(harmonics.getUnnormalizedCnm(n, 0));
                                kns = hansenObjects.getHansenObjects()[s].getValue(-n - 1, context.getX());
                                T dkns = hansenObjects.getHansenObjects()[s].getDerivative(-n - 1, context.getX());
                                RealFieldElement coef0 = (RealFieldElement)jn.multiply(d0smj);
                                RealFieldElement coef1 = (RealFieldElement)coef0.multiply(lns);
                                coef2 = (RealFieldElement)coef1.multiply(kns);
                                coef3 = (RealFieldElement)coef2.multiply(ijs);
                                coef4 = (RealFieldElement)coef2.multiply(jjs);
                                this.cCoef[0][j] = this.cCoef[0][j].subtract((RealFieldElement)coef3);
                                this.cCoef[1][j] = (RealFieldElement)this.cCoef[1][j].subtract(coef3.multiply(n + 1));
                                this.cCoef[2][j] = (RealFieldElement)this.cCoef[2][j].subtract(coef1.multiply(((RealFieldElement)kns.multiply(dIjsdh)).add(((RealFieldElement)ijs.multiply(this.hXXX)).multiply(dkns))));
                                this.cCoef[3][j] = (RealFieldElement)this.cCoef[3][j].subtract(coef1.multiply(((RealFieldElement)kns.multiply(dIjsdk)).add(((RealFieldElement)ijs.multiply(this.kXXX)).multiply(dkns))));
                                this.cCoef[4][j] = (RealFieldElement)this.cCoef[4][j].subtract(coef2.multiply(dIjsdAlpha));
                                this.cCoef[5][j] = (RealFieldElement)this.cCoef[5][j].subtract(coef2.multiply(dIjsdBeta));
                                this.cCoef[6][j] = (RealFieldElement)this.cCoef[6][j].subtract(((RealFieldElement)((RealFieldElement)coef0.multiply(dlns)).multiply(kns)).multiply(ijs));
                                this.sCoef[0][j] = this.sCoef[0][j].add((RealFieldElement)coef4);
                                this.sCoef[1][j] = (RealFieldElement)this.sCoef[1][j].add(coef4.multiply(n + 1));
                                this.sCoef[2][j] = (RealFieldElement)this.sCoef[2][j].add(coef1.multiply(((RealFieldElement)kns.multiply(dJjsdh)).add(((RealFieldElement)jjs.multiply(this.hXXX)).multiply(dkns))));
                                this.sCoef[3][j] = (RealFieldElement)this.sCoef[3][j].add(coef1.multiply(((RealFieldElement)kns.multiply(dJjsdk)).add(((RealFieldElement)jjs.multiply(this.kXXX)).multiply(dkns))));
                                this.sCoef[4][j] = (RealFieldElement)this.sCoef[4][j].add(coef2.multiply(dJjsdAlpha));
                                this.sCoef[5][j] = (RealFieldElement)this.sCoef[5][j].add(coef2.multiply(dJjsdBeta));
                                this.sCoef[6][j] = (RealFieldElement)this.sCoef[6][j].add(((RealFieldElement)((RealFieldElement)coef0.multiply(dlns)).multiply(kns)).multiply(jjs));
                            }
                        }
                    } else {
                        int s;
                        for (s = (j - 1) / 2; s <= FastMath.min(minjm1on - 1, this.sMax); ++s) {
                            int jms = j - s;
                            int d0smj = s == j ? 1 : 2;
                            for (int n = s + 1; n <= minjm1on; ++n) {
                                if ((n + jms) % 2 != 0) continue;
                                lns = this.lnsCoef.getLns(n, jms);
                                dlns = this.lnsCoef.getdLnsdGamma(n, jms);
                                ijs = this.ghijCoef.getIjs(s, jms);
                                dIjsdh = this.ghijCoef.getdIjsdh(s, jms);
                                dIjsdk = this.ghijCoef.getdIjsdk(s, jms);
                                dIjsdAlpha = this.ghijCoef.getdIjsdAlpha(s, jms);
                                dIjsdBeta = this.ghijCoef.getdIjsdBeta(s, jms);
                                jjs = this.ghijCoef.getJjs(s, jms);
                                dJjsdh = this.ghijCoef.getdJjsdh(s, jms);
                                dJjsdk = this.ghijCoef.getdJjsdk(s, jms);
                                dJjsdAlpha = this.ghijCoef.getdJjsdAlpha(s, jms);
                                dJjsdBeta = this.ghijCoef.getdJjsdBeta(s, jms);
                                jn = (RealFieldElement)zero.subtract(harmonics.getUnnormalizedCnm(n, 0));
                                kns = hansenObjects.getHansenObjects()[s].getValue(-n - 1, context.getX());
                                T dkns = hansenObjects.getHansenObjects()[s].getDerivative(-n - 1, context.getX());
                                RealFieldElement coef0 = (RealFieldElement)jn.multiply(d0smj);
                                RealFieldElement coef1 = (RealFieldElement)coef0.multiply(lns);
                                coef2 = (RealFieldElement)coef1.multiply(kns);
                                coef3 = (RealFieldElement)coef2.multiply(ijs);
                                coef4 = (RealFieldElement)coef2.multiply(jjs);
                                this.cCoef[0][j] = this.cCoef[0][j].subtract((RealFieldElement)coef3);
                                this.cCoef[1][j] = (RealFieldElement)this.cCoef[1][j].subtract(coef3.multiply(n + 1));
                                this.cCoef[2][j] = (RealFieldElement)this.cCoef[2][j].subtract(coef1.multiply(((RealFieldElement)kns.multiply(dIjsdh)).add(((RealFieldElement)ijs.multiply(this.hXXX)).multiply(dkns))));
                                this.cCoef[3][j] = (RealFieldElement)this.cCoef[3][j].subtract(coef1.multiply(((RealFieldElement)kns.multiply(dIjsdk)).add(((RealFieldElement)ijs.multiply(this.kXXX)).multiply(dkns))));
                                this.cCoef[4][j] = (RealFieldElement)this.cCoef[4][j].subtract(coef2.multiply(dIjsdAlpha));
                                this.cCoef[5][j] = (RealFieldElement)this.cCoef[5][j].subtract(coef2.multiply(dIjsdBeta));
                                this.cCoef[6][j] = (RealFieldElement)this.cCoef[6][j].subtract(((RealFieldElement)((RealFieldElement)coef0.multiply(dlns)).multiply(kns)).multiply(ijs));
                                this.sCoef[0][j] = this.sCoef[0][j].add((RealFieldElement)coef4);
                                this.sCoef[1][j] = (RealFieldElement)this.sCoef[1][j].add(coef4.multiply(n + 1));
                                this.sCoef[2][j] = (RealFieldElement)this.sCoef[2][j].add(coef1.multiply(((RealFieldElement)kns.multiply(dJjsdh)).add(((RealFieldElement)jjs.multiply(this.hXXX)).multiply(dkns))));
                                this.sCoef[3][j] = (RealFieldElement)this.sCoef[3][j].add(coef1.multiply(((RealFieldElement)kns.multiply(dJjsdk)).add(((RealFieldElement)jjs.multiply(this.kXXX)).multiply(dkns))));
                                this.sCoef[4][j] = (RealFieldElement)this.sCoef[4][j].add(coef2.multiply(dJjsdAlpha));
                                this.sCoef[5][j] = (RealFieldElement)this.sCoef[5][j].add(coef2.multiply(dJjsdBeta));
                                this.sCoef[6][j] = (RealFieldElement)this.sCoef[6][j].add(((RealFieldElement)((RealFieldElement)coef0.multiply(dlns)).multiply(kns)).multiply(jjs));
                            }
                        }
                        if (this.nMax >= 4 && this.isBetween(j, 5, 2 * this.nMax - 3)) {
                            for (s = j - minjm1on; s <= FastMath.min((j - 3) / 2, this.sMax); ++s) {
                                int jms = j - s;
                                int d0smj = s == j ? 1 : 2;
                                for (int n = j - s; n <= minjm1on; ++n) {
                                    if ((n + jms) % 2 != 0) continue;
                                    lns = this.lnsCoef.getLns(n, jms);
                                    dlns = this.lnsCoef.getdLnsdGamma(n, jms);
                                    ijs = this.ghijCoef.getIjs(s, jms);
                                    dIjsdh = this.ghijCoef.getdIjsdh(s, jms);
                                    dIjsdk = this.ghijCoef.getdIjsdk(s, jms);
                                    dIjsdAlpha = this.ghijCoef.getdIjsdAlpha(s, jms);
                                    dIjsdBeta = this.ghijCoef.getdIjsdBeta(s, jms);
                                    jjs = this.ghijCoef.getJjs(s, jms);
                                    dJjsdh = this.ghijCoef.getdJjsdh(s, jms);
                                    dJjsdk = this.ghijCoef.getdJjsdk(s, jms);
                                    dJjsdAlpha = this.ghijCoef.getdJjsdAlpha(s, jms);
                                    dJjsdBeta = this.ghijCoef.getdJjsdBeta(s, jms);
                                    jn = (RealFieldElement)zero.subtract(harmonics.getUnnormalizedCnm(n, 0));
                                    kns = hansenObjects.getHansenObjects()[s].getValue(-n - 1, context.getX());
                                    T dkns = hansenObjects.getHansenObjects()[s].getDerivative(-n - 1, context.getX());
                                    RealFieldElement coef0 = (RealFieldElement)jn.multiply(d0smj);
                                    RealFieldElement coef1 = (RealFieldElement)coef0.multiply(lns);
                                    coef2 = (RealFieldElement)coef1.multiply(kns);
                                    coef3 = (RealFieldElement)coef2.multiply(ijs);
                                    coef4 = (RealFieldElement)coef2.multiply(jjs);
                                    this.cCoef[0][j] = this.cCoef[0][j].subtract((RealFieldElement)coef3);
                                    this.cCoef[1][j] = (RealFieldElement)this.cCoef[1][j].subtract(coef3.multiply(n + 1));
                                    this.cCoef[2][j] = (RealFieldElement)this.cCoef[2][j].subtract(coef1.multiply(((RealFieldElement)kns.multiply(dIjsdh)).add(((RealFieldElement)ijs.multiply(this.hXXX)).multiply(dkns))));
                                    this.cCoef[3][j] = (RealFieldElement)this.cCoef[3][j].subtract(coef1.multiply(((RealFieldElement)kns.multiply(dIjsdk)).add(((RealFieldElement)ijs.multiply(this.kXXX)).multiply(dkns))));
                                    this.cCoef[4][j] = (RealFieldElement)this.cCoef[4][j].subtract(coef2.multiply(dIjsdAlpha));
                                    this.cCoef[5][j] = (RealFieldElement)this.cCoef[5][j].subtract(coef2.multiply(dIjsdBeta));
                                    this.cCoef[6][j] = (RealFieldElement)this.cCoef[6][j].subtract(((RealFieldElement)((RealFieldElement)coef0.multiply(dlns)).multiply(kns)).multiply(ijs));
                                    this.sCoef[0][j] = this.sCoef[0][j].add((RealFieldElement)coef4);
                                    this.sCoef[1][j] = (RealFieldElement)this.sCoef[1][j].add(coef4.multiply(n + 1));
                                    this.sCoef[2][j] = (RealFieldElement)this.sCoef[2][j].add(coef1.multiply(((RealFieldElement)kns.multiply(dJjsdh)).add(((RealFieldElement)jjs.multiply(this.hXXX)).multiply(dkns))));
                                    this.sCoef[3][j] = (RealFieldElement)this.sCoef[3][j].add(coef1.multiply(((RealFieldElement)kns.multiply(dJjsdk)).add(((RealFieldElement)jjs.multiply(this.kXXX)).multiply(dkns))));
                                    this.sCoef[4][j] = (RealFieldElement)this.sCoef[4][j].add(coef2.multiply(dJjsdAlpha));
                                    this.sCoef[5][j] = (RealFieldElement)this.sCoef[5][j].add(coef2.multiply(dJjsdBeta));
                                    this.sCoef[6][j] = (RealFieldElement)this.sCoef[6][j].add(((RealFieldElement)((RealFieldElement)coef0.multiply(dlns)).multiply(kns)).multiply(jjs));
                                }
                            }
                        }
                    }
                }
                this.cCoef[0][j] = (RealFieldElement)this.cCoef[0][j].multiply(((RealFieldElement)context.getMuoa().divide(j)).negate());
                this.cCoef[1][j] = (RealFieldElement)this.cCoef[1][j].multiply((int)context.getMuoa().divide(auxiliaryElements.getSma().multiply((int)j)));
                this.cCoef[2][j] = (RealFieldElement)this.cCoef[2][j].multiply(((RealFieldElement)context.getMuoa().divide(j)).negate());
                this.cCoef[3][j] = (RealFieldElement)this.cCoef[3][j].multiply(((RealFieldElement)context.getMuoa().divide(j)).negate());
                this.cCoef[4][j] = (RealFieldElement)this.cCoef[4][j].multiply(((RealFieldElement)context.getMuoa().divide(j)).negate());
                this.cCoef[5][j] = (RealFieldElement)this.cCoef[5][j].multiply(((RealFieldElement)context.getMuoa().divide(j)).negate());
                this.cCoef[6][j] = (RealFieldElement)this.cCoef[6][j].multiply(((RealFieldElement)context.getMuoa().divide(j)).negate());
                this.sCoef[0][j] = (RealFieldElement)this.sCoef[0][j].multiply(((RealFieldElement)context.getMuoa().divide(j)).negate());
                this.sCoef[1][j] = (RealFieldElement)this.sCoef[1][j].multiply((int)context.getMuoa().divide(auxiliaryElements.getSma().multiply((int)j)));
                this.sCoef[2][j] = (RealFieldElement)this.sCoef[2][j].multiply(((RealFieldElement)context.getMuoa().divide(j)).negate());
                this.sCoef[3][j] = (RealFieldElement)this.sCoef[3][j].multiply(((RealFieldElement)context.getMuoa().divide(j)).negate());
                this.sCoef[4][j] = (RealFieldElement)this.sCoef[4][j].multiply(((RealFieldElement)context.getMuoa().divide(j)).negate());
                this.sCoef[5][j] = (RealFieldElement)this.sCoef[5][j].multiply(((RealFieldElement)context.getMuoa().divide(j)).negate());
                this.sCoef[6][j] = (RealFieldElement)this.sCoef[6][j].multiply(((RealFieldElement)context.getMuoa().divide(j)).negate());
            }
        }

        private boolean isBetween(int index, int lowerBound, int upperBound) {
            return index >= lowerBound && index <= upperBound;
        }

        public T getCj(int j) {
            return this.cCoef[0][j];
        }

        public T getdCjdA(int j) {
            return this.cCoef[1][j];
        }

        public T getdCjdH(int j) {
            return this.cCoef[2][j];
        }

        public T getdCjdK(int j) {
            return this.cCoef[3][j];
        }

        public T getdCjdAlpha(int j) {
            return this.cCoef[4][j];
        }

        public T getdCjdBeta(int j) {
            return this.cCoef[5][j];
        }

        public T getdCjdGamma(int j) {
            return this.cCoef[6][j];
        }

        public T getSj(int j) {
            return this.sCoef[0][j];
        }

        public T getdSjdA(int j) {
            return this.sCoef[1][j];
        }

        public T getdSjdH(int j) {
            return this.sCoef[2][j];
        }

        public T getdSjdK(int j) {
            return this.sCoef[3][j];
        }

        public T getdSjdAlpha(int j) {
            return this.sCoef[4][j];
        }

        public T getdSjdBeta(int j) {
            return this.sCoef[5][j];
        }

        public T getdSjdGamma(int j) {
            return this.sCoef[6][j];
        }
    }

    private class FourierCjSjCoefficients {
        private final GHIJjsPolynomials ghijCoef;
        private final LnsCoefficients lnsCoef;
        private final int nMax;
        private final int sMax;
        private final int jMax;
        private final double[][] cCoef;
        private final double[][] sCoef;
        private final double hXXX;
        private final double kXXX;

        FourierCjSjCoefficients(AbsoluteDate date, int nMax, int sMax, int jMax, DSSTZonalContext context, HansenObjects hansenObjects) {
            AuxiliaryElements auxiliaryElements = context.getAuxiliaryElements();
            this.ghijCoef = new GHIJjsPolynomials(auxiliaryElements.getK(), auxiliaryElements.getH(), auxiliaryElements.getAlpha(), auxiliaryElements.getBeta());
            double[][] Qns = CoefficientsFactory.computeQns(auxiliaryElements.getGamma(), nMax, nMax);
            this.lnsCoef = new LnsCoefficients(nMax, nMax, Qns, DSSTZonal.this.Vns, context.getRoa());
            this.nMax = nMax;
            this.sMax = sMax;
            this.jMax = jMax;
            this.hXXX = auxiliaryElements.getH() * context.getXXX();
            this.kXXX = auxiliaryElements.getK() * context.getXXX();
            this.cCoef = new double[7][jMax + 1];
            this.sCoef = new double[7][jMax + 1];
            for (int s = 0; s <= sMax; ++s) {
                hansenObjects.computeHansenObjectsInitValues(context, s);
            }
            this.generateCoefficients(date, context, auxiliaryElements, hansenObjects);
        }

        private void generateCoefficients(AbsoluteDate date, DSSTZonalContext context, AuxiliaryElements auxiliaryElements, HansenObjects hansenObjects) {
            UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics = DSSTZonal.this.provider.onDate(date);
            for (int j = 1; j <= this.jMax; ++j) {
                double coef4;
                double coef3;
                double coef1;
                double coef0;
                double dkns;
                double kns;
                double jn;
                double dlns;
                double lns;
                double dGjsdBeta;
                double dGjsdAlpha;
                double dGjsdk;
                double dGjsdh;
                double gjs;
                double dHjsdBeta;
                double dHjsdAlpha;
                double dHjsdk;
                double dHjsdh;
                double hjs;
                for (int i = 0; i <= 6; ++i) {
                    this.cCoef[i][j] = 0.0;
                    this.sCoef[i][j] = 0.0;
                }
                if (this.isBetween(j, 1, this.nMax - 1)) {
                    double coef42;
                    double coef32;
                    double coef2;
                    double coef12;
                    double coef02;
                    double dkns2;
                    double kns2;
                    double jn2;
                    double dlns2;
                    int n;
                    int jms;
                    int s;
                    for (s = j; s <= FastMath.min(this.nMax - 1, this.sMax); ++s) {
                        jms = j - s;
                        int d0smj = s == j ? 1 : 2;
                        for (n = s + 1; n <= this.nMax; ++n) {
                            if ((n + jms) % 2 != 0) continue;
                            double lns2 = this.lnsCoef.getLns(n, -jms);
                            dlns2 = this.lnsCoef.getdLnsdGamma(n, -jms);
                            hjs = this.ghijCoef.getHjs(s, -jms);
                            dHjsdh = this.ghijCoef.getdHjsdh(s, -jms);
                            dHjsdk = this.ghijCoef.getdHjsdk(s, -jms);
                            dHjsdAlpha = this.ghijCoef.getdHjsdAlpha(s, -jms);
                            dHjsdBeta = this.ghijCoef.getdHjsdBeta(s, -jms);
                            gjs = this.ghijCoef.getGjs(s, -jms);
                            dGjsdh = this.ghijCoef.getdGjsdh(s, -jms);
                            dGjsdk = this.ghijCoef.getdGjsdk(s, -jms);
                            dGjsdAlpha = this.ghijCoef.getdGjsdAlpha(s, -jms);
                            dGjsdBeta = this.ghijCoef.getdGjsdBeta(s, -jms);
                            jn2 = -harmonics.getUnnormalizedCnm(n, 0);
                            kns2 = hansenObjects.getHansenObjects()[s].getValue(-n - 1, context.getX());
                            dkns2 = hansenObjects.getHansenObjects()[s].getDerivative(-n - 1, context.getX());
                            coef02 = (double)d0smj * jn2;
                            coef12 = coef02 * lns2;
                            coef2 = coef12 * kns2;
                            coef32 = coef2 * hjs;
                            coef42 = coef2 * gjs;
                            double[] dArray = this.cCoef[0];
                            int n2 = j;
                            dArray[n2] = dArray[n2] + coef32;
                            double[] dArray2 = this.cCoef[1];
                            int n3 = j;
                            dArray2[n3] = dArray2[n3] + coef32 * (double)(n + 1);
                            double[] dArray3 = this.cCoef[2];
                            int n4 = j;
                            dArray3[n4] = dArray3[n4] + coef12 * (kns2 * dHjsdh + hjs * this.hXXX * dkns2);
                            double[] dArray4 = this.cCoef[3];
                            int n5 = j;
                            dArray4[n5] = dArray4[n5] + coef12 * (kns2 * dHjsdk + hjs * this.kXXX * dkns2);
                            double[] dArray5 = this.cCoef[4];
                            int n6 = j;
                            dArray5[n6] = dArray5[n6] + coef2 * dHjsdAlpha;
                            double[] dArray6 = this.cCoef[5];
                            int n7 = j;
                            dArray6[n7] = dArray6[n7] + coef2 * dHjsdBeta;
                            double[] dArray7 = this.cCoef[6];
                            int n8 = j;
                            dArray7[n8] = dArray7[n8] + coef02 * dlns2 * kns2 * hjs;
                            double[] dArray8 = this.sCoef[0];
                            int n9 = j;
                            dArray8[n9] = dArray8[n9] + coef42;
                            double[] dArray9 = this.sCoef[1];
                            int n10 = j;
                            dArray9[n10] = dArray9[n10] + coef42 * (double)(n + 1);
                            double[] dArray10 = this.sCoef[2];
                            int n11 = j;
                            dArray10[n11] = dArray10[n11] + coef12 * (kns2 * dGjsdh + gjs * this.hXXX * dkns2);
                            double[] dArray11 = this.sCoef[3];
                            int n12 = j;
                            dArray11[n12] = dArray11[n12] + coef12 * (kns2 * dGjsdk + gjs * this.kXXX * dkns2);
                            double[] dArray12 = this.sCoef[4];
                            int n13 = j;
                            dArray12[n13] = dArray12[n13] + coef2 * dGjsdAlpha;
                            double[] dArray13 = this.sCoef[5];
                            int n14 = j;
                            dArray13[n14] = dArray13[n14] + coef2 * dGjsdBeta;
                            double[] dArray14 = this.sCoef[6];
                            int n15 = j;
                            dArray14[n15] = dArray14[n15] + coef02 * dlns2 * kns2 * gjs;
                        }
                    }
                    for (s = 0; s <= FastMath.min(this.nMax - j, this.sMax); ++s) {
                        int jps = j + s;
                        double d0spj = s == -j ? 1.0 : 2.0;
                        for (int n16 = FastMath.max(j + s, j + 1); n16 <= this.nMax; ++n16) {
                            if ((n16 + jps) % 2 != 0) continue;
                            lns = this.lnsCoef.getLns(n16, jps);
                            dlns = this.lnsCoef.getdLnsdGamma(n16, jps);
                            double hjs2 = this.ghijCoef.getHjs(s, jps);
                            double dHjsdh2 = this.ghijCoef.getdHjsdh(s, jps);
                            double dHjsdk2 = this.ghijCoef.getdHjsdk(s, jps);
                            double dHjsdAlpha2 = this.ghijCoef.getdHjsdAlpha(s, jps);
                            double dHjsdBeta2 = this.ghijCoef.getdHjsdBeta(s, jps);
                            double gjs2 = this.ghijCoef.getGjs(s, jps);
                            double dGjsdh2 = this.ghijCoef.getdGjsdh(s, jps);
                            double dGjsdk2 = this.ghijCoef.getdGjsdk(s, jps);
                            double dGjsdAlpha2 = this.ghijCoef.getdGjsdAlpha(s, jps);
                            double dGjsdBeta2 = this.ghijCoef.getdGjsdBeta(s, jps);
                            jn = -harmonics.getUnnormalizedCnm(n16, 0);
                            kns = hansenObjects.getHansenObjects()[s].getValue(-n16 - 1, context.getX());
                            dkns = hansenObjects.getHansenObjects()[s].getDerivative(-n16 - 1, context.getX());
                            coef0 = d0spj * jn;
                            coef1 = coef0 * lns;
                            double coef22 = coef1 * kns;
                            coef3 = coef22 * hjs2;
                            coef4 = coef22 * gjs2;
                            double[] dArray = this.cCoef[0];
                            int n17 = j;
                            dArray[n17] = dArray[n17] - coef3;
                            double[] dArray15 = this.cCoef[1];
                            int n18 = j;
                            dArray15[n18] = dArray15[n18] - coef3 * (double)(n16 + 1);
                            double[] dArray16 = this.cCoef[2];
                            int n19 = j;
                            dArray16[n19] = dArray16[n19] - coef1 * (kns * dHjsdh2 + hjs2 * this.hXXX * dkns);
                            double[] dArray17 = this.cCoef[3];
                            int n20 = j;
                            dArray17[n20] = dArray17[n20] - coef1 * (kns * dHjsdk2 + hjs2 * this.kXXX * dkns);
                            double[] dArray18 = this.cCoef[4];
                            int n21 = j;
                            dArray18[n21] = dArray18[n21] - coef22 * dHjsdAlpha2;
                            double[] dArray19 = this.cCoef[5];
                            int n22 = j;
                            dArray19[n22] = dArray19[n22] - coef22 * dHjsdBeta2;
                            double[] dArray20 = this.cCoef[6];
                            int n23 = j;
                            dArray20[n23] = dArray20[n23] - coef0 * dlns * kns * hjs2;
                            double[] dArray21 = this.sCoef[0];
                            int n24 = j;
                            dArray21[n24] = dArray21[n24] + coef4;
                            double[] dArray22 = this.sCoef[1];
                            int n25 = j;
                            dArray22[n25] = dArray22[n25] + coef4 * (double)(n16 + 1);
                            double[] dArray23 = this.sCoef[2];
                            int n26 = j;
                            dArray23[n26] = dArray23[n26] + coef1 * (kns * dGjsdh2 + gjs2 * this.hXXX * dkns);
                            double[] dArray24 = this.sCoef[3];
                            int n27 = j;
                            dArray24[n27] = dArray24[n27] + coef1 * (kns * dGjsdk2 + gjs2 * this.kXXX * dkns);
                            double[] dArray25 = this.sCoef[4];
                            int n28 = j;
                            dArray25[n28] = dArray25[n28] + coef22 * dGjsdAlpha2;
                            double[] dArray26 = this.sCoef[5];
                            int n29 = j;
                            dArray26[n29] = dArray26[n29] + coef22 * dGjsdBeta2;
                            double[] dArray27 = this.sCoef[6];
                            int n30 = j;
                            dArray27[n30] = dArray27[n30] + coef0 * dlns * kns * gjs2;
                        }
                    }
                    for (s = 1; s <= FastMath.min(j, this.sMax); ++s) {
                        jms = j - s;
                        int d0smj = s == j ? 1 : 2;
                        for (n = j + 1; n <= this.nMax; ++n) {
                            if ((n + jms) % 2 != 0) continue;
                            double lns3 = this.lnsCoef.getLns(n, jms);
                            dlns2 = this.lnsCoef.getdLnsdGamma(n, jms);
                            double ijs = this.ghijCoef.getIjs(s, jms);
                            double dIjsdh = this.ghijCoef.getdIjsdh(s, jms);
                            double dIjsdk = this.ghijCoef.getdIjsdk(s, jms);
                            double dIjsdAlpha = this.ghijCoef.getdIjsdAlpha(s, jms);
                            double dIjsdBeta = this.ghijCoef.getdIjsdBeta(s, jms);
                            double jjs = this.ghijCoef.getJjs(s, jms);
                            double dJjsdh = this.ghijCoef.getdJjsdh(s, jms);
                            double dJjsdk = this.ghijCoef.getdJjsdk(s, jms);
                            double dJjsdAlpha = this.ghijCoef.getdJjsdAlpha(s, jms);
                            double dJjsdBeta = this.ghijCoef.getdJjsdBeta(s, jms);
                            jn2 = -harmonics.getUnnormalizedCnm(n, 0);
                            kns2 = hansenObjects.getHansenObjects()[s].getValue(-n - 1, context.getX());
                            dkns2 = hansenObjects.getHansenObjects()[s].getDerivative(-n - 1, context.getX());
                            coef02 = (double)d0smj * jn2;
                            coef12 = coef02 * lns3;
                            coef2 = coef12 * kns2;
                            coef32 = coef2 * ijs;
                            coef42 = coef2 * jjs;
                            double[] dArray = this.cCoef[0];
                            int n31 = j;
                            dArray[n31] = dArray[n31] - coef32;
                            double[] dArray28 = this.cCoef[1];
                            int n32 = j;
                            dArray28[n32] = dArray28[n32] - coef32 * (double)(n + 1);
                            double[] dArray29 = this.cCoef[2];
                            int n33 = j;
                            dArray29[n33] = dArray29[n33] - coef12 * (kns2 * dIjsdh + ijs * this.hXXX * dkns2);
                            double[] dArray30 = this.cCoef[3];
                            int n34 = j;
                            dArray30[n34] = dArray30[n34] - coef12 * (kns2 * dIjsdk + ijs * this.kXXX * dkns2);
                            double[] dArray31 = this.cCoef[4];
                            int n35 = j;
                            dArray31[n35] = dArray31[n35] - coef2 * dIjsdAlpha;
                            double[] dArray32 = this.cCoef[5];
                            int n36 = j;
                            dArray32[n36] = dArray32[n36] - coef2 * dIjsdBeta;
                            double[] dArray33 = this.cCoef[6];
                            int n37 = j;
                            dArray33[n37] = dArray33[n37] - coef02 * dlns2 * kns2 * ijs;
                            double[] dArray34 = this.sCoef[0];
                            int n38 = j;
                            dArray34[n38] = dArray34[n38] + coef42;
                            double[] dArray35 = this.sCoef[1];
                            int n39 = j;
                            dArray35[n39] = dArray35[n39] + coef42 * (double)(n + 1);
                            double[] dArray36 = this.sCoef[2];
                            int n40 = j;
                            dArray36[n40] = dArray36[n40] + coef12 * (kns2 * dJjsdh + jjs * this.hXXX * dkns2);
                            double[] dArray37 = this.sCoef[3];
                            int n41 = j;
                            dArray37[n41] = dArray37[n41] + coef12 * (kns2 * dJjsdk + jjs * this.kXXX * dkns2);
                            double[] dArray38 = this.sCoef[4];
                            int n42 = j;
                            dArray38[n42] = dArray38[n42] + coef2 * dJjsdAlpha;
                            double[] dArray39 = this.sCoef[5];
                            int n43 = j;
                            dArray39[n43] = dArray39[n43] + coef2 * dJjsdBeta;
                            double[] dArray40 = this.sCoef[6];
                            int n44 = j;
                            dArray40[n44] = dArray40[n44] + coef02 * dlns2 * kns2 * jjs;
                        }
                    }
                }
                if (this.isBetween(j, 2, this.nMax)) {
                    double jj = -harmonics.getUnnormalizedCnm(j, 0);
                    double kns3 = hansenObjects.getHansenObjects()[0].getValue(-j - 1, context.getX());
                    double dkns3 = hansenObjects.getHansenObjects()[0].getDerivative(-j - 1, context.getX());
                    double lns4 = this.lnsCoef.getLns(j, j);
                    hjs = this.ghijCoef.getHjs(0, j);
                    dHjsdh = this.ghijCoef.getdHjsdh(0, j);
                    dHjsdk = this.ghijCoef.getdHjsdk(0, j);
                    dHjsdAlpha = this.ghijCoef.getdHjsdAlpha(0, j);
                    dHjsdBeta = this.ghijCoef.getdHjsdBeta(0, j);
                    gjs = this.ghijCoef.getGjs(0, j);
                    dGjsdh = this.ghijCoef.getdGjsdh(0, j);
                    dGjsdk = this.ghijCoef.getdGjsdk(0, j);
                    dGjsdAlpha = this.ghijCoef.getdGjsdAlpha(0, j);
                    dGjsdBeta = this.ghijCoef.getdGjsdBeta(0, j);
                    double coef03 = 2.0 * jj;
                    double coef13 = coef03 * lns4;
                    double coef2 = coef13 * kns3;
                    double coef33 = coef2 * hjs;
                    double coef43 = coef2 * gjs;
                    double[] dArray = this.cCoef[0];
                    int n = j;
                    dArray[n] = dArray[n] - coef33;
                    double[] dArray41 = this.cCoef[1];
                    int n45 = j;
                    dArray41[n45] = dArray41[n45] - coef33 * (double)(j + 1);
                    double[] dArray42 = this.cCoef[2];
                    int n46 = j;
                    dArray42[n46] = dArray42[n46] - coef13 * (kns3 * dHjsdh + hjs * this.hXXX * dkns3);
                    double[] dArray43 = this.cCoef[3];
                    int n47 = j;
                    dArray43[n47] = dArray43[n47] - coef13 * (kns3 * dHjsdk + hjs * this.kXXX * dkns3);
                    double[] dArray44 = this.cCoef[4];
                    int n48 = j;
                    dArray44[n48] = dArray44[n48] - coef2 * dHjsdAlpha;
                    double[] dArray45 = this.cCoef[5];
                    int n49 = j;
                    dArray45[n49] = dArray45[n49] - coef2 * dHjsdBeta;
                    double[] dArray46 = this.sCoef[0];
                    int n50 = j;
                    dArray46[n50] = dArray46[n50] + coef43;
                    double[] dArray47 = this.sCoef[1];
                    int n51 = j;
                    dArray47[n51] = dArray47[n51] + coef43 * (double)(j + 1);
                    double[] dArray48 = this.sCoef[2];
                    int n52 = j;
                    dArray48[n52] = dArray48[n52] + coef13 * (kns3 * dGjsdh + gjs * this.hXXX * dkns3);
                    double[] dArray49 = this.sCoef[3];
                    int n53 = j;
                    dArray49[n53] = dArray49[n53] + coef13 * (kns3 * dGjsdk + gjs * this.kXXX * dkns3);
                    double[] dArray50 = this.sCoef[4];
                    int n54 = j;
                    dArray50[n54] = dArray50[n54] + coef2 * dGjsdAlpha;
                    double[] dArray51 = this.sCoef[5];
                    int n55 = j;
                    dArray51[n55] = dArray51[n55] + coef2 * dGjsdBeta;
                    for (int s = 1; s <= FastMath.min(j - 1, this.sMax); ++s) {
                        int d0smj;
                        int jms = j - s;
                        int n56 = d0smj = s == j ? 1 : 2;
                        if (s % 2 != 0) continue;
                        kns3 = hansenObjects.getHansenObjects()[s].getValue(-j - 1, context.getX());
                        dkns3 = hansenObjects.getHansenObjects()[s].getDerivative(-j - 1, context.getX());
                        lns4 = this.lnsCoef.getLns(j, jms);
                        double dlns3 = this.lnsCoef.getdLnsdGamma(j, jms);
                        double ijs = this.ghijCoef.getIjs(s, jms);
                        double dIjsdh = this.ghijCoef.getdIjsdh(s, jms);
                        double dIjsdk = this.ghijCoef.getdIjsdk(s, jms);
                        double dIjsdAlpha = this.ghijCoef.getdIjsdAlpha(s, jms);
                        double dIjsdBeta = this.ghijCoef.getdIjsdBeta(s, jms);
                        double jjs = this.ghijCoef.getJjs(s, jms);
                        double dJjsdh = this.ghijCoef.getdJjsdh(s, jms);
                        double dJjsdk = this.ghijCoef.getdJjsdk(s, jms);
                        double dJjsdAlpha = this.ghijCoef.getdJjsdAlpha(s, jms);
                        double dJjsdBeta = this.ghijCoef.getdJjsdBeta(s, jms);
                        coef03 = (double)d0smj * jj;
                        coef13 = coef03 * lns4;
                        coef2 = coef13 * kns3;
                        coef33 = coef2 * ijs;
                        coef43 = coef2 * jjs;
                        double[] dArray52 = this.cCoef[0];
                        int n57 = j;
                        dArray52[n57] = dArray52[n57] - coef33;
                        double[] dArray53 = this.cCoef[1];
                        int n58 = j;
                        dArray53[n58] = dArray53[n58] - coef33 * (double)(j + 1);
                        double[] dArray54 = this.cCoef[2];
                        int n59 = j;
                        dArray54[n59] = dArray54[n59] - coef13 * (kns3 * dIjsdh + ijs * this.hXXX * dkns3);
                        double[] dArray55 = this.cCoef[3];
                        int n60 = j;
                        dArray55[n60] = dArray55[n60] - coef13 * (kns3 * dIjsdk + ijs * this.kXXX * dkns3);
                        double[] dArray56 = this.cCoef[4];
                        int n61 = j;
                        dArray56[n61] = dArray56[n61] - coef2 * dIjsdAlpha;
                        double[] dArray57 = this.cCoef[5];
                        int n62 = j;
                        dArray57[n62] = dArray57[n62] - coef2 * dIjsdBeta;
                        double[] dArray58 = this.cCoef[6];
                        int n63 = j;
                        dArray58[n63] = dArray58[n63] - coef03 * dlns3 * kns3 * ijs;
                        double[] dArray59 = this.sCoef[0];
                        int n64 = j;
                        dArray59[n64] = dArray59[n64] + coef43;
                        double[] dArray60 = this.sCoef[1];
                        int n65 = j;
                        dArray60[n65] = dArray60[n65] + coef43 * (double)(j + 1);
                        double[] dArray61 = this.sCoef[2];
                        int n66 = j;
                        dArray61[n66] = dArray61[n66] + coef13 * (kns3 * dJjsdh + jjs * this.hXXX * dkns3);
                        double[] dArray62 = this.sCoef[3];
                        int n67 = j;
                        dArray62[n67] = dArray62[n67] + coef13 * (kns3 * dJjsdk + jjs * this.kXXX * dkns3);
                        double[] dArray63 = this.sCoef[4];
                        int n68 = j;
                        dArray63[n68] = dArray63[n68] + coef2 * dJjsdAlpha;
                        double[] dArray64 = this.sCoef[5];
                        int n69 = j;
                        dArray64[n69] = dArray64[n69] + coef2 * dJjsdBeta;
                        double[] dArray65 = this.sCoef[6];
                        int n70 = j;
                        dArray65[n70] = dArray65[n70] + coef03 * dlns3 * kns3 * jjs;
                    }
                }
                if (this.isBetween(j, 3, 2 * this.nMax - 1)) {
                    double dJjsdBeta;
                    double dJjsdAlpha;
                    double dJjsdk;
                    double dJjsdh;
                    double jjs;
                    double dIjsdBeta;
                    double dIjsdAlpha;
                    double dIjsdk;
                    double dIjsdh;
                    double ijs;
                    int d0smj;
                    int s;
                    int minjm1on = FastMath.min(j - 1, this.nMax);
                    if (j % 2 == 0) {
                        for (s = j - minjm1on; s <= FastMath.min(j / 2 - 1, this.sMax); ++s) {
                            int jms = j - s;
                            d0smj = s == j ? 1 : 2;
                            for (int n = j - s; n <= minjm1on; ++n) {
                                if ((n + jms) % 2 != 0) continue;
                                lns = this.lnsCoef.getLns(n, jms);
                                dlns = this.lnsCoef.getdLnsdGamma(n, jms);
                                ijs = this.ghijCoef.getIjs(s, jms);
                                dIjsdh = this.ghijCoef.getdIjsdh(s, jms);
                                dIjsdk = this.ghijCoef.getdIjsdk(s, jms);
                                dIjsdAlpha = this.ghijCoef.getdIjsdAlpha(s, jms);
                                dIjsdBeta = this.ghijCoef.getdIjsdBeta(s, jms);
                                jjs = this.ghijCoef.getJjs(s, jms);
                                dJjsdh = this.ghijCoef.getdJjsdh(s, jms);
                                dJjsdk = this.ghijCoef.getdJjsdk(s, jms);
                                dJjsdAlpha = this.ghijCoef.getdJjsdAlpha(s, jms);
                                dJjsdBeta = this.ghijCoef.getdJjsdBeta(s, jms);
                                jn = -harmonics.getUnnormalizedCnm(n, 0);
                                kns = hansenObjects.getHansenObjects()[s].getValue(-n - 1, context.getX());
                                dkns = hansenObjects.getHansenObjects()[s].getDerivative(-n - 1, context.getX());
                                coef0 = (double)d0smj * jn;
                                coef1 = coef0 * lns;
                                double coef2 = coef1 * kns;
                                coef3 = coef2 * ijs;
                                coef4 = coef2 * jjs;
                                double[] dArray = this.cCoef[0];
                                int n71 = j;
                                dArray[n71] = dArray[n71] - coef3;
                                double[] dArray66 = this.cCoef[1];
                                int n72 = j;
                                dArray66[n72] = dArray66[n72] - coef3 * (double)(n + 1);
                                double[] dArray67 = this.cCoef[2];
                                int n73 = j;
                                dArray67[n73] = dArray67[n73] - coef1 * (kns * dIjsdh + ijs * this.hXXX * dkns);
                                double[] dArray68 = this.cCoef[3];
                                int n74 = j;
                                dArray68[n74] = dArray68[n74] - coef1 * (kns * dIjsdk + ijs * this.kXXX * dkns);
                                double[] dArray69 = this.cCoef[4];
                                int n75 = j;
                                dArray69[n75] = dArray69[n75] - coef2 * dIjsdAlpha;
                                double[] dArray70 = this.cCoef[5];
                                int n76 = j;
                                dArray70[n76] = dArray70[n76] - coef2 * dIjsdBeta;
                                double[] dArray71 = this.cCoef[6];
                                int n77 = j;
                                dArray71[n77] = dArray71[n77] - coef0 * dlns * kns * ijs;
                                double[] dArray72 = this.sCoef[0];
                                int n78 = j;
                                dArray72[n78] = dArray72[n78] + coef4;
                                double[] dArray73 = this.sCoef[1];
                                int n79 = j;
                                dArray73[n79] = dArray73[n79] + coef4 * (double)(n + 1);
                                double[] dArray74 = this.sCoef[2];
                                int n80 = j;
                                dArray74[n80] = dArray74[n80] + coef1 * (kns * dJjsdh + jjs * this.hXXX * dkns);
                                double[] dArray75 = this.sCoef[3];
                                int n81 = j;
                                dArray75[n81] = dArray75[n81] + coef1 * (kns * dJjsdk + jjs * this.kXXX * dkns);
                                double[] dArray76 = this.sCoef[4];
                                int n82 = j;
                                dArray76[n82] = dArray76[n82] + coef2 * dJjsdAlpha;
                                double[] dArray77 = this.sCoef[5];
                                int n83 = j;
                                dArray77[n83] = dArray77[n83] + coef2 * dJjsdBeta;
                                double[] dArray78 = this.sCoef[6];
                                int n84 = j;
                                dArray78[n84] = dArray78[n84] + coef0 * dlns * kns * jjs;
                            }
                        }
                        for (s = j / 2; s <= FastMath.min(minjm1on - 1, this.sMax); ++s) {
                            int jms = j - s;
                            d0smj = s == j ? 1 : 2;
                            for (int n = s + 1; n <= minjm1on; ++n) {
                                if ((n + jms) % 2 != 0) continue;
                                lns = this.lnsCoef.getLns(n, jms);
                                dlns = this.lnsCoef.getdLnsdGamma(n, jms);
                                ijs = this.ghijCoef.getIjs(s, jms);
                                dIjsdh = this.ghijCoef.getdIjsdh(s, jms);
                                dIjsdk = this.ghijCoef.getdIjsdk(s, jms);
                                dIjsdAlpha = this.ghijCoef.getdIjsdAlpha(s, jms);
                                dIjsdBeta = this.ghijCoef.getdIjsdBeta(s, jms);
                                jjs = this.ghijCoef.getJjs(s, jms);
                                dJjsdh = this.ghijCoef.getdJjsdh(s, jms);
                                dJjsdk = this.ghijCoef.getdJjsdk(s, jms);
                                dJjsdAlpha = this.ghijCoef.getdJjsdAlpha(s, jms);
                                dJjsdBeta = this.ghijCoef.getdJjsdBeta(s, jms);
                                jn = -harmonics.getUnnormalizedCnm(n, 0);
                                kns = hansenObjects.getHansenObjects()[s].getValue(-n - 1, context.getX());
                                dkns = hansenObjects.getHansenObjects()[s].getDerivative(-n - 1, context.getX());
                                coef0 = (double)d0smj * jn;
                                coef1 = coef0 * lns;
                                double coef2 = coef1 * kns;
                                coef3 = coef2 * ijs;
                                coef4 = coef2 * jjs;
                                double[] dArray = this.cCoef[0];
                                int n85 = j;
                                dArray[n85] = dArray[n85] - coef3;
                                double[] dArray79 = this.cCoef[1];
                                int n86 = j;
                                dArray79[n86] = dArray79[n86] - coef3 * (double)(n + 1);
                                double[] dArray80 = this.cCoef[2];
                                int n87 = j;
                                dArray80[n87] = dArray80[n87] - coef1 * (kns * dIjsdh + ijs * this.hXXX * dkns);
                                double[] dArray81 = this.cCoef[3];
                                int n88 = j;
                                dArray81[n88] = dArray81[n88] - coef1 * (kns * dIjsdk + ijs * this.kXXX * dkns);
                                double[] dArray82 = this.cCoef[4];
                                int n89 = j;
                                dArray82[n89] = dArray82[n89] - coef2 * dIjsdAlpha;
                                double[] dArray83 = this.cCoef[5];
                                int n90 = j;
                                dArray83[n90] = dArray83[n90] - coef2 * dIjsdBeta;
                                double[] dArray84 = this.cCoef[6];
                                int n91 = j;
                                dArray84[n91] = dArray84[n91] - coef0 * dlns * kns * ijs;
                                double[] dArray85 = this.sCoef[0];
                                int n92 = j;
                                dArray85[n92] = dArray85[n92] + coef4;
                                double[] dArray86 = this.sCoef[1];
                                int n93 = j;
                                dArray86[n93] = dArray86[n93] + coef4 * (double)(n + 1);
                                double[] dArray87 = this.sCoef[2];
                                int n94 = j;
                                dArray87[n94] = dArray87[n94] + coef1 * (kns * dJjsdh + jjs * this.hXXX * dkns);
                                double[] dArray88 = this.sCoef[3];
                                int n95 = j;
                                dArray88[n95] = dArray88[n95] + coef1 * (kns * dJjsdk + jjs * this.kXXX * dkns);
                                double[] dArray89 = this.sCoef[4];
                                int n96 = j;
                                dArray89[n96] = dArray89[n96] + coef2 * dJjsdAlpha;
                                double[] dArray90 = this.sCoef[5];
                                int n97 = j;
                                dArray90[n97] = dArray90[n97] + coef2 * dJjsdBeta;
                                double[] dArray91 = this.sCoef[6];
                                int n98 = j;
                                dArray91[n98] = dArray91[n98] + coef0 * dlns * kns * jjs;
                            }
                        }
                    } else {
                        for (s = (j - 1) / 2; s <= FastMath.min(minjm1on - 1, this.sMax); ++s) {
                            int jms = j - s;
                            d0smj = s == j ? 1 : 2;
                            for (int n = s + 1; n <= minjm1on; ++n) {
                                if ((n + jms) % 2 != 0) continue;
                                lns = this.lnsCoef.getLns(n, jms);
                                dlns = this.lnsCoef.getdLnsdGamma(n, jms);
                                ijs = this.ghijCoef.getIjs(s, jms);
                                dIjsdh = this.ghijCoef.getdIjsdh(s, jms);
                                dIjsdk = this.ghijCoef.getdIjsdk(s, jms);
                                dIjsdAlpha = this.ghijCoef.getdIjsdAlpha(s, jms);
                                dIjsdBeta = this.ghijCoef.getdIjsdBeta(s, jms);
                                jjs = this.ghijCoef.getJjs(s, jms);
                                dJjsdh = this.ghijCoef.getdJjsdh(s, jms);
                                dJjsdk = this.ghijCoef.getdJjsdk(s, jms);
                                dJjsdAlpha = this.ghijCoef.getdJjsdAlpha(s, jms);
                                dJjsdBeta = this.ghijCoef.getdJjsdBeta(s, jms);
                                jn = -harmonics.getUnnormalizedCnm(n, 0);
                                kns = hansenObjects.getHansenObjects()[s].getValue(-n - 1, context.getX());
                                dkns = hansenObjects.getHansenObjects()[s].getDerivative(-n - 1, context.getX());
                                coef0 = (double)d0smj * jn;
                                coef1 = coef0 * lns;
                                double coef2 = coef1 * kns;
                                coef3 = coef2 * ijs;
                                coef4 = coef2 * jjs;
                                double[] dArray = this.cCoef[0];
                                int n99 = j;
                                dArray[n99] = dArray[n99] - coef3;
                                double[] dArray92 = this.cCoef[1];
                                int n100 = j;
                                dArray92[n100] = dArray92[n100] - coef3 * (double)(n + 1);
                                double[] dArray93 = this.cCoef[2];
                                int n101 = j;
                                dArray93[n101] = dArray93[n101] - coef1 * (kns * dIjsdh + ijs * this.hXXX * dkns);
                                double[] dArray94 = this.cCoef[3];
                                int n102 = j;
                                dArray94[n102] = dArray94[n102] - coef1 * (kns * dIjsdk + ijs * this.kXXX * dkns);
                                double[] dArray95 = this.cCoef[4];
                                int n103 = j;
                                dArray95[n103] = dArray95[n103] - coef2 * dIjsdAlpha;
                                double[] dArray96 = this.cCoef[5];
                                int n104 = j;
                                dArray96[n104] = dArray96[n104] - coef2 * dIjsdBeta;
                                double[] dArray97 = this.cCoef[6];
                                int n105 = j;
                                dArray97[n105] = dArray97[n105] - coef0 * dlns * kns * ijs;
                                double[] dArray98 = this.sCoef[0];
                                int n106 = j;
                                dArray98[n106] = dArray98[n106] + coef4;
                                double[] dArray99 = this.sCoef[1];
                                int n107 = j;
                                dArray99[n107] = dArray99[n107] + coef4 * (double)(n + 1);
                                double[] dArray100 = this.sCoef[2];
                                int n108 = j;
                                dArray100[n108] = dArray100[n108] + coef1 * (kns * dJjsdh + jjs * this.hXXX * dkns);
                                double[] dArray101 = this.sCoef[3];
                                int n109 = j;
                                dArray101[n109] = dArray101[n109] + coef1 * (kns * dJjsdk + jjs * this.kXXX * dkns);
                                double[] dArray102 = this.sCoef[4];
                                int n110 = j;
                                dArray102[n110] = dArray102[n110] + coef2 * dJjsdAlpha;
                                double[] dArray103 = this.sCoef[5];
                                int n111 = j;
                                dArray103[n111] = dArray103[n111] + coef2 * dJjsdBeta;
                                double[] dArray104 = this.sCoef[6];
                                int n112 = j;
                                dArray104[n112] = dArray104[n112] + coef0 * dlns * kns * jjs;
                            }
                        }
                        if (this.nMax >= 4 && this.isBetween(j, 5, 2 * this.nMax - 3)) {
                            for (s = j - minjm1on; s <= FastMath.min((j - 3) / 2, this.sMax); ++s) {
                                int jms = j - s;
                                d0smj = s == j ? 1 : 2;
                                for (int n = j - s; n <= minjm1on; ++n) {
                                    if ((n + jms) % 2 != 0) continue;
                                    lns = this.lnsCoef.getLns(n, jms);
                                    dlns = this.lnsCoef.getdLnsdGamma(n, jms);
                                    ijs = this.ghijCoef.getIjs(s, jms);
                                    dIjsdh = this.ghijCoef.getdIjsdh(s, jms);
                                    dIjsdk = this.ghijCoef.getdIjsdk(s, jms);
                                    dIjsdAlpha = this.ghijCoef.getdIjsdAlpha(s, jms);
                                    dIjsdBeta = this.ghijCoef.getdIjsdBeta(s, jms);
                                    jjs = this.ghijCoef.getJjs(s, jms);
                                    dJjsdh = this.ghijCoef.getdJjsdh(s, jms);
                                    dJjsdk = this.ghijCoef.getdJjsdk(s, jms);
                                    dJjsdAlpha = this.ghijCoef.getdJjsdAlpha(s, jms);
                                    dJjsdBeta = this.ghijCoef.getdJjsdBeta(s, jms);
                                    jn = -harmonics.getUnnormalizedCnm(n, 0);
                                    kns = hansenObjects.getHansenObjects()[s].getValue(-n - 1, context.getX());
                                    dkns = hansenObjects.getHansenObjects()[s].getDerivative(-n - 1, context.getX());
                                    coef0 = (double)d0smj * jn;
                                    coef1 = coef0 * lns;
                                    double coef2 = coef1 * kns;
                                    coef3 = coef2 * ijs;
                                    coef4 = coef2 * jjs;
                                    double[] dArray = this.cCoef[0];
                                    int n113 = j;
                                    dArray[n113] = dArray[n113] - coef3;
                                    double[] dArray105 = this.cCoef[1];
                                    int n114 = j;
                                    dArray105[n114] = dArray105[n114] - coef3 * (double)(n + 1);
                                    double[] dArray106 = this.cCoef[2];
                                    int n115 = j;
                                    dArray106[n115] = dArray106[n115] - coef1 * (kns * dIjsdh + ijs * this.hXXX * dkns);
                                    double[] dArray107 = this.cCoef[3];
                                    int n116 = j;
                                    dArray107[n116] = dArray107[n116] - coef1 * (kns * dIjsdk + ijs * this.kXXX * dkns);
                                    double[] dArray108 = this.cCoef[4];
                                    int n117 = j;
                                    dArray108[n117] = dArray108[n117] - coef2 * dIjsdAlpha;
                                    double[] dArray109 = this.cCoef[5];
                                    int n118 = j;
                                    dArray109[n118] = dArray109[n118] - coef2 * dIjsdBeta;
                                    double[] dArray110 = this.cCoef[6];
                                    int n119 = j;
                                    dArray110[n119] = dArray110[n119] - coef0 * dlns * kns * ijs;
                                    double[] dArray111 = this.sCoef[0];
                                    int n120 = j;
                                    dArray111[n120] = dArray111[n120] + coef4;
                                    double[] dArray112 = this.sCoef[1];
                                    int n121 = j;
                                    dArray112[n121] = dArray112[n121] + coef4 * (double)(n + 1);
                                    double[] dArray113 = this.sCoef[2];
                                    int n122 = j;
                                    dArray113[n122] = dArray113[n122] + coef1 * (kns * dJjsdh + jjs * this.hXXX * dkns);
                                    double[] dArray114 = this.sCoef[3];
                                    int n123 = j;
                                    dArray114[n123] = dArray114[n123] + coef1 * (kns * dJjsdk + jjs * this.kXXX * dkns);
                                    double[] dArray115 = this.sCoef[4];
                                    int n124 = j;
                                    dArray115[n124] = dArray115[n124] + coef2 * dJjsdAlpha;
                                    double[] dArray116 = this.sCoef[5];
                                    int n125 = j;
                                    dArray116[n125] = dArray116[n125] + coef2 * dJjsdBeta;
                                    double[] dArray117 = this.sCoef[6];
                                    int n126 = j;
                                    dArray117[n126] = dArray117[n126] + coef0 * dlns * kns * jjs;
                                }
                            }
                        }
                    }
                }
                double[] dArray = this.cCoef[0];
                int n = j;
                dArray[n] = dArray[n] * (-context.getMuoa() / (double)j);
                double[] dArray118 = this.cCoef[1];
                int n127 = j;
                dArray118[n127] = dArray118[n127] * (context.getMuoa() / ((double)j * auxiliaryElements.getSma()));
                double[] dArray119 = this.cCoef[2];
                int n128 = j;
                dArray119[n128] = dArray119[n128] * (-context.getMuoa() / (double)j);
                double[] dArray120 = this.cCoef[3];
                int n129 = j;
                dArray120[n129] = dArray120[n129] * (-context.getMuoa() / (double)j);
                double[] dArray121 = this.cCoef[4];
                int n130 = j;
                dArray121[n130] = dArray121[n130] * (-context.getMuoa() / (double)j);
                double[] dArray122 = this.cCoef[5];
                int n131 = j;
                dArray122[n131] = dArray122[n131] * (-context.getMuoa() / (double)j);
                double[] dArray123 = this.cCoef[6];
                int n132 = j;
                dArray123[n132] = dArray123[n132] * (-context.getMuoa() / (double)j);
                double[] dArray124 = this.sCoef[0];
                int n133 = j;
                dArray124[n133] = dArray124[n133] * (-context.getMuoa() / (double)j);
                double[] dArray125 = this.sCoef[1];
                int n134 = j;
                dArray125[n134] = dArray125[n134] * (context.getMuoa() / ((double)j * auxiliaryElements.getSma()));
                double[] dArray126 = this.sCoef[2];
                int n135 = j;
                dArray126[n135] = dArray126[n135] * (-context.getMuoa() / (double)j);
                double[] dArray127 = this.sCoef[3];
                int n136 = j;
                dArray127[n136] = dArray127[n136] * (-context.getMuoa() / (double)j);
                double[] dArray128 = this.sCoef[4];
                int n137 = j;
                dArray128[n137] = dArray128[n137] * (-context.getMuoa() / (double)j);
                double[] dArray129 = this.sCoef[5];
                int n138 = j;
                dArray129[n138] = dArray129[n138] * (-context.getMuoa() / (double)j);
                double[] dArray130 = this.sCoef[6];
                int n139 = j;
                dArray130[n139] = dArray130[n139] * (-context.getMuoa() / (double)j);
            }
        }

        private boolean isBetween(int index, int lowerBound, int upperBound) {
            return index >= lowerBound && index <= upperBound;
        }

        public double getCj(int j) {
            return this.cCoef[0][j];
        }

        public double getdCjdA(int j) {
            return this.cCoef[1][j];
        }

        public double getdCjdH(int j) {
            return this.cCoef[2][j];
        }

        public double getdCjdK(int j) {
            return this.cCoef[3][j];
        }

        public double getdCjdAlpha(int j) {
            return this.cCoef[4][j];
        }

        public double getdCjdBeta(int j) {
            return this.cCoef[5][j];
        }

        public double getdCjdGamma(int j) {
            return this.cCoef[6][j];
        }

        public double getSj(int j) {
            return this.sCoef[0][j];
        }

        public double getdSjdA(int j) {
            return this.sCoef[1][j];
        }

        public double getdSjdH(int j) {
            return this.sCoef[2][j];
        }

        public double getdSjdK(int j) {
            return this.sCoef[3][j];
        }

        public double getdSjdAlpha(int j) {
            return this.sCoef[4][j];
        }

        public double getdSjdBeta(int j) {
            return this.sCoef[5][j];
        }

        public double getdSjdGamma(int j) {
            return this.sCoef[6][j];
        }
    }

    private static class FieldZonalShortPeriodicCoefficients<T extends RealFieldElement<T>>
    implements FieldShortPeriodTerms<T> {
        private final int maxFrequencyShortPeriodics;
        private final int interpolationPoints;
        private final transient FieldTimeSpanMap<FieldSlot<T>, T> slots;

        FieldZonalShortPeriodicCoefficients(int maxFrequencyShortPeriodics, int interpolationPoints, FieldTimeSpanMap<FieldSlot<T>, T> slots) {
            this.maxFrequencyShortPeriodics = maxFrequencyShortPeriodics;
            this.interpolationPoints = interpolationPoints;
            this.slots = slots;
        }

        public FieldSlot<T> createSlot(FieldSpacecraftState<T> ... meanStates) {
            FieldAbsoluteDate<T> last;
            FieldSlot slot = new FieldSlot(this.maxFrequencyShortPeriodics, this.interpolationPoints);
            FieldAbsoluteDate<T> first = meanStates[0].getDate();
            if (first.compareTo(last = meanStates[meanStates.length - 1].getDate()) <= 0) {
                this.slots.addValidAfter(slot, first);
            } else {
                this.slots.addValidBefore(slot, first);
            }
            return slot;
        }

        @Override
        public T[] value(FieldOrbit<T> meanOrbit) {
            FieldSlot<T> slot = this.slots.get(meanOrbit.getDate());
            T L = meanOrbit.getLv();
            RealFieldElement center = (RealFieldElement)L.subtract(meanOrbit.getLM());
            RealFieldElement[] shortPeriodicVariation = ((FieldSlot)slot).cij[0].value(meanOrbit.getDate());
            RealFieldElement[] d = ((FieldSlot)slot).di.value(meanOrbit.getDate());
            for (int i = 0; i < 6; ++i) {
                shortPeriodicVariation[i] = shortPeriodicVariation[i].add(center.multiply(d[i]));
            }
            for (int j = 1; j <= this.maxFrequencyShortPeriodics; ++j) {
                RealFieldElement[] c = ((FieldSlot)slot).cij[j].value(meanOrbit.getDate());
                RealFieldElement[] s = ((FieldSlot)slot).sij[j].value(meanOrbit.getDate());
                RealFieldElement cos = FastMath.cos((RealFieldElement)L.multiply((int)j));
                RealFieldElement sin = FastMath.sin((RealFieldElement)L.multiply((int)j));
                for (int i = 0; i < 6; ++i) {
                    shortPeriodicVariation[i] = shortPeriodicVariation[i].add(c[i].multiply(cos));
                    shortPeriodicVariation[i] = shortPeriodicVariation[i].add(s[i].multiply(sin));
                }
            }
            return shortPeriodicVariation;
        }

        @Override
        public String getCoefficientsKeyPrefix() {
            return DSSTZonal.SHORT_PERIOD_PREFIX;
        }

        @Override
        public Map<String, T[]> getCoefficients(FieldAbsoluteDate<T> date, Set<String> selected) {
            FieldSlot<T> slot = this.slots.get(date);
            HashMap<String, T[]> coefficients = new HashMap<String, T[]>(2 * this.maxFrequencyShortPeriodics + 2);
            this.storeIfSelected(coefficients, selected, ((FieldSlot)slot).cij[0].value(date), "d", new int[]{0});
            this.storeIfSelected(coefficients, selected, ((FieldSlot)slot).di.value(date), "d", new int[]{1});
            for (int j = 1; j <= this.maxFrequencyShortPeriodics; ++j) {
                this.storeIfSelected(coefficients, selected, ((FieldSlot)slot).cij[j].value(date), "c", new int[]{j});
                this.storeIfSelected(coefficients, selected, ((FieldSlot)slot).sij[j].value(date), "s", new int[]{j});
            }
            return coefficients;
        }

        private void storeIfSelected(Map<String, T[]> map, Set<String> selected, T[] value, String id, int ... indices) {
            StringBuilder keyBuilder = new StringBuilder(this.getCoefficientsKeyPrefix());
            keyBuilder.append(id);
            for (int index : indices) {
                keyBuilder.append('[').append(index).append(']');
            }
            String key = keyBuilder.toString();
            if (selected.isEmpty() || selected.contains(key)) {
                map.put(key, value);
            }
        }
    }

    private static class ZonalShortPeriodicCoefficients
    implements ShortPeriodTerms {
        private final int maxFrequencyShortPeriodics;
        private final int interpolationPoints;
        private final transient TimeSpanMap<Slot> slots;

        ZonalShortPeriodicCoefficients(int maxFrequencyShortPeriodics, int interpolationPoints, TimeSpanMap<Slot> slots) {
            this.maxFrequencyShortPeriodics = maxFrequencyShortPeriodics;
            this.interpolationPoints = interpolationPoints;
            this.slots = slots;
        }

        public Slot createSlot(SpacecraftState ... meanStates) {
            AbsoluteDate last;
            Slot slot = new Slot(this.maxFrequencyShortPeriodics, this.interpolationPoints);
            AbsoluteDate first = meanStates[0].getDate();
            if (first.compareTo(last = meanStates[meanStates.length - 1].getDate()) <= 0) {
                this.slots.addValidAfter(slot, first);
            } else {
                this.slots.addValidBefore(slot, first);
            }
            return slot;
        }

        @Override
        public double[] value(Orbit meanOrbit) {
            Slot slot = this.slots.get(meanOrbit.getDate());
            double L = meanOrbit.getLv();
            double center = L - meanOrbit.getLM();
            double[] shortPeriodicVariation = slot.cij[0].value(meanOrbit.getDate());
            double[] d = slot.di.value(meanOrbit.getDate());
            for (int i = 0; i < 6; ++i) {
                int n = i;
                shortPeriodicVariation[n] = shortPeriodicVariation[n] + center * d[i];
            }
            for (int j = 1; j <= this.maxFrequencyShortPeriodics; ++j) {
                double[] c = slot.cij[j].value(meanOrbit.getDate());
                double[] s = slot.sij[j].value(meanOrbit.getDate());
                double cos = FastMath.cos((double)j * L);
                double sin = FastMath.sin((double)j * L);
                for (int i = 0; i < 6; ++i) {
                    int n = i;
                    shortPeriodicVariation[n] = shortPeriodicVariation[n] + c[i] * cos;
                    int n2 = i;
                    shortPeriodicVariation[n2] = shortPeriodicVariation[n2] + s[i] * sin;
                }
            }
            return shortPeriodicVariation;
        }

        @Override
        public String getCoefficientsKeyPrefix() {
            return DSSTZonal.SHORT_PERIOD_PREFIX;
        }

        @Override
        public Map<String, double[]> getCoefficients(AbsoluteDate date, Set<String> selected) {
            Slot slot = this.slots.get(date);
            HashMap<String, double[]> coefficients = new HashMap<String, double[]>(2 * this.maxFrequencyShortPeriodics + 2);
            this.storeIfSelected(coefficients, selected, slot.cij[0].value(date), "d", 0);
            this.storeIfSelected(coefficients, selected, slot.di.value(date), "d", 1);
            for (int j = 1; j <= this.maxFrequencyShortPeriodics; ++j) {
                this.storeIfSelected(coefficients, selected, slot.cij[j].value(date), "c", j);
                this.storeIfSelected(coefficients, selected, slot.sij[j].value(date), "s", j);
            }
            return coefficients;
        }

        private void storeIfSelected(Map<String, double[]> map, Set<String> selected, double[] value, String id, int ... indices) {
            StringBuilder keyBuilder = new StringBuilder(this.getCoefficientsKeyPrefix());
            keyBuilder.append(id);
            for (int index : indices) {
                keyBuilder.append('[').append(index).append(']');
            }
            String key = keyBuilder.toString();
            if (selected.isEmpty() || selected.contains(key)) {
                map.put(key, value);
            }
        }
    }
}

